// This code conforms with the UFC specification version 2.0.3
// and was automatically generated by FFC version 1.0-beta2+.
//
// This code was generated with the option '-l dolfin' and
// contains DOLFIN-specific wrappers that depend on DOLFIN.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   False
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'dolfin'
//   log_level:                      10
//   log_prefix:                     ''
//   no_ferari:                      True
//   optimize:                       True
//   output_dir:                     '.'
//   precision:                      15
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'auto'
//   split:                          False
//   swig_binary:                    'swig'
//   swig_path:                      ''

#ifndef __POISSON3D_5_H
#define __POISSON3D_5_H

#include <cmath>
#include <stdexcept>
#include <fstream>
#include <ufc.h>

/// This class defines the interface for a finite element.

class poisson3d_5_finite_element_0: public ufc::finite_element
{
public:

  /// Constructor
  poisson3d_5_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~poisson3d_5_finite_element_0()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 5, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::tetrahedron;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 3;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 3;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 56;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[3][0] + x[2][0] + x[1][0] - x[0][0];
    const double C1 = x[3][1] + x[2][1] + x[1][1] - x[0][1];
    const double C2 = x[3][2] + x[2][2] + x[1][2] - x[0][2];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*coordinates[0] - C0) + d_10*(2.0*coordinates[1] - C1) + d_20*(2.0*coordinates[2] - C2)) / detJ;
    double Y = (d_01*(2.0*coordinates[0] - C0) + d_11*(2.0*coordinates[1] - C1) + d_21*(2.0*coordinates[2] - C2)) / detJ;
    double Z = (d_02*(2.0*coordinates[0] - C0) + d_12*(2.0*coordinates[1] - C1) + d_22*(2.0*coordinates[2] - C2)) / detJ;
    
    
    // Reset values.
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.00945067404923493, 0.00609788120679252, 0.00352061335622803, 0.00248944957812476, 0.00705946233325038, 0.00546823600997146, 0.00446479600584757, 0.00315708753234943, 0.00257775117585286, 0.00182274533665714, -0.00298267418725716, -0.00252081977982931, -0.00218309396769448, -0.00195261860521384, -0.00169101731601731, -0.00138070985681772, -0.00112734487734488, -0.000976309302606919, -0.000797153207506481, -0.00056367243867244, 0.00278687112460005, 0.00245778931055954, 0.00219831358911339, 0.00207721109304566, 0.0018579140830667, 0.00160900079398464, 0.00160900079398463, 0.00143913406048031, 0.0012463266558274, 0.00101762145320216, 0.000928957041533353, 0.000830884437218264, 0.000719567030240156, 0.000587524019939406, 0.00041544221860914, -0.00705593524717798, -0.0063823335708908, -0.00582624677716565, -0.00562868913761196, -0.00513826668309062, -0.0045958054359652, -0.00475711057319694, -0.00434262794914382, -0.00388416451811043, -0.00336378514516177, -0.00368484200521179, -0.00336378514516178, -0.00300866089851429, -0.00260557676948629, -0.00212744452363026, -0.00212744452363027, -0.00194208225905522, -0.00173705117965753, -0.00150433044925714, -0.00122828066840393, -0.000868525589828766};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.00945067404923496, -0.00609788120679253, 0.00352061335622802, 0.00248944957812477, 0.00705946233325039, -0.00546823600997146, -0.00446479600584757, 0.00315708753234943, 0.00257775117585286, 0.00182274533665715, 0.00298267418725716, -0.00252081977982931, -0.00218309396769447, 0.00195261860521383, 0.00169101731601732, 0.00138070985681771, -0.00112734487734488, -0.000976309302606918, -0.000797153207506481, -0.00056367243867244, 0.00278687112460004, -0.00245778931055954, -0.00219831358911339, 0.00207721109304566, 0.00185791408306669, 0.00160900079398463, -0.00160900079398463, -0.00143913406048031, -0.0012463266558274, -0.00101762145320216, 0.000928957041533346, 0.000830884437218264, 0.000719567030240152, 0.0005875240199394, 0.000415442218609133, 0.00705593524717799, -0.00638233357089081, -0.00582624677716565, 0.00562868913761196, 0.00513826668309062, 0.0045958054359652, -0.00475711057319694, -0.00434262794914382, -0.00388416451811044, -0.00336378514516178, 0.00368484200521179, 0.00336378514516178, 0.00300866089851429, 0.00260557676948629, 0.00212744452363027, -0.00212744452363027, -0.00194208225905522, -0.00173705117965753, -0.00150433044925714, -0.00122828066840393, -0.000868525589828764};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.00945067404923496, 0.0, -0.00704122671245607, 0.00248944957812477, 0.0, 0.0, 0.0, 0.00947126259704828, -0.00515550235170571, 0.00182274533665715, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0045093795093795, -0.00292892790782074, 0.00159430641501296, -0.00056367243867244, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00464478520766673, -0.00332353774887305, 0.00215870109072045, -0.00117504803987881, 0.000415442218609129, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0127646671417816, -0.00971041129527609, 0.00694820471863012, -0.00451299134777144, 0.00245656133680786, -0.000868525589828762};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.00945067404923495, 0.0, 0.0, -0.0074683487343743, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0109364720199429, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00563672438672438, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00623163327913697, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0182390373864041};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.010023442173431, 0.0, 0.0374718748311399, -0.0289614183593722, 0.0, 0.0, 0.0, 0.0284137877911448, 0.00515550235170572, -0.00619733414463432, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0315656565656565, -0.0113902751970807, 0.00265717735835493, -0.000187890812890802, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0232239260383337, -0.00166176887443653, -0.00647610327216137, 0.00646276421933343, -0.0029080955302639, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0213629048496074, -0.0277928188745205, 0.0243701532779658, -0.0157219925555703, 0.00607967912880133};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.0100234421734311, 0.0, -0.028757485335526, 0.0536094339843699, 0.0, 0.0, 0.0, -0.0189425251940966, 0.0154665070551172, 0.0153110608279201, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0045093795093795, 0.0370997534990628, -0.0281660799985623, 0.0108976671476671, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0299118397398575, -0.00431740218144092, -0.0123380044187275, 0.00872428659079175, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0312669212338355, -0.0487403065559316, 0.041270230458372, -0.018239037386404};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.010023442173431, 0.0, 0.0409576306293855, -0.0449826285156208, 0.0, 0.0, 0.0, 0.0189425251940966, -0.00515550235170574, -0.0211438459052229, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00455611007883227, 0.0356061766019561, -0.0319414381914382, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0302218152700864, 0.00411266813957586, -0.0145404776513196, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0379091273212801, -0.0550269739444961, 0.0303983956440067};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.010023442173431, 0.0, -0.0148144621425437, 0.0449826285156208, 0.0, 0.0, 0.0, 0.0, 0.0206220094068228, 0.0211438459052229, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0106287094334197, 0.0319414381914382, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0205633406978791, 0.0145404776513196, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0343918587153101, -0.0303983956440068};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.010023442173431, 0.0324515955311978, -0.0187359374155699, -0.0289614183593722, 0.0211783869997511, -0.0164047080299143, 0.00446479600584758, 0.00947126259704828, -0.00257775117585285, -0.00619733414463429, 0.0208787193108001, -0.0176457384588051, -0.0084898098743674, 0.0136683302364968, 0.00657617845117845, 0.0023011830946962, -0.00789141414141413, -0.00379675839902689, -0.00132858867917746, -0.000187890812890802, 0.0139343556230002, -0.0122889465527977, -0.0010991567945567, 0.0103860554652283, 0.000928957041533345, -0.00482700238195389, -0.00804500396992314, -0.000719567030240155, 0.00373897996748219, 0.00559691799261186, 0.00464478520766673, 0.00041544221860913, -0.00215870109072046, -0.00323138210966671, -0.00290809553026393, 0.0, 0.0, 0.0128177429097644, 0.0, -0.0113041867027994, -0.0183832217438608, 0.0, 0.0095537814881164, 0.0155366580724417, 0.0181644397838736, 0.0, -0.00740032731935591, -0.0120346435940572, -0.014070114555226, -0.0136156449512337, 0.0, 0.00427258096992147, 0.00694820471863011, 0.00812338442598858, 0.00786099627778514, 0.00607967912880134};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.010023442173431, -0.0249047128495239, 0.0143787426677629, 0.0536094339843699, -0.0141189246665008, 0.0109364720199429, 0.0133943880175427, -0.00631417506469884, -0.00773325352755859, 0.01531106082792, -0.00298267418725715, 0.00252081977982931, 0.0276525235907967, -0.00195261860521383, -0.0214195526695527, -0.0243925408037797, 0.00112734487734488, 0.0123665844996876, 0.0140830399992811, 0.0108976671476671, 0.0, 0.0, 0.0197848223020205, 0.0, -0.0167212267476002, -0.00321800158796925, 0.0, 0.0129522065443228, 0.00249265331165478, -0.0106850252586226, 0.0, -0.00747795993496437, -0.0014391340604803, 0.00616900220936373, 0.00872428659079178, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0206811244618434, 0.0, 0.0, -0.017478740331497, -0.0363288795677472, 0.0, 0.0, 0.0135389740433143, 0.0281402291104519, 0.0357410679969885, 0.0, 0.0, -0.00781673030845888, -0.0162467688519772, -0.020635115229186, -0.018239037386404};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 10:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.010023442173431, 0.0354703486038674, -0.0204788153146927, -0.0449826285156207, 0.0141189246665008, -0.0109364720199429, -0.00446479600584757, 0.00631417506469884, 0.00257775117585286, -0.0211438459052229, 0.0, 0.0, 0.00339592394974695, 0.0, -0.00263047138047138, 0.0308358534689291, 0.0, 0.00151870335961075, -0.017803088300978, -0.0319414381914382, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0225260111157848, 0.0, 0.0, -0.0174485731815835, 0.00356167508620757, 0.0, 0.0, 0.0100739384233621, -0.00205633406978791, -0.0145404776513196, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0282557952193589, 0.0, 0.0, 0.0, -0.0218868448636848, -0.047654757329318, 0.0, 0.0, 0.0, 0.01263637577376, 0.027513486972248, 0.0303983956440067};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 11:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.010023442173431, -0.0128297005588457, 0.00740723107127183, 0.0449826285156208, 0.0, 0.0, 0.0178591840233903, 0.0, -0.0103110047034114, 0.0211438459052229, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00920473237878477, 0.0, 0.0, -0.00531435471670985, 0.0319414381914382, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0178083754310377, 0.0, 0.0, 0.0, -0.0102816703489395, 0.0145404776513196, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0297842233308238, 0.0, 0.0, 0.0, 0.0, -0.017195929357655, -0.0303983956440068};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 12:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.010023442173431, 0.0324515955311978, -0.0335503995581136, -0.00801060507812423, 0.0211783869997512, 0.0010936472019943, -0.0169662248222207, -0.00568275755822895, 0.00567105258687629, 0.00838462854862291, 0.0208787193108001, -0.0109235523792603, -0.0162519217595033, 0.00499002532443535, 0.00958243145743146, 0.0108922666482287, -0.00187890812890811, -0.00466458889023305, -0.00558007245254535, -0.00469727032227032, 0.0139343556230002, -0.00245778931055954, -0.0120907247401236, -0.00415442218609132, 0.00464478520766674, 0.00965400476390777, 0.00643600317593852, -0.000719567030240151, -0.00498530662330958, -0.006614539445814, -0.00464478520766673, -0.00041544221860913, 0.00215870109072045, 0.00323138210966671, 0.00290809553026392, 0.0, 0.0127646671417816, -0.00116524935543313, -0.0202632808954031, -0.00719357335632687, 0.00183832217438608, 0.0228341307513453, 0.0112908326677739, 0.00310733161448834, -0.00201827108709707, -0.020635115229186, -0.01143686949355, -0.00481385743762287, -0.000521115353897257, 0.00170195561890421, 0.0127646671417816, 0.00737991258440982, 0.00347410235931506, 0.000902598269554287, -0.000491312267361571, -0.000868525589828761};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 13:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.010023442173431, -0.0249047128495239, 0.0553363732971483, -0.00431340273437461, -0.0141189246665008, 0.0153110608279201, 0.00803663281052562, 0.00883984509057836, -0.0159820572902877, 0.000729098134662857, -0.00298267418725716, 0.0277290175781224, -0.00145539597846298, -0.0301571095694136, -0.0116492303992304, 0.00352848074520083, 0.0191648629148629, 0.00976309302606916, 0.00132858867917746, -0.00263047138047138, 0.0, 0.0196623144844763, -0.00219831358911338, -0.00727023882565979, -0.0148633126645335, 0.00402250198496157, -0.00724050357293084, 0.0129522065443227, 0.00685479660705068, -0.0045792965394097, 0.00928957041533347, -0.00664707549774611, -0.00575653624192121, -0.000293762009969703, 0.00290809553026393, 0.0, 0.0, 0.0, 0.0202632808954031, -0.00411061334647249, 0.000459580543596524, -0.0399597288148542, -0.00303983956440067, 0.00427258096992148, -0.00100913554354853, 0.0464290092656685, 0.00908221989193679, -0.00270779480866285, -0.00234501909253766, 0.00127646671417816, -0.031911667854454, -0.00776832903622086, 0.000868525589828761, 0.00180519653910857, 0.000245656133680787, -0.000868525589828764};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 14:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.010023442173431, 0.0354703486038674, -0.0492363006502186, -0.00431340273437461, 0.0141189246665008, -0.00656188321196574, -0.00982255121286466, -0.016416855168217, 0.0149509568199466, 0.000729098134662861, 0.0, 0.0033610930397724, -0.000485131992820985, 0.0282044909641998, -0.0124007936507936, 0.00291483191994851, -0.0353234728234728, 0.008895262534863, 0.00239145962251944, -0.00263047138047137, 0.0, 0.0, 0.0, 0.0218107164769794, -0.00557374224920008, 0.000804500396992314, -0.00402250198496156, -0.0143913406048031, 0.00934744991870546, -0.00254405363300538, -0.00928957041533347, 0.0141250354327105, -0.00287826812096062, -0.00381890612960612, 0.00290809553026392, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0266398192099028, -0.00911951869320203, 0.00233049871086626, -0.000336378514516179, -0.0515877880729651, 0.00840946286290445, 0.00300866089851429, -0.00286613444643492, 0.000850977809452103, 0.0425488904726053, -0.00388416451811043, -0.00347410235931506, 0.00120346435940572, 0.00098262453472315, -0.000868525589828769};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 15:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.010023442173431, -0.0128297005588457, 0.0448791059024117, -0.00801060507812421, 0.0, 0.0174983552319087, -0.00357183680467804, 0.0132597676358676, -0.0175287079957994, 0.0083846285486229, 0.0, 0.0, 0.0, 0.00867830491206146, -0.003006253006253, 0.000613648825252311, 0.0225468975468975, -0.019200749617936, 0.0122230158484327, -0.00469727032227033, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0160900079398463, -0.00719567030240153, 0.0024926533116548, -0.000508810726601082, 0.00464478520766675, -0.0108014976838374, 0.0107935054536023, -0.00734405024924252, 0.00290809553026392, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0257938940364826, -0.0134551405806471, 0.00601732179702859, -0.00208446141558904, 0.000425488904726057, -0.031911667854454, 0.0135945758133865, -0.00347410235931506, -0.00090259826955429, 0.00171959293576549, -0.000868525589828764};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 16:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.0100234421734309, -0.0324515955311978, -0.0187359374155699, -0.0289614183593722, 0.0211783869997511, 0.0164047080299144, -0.00446479600584757, 0.00947126259704828, -0.00257775117585285, -0.00619733414463429, -0.0208787193108001, -0.0176457384588052, -0.00848980987436741, -0.0136683302364968, -0.00657617845117845, -0.0023011830946962, -0.00789141414141414, -0.0037967583990269, -0.00132858867917746, -0.000187890812890811, 0.0139343556230002, 0.0122889465527977, 0.00109915679455668, 0.0103860554652283, 0.000928957041533337, -0.0048270023819539, 0.00804500396992314, 0.000719567030240144, -0.0037389799674822, -0.00559691799261186, 0.00464478520766673, 0.00041544221860913, -0.00215870109072047, -0.00323138210966672, -0.00290809553026394, 0.0, 0.0, 0.0128177429097644, 0.0, 0.0113041867027994, 0.0183832217438608, 0.0, 0.0095537814881164, 0.0155366580724417, 0.0181644397838736, 0.0, 0.0074003273193559, 0.0120346435940572, 0.014070114555226, 0.0136156449512337, 0.0, 0.00427258096992147, 0.00694820471863011, 0.00812338442598858, 0.00786099627778515, 0.00607967912880135};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 17:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.010023442173431, 0.0249047128495239, 0.014378742667763, 0.0536094339843699, -0.0141189246665007, -0.0109364720199429, -0.0133943880175427, -0.00631417506469884, -0.00773325352755857, 0.01531106082792, 0.00298267418725716, 0.00252081977982931, 0.0276525235907967, 0.00195261860521383, 0.0214195526695527, 0.0243925408037797, 0.00112734487734488, 0.0123665844996876, 0.0140830399992811, 0.0108976671476671, 0.0, 0.0, -0.0197848223020205, 0.0, -0.0167212267476002, -0.00321800158796924, 0.0, -0.0129522065443228, -0.00249265331165477, 0.0106850252586226, 0.0, -0.00747795993496437, -0.0014391340604803, 0.00616900220936374, 0.00872428659079179, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0206811244618434, 0.0, 0.0, -0.017478740331497, -0.0363288795677472, 0.0, 0.0, -0.0135389740433143, -0.0281402291104519, -0.0357410679969885, 0.0, 0.0, -0.00781673030845888, -0.0162467688519772, -0.020635115229186, -0.018239037386404};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 18:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.010023442173431, -0.0354703486038674, -0.0204788153146927, -0.0449826285156207, 0.0141189246665007, 0.0109364720199429, 0.00446479600584756, 0.00631417506469885, 0.00257775117585286, -0.0211438459052229, 0.0, 0.0, 0.00339592394974696, 0.0, 0.00263047138047138, -0.0308358534689291, 0.0, 0.00151870335961075, -0.017803088300978, -0.0319414381914382, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0225260111157848, 0.0, 0.0, 0.0174485731815835, -0.00356167508620757, 0.0, 0.0, 0.0100739384233621, -0.00205633406978793, -0.0145404776513197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0282557952193589, 0.0, 0.0, 0.0, 0.0218868448636848, 0.047654757329318, 0.0, 0.0, 0.0, 0.01263637577376, 0.027513486972248, 0.0303983956440068};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 19:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.010023442173431, 0.0128297005588457, 0.00740723107127183, 0.0449826285156208, 0.0, 0.0, -0.0178591840233903, 0.0, -0.0103110047034114, 0.0211438459052229, 0.0, 0.0, 0.0, 0.0, 0.0, -0.00920473237878477, 0.0, 0.0, -0.00531435471670984, 0.0319414381914382, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0178083754310377, 0.0, 0.0, 0.0, -0.0102816703489395, 0.0145404776513196, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0297842233308238, 0.0, 0.0, 0.0, 0.0, -0.017195929357655, -0.0303983956440068};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 20:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.0100234421734309, -0.0324515955311978, -0.0335503995581136, -0.00801060507812424, 0.0211783869997512, -0.00109364720199428, 0.0169662248222207, -0.00568275755822895, 0.00567105258687629, 0.00838462854862291, -0.0208787193108001, -0.0109235523792603, -0.0162519217595033, -0.00499002532443533, -0.00958243145743146, -0.0108922666482287, -0.00187890812890813, -0.00466458889023305, -0.00558007245254535, -0.00469727032227032, 0.0139343556230002, 0.00245778931055952, 0.0120907247401236, -0.00415442218609134, 0.00464478520766673, 0.00965400476390776, -0.00643600317593853, 0.000719567030240143, 0.00498530662330958, 0.00661453944581401, -0.00464478520766676, -0.000415442218609133, 0.00215870109072045, 0.00323138210966671, 0.00290809553026392, 0.0, 0.0127646671417816, -0.00116524935543313, 0.0202632808954031, 0.00719357335632687, -0.00183832217438607, 0.0228341307513453, 0.0112908326677739, 0.00310733161448834, -0.00201827108709707, 0.020635115229186, 0.01143686949355, 0.00481385743762287, 0.000521115353897259, -0.00170195561890422, 0.0127646671417816, 0.00737991258440982, 0.00347410235931506, 0.000902598269554281, -0.000491312267361567, -0.000868525589828765};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 21:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.010023442173431, 0.0249047128495239, 0.0553363732971484, -0.00431340273437461, -0.0141189246665008, -0.0153110608279201, -0.00803663281052562, 0.00883984509057835, -0.0159820572902877, 0.000729098134662849, 0.00298267418725716, 0.0277290175781224, -0.00145539597846298, 0.0301571095694136, 0.0116492303992304, -0.00352848074520084, 0.0191648629148629, 0.00976309302606917, 0.00132858867917746, -0.00263047138047138, 0.0, -0.0196623144844763, 0.00219831358911338, -0.00727023882565977, -0.0148633126645336, 0.00402250198496158, 0.00724050357293085, -0.0129522065443228, -0.00685479660705068, 0.0045792965394097, 0.00928957041533351, -0.00664707549774611, -0.00575653624192122, -0.000293762009969695, 0.00290809553026392, 0.0, 0.0, 0.0, -0.0202632808954031, 0.00411061334647249, -0.000459580543596525, -0.0399597288148542, -0.00303983956440068, 0.00427258096992149, -0.00100913554354853, -0.0464290092656686, -0.0090822198919368, 0.00270779480866286, 0.00234501909253766, -0.00127646671417816, -0.031911667854454, -0.00776832903622086, 0.000868525589828746, 0.00180519653910859, 0.000245656133680777, -0.000868525589828759};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 22:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.0100234421734309, -0.0354703486038674, -0.0492363006502186, -0.00431340273437459, 0.0141189246665008, 0.00656188321196577, 0.00982255121286462, -0.016416855168217, 0.0149509568199465, 0.000729098134662873, 0.0, 0.0033610930397724, -0.000485131992820981, -0.0282044909641998, 0.0124007936507937, -0.00291483191994851, -0.0353234728234728, 0.00889526253486299, 0.00239145962251945, -0.00263047138047138, 0.0, 0.0, 0.0, 0.0218107164769794, -0.00557374224920007, 0.00080450039699232, 0.00402250198496157, 0.0143913406048031, -0.00934744991870546, 0.0025440536330054, -0.00928957041533351, 0.0141250354327105, -0.00287826812096061, -0.00381890612960613, 0.00290809553026393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0266398192099028, -0.00911951869320202, 0.00233049871086626, -0.000336378514516183, 0.0515877880729651, -0.00840946286290443, -0.00300866089851429, 0.00286613444643493, -0.000850977809452109, 0.0425488904726053, -0.00388416451811043, -0.00347410235931504, 0.00120346435940571, 0.00098262453472316, -0.000868525589828774};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 23:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.010023442173431, 0.0128297005588457, 0.0448791059024117, -0.00801060507812422, 0.0, -0.0174983552319087, 0.00357183680467805, 0.0132597676358676, -0.0175287079957994, 0.0083846285486229, 0.0, 0.0, 0.0, -0.00867830491206147, 0.00300625300625301, -0.000613648825252319, 0.0225468975468975, -0.019200749617936, 0.0122230158484327, -0.00469727032227032, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0160900079398463, 0.00719567030240152, -0.00249265331165479, 0.000508810726601079, 0.00464478520766676, -0.0108014976838374, 0.0107935054536023, -0.00734405024924252, 0.00290809553026392, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0257938940364826, 0.0134551405806471, -0.00601732179702859, 0.00208446141558903, -0.000425488904726057, -0.031911667854454, 0.0135945758133865, -0.00347410235931506, -0.000902598269554282, 0.00171959293576549, -0.000868525589828763};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 24:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.010023442173431, -0.0452812960900435, -0.0113287063442981, -0.00801060507812424, -0.00141189246665006, 0.0164047080299144, 0.0133943880175427, 0.0145226026488074, 0.0118576554089232, 0.00838462854862292, -0.00894802256177148, -0.0142846454190327, -0.0123708658169354, -0.014536160727703, -0.0125886844636845, -0.0102786178229764, -0.00939454064454065, -0.00813591085505763, -0.00664294339588732, -0.00469727032227033, -0.00836061337380015, 0.00245778931055953, 0.00219831358911339, 0.00830884437218262, 0.00743165633226677, 0.0064360031759385, 0.00965400476390777, 0.00863480436288184, 0.00747795993496438, 0.00610572871921295, 0.00650269929073342, 0.00581619106052785, 0.00503696921168107, 0.00411266813957581, 0.00290809553026391, 0.0352796762358899, 0.0191470007126724, 0.0174787403314969, 0.00788016479265675, 0.00719357335632688, 0.00643412761035129, 0.000951422114639392, 0.000868525589828756, 0.000776832903622077, 0.00067275702903235, -0.00221090520312707, -0.00201827108709706, -0.00180519653910857, -0.00156334606169177, -0.00127646671417816, -0.00212744452363026, -0.00194208225905522, -0.00173705117965753, -0.00150433044925715, -0.00122828066840393, -0.000868525589828761};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 25:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.0100234421734309, 0.0603750614533913, -0.00610007264692971, -0.00431340273437461, -0.00564756986660035, -0.0218729440398858, -0.0178591840233902, 0.00126283501293976, 0.00103110047034113, 0.000729098134662847, 0.0417574386216002, 0.0168054651988621, 0.0145539597846298, -0.000867830491206143, -0.000751563251563238, -0.000613648825252313, -0.00526094276094276, -0.00455611007883229, -0.00372004830169691, -0.00263047138047139, 0.00557374224920013, -0.0196623144844763, -0.0175865087129071, -0.0103860554652283, -0.00928957041533347, -0.00804500396992313, 0.00321800158796925, 0.00287826812096061, 0.00249265331165479, 0.00203524290640429, 0.00650269929073344, 0.00581619106052785, 0.00503696921168108, 0.00411266813957583, 0.00290809553026394, -0.0705593524717798, -0.0127646671417816, -0.0116524935543313, 0.00450295131008957, 0.00411061334647248, 0.00367664434877215, 0.00380568845855754, 0.00347410235931507, 0.00310733161448836, 0.00269102811612943, -0.000736968401042359, -0.000672757029032369, -0.000601732179702874, -0.000521115353897271, -0.000425488904726046, -0.00212744452363028, -0.00194208225905521, -0.00173705117965752, -0.00150433044925714, -0.00122828066840393, -0.000868525589828765};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 26:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.0100234421734311, -0.0603750614533913, -0.00610007264692977, -0.00431340273437461, -0.00564756986660029, 0.0218729440398858, 0.0178591840233902, 0.00126283501293978, 0.00103110047034116, 0.000729098134662881, -0.0417574386216002, 0.016805465198862, 0.0145539597846298, 0.000867830491206143, 0.000751563251563235, 0.000613648825252312, -0.00526094276094277, -0.00455611007883227, -0.00372004830169691, -0.00263047138047137, 0.00557374224920005, 0.0196623144844763, 0.0175865087129071, -0.0103860554652283, -0.00928957041533347, -0.00804500396992315, -0.00321800158796926, -0.00287826812096061, -0.00249265331165479, -0.0020352429064043, 0.00650269929073342, 0.00581619106052784, 0.00503696921168108, 0.00411266813957581, 0.00290809553026392, 0.0705593524717798, -0.0127646671417816, -0.0116524935543313, -0.00450295131008957, -0.00411061334647248, -0.00367664434877216, 0.00380568845855755, 0.00347410235931505, 0.00310733161448834, 0.00269102811612941, 0.000736968401042367, 0.000672757029032373, 0.000601732179702876, 0.000521115353897275, 0.000425488904726052, -0.00212744452363026, -0.00194208225905522, -0.00173705117965753, -0.00150433044925715, -0.00122828066840393, -0.000868525589828766};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 27:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.010023442173431, 0.0452812960900435, -0.0113287063442981, -0.00801060507812425, -0.00141189246665008, -0.0164047080299144, -0.0133943880175427, 0.0145226026488074, 0.0118576554089231, 0.0083846285486229, 0.0089480225617715, -0.0142846454190327, -0.0123708658169354, 0.014536160727703, 0.0125886844636845, 0.0102786178229764, -0.00939454064454064, -0.00813591085505764, -0.00664294339588732, -0.00469727032227033, -0.00836061337380011, -0.00245778931055955, -0.00219831358911339, 0.00830884437218264, 0.00743165633226678, 0.00643600317593852, -0.00965400476390778, -0.00863480436288184, -0.00747795993496438, -0.00610572871921294, 0.00650269929073343, 0.00581619106052785, 0.00503696921168107, 0.00411266813957582, 0.00290809553026392, -0.0352796762358899, 0.0191470007126724, 0.017478740331497, -0.00788016479265675, -0.00719357335632687, -0.00643412761035128, 0.00095142211463939, 0.000868525589828763, 0.000776832903622088, 0.000672757029032363, 0.00221090520312707, 0.00201827108709705, 0.00180519653910857, 0.00156334606169177, 0.00127646671417816, -0.00212744452363027, -0.00194208225905522, -0.00173705117965753, -0.00150433044925715, -0.00122828066840393, -0.000868525589828761};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 28:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.0787556170769579, 0.0679219441350653, -0.00435719474780701, -0.00308100195312472, 0.0705946233325039, -0.0328094160598288, -0.0267887760350854, 0.0126283501293977, 0.03608851646194, -0.00729098134662864, 0.0298267418725716, 0.0151249186789758, 0.0130985638061669, -0.0325436434202305, -0.0229226791726792, -0.024852777422719, 0.0248015873015873, 0.0169226945785199, 0.0164744996218006, 0.0142797017797018, 0.0, 0.0245778931055954, 0.0219831358911339, -0.0363511941282991, -0.00743165633226678, -0.0345935170706695, 0.0362025178646542, 0.0, 0.0130864298861876, 0.0335815079556711, -0.0232239260383337, 0.00166176887443653, -0.00359783515120075, -0.0146881004984851, -0.0178640154001927, 0.0, 0.0, 0.0, 0.0, 0.0226083734055987, -0.00459580543596521, 0.0, -0.0334382352084074, -0.0194208225905522, 0.0090822198919368, 0.0, 0.0333014729371016, 0.0270779480866286, 0.00703505727761298, -0.0102117337134253, 0.0, -0.0213629048496074, -0.0191075629762328, -0.00812338442598858, 0.00196524906944629, 0.00607967912880134};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 29:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.0214788046573521, 0.00377344134083697, 0.00217859737390355, -0.021567013671873, 0.0, 0.0984282481794862, -0.0312535720409329, -0.0852413633734345, -0.01804425823097, 0.0309866707231716, 0.0, 0.0453747560369276, -0.0116431678277039, 0.0, 0.0236742424242424, -0.00138070985681771, -0.0202922077922078, -0.0335199527228374, -0.000797153207506509, 0.00394570707070706, 0.0, 0.0, 0.0, 0.0363511941282991, 0.024152883079867, -0.00724050357293084, -0.0603375297744235, 0.0, -0.039259289658563, 0.0188259968842399, 0.0464478520766673, -0.0108014976838374, 0.0259044130886455, 0.010869194368879, -0.0178640154001927, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0334382352084074, -0.0155366580724417, 0.0030274066306456, 0.0, -0.0555024548951693, 0.0, 0.0164151336477636, -0.00680782247561686, 0.0, 0.0427258096992148, 0.00694820471863013, -0.0108311792346515, -0.0039304981388926, 0.00607967912880136};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 30:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.078755617076958, 0.0301875307266957, 0.0610007264692975, -0.00308100195312466, 0.0, 0.0218729440398858, 0.0178591840233903, 0.0757701007763863, -0.0412440188136457, -0.00729098134662864, 0.0, 0.0, 0.0, 0.0520698294723688, -0.0127765752765753, 0.00184094647575696, -0.00901875901875901, 0.0286384062098029, -0.0297603864135752, 0.0142797017797018, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0402250198496157, 0.014391340604803, -0.0137095932141014, 0.00407048581280863, -0.0464478520766673, 0.0182794576188018, -0.0345392174515274, 0.0364264892362429, -0.0178640154001927, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0370016365967795, -0.0300866089851429, 0.014070114555226, -0.00340391123780843, 0.0, -0.0427258096992148, 0.0243187165152054, 0.0, -0.00982624534723142, 0.00607967912880136};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 31:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.0214788046573521, 0.00377344134083679, -0.0196073763651312, 0.00924300585937423, 0.0, -0.010936472019943, 0.102690308134494, 0.00947126259704826, -0.0695992817480271, -0.060150596109686, 0.0, -0.00504163955965861, 0.0465726713108155, 0.00650872868404609, 0.0214195526695527, -0.00782402252196699, -0.00450937950937951, -0.0289638426440052, -0.0263060558477138, 0.000563672438672422, 0.0, 0.0, 0.0, 0.0, 0.0334424534952005, 0.0289620142917233, 0.0, -0.0431740218144092, -0.00249265331165476, -0.0605484764655283, 0.0, 0.0299118397398575, -0.00431740218144095, 0.0185070066280912, 0.0461140862656136, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0349574806629939, -0.0121096265225824, 0.0, 0.0, -0.0451299134777144, -0.0281402291104519, 0.023827378664659, 0.0, 0.0, 0.0312669212338355, 0.0270779480866286, 0.0, -0.018239037386404};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 32:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.0214788046573522, -0.0150937653633478, 0.0130715842434208, 0.00924300585937413, 0.0, -0.0109364720199429, -0.00892959201169512, 0.00947126259704829, 0.123732056440937, -0.0601505961096861, 0.0, 0.0, 0.0, -0.00650872868404609, 0.0574945887445887, -0.0266937238984759, 0.00676406926406925, 0.0126920209338899, 0.00637722566005185, 0.000563672438672456, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0431740218144092, 0.0199412264932383, -0.0142467003448302, 0.0, -0.0448677596097863, 0.0215870109072046, -0.0616900220936373, 0.0461140862656137, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0451299134777144, -0.0375203054806026, 0.0119136893323295, 0.0, 0.0, -0.0469003818507533, 0.0162467688519772, 0.020635115229186, -0.0182390373864041};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 33:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.0787556170769579, 0.0301875307266957, 0.0174287789912278, 0.0585390371093694, 0.0, 0.0218729440398858, 0.0178591840233902, -0.0189425251940966, 0.0103110047034114, 0.083846285486229, 0.0, 0.0, 0.0, 0.0, 0.00526094276094275, 0.0533874477969518, 0.0, -0.00455611007883227, 0.0308232573569172, -0.0319414381914382, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0348971463631671, 0.0284934006896603, 0.0, 0.0, -0.0302218152700864, 0.0164506725583033, -0.0643935438844155, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0437736897273697, -0.023827378664659, 0.0, 0.0, 0.0, -0.0379091273212801, -0.013756743486124, 0.0303983956440068};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 34:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.0787556170769578, -0.0679219441350653, -0.00435719474780704, -0.00308100195312474, 0.0705946233325039, 0.0328094160598287, 0.0267887760350854, 0.0126283501293977, 0.03608851646194, -0.00729098134662863, -0.0298267418725716, 0.0151249186789759, 0.0130985638061669, 0.0325436434202305, 0.0229226791726792, 0.024852777422719, 0.0248015873015873, 0.0169226945785199, 0.0164744996218006, 0.0142797017797018, 0.0, -0.0245778931055953, -0.0219831358911338, -0.036351194128299, -0.00743165633226677, -0.0345935170706695, -0.0362025178646541, 0.0, -0.0130864298861876, -0.0335815079556711, -0.0232239260383337, 0.00166176887443653, -0.00359783515120076, -0.0146881004984851, -0.0178640154001927, 0.0, 0.0, 0.0, 0.0, -0.0226083734055987, 0.00459580543596521, 0.0, -0.0334382352084074, -0.0194208225905522, 0.00908221989193679, 0.0, -0.0333014729371016, -0.0270779480866286, -0.00703505727761297, 0.0102117337134253, 0.0, -0.0213629048496074, -0.0191075629762328, -0.00812338442598856, 0.00196524906944629, 0.00607967912880134};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 35:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.0214788046573521, -0.00377344134083696, 0.00217859737390356, -0.021567013671873, 0.0, -0.0984282481794863, 0.031253572040933, -0.0852413633734345, -0.01804425823097, 0.0309866707231716, 0.0, 0.0453747560369276, -0.0116431678277039, 0.0, -0.0236742424242424, 0.00138070985681773, -0.0202922077922078, -0.0335199527228374, -0.000797153207506523, 0.00394570707070709, 0.0, 0.0, 0.0, 0.036351194128299, 0.024152883079867, -0.00724050357293083, 0.0603375297744236, 0.0, 0.039259289658563, -0.0188259968842399, 0.0464478520766673, -0.0108014976838374, 0.0259044130886455, 0.010869194368879, -0.0178640154001927, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0334382352084074, -0.0155366580724417, 0.00302740663064559, 0.0, 0.0555024548951693, 0.0, -0.0164151336477637, 0.00680782247561684, 0.0, 0.0427258096992147, 0.00694820471863015, -0.0108311792346515, -0.00393049813889259, 0.00607967912880135};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 36:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.0787556170769579, -0.0301875307266957, 0.0610007264692974, -0.00308100195312475, 0.0, -0.0218729440398858, -0.0178591840233903, 0.0757701007763862, -0.0412440188136457, -0.00729098134662862, 0.0, 0.0, 0.0, -0.0520698294723688, 0.0127765752765753, -0.00184094647575695, -0.00901875901875899, 0.0286384062098028, -0.0297603864135752, 0.0142797017797018, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0402250198496157, -0.0143913406048031, 0.0137095932141014, -0.00407048581280862, -0.0464478520766673, 0.0182794576188018, -0.0345392174515274, 0.0364264892362429, -0.0178640154001927, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0370016365967796, 0.030086608985143, -0.014070114555226, 0.00340391123780844, 0.0, -0.0427258096992147, 0.0243187165152054, 0.0, -0.00982624534723144, 0.00607967912880137};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 37:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.0214788046573521, -0.00377344134083692, -0.0196073763651313, 0.00924300585937421, 0.0, 0.0109364720199429, -0.102690308134494, 0.00947126259704825, -0.0695992817480272, -0.060150596109686, 0.0, -0.00504163955965862, 0.0465726713108155, -0.00650872868404611, -0.0214195526695527, 0.00782402252196702, -0.00450937950937952, -0.0289638426440052, -0.0263060558477138, 0.000563672438672383, 0.0, 0.0, 0.0, 0.0, 0.0334424534952005, 0.0289620142917233, 0.0, 0.0431740218144092, 0.00249265331165474, 0.0605484764655282, 0.0, 0.0299118397398575, -0.00431740218144096, 0.0185070066280912, 0.0461140862656136, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0349574806629939, -0.0121096265225824, 0.0, 0.0, 0.0451299134777144, 0.0281402291104519, -0.023827378664659, 0.0, 0.0, 0.0312669212338355, 0.0270779480866286, 0.0, -0.018239037386404};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 38:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.0214788046573524, 0.0150937653633479, 0.0130715842434208, 0.00924300585937416, 0.0, 0.0109364720199429, 0.00892959201169514, 0.00947126259704829, 0.123732056440937, -0.060150596109686, 0.0, 0.0, 0.0, 0.00650872868404611, -0.0574945887445887, 0.0266937238984759, 0.00676406926406924, 0.0126920209338899, 0.00637722566005187, 0.000563672438672437, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0431740218144092, -0.0199412264932383, 0.0142467003448302, 0.0, -0.0448677596097863, 0.0215870109072046, -0.0616900220936373, 0.0461140862656137, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0451299134777144, 0.0375203054806026, -0.0119136893323295, 0.0, 0.0, -0.0469003818507533, 0.0162467688519772, 0.020635115229186, -0.0182390373864041};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 39:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.0787556170769579, -0.0301875307266957, 0.017428778991228, 0.0585390371093694, 0.0, -0.0218729440398858, -0.0178591840233903, -0.0189425251940965, 0.0103110047034114, 0.083846285486229, 0.0, 0.0, 0.0, 0.0, -0.00526094276094274, -0.0533874477969518, 0.0, -0.00455611007883226, 0.0308232573569171, -0.0319414381914382, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.034897146363167, -0.0284934006896604, 0.0, 0.0, -0.0302218152700864, 0.0164506725583033, -0.0643935438844155, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0437736897273697, 0.023827378664659, 0.0, 0.0, 0.0, -0.0379091273212801, -0.013756743486124, 0.0303983956440068};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 40:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.0787556170769578, -0.0377344134083697, -0.0566435317214905, -0.00308100195312475, 0.0423567739995023, 0.0546823600997146, 0.0446479600584757, 0.0378850503881931, 0.00515550235170571, -0.00729098134662862, 0.0417574386216002, -0.00504163955965862, 0.0295930515620807, -0.0247331689993752, 0.0101461038961039, 0.0266937238984759, -0.0202922077922078, 0.00216957622801537, 0.0132858867917747, 0.0142797017797018, -0.0557374224920008, -0.0245778931055954, -0.00219831358911336, -0.00519302773261413, -0.0130053985814668, -0.0168945083368386, 0.00402250198496157, -0.0158304746652834, -0.026796023100289, -0.0295110221428625, 0.00464478520766674, -0.0108014976838374, -0.0194283098164841, -0.0217383887377579, -0.0178640154001927, 0.0, 0.0, -0.0512709716390577, 0.0, -0.0226083734055987, -0.0367664434877216, 0.0, -0.00477689074405818, -0.00776832903622085, -0.00908221989193679, 0.0, 0.00370016365967795, 0.00601732179702858, 0.00703505727761299, 0.00680782247561686, 0.0, 0.00427258096992149, 0.00694820471863011, 0.00812338442598859, 0.00786099627778515, 0.00607967912880134};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 41:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.0214788046573521, 0.0, -0.004357194747807, -0.021567013671873, -0.127070321998507, 0.0, 0.0, 0.0284137877911448, 0.03608851646194, 0.0309866707231716, 0.0, 0.0453747560369276, -0.0422064833754265, 0.0, 0.0, 0.0, -0.0202922077922078, -0.00618329224984378, 0.00159430641501297, 0.00394570707070706, 0.0836061337380012, 0.0, 0.0, -0.0103860554652283, 0.024152883079867, 0.043443021437585, 0.0, 0.0, 0.0, 0.0, 0.00464478520766672, -0.0108014976838374, -0.0194283098164841, -0.0217383887377579, -0.0178640154001927, 0.0, 0.0, 0.0769064574585865, 0.0, 0.0, 0.0, 0.0, -0.00955378148811643, -0.0155366580724418, -0.0181644397838736, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00427258096992146, 0.0069482047186301, 0.00812338442598858, 0.00786099627778515, 0.00607967912880136};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 42:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.0787556170769578, 0.0377344134083696, -0.0566435317214905, -0.00308100195312472, 0.0423567739995023, -0.0546823600997145, -0.0446479600584756, 0.0378850503881931, 0.0051555023517057, -0.0072909813466286, -0.0417574386216002, -0.00504163955965864, 0.0295930515620807, 0.0247331689993752, -0.0101461038961039, -0.0266937238984759, -0.0202922077922078, 0.00216957622801536, 0.0132858867917746, 0.0142797017797018, -0.0557374224920008, 0.0245778931055953, 0.00219831358911338, -0.00519302773261414, -0.0130053985814669, -0.0168945083368386, -0.00402250198496158, 0.0158304746652834, 0.026796023100289, 0.0295110221428625, 0.00464478520766675, -0.0108014976838374, -0.0194283098164841, -0.0217383887377579, -0.0178640154001927, 0.0, 0.0, -0.0512709716390577, 0.0, 0.0226083734055987, 0.0367664434877216, 0.0, -0.00477689074405819, -0.00776832903622085, -0.0090822198919368, 0.0, -0.00370016365967796, -0.0060173217970286, -0.00703505727761299, -0.00680782247561685, 0.0, 0.00427258096992149, 0.00694820471863012, 0.00812338442598859, 0.00786099627778516, 0.00607967912880135};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 43:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.0214788046573521, -0.0188672067041847, 0.00653579212171047, 0.00924300585937427, 0.0141189246665008, 0.0, -0.111619900146189, -0.00315708753234943, -0.0541327746929101, -0.060150596109686, -0.00894802256177148, -0.0025208197798293, -0.0276525235907967, 0.000650872868404625, 0.0360750360750361, -0.0188697013765088, 0.00112734487734488, 0.0374251899332651, 0.019928830187662, 0.000563672438672404, 0.0, 0.0, 0.0593544669060614, 0.0, 0.0167212267476002, 0.00321800158796921, 0.0, -0.0043174021814409, 0.0224338798048931, 0.0463017761206981, 0.0, -0.00747795993496436, 0.018708742786244, 0.0431830154655461, 0.0461140862656137, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0620433733855302, 0.0, 0.0, 0.0174787403314969, 0.0363288795677472, 0.0, 0.0, -0.00451299134777144, -0.00938007637015064, -0.0119136893323295, 0.0, 0.0, -0.00781673030845887, -0.0162467688519772, -0.020635115229186, -0.0182390373864041};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 44:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.0214788046573522, 0.0188672067041847, 0.00653579212171049, 0.00924300585937416, 0.0141189246665008, 0.0, 0.111619900146189, -0.00315708753234941, -0.05413277469291, -0.0601505961096861, 0.0089480225617715, -0.0025208197798293, -0.0276525235907967, -0.000650872868404616, -0.0360750360750361, 0.0188697013765088, 0.00112734487734487, 0.0374251899332651, 0.019928830187662, 0.000563672438672466, 0.0, 0.0, -0.0593544669060614, 0.0, 0.0167212267476002, 0.00321800158796926, 0.0, 0.00431740218144093, -0.0224338798048931, -0.0463017761206981, 0.0, -0.00747795993496438, 0.018708742786244, 0.0431830154655461, 0.0461140862656137, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0620433733855302, 0.0, 0.0, 0.0174787403314969, 0.0363288795677472, 0.0, 0.0, 0.00451299134777146, 0.00938007637015065, 0.0119136893323295, 0.0, 0.0, -0.00781673030845887, -0.0162467688519772, -0.020635115229186, -0.0182390373864041};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 45:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.0787556170769579, 0.0, -0.0348575579824557, 0.0585390371093694, -0.0282378493330015, 0.0, 0.0, 0.00631417506469885, -0.0206220094068228, 0.083846285486229, 0.0, 0.0, -0.00679184789949392, 0.0, 0.0, 0.0, 0.0, 0.00151870335961075, -0.0616465147138344, -0.0319414381914382, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0450520222315696, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0100739384233622, -0.0329013451166065, -0.0643935438844155, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0565115904387179, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.01263637577376, 0.027513486972248, 0.0303983956440068};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 46:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.0787556170769576, -0.0377344134083697, -0.0217859737390349, -0.0523770332031201, 0.0423567739995023, 0.0546823600997146, 0.0446479600584756, 0.0, 0.0257775117585286, 0.0291639253865144, 0.0417574386216003, 0.0285692908380655, -0.00921750786359888, 0.0273366604729936, -0.00789141414141415, -0.0248527774227189, 0.0187890812890813, -0.00347132196482461, -0.0143487577351166, -0.015031265031265, -0.0557374224920008, -0.00491557862111904, -0.0241814494802472, -0.0197335053839337, -0.00928957041533347, -0.00241350119097693, -0.0394205194526234, -0.0158304746652834, -0.000623163327913692, 0.00712335017241508, -0.0325134964536671, -0.0141250354327105, -0.00215870109072045, 0.00411266813957583, 0.00540074884191874, 0.0, -0.0510586685671264, 0.0046609974217325, -0.0405265617908061, -0.0143871467126537, 0.00367664434877216, -0.0114170653756726, -0.00564541633388695, -0.00155366580724416, 0.00100913554354853, 0.010317557614593, 0.00571843474677502, 0.00240692871881143, 0.00026055767694862, -0.000850977809452103, 0.0127646671417816, 0.00737991258440985, 0.00347410235931507, 0.000902598269554295, -0.000491312267361573, -0.000868525589828774};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 47:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.0214788046573518, 0.0, -0.0217859737390347, 0.00308100195312468, -0.127070321998507, 0.0, 0.0, 0.0473563129852414, 0.0257775117585286, 0.0127592173566001, 0.0, -0.0352914769176103, 0.0509388592462045, 0.0, 0.0, 0.0, 0.00225468975468978, -0.00943765659186684, -0.0143487577351166, -0.0129644660894661, 0.0836061337380012, 0.0, 0.0, 0.0477758551400501, 0.00928957041533348, -0.0144810071458617, 0.0, 0.0, 0.0, 0.0, -0.0325134964536672, -0.0141250354327105, -0.00215870109072047, 0.0041126681395758, 0.00540074884191869, 0.0, 0.0765880028506896, -0.00699149613259876, 0.0, 0.0, 0.0, -0.0228341307513453, -0.011290832667774, -0.00310733161448836, 0.00201827108709708, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0127646671417816, 0.0073799125844098, 0.00347410235931505, 0.000902598269554274, -0.000491312267361568, -0.000868525589828758};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 48:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.0787556170769578, 0.0377344134083696, -0.0217859737390348, -0.0523770332031201, 0.0423567739995023, -0.0546823600997146, -0.0446479600584756, 0.0, 0.0257775117585286, 0.0291639253865144, -0.0417574386216002, 0.0285692908380655, -0.0092175078635989, -0.0273366604729936, 0.00789141414141413, 0.0248527774227189, 0.0187890812890813, -0.0034713219648246, -0.0143487577351166, -0.015031265031265, -0.0557374224920008, 0.00491557862111908, 0.0241814494802472, -0.0197335053839337, -0.00928957041533347, -0.00241350119097693, 0.0394205194526234, 0.0158304746652834, 0.000623163327913709, -0.00712335017241509, -0.0325134964536671, -0.0141250354327105, -0.00215870109072044, 0.00411266813957583, 0.00540074884191873, 0.0, -0.0510586685671264, 0.00466099742173251, 0.0405265617908061, 0.0143871467126537, -0.00367664434877215, -0.0114170653756727, -0.00564541633388695, -0.00155366580724416, 0.00100913554354853, -0.010317557614593, -0.00571843474677501, -0.00240692871881144, -0.000260557676948624, 0.000850977809452111, 0.0127646671417816, 0.00737991258440985, 0.00347410235931507, 0.000902598269554293, -0.000491312267361575, -0.00086852558982877};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 49:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.021478804657352, -0.0188672067041848, 0.0108929868695175, 0.00308100195312467, 0.0141189246665008, -0.109364720199429, 0.0223239800292378, -0.0789271883087357, -0.0128887558792643, 0.0127592173566001, -0.00894802256177149, -0.0277290175781224, 0.00145539597846298, -0.00585785581564147, 0.0383297258297258, -0.0124263887113595, 0.0191648629148629, 0.0348216984596467, 0.00717437886755832, -0.0129644660894661, 0.0, 0.0589869434534289, -0.00659494076734013, 0.00727023882565976, 0.0148633126645336, -0.00402250198496158, 0.0506835250105158, -0.00431740218144092, -0.00810112326287806, 0.00356167508620755, 0.0650269929073343, -0.00166176887443651, -0.0115130724838425, -0.0020563340697879, 0.00540074884191872, 0.0, 0.0, 0.0, 0.0607898426862092, -0.0123318400394175, 0.00137874163078957, 0.0399597288148543, 0.00303983956440068, -0.00427258096992149, 0.00100913554354853, -0.0154763364218896, -0.00302740663064559, 0.00090259826955429, 0.000781673030845888, -0.000425488904726055, -0.031911667854454, -0.00776832903622089, 0.00086852558982876, 0.00180519653910858, 0.00024565613368078, -0.000868525589828765};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 50:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.0214788046573521, 0.0188672067041847, 0.0108929868695175, 0.00308100195312471, 0.0141189246665008, 0.109364720199429, -0.0223239800292378, -0.0789271883087356, -0.0128887558792643, 0.0127592173566001, 0.00894802256177148, -0.0277290175781224, 0.00145539597846297, 0.00585785581564144, -0.0383297258297258, 0.0124263887113595, 0.0191648629148629, 0.0348216984596467, 0.00717437886755832, -0.0129644660894661, 0.0, -0.0589869434534289, 0.00659494076734015, 0.00727023882565981, 0.0148633126645335, -0.00402250198496157, -0.0506835250105158, 0.00431740218144094, 0.00810112326287806, -0.00356167508620756, 0.0650269929073343, -0.00166176887443652, -0.0115130724838425, -0.0020563340697879, 0.00540074884191872, 0.0, 0.0, 0.0, -0.0607898426862092, 0.0123318400394175, -0.00137874163078957, 0.0399597288148542, 0.00303983956440067, -0.00427258096992148, 0.00100913554354854, 0.0154763364218896, 0.0030274066306456, -0.000902598269554289, -0.000781673030845889, 0.00042548890472606, -0.031911667854454, -0.0077683290362209, 0.000868525589828759, 0.00180519653910858, 0.000245656133680777, -0.000868525589828763};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 51:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.0787556170769578, 0.0, 0.0435719474780696, -0.05237703320312, -0.0282378493330015, 0.0, 0.0, 0.0631417506469885, -0.0515550235170572, 0.0291639253865144, 0.0, -0.00672218607954481, 0.000970263985641985, 0.0, 0.0, 0.0, -0.0601250601250601, -0.0125835421224892, 0.0286975154702333, -0.015031265031265, 0.0, 0.0, 0.0, -0.0436214329539588, 0.0111474844984002, -0.00160900079398463, 0.0, 0.0, 0.0, 0.0, -0.0650269929073343, 0.031573608614294, -0.0028782681209606, -0.00822533627915165, 0.00540074884191872, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0532796384198057, 0.0182390373864041, -0.00466099742173251, 0.000672757029032359, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0425488904726053, -0.00388416451811041, -0.00347410235931506, 0.00120346435940572, 0.000982624534723163, -0.000868525589828766};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 52:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.107394023286761, -0.188672067041848, -0.108929868695174, -0.0770250488281178, -0.0705946233325039, -0.0546823600997146, -0.0446479600584757, -0.0315708753234943, -0.0257775117585286, -0.0182274533665715, 0.0894802256177148, -0.0151249186789759, -0.0130985638061669, 0.0585785581564149, -0.028183621933622, 0.0690354928408859, 0.0744047619047619, 0.00976309302606914, 0.0398576603753239, 0.0597492784992785, 0.0, 0.0737336793167861, 0.0659494076734016, 0.036351194128299, 0.00743165633226675, 0.0345935170706695, -0.0120675059548847, 0.0431740218144092, 0.0155790831978425, -0.0254405363300539, -0.0232239260383337, 0.0465295284842228, 0.0251848460584054, -0.0146881004984851, -0.0328199352701215, 0.0, 0.0, 0.0, 0.0, 0.0678251202167962, -0.0137874163078956, 0.0, 0.0334382352084074, 0.0194208225905522, -0.00908221989193681, 0.0, -0.0111004909790338, -0.00902598269554288, -0.00234501909253764, 0.0034039112378084, 0.0, -0.0213629048496074, -0.0191075629762328, -0.00812338442598858, 0.0019652490694463, 0.00607967912880138};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 53:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.107394023286761, 0.188672067041848, -0.108929868695174, -0.0770250488281178, -0.0705946233325039, 0.0546823600997146, 0.0446479600584757, -0.0315708753234942, -0.0257775117585286, -0.0182274533665715, -0.0894802256177148, -0.0151249186789758, -0.0130985638061669, -0.0585785581564149, 0.028183621933622, -0.0690354928408859, 0.0744047619047619, 0.00976309302606914, 0.0398576603753239, 0.0597492784992785, 0.0, -0.0737336793167861, -0.0659494076734016, 0.0363511941282991, 0.0074316563322668, 0.0345935170706696, 0.0120675059548847, -0.0431740218144092, -0.0155790831978425, 0.0254405363300538, -0.0232239260383337, 0.0465295284842228, 0.0251848460584054, -0.0146881004984851, -0.0328199352701214, 0.0, 0.0, 0.0, 0.0, -0.0678251202167962, 0.0137874163078956, 0.0, 0.0334382352084074, 0.0194208225905522, -0.00908221989193681, 0.0, 0.0111004909790338, 0.00902598269554287, 0.00234501909253763, -0.00340391123780842, 0.0, -0.0213629048496074, -0.0191075629762328, -0.00812338442598857, 0.0019652490694463, 0.00607967912880136};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 54:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.107394023286761, 0.0, 0.217859737390348, -0.0770250488281176, 0.0, 0.0, 0.0, -0.0947126259704826, 0.0515550235170572, -0.0182274533665715, 0.0, -0.0907495120738551, 0.0232863356554078, 0.0, 0.0, 0.0, -0.0946969696969697, -0.0227805503941613, -0.0797153207506479, 0.0597492784992785, 0.0, 0.0, 0.0, -0.0727023882565981, -0.048305766159734, 0.0144810071458617, 0.0, 0.0, 0.0, 0.0, 0.0464478520766673, -0.0781031370985168, 0.0431740218144092, 0.0293762009969701, -0.0328199352701214, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0668764704168148, 0.0310733161448835, -0.00605481326129121, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0427258096992147, 0.00694820471863009, -0.0108311792346514, -0.00393049813889258, 0.00607967912880134};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 55:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.107394023286761, 0.0, 0.0, 0.231075146484353, 0.0, 0.0, 0.0, 0.0, 0.0, -0.109364720199429, 0.0, 0.0100832791193173, -0.093145342621631, 0.0, 0.0, 0.0, -0.0045093795093795, -0.104139658944738, 0.0, -0.09244227994228, 0.0, 0.0, 0.0, 0.0, -0.066884906990401, -0.0579240285834466, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0299118397398575, -0.0647610327216138, 0.0, 0.0835038859404356, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0699149613259878, 0.0242192530451648, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0312669212338355, 0.0270779480866286, 0.0, -0.0182390373864041};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 56; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    const double K_00 = d_00 / detJ;
    const double K_01 = d_10 / detJ;
    const double K_02 = d_20 / detJ;
    const double K_10 = d_01 / detJ;
    const double K_11 = d_11 / detJ;
    const double K_12 = d_21 / detJ;
    const double K_20 = d_02 / detJ;
    const double K_21 = d_12 / detJ;
    const double K_22 = d_22 / detJ;
    
    // Compute constants
    const double C0 = x[3][0] + x[2][0] + x[1][0] - x[0][0];
    const double C1 = x[3][1] + x[2][1] + x[1][1] - x[0][1];
    const double C2 = x[3][2] + x[2][2] + x[1][2] - x[0][2];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*coordinates[0] - C0) + d_10*(2.0*coordinates[1] - C1) + d_20*(2.0*coordinates[2] - C2)) / detJ;
    double Y = (d_01*(2.0*coordinates[0] - C0) + d_11*(2.0*coordinates[1] - C1) + d_21*(2.0*coordinates[2] - C2)) / detJ;
    double Z = (d_02*(2.0*coordinates[0] - C0) + d_12*(2.0*coordinates[1] - C1) + d_22*(2.0*coordinates[2] - C2)) / detJ;
    
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K_00, K_01, K_02}, {K_10, K_11, K_12}, {K_20, K_21, K_22}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.00945067404923493, 0.00609788120679252, 0.00352061335622803, 0.00248944957812476, 0.00705946233325038, 0.00546823600997146, 0.00446479600584757, 0.00315708753234943, 0.00257775117585286, 0.00182274533665714, -0.00298267418725716, -0.00252081977982931, -0.00218309396769448, -0.00195261860521384, -0.00169101731601731, -0.00138070985681772, -0.00112734487734488, -0.000976309302606919, -0.000797153207506481, -0.00056367243867244, 0.00278687112460005, 0.00245778931055954, 0.00219831358911339, 0.00207721109304566, 0.0018579140830667, 0.00160900079398464, 0.00160900079398463, 0.00143913406048031, 0.0012463266558274, 0.00101762145320216, 0.000928957041533353, 0.000830884437218264, 0.000719567030240156, 0.000587524019939406, 0.00041544221860914, -0.00705593524717798, -0.0063823335708908, -0.00582624677716565, -0.00562868913761196, -0.00513826668309062, -0.0045958054359652, -0.00475711057319694, -0.00434262794914382, -0.00388416451811043, -0.00336378514516177, -0.00368484200521179, -0.00336378514516178, -0.00300866089851429, -0.00260557676948629, -0.00212744452363026, -0.00212744452363027, -0.00194208225905522, -0.00173705117965753, -0.00150433044925714, -0.00122828066840393, -0.000868525589828766};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 1.2910299999197e-14, 0.0, 0.0, 0.0, 1.13791354811044e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.82459407806732e-14, 0.0, 0.0, 1.14502076617531e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0075685218886e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495583, 0.0, 8.36660026534078, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.80145229452567e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15685944010291e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.27459512282647e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.09631768083421e-14, 0.0, 0.0, 1.1552363868434e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.499090833947, 0.0, -3.34664010613631, -2.36643191323983, 15.4919333848297, 1.40047939984465e-14, 0.0, 0.692820323027552, 0.565685424949243, 0.400000000000003, 0.0, -2.49005609448537e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.57593122579458e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.43663518857582e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.89897948556634, 0.0, 0.0, 0.0, 14.1985914794391, -0.82807867121082, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06536050760624e-14, 0.0, 0.0, 1.39367297957671e-14, 0.0, 0.0, 1.05249092186598e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.54267715844228e-14, 4.24264068711926, 0.0, 0.0, 0.0, 0.0, 14.3427433120127, 0.0, 0.0, 0.0, 0.0, 0.0, 1.05353075839509e-14, 0.0, 0.0, -3.24774929172378e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15085846777474e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.6, 0.0, 8.76356092008268, -1.54919333848298, 0.0, 0.0, 0.0, 9.52470471983254, -1.48131215963609, 0.261861468283191, 0.0, 0.0, 0.0, 1.2116276143714e-14, 0.0, 0.0, 2.02795020253393e-14, -1.24841587070845e-14, 0.0, -1.13301837530166e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.11769145362398, 0.0, 3.16227766016839, 4.91934955049953, 0.0, 0.0, 0.0, 0.0, 10.690449676497, -2.41897262725906, 0.0, 0.0, 0.0, 0.0, 0.0, 1.51412862395202e-14, 0.0, 0.0, 0.0, -1.52542908860021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.01325198231805e-14},
      {2.54558441227158, 0.0, 0.0, 7.66811580507232, 0.0, 0.0, 0.0, 0.0, 0.0, 10.3691851174526, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.45807581273514e-14, 0.0, -1.39332989590457e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0099560077137e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.6057691494799, 1.13965640310271e-14, 1.12317278033983e-14, 0.0, -4.20458932936039, -3.43303281162797, 0.0, 0.0, 0.0, 19.6214168703486, 0.0, -2.36962160732751e-14, 0.611677741841193, 0.529728463363953, 0.43252147915678, 0.0, 1.5150275997887e-14, 1.06682783267142e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.08329718200539e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.53137212479104, 0.0, 3.54562104171167, -2.50713268211202, 4.78713553878169, 2.10513249875174e-14, 0.0, -5.56626745075489, -1.04880884817015, 0.741619848709568, 0.0, 18.8034951158402, -0.603122387046446, -2.28847070207928e-14, 0.0, 0.0, 1.68183573174417, 0.701283781217659, 0.132137494528686, -0.0934353184302173, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.44061292815194e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.05298244095219, 0.0, -1.58564993434419, 4.48489528465111, 4.28174419288837, 1.20835277214061e-14, 1.11961712189777e-14, 0.191485421551267, -3.75233260785875, -4.31161222746203, 0.0, 0.0, 18.8807171866294, 0.0, 0.0, 0.0, 0.0, 0.844371341865031, 1.18187368057056, 1.04463861754668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.2134084668507e-14, 2.59512887494071, 1.30243580677425e-14, 0.0, 0.0, 10.0285307284481, -0.767649473578736, 1.32152493598616e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 16.4130361329658, -1.26347611061158, 0.0967147429123368, 2.54129405369957e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.23815712294068e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.32115382989598, 0.0, 0.0, 0.0, 3.9242833740697, 5.49285249860477, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06108914491809e-14, 17.3044631365566, -1.73008591662715, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.29781861460725e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.01017818278145, 0.0, 0.0, 0.0, 0.0, 8.91928088068603, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.8558564884488, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.96647939483828, 0.0, 8.12403840463597, -1.64130361329658, 0.0, 0.0, 0.0, 11.7728501222092, -2.40312296813959, 0.485504156227614, 0.0, 0.0, 0.0, 1.23564094401707e-14, 0.0, 0.0, 10.2761860629321, -1.48323969741915, 0.302765035409766, -0.0611677741841213, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.41468916081805e-14, -1.06387139939102e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.65329983228432, 1.07906632212329e-14, 4.15220619990514, 2.93605316083771, 0.0, 0.0, 0.0, 2.63248931621765, 9.82591326180785, -2.82261277137741, 0.0, 0.0, 0.0, 0.0, 1.24131222965466e-14, 1.49900004882226e-14, 0.0, 11.6081867662439, -3.09487177319465, 0.683876505540215, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15581372597817e-14},
      {2.29782505861521, 0.0, 1.49829835452877, 5.50917601898535, 0.0, 0.0, 0.0, 0.0, 6.6480394532094, 4.13676892548486, 0.0, 0.0, 0.0, 0.0, -1.17293975629304e-14, 0.0, 0.0, 1.77288971805021e-14, 12.5636136423842, -3.55352656109507, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.11514820135553e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59891152423402e-14, 0.0},
      {1.87616630392937, 0.0, 0.0, 6.22830929985769, 0.0, 0.0, 0.0, 0.0, 0.0, 11.0541524195338, 0.0, 0.0, 0.0, 0.0, 2.21090682023547e-14, -2.20298115882095e-14, 0.0, 0.0, 0.0, 11.6057691494799, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.33025010156243e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.02243531748197e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.83186700722506, 0.0, -4.4108709245369, -3.11895674167862, 16.6749979177077, 0.0, 0.0, 2.13065307820924, 1.73967095350099, 1.23013312825383, 0.0, -4.36653943835009, -3.78153408023783, 1.41518305777056e-14, 0.0, 0.0, -0.557935943461964, -0.483186700722496, -0.394520289089678, -0.27896797173098, 23.6981011897578, 0.0, 0.0, 0.490653381462662, 0.43885372573626, 0.380058475033051, 0.0, 0.0, 0.0, 0.0, 0.0626933893908886, 0.0560746721671629, 0.0485620906056458, 0.0396507809422063, 0.0280373360835801, -1.53456478450664e-14, 0.0, -1.99429181619326e-14, 1.44789034491149e-14, 1.01988074810049e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 6.91050664139876, 0.0, 0.0, 0.0, 10.5706241650196, -2.725540575477, 0.0, 0.0, 0.0, 4.67332857821917, -1.05010595342034e-14, 0.0, -7.86705867811456, -2.39719223514615, 0.618094504365255, -1.47455891591556e-14, 1.12727459016504e-14, 0.0, 0.0, 0.0, 23.10555488766, -0.46968719442418, 0.0, 0.0, 0.0, 1.62065746295906, 0.790669146636832, 0.240926884676764, -0.0621208350290953, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.80757955956212e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23610364477168e-14, 6.30840061880561, 0.0, 1.32560721454874e-14, 0.0, -1.52362350055009, 11.1963004093827, 0.0, 0.0, 0.0, 4.26614580154031, 0.0, -2.16065093893094e-14, 0.132992762321608, -4.72217953828918, -6.67684597013018, 0.0, 1.9088487167099e-14, 0.0, 0.0, 0.0, 0.0, 23.1532444221696, 0.0, 0.0, 0.0, 0.0, 0.721778878560589, 1.11125127955291, 1.1908743922773, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.38981605247764e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.85449644663771, -1.18136914997961e-14, 5.98171817966649, -2.4880667576406, 1.90029237516522, 0.0, 0.0, -0.339934634239515, -2.35922146606162, 0.981306762925318, -1.26323072778345e-14, 9.9522670305624, -0.430945803685669, -1.49384636824453e-14, -1.23780151626501e-14, 0.0, -6.45364422706455, 0.0770899289327555, 0.535021138879219, -0.222539456105681, 0.0, 0.0, 0.0, 21.5273297444417, -1.00024047132728, 0.0433116829031369, 0.0, 0.0, 0.0, 0.0, 2.75066129615, 0.648615649442914, -0.00774782937530893, -0.0537716476536644, 0.0223660568773436, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.51865775274498, 0.0, 1.92724822331886, 2.72554057547702, 1.73472166622178, 2.21844751832061e-14, 0.0, -2.01705689521107, 3.42052627529741, -4.03112887414929, 0.0, 4.08831086321547, 5.37643791520788, -1.71481853656905e-14, 0.0, -1.06882166763076e-14, 0.365669640132034, -6.25148194071025, -2.03981013744549, 1.80803322065282, 0.0, 0.0, 0.0, 0.0, 22.1880978975596, -1.26521523890981, 0.0, 0.0, 1.14605390115538e-14, 0.0, 0.0, 1.98456380761453, 1.4711357857929, 0.363818136386359, -0.294009452979932, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.71815051937847e-14, 0.0, 0.0, 0.0, 0.0, -1.18769617990554e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.26320395116286e-14},
      {3.14718316987777, 0.0, -0.861891607371333, 6.09449400220043, 1.55158222708543, 0.0, 0.0, 0.0693888666488761, -3.05941170815568, 1.802775637732, -1.21553148106218e-14, 0.0, 9.03122156537878, 0.0, -1.07871246143559e-14, 0.0, 0.0, 0.403888506800963, -3.67461994579464, -5.49650682721193, 0.0, 0.0, 0.0, 0.0, 0.0, 21.7841260588564, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.974215733960555, 1.78974858569577, 1.80791908794931, 0.0, 0.0, -1.60686571624997e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.54523626091313, 0.0, 0.0, 0.0, 6.71778024562962, -0.60944940022004, 1.10275490459957e-14, 0.0, 0.0, 0.0, -1.6456712081289e-14, 0.0, 14.6593983227032, -1.52344936219871, 0.138210132827971, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.119501277094, -1.47332496632642, 0.153112421864223, -0.0138906409944096, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.39995279753084e-14, 1.41060126129512, 0.0, 0.0, 0.0, 3.63405410063597, 2.50356888118885, 0.0, 0.0, 0.0, 0.0, 0.0, -1.45045476356222e-14, 3.56857028479908, 11.263055412878, -1.49298814645065, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 19.3673596462205, -2.65048896124153, 0.26628760937957, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.26168012376112, 0.0, 0.0, 0.0, 1.42204860051345, 4.47852016375307, 0.0, 0.0, 0.0, 0.0, -1.06631060032885e-14, 0.0, 0.0, 8.27725128825318, 5.37909280973866, 0.0, 0.0, 0.0, -1.26802643034984e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 19.9654813226339, -2.61992366301005, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03547418869597e-14, 1.09264703862704, 0.0, 0.0, 0.0, 0.0, 5.38682254607084, 0.0, 0.0, 0.0, 1.43678447654116e-14, 0.0, -1.26850385459499e-14, 0.0, 0.0, 13.4377817958113, 0.0, 0.0, 0.0, -1.19741539833768e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.907670401189, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.16144232859832e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.52336024752224, 0.0, 7.37120708415867, -1.62882203585592, 0.0, 0.0, 0.0, 12.0171306297064, -2.90724328050879, 0.642416074439623, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.9858820944259, -2.72522906732403, 0.659300804656277, -0.145686271816944, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8043830863937, -1.40563403846548, 0.273895826790428, -0.0662622240310403, 0.0146420212340139, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.30350221379959, 0.0, 4.41588043316394, 1.78428514239953, 0.0, 0.0, 0.0, 4.26614580154032, 7.83741028656786, -2.63899331455874, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.23427840700304, 13.2221027072096, -4.67379217909109, 1.18363558466232, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.1258851598178, -3.11150358274814, 0.833612074594105, -0.192474367616153, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.16671184212998e-14, -1.05506262439036e-14, 1.20949219331451e-14, 0.0},
      {2.06031501455085, 0.0, 2.25696201807215, 3.98978286964827, 0.0, 0.0, 0.0, 0.953939201416944, 8.01142041980431, 1.18019368870418, 0.0, 0.0, -1.10987880183744e-14, 0.0, 0.0, 1.33508081524865e-14, -1.28916900933361e-14, 5.55254896421455, 9.62241374388481, -3.59830837050573, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.3932520322736, -4.68666192508058, 1.18356086726903, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.78428514239953, -1.30036122119359e-14, 0.814411017927983, 5.06770487035908, 0.0, 0.0, 0.0, 1.14120304309435e-14, 4.01510046524762, 6.58672305740272, 0.0, 0.0, 0.0, 0.0, 0.0, -1.94269048743982e-14, 1.98645161343897e-14, 0.0, 10.0159311874144, 2.83293314500742, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.0929454377398, -4.55552790213387, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.19426646424874e-14, 0.0, 0.0},
      {1.45686271816937, -1.0799768076155e-14, 0.0, 5.07816454066238, 0.0, 0.0, -1.21979263065773e-14, 0.0, 0.0, 10.0142755247554, -1.19130319852633e-14, 0.0, 0.0, 0.0, 1.61556546574893e-14, -1.95283513114671e-14, 0.0, 0.0, 1.35506876181836e-14, 13.8784813613723, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.5535587278944, 0.0, 0.0, 0.0, 0.0, 0.0, -1.229814494606e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580398915498, 5.6124860801609, -1.08012344973464, -0.76376261582597, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747791, 7.24568837309471, 4.1833001326704, -0.59160797830996, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.84724056670101e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513110646, 0.0, 9.66091783079298, 0.683130051063968, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.14713790139846e-14, 1.71237169977297e-14, 0.0, 0.0, -1.08954728919586e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847577, -1.67332005306815, -1.18321595661991, 7.74596669241484, -1.19999999999999, -0.979795897113259, 0.346410161513775, 0.282842712474621, 0.200000000000003, 0.0, -1.151409054946e-14, 0.0, -1.15969281804308e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.26922669423102e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772444, 2.44948974278317, 2.82842712474621, -0.99999999999999, 9.16515138991168, 7.09929573971954, -0.414039335605405, -2.04939015319191, -0.478091443733754, 0.169030850945706, 0.0, 0.0, 0.0, -1.33543246568772e-14, 1.09049726635857e-14, 0.0, 2.45272869424639e-14, 0.0, 0.0, 1.50613028992996e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0124611797498, 2.12132034355963, -0.40824829046386, 3.17542648054293, 0.0, 0.0, 7.17137165600636, 0.0, -1.38013111868471, -1.56144011671766, 0.0, 0.0, 0.0, 0.0, 0.0, -1.79811931838274e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, -5.69209978830308, 4.38178046004133, -0.774596669241488, 0.0, 10.998181667894, 0.962140470884725, 4.76235235991627, -0.740656079818041, 0.130930734141592, 0.0, 0.0, 0.0, 1.01063973293581e-14, 0.0, 0.0, 0.0, -1.30375612894406e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681198, 2.73861278752582, 1.5811388300842, 2.45967477524976, 0.0, 0.0, 9.25820099772552, 0.0, 5.3452248382485, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24531615432229e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613579, 0.0, 0.0, 3.83405790253616, 0.0, 0.0, 0.0, 0.0, 0.0, 5.18459255872629, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270665, 1.30114842892144e-14, -3.1622776601684, -2.23606797749979, 0.0, 0.0, 0.0, 13.7477270848675, 0.534522483824848, 0.377964473009225, 0.0, 0.0, 0.0, 1.43607271013995e-14, 0.0, 0.0, -2.43670412228116e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.16367050022963e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.8, 1.32427747618133e-14, 3.6514837167011, -2.8401877872188, 0.0, 0.0, 0.0, 1.59418229182701e-14, 12.3442679969674, 1.39659449751035, 0.0, 0.0, 0.0, 0.0, 1.03196509981685e-14, 2.65071218225995e-14, 0.0, -1.24384285458553e-14, -1.52262689000772e-14, -2.8799445467298e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.14359604727581e-14, -1.52773957190921e-14, -1.33794884893401e-14},
      {2.20454076850487, 0.0, 0.0, 6.64078308635358, 0.0, 0.0, 0.0, 0.0, 0.0, 8.97997772825745, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.21719387145091e-14, 0.0, -1.86951149006021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.10337086689505e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.56904651573302, 5.80288457473996, -2.01017818278146, -1.42141062443801, 8.14215222512714, -2.10229466468019, -1.71651640581398, 0.728256234341415, 0.594618725379071, 0.420458932936045, 9.81070843517429, -1.18450885369837, -1.02581475831037, 0.305838870920592, 0.26486423168198, 0.216260739578387, -0.105945692672791, -0.0917516612761676, -0.0749149177264296, -0.052972846336385, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239552, 3.07059789431495, 1.77281052085584, -1.25356634105601, 2.39356776939085, 6.30376871403132, -0.908295106229251, -2.78313372537744, -0.524404424085073, 0.370809924354785, 11.1242977306435, 9.40174755792012, -0.301561193523238, -2.42752078113806, -0.79420020665697, 0.114434427054266, 0.840917865872091, 0.350641890608831, 0.0660687472643452, -0.0467176592151053, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.02649122047608, 2.74642624930237, -0.79282496717209, 2.24244764232556, 2.14087209644419, -0.331662479035533, 6.49923072370878, 0.0957427107756358, -1.87616630392937, -2.15580611373101, 0.0, 0.0, 9.4403585933147, 0.0, -1.46249406456535, -2.04706526287666, 0.0, 0.422185670932512, 0.590936840285283, 0.522319308773346, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551269, 1.29756443747036, 3.74574588632198, -1.05945692672795, -8.09173593712688, 5.01426536422407, -0.383824736789376, 1.80936716113937, -1.1080065755349, 0.313391585263999, 0.0, 12.7134831207354, 1.01946290306867, 8.2065180664829, -0.631738055305792, 0.0483573714561624, -2.84282124887604, -0.227958835180082, 0.1395957071376, -0.0394836284566178, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.16906536108784e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715535, 1.160576914948, 1.34011878852098, 1.89521416591738, 2.53311402559511, 1.96214168703485, 2.74642624930238, -0.566421515598877, 3.17129986868838, -1.82198870938951, 0.0, 0.0, 11.169982923824, 0.0, 8.65223156827829, -0.865042958313569, 0.0, -2.49768411251822, -0.998865569685856, 0.441440386136652, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741913, 1.00508909139072, -0.193429485824663, 3.55615782880926, 0.0, 0.0, 4.45964044034302, 0.0, -0.858258202906993, 2.67027285925187, 0.0, 0.0, 1.02205127091632e-14, 0.0, 0.0, 8.42792824422442, 0.0, 0.0, -1.62195554683794, -2.29379153190449, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741915, 7.03562363973515, 4.062019202318, -0.820651806648287, 0.0, -6.79705818718656, -2.08116553882674, 5.88642506110459, -1.2015614840698, 0.24275207811381, 0.0, 0.0, 0.0, 14.8323969741913, 0.856348838577674, 0.262202212042538, 5.13809303146608, -0.741619848709572, 0.151382517704889, -0.0305838870920605, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.2372868034904e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32664991614217, -2.69693703815181, 2.07610309995256, 1.46802658041886, 0.0, 3.03973683071412, -6.38211787508102, 1.31624465810882, 4.91295663090393, -1.4113063856887, 0.0, 0.0, -2.2592738714644e-14, 0.0, 13.4039795085887, 2.01017818278149, 0.0, 5.80409338312193, -1.54743588659733, 0.341938252770107, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1489125293076, 1.29756443747034, 0.749149177264387, 2.75458800949267, 0.0, 0.0, 5.75737105184054, 0.0, 3.32401972660471, 2.06838446274243, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8804085776374, 0.0, 0.0, 6.28180682119208, -1.77676328054755, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.01213079341215e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.938083151964683, 0.0, 0.0, 3.11415464992885, 0.0, 0.0, 0.0, 0.0, 0.0, 5.52707620976692, 0.0, 0.0, 0.0, 0.0, 1.10545341011773e-14, -1.10149057941048e-14, 0.0, 0.0, 0.0, 5.80288457473997, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.4253953543107, 0.0, 9.38083151964688, 1.89521416591738, 0.0, 0.0, 0.0, -3.39852909359328, -2.77488738510233, -0.560611910581392, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.7988763690296, 0.42817441928883, 0.349602949390067, 0.0706304617818757, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.82970843102536, 0.0, -1.49829835452879, 4.23782770691181, 0.0, 0.0, 0.0, 3.79967103839267, -3.54562104171169, -4.07409060843205, 0.0, 0.0, 0.0, 0.0, 0.0, -1.52158320389315e-14, 0.0, 16.7549743857359, 1.11676565710083, 0.987090711415307, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.01936820004651e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15848226724032e-14, 0.0},
      {-1.32664991614217, 0.0, 1.73008591662712, -3.18072425757424, 0.0, 0.0, 0.0, 0.0, 7.6764947357874, -2.38836465270397, 0.0, 0.0, -1.79238954995876e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 14.5072114368499, 2.05162951662071, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.38270237873247e-14, 0.0},
      {1.62480768092719, 0.0, 0.0, 5.39387407630362, 0.0, 0.0, 0.0, 0.0, 0.0, 9.57317681262151, 0.0, 0.0, 0.0, 0.0, 1.84472351819205e-14, -1.99075298319087e-14, 0.0, 0.0, 0.0, 10.0508909139073, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.11796624108017e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.41593350361253, 5.72988941019467, -2.20543546226844, -1.5594783708393, 8.33749895885383, -2.76779953857106, -2.25989885993662, 1.06532653910461, 0.869835476750492, 0.615066564126914, 10.333118277332, -2.18326971917504, -1.89076704011892, 0.724780051083757, 0.627677936394704, 0.512496888990057, -0.278967971730972, -0.241593350361236, -0.197260144544829, -0.139483985865484, 11.8490505948789, -1.16109782023228, -1.03851746182648, 0.245326690731331, 0.219426862868129, 0.190029237516526, -0.0814411017927947, -0.0728431359084675, -0.0630840061880541, -0.0515078753637702, 0.0313466946954437, 0.0280373360835811, 0.0242810453028231, 0.0198253904711023, 0.0140186680417899, -1.34598912841459e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.18529407725404, 3.45525332069938, 0.997445717412069, -1.4106012612951, 3.23209352764251, 5.28531208250979, -1.3627702877385, -2.8908723349783, -0.393397896234722, 0.556348640264194, 2.33666428910958, 9.02784807228867, -0.732969916135166, -3.93352933905728, -1.19859611757308, 0.309047252182629, 1.64018416088946, 0.655588223176222, 0.0892142571199762, -0.126168012376104, 13.0996183150503, 11.55277744383, -0.23484359721209, -2.44096975264613, -0.907332870306509, 0.0736662483163258, 0.810328731479528, 0.395334573318415, 0.120463442338383, -0.0310604175145496, -0.311895674167861, -0.164844710568313, -0.0658890955530676, -0.0089663702065851, 0.012680362351407, 0.0, 0.0, 0.0, 1.11652798437369e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99489143482415, 3.1542003094028, -1.09264703862703, 1.54523626091315, 2.95048422176041, -0.761811750275038, 5.59815020469136, 0.263899331455871, -1.93925611658551, -2.28543525082517, 2.13307290077015, -0.257539376818854, 9.14446135479765, 0.0664963811608003, -2.36108976914459, -3.33842298506509, -0.0230350221379984, 0.817905488277902, 1.1564636454577, 1.02505848514082, 0.0, 0.0, 11.5766222110848, 0.0, -1.39771878815471, -2.15192884958005, 0.0, 0.360889439280297, 0.555625639776455, 0.595437196138648, 0.0, -0.125015768949706, -0.192474367616159, -0.206265495285701, -0.166687691932938, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.92724822331886, 1.82834820066014, 2.99085908983326, -1.2440333788203, 0.950146187582609, 5.74064456311311, -0.721110255092802, -0.169967317119738, -1.17961073303082, 0.490653381462658, -10.3037210107158, 4.97613351528119, -0.215472901842826, 5.7817446699566, -1.30185581821821, 0.16353243452862, -3.22682211353225, 0.0385449644663744, 0.267510569439616, -0.111269728052839, 0.0, 14.555131461167, 1.03556292536503, 10.7636648722209, -0.500120235663639, 0.0216558414515674, -3.57321383950879, -0.581087203147979, 0.130841432732454, -0.0164356280722681, 1.375330648075, 0.324307824721454, -0.00387391468765176, -0.0268858238268353, 0.0111830284386719, 0.0, 0.0, 0.0, -1.24814777259306e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.01558844222418e-14, 0.0, 0.0, 0.0, 0.0, 1.4259678156057e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.75932887637251, 1.66904592079257, 0.963624111659426, 1.36277028773851, 0.867360833110885, 2.28430636201793, 2.96226264871973, -1.00852844760553, 1.71026313764871, -2.01556443707464, 2.41867732448957, 2.04415543160773, 2.68821895760392, -0.52779866291175, 7.07977053255617, -1.76652739792482, 0.182834820066016, -3.12574097035512, -1.01990506872275, 0.904016610326407, 0.0, 0.0, 13.1266557397187, 0.0, 11.0940489487798, -0.632607619454898, 0.0, -2.8644711213756, -1.66605356688627, 0.315075748468086, 0.0, 0.992281903807264, 0.735567892896454, 0.181909068193181, -0.147004726489968, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.29943670433591e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.57359158493888, 1.49284005458434, -0.430945803685661, 3.04724700110022, 0.775791113542715, -0.12018504251546, 5.29905651979671, 0.0346944333244405, -1.52970585407784, 0.901387818866003, 0.0, 0.0, 4.51561078268939, 0.0, -0.699555414372428, 6.36462844462228, 0.0, 0.201944253400478, -1.83730997289731, -2.74825341360596, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8920630294282, 0.0, 0.0, -1.68739114875268, -3.0999354831996, 0.0, 0.0, 0.487107866980278, 0.894874292847886, 0.903959543974654, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.62882203585591, 0.772618130456559, 3.86595114186569, -1.05140010313426, 9.15442906076461, 3.35889012281481, -0.304724700110017, 3.87851223317103, -1.52475169285616, 0.414677792940103, -1.30025811259761e-14, -9.46260092820843, -2.07602937339136, 7.32969916135159, -0.761724681099364, 0.0691050664139826, 0.564240504518059, -0.879563899362192, 0.34578118203619, -0.0940400840863324, 0.0, 0.0, 0.0, 16.3745228938128, 0.951027176355642, 0.208648802584723, 9.05975063854701, -0.736662483163209, 0.0765562109321155, -0.00694532049720559, -3.48709964663733, -0.0567083043941599, 0.0883994979795876, -0.0347523163751415, 0.00945138406569528, 0.0, -1.00011135325188e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48690428533296, 0.705300630647561, 2.03602754481989, 1.15175110689978, -2.93221479395415, 1.81702705031799, 1.25178444059441, 0.65566316039121, 3.61359041872287, -1.70346285967312, 0.0, 2.7642026565595, -9.0878387586433, 1.78428514239954, 5.631527706439, -0.746494073225328, -0.61809450436525, 2.03210252328837, -2.15494277062552, 0.764033484562603, 0.0, 0.0, 0.0, 0.0, 15.0018922739643, 2.13860408462396, 0.0, 9.68367982311022, -1.32524448062075, 0.133143804689781, 0.0, -3.3545250915713, -0.478206411017786, 0.384353057392912, -0.12424167005819, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.36916607789467e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32992762321609, 0.630840061880566, 0.72843135908468, 2.57539376818855, 0.917928424547682, 0.711024300256724, 2.23926008187653, -0.205255035576784, 2.58567482211401, 0.761811750275059, 0.0, 0.0, 5.34294273196306, 0.0, 4.13862564412659, 2.68954640486934, 0.0, -1.19471831485579, 3.1056206816986, -2.32269806558126, 0.0, 0.0, 0.0, 0.0, 0.0, 12.8876627769294, 0.0, 0.0, 9.98274066131696, -1.30996183150503, 0.0, 0.0, -2.88176900403078, -1.51261363209512, 0.763985254692622, 0.0, 0.0, -1.17185759123372e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1517511068998, 0.546323519313516, -0.105140010313426, 3.2711894277325, 0.0, 0.0, 2.69341127303542, 0.0, -0.518347241175126, 4.25171145123353, 1.14902781575578e-14, 0.0, 0.0, 0.0, 0.0, 6.71889089790564, 0.0, 0.0, -1.29305115618719, 1.82865048192212, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.45383520059451, 0.0, 0.0, 0.0, -1.81939143264587, -2.94058061635795, 0.0, 0.0, 0.0, 0.0, 0.0, 1.05723279563221e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.26168012376111, -6.78263087840206, 3.68560354207933, -0.814411017927962, 0.0, 10.0216907612581, 2.67510569439611, 6.00856531485322, -1.4536216402544, 0.321208037219806, -1.65057976629295e-14, 0.0, 1.17706771112406e-14, -7.57008074256672, -2.27270584034422, -0.606656948415846, 6.99294104721295, -1.36261453366202, 0.329650402328128, -0.0728431359084687, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.7137404500718, 0.760821741084516, 0.228415531250646, 0.0609713174047718, 5.40219154319687, -0.702817019232743, 0.136947913395215, -0.0331311120155195, 0.00732101061700708, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.42496696880162e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1517511068998, 3.82426463519459, 2.20794021658197, 0.892142571199776, 0.0, -2.46306042692148, 6.78739640804926, 2.13307290077016, 3.91870514328393, -1.31949665727937, 0.0, 0.0, 0.0, 3.22490309931941, -7.63378455726036, -4.04762275910194, 1.11713920350153, 6.61105135360481, -2.33689608954555, 0.591817792331165, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.5022076529583, 1.79642743108413, 0.72192923349994, 0.0, 6.06294257990892, -1.55575179137407, 0.416806037297051, -0.0962371838080743, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03015750727543, -1.4659398322703, 1.12848100903607, 1.99489143482414, 0.0, 1.10151410945723, -5.20357020296094, 0.476969600708469, 4.00571020990215, 0.590096844352087, 0.0, 0.0, 0.0, 0.0, 6.41153127835568, -6.24994106094656, 0.0, 2.77627448210729, 4.81120687194239, -1.79915418525286, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.4651953323153, 3.04407621455179, 0.0, 0.0, 6.69662601613678, -2.34333096254029, 0.591780433634514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.892142571199772, 0.705300630647555, 0.407205508963985, 2.53385243517954, 0.0, 0.0, 3.47717900165117, 0.0, 2.00755023262381, 3.29336152870136, 0.0, 0.0, 0.0, 0.0, 0.0, 8.67405085085771, 0.0, 0.0, 5.0079655937072, 1.4164665725037, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.2048487632307, 0.0, 0.0, 0.0, 7.0464727188699, -2.27776395106694, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.728431359084687, 0.0, 0.0, 2.53908227033119, 0.0, 0.0, 0.0, 0.0, 0.0, 5.00713776237768, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.93924068068616, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.2767793639472, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.09901951359278, 0.0, -4.65474668125635, -3.29140294302194, 0.0, 0.0, 0.0, 13.490737563232, 1.83585684909538, 1.29814682728311, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -3.53270434653118, -3.05941170815567, -0.416333199893246, -0.294392028877619, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 21.8326971917504, 0.355050145839447, 0.307482445914322, 0.0418430609640578, 0.0295875121532877, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.61462585708151e-14, 0.0, 0.0, 0.0, 0.0, -1.16102518088945e-14},
      {-2.65985524643218, 0.0, 5.0990195135928, -2.06031501455083, 0.0, 0.0, 0.0, -1.23153021346074, 9.04986187739901, 3.04724700110021, 0.0, 0.0, 1.42882694523272e-14, 0.0, 0.0, 0.0, 3.86988371918332, -3.81689227863017, -5.39683034546924, -1.3667446468544, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 21.00264918355, 0.898213715542062, 0.962572311333254, 0.222250255910583, 0.0, 0.0, 0.0, 0.0, -1.12681836907137e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.18513103827981e-14, 0.0, 0.0, 1.05763921925961e-14},
      {2.97380857066589, 0.0, -0.814411017927952, 5.75875553449899, 0.0, 0.0, 0.0, 1.37689263682151, -2.89087233497831, 1.70346285967313, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 8.01441409794461, -3.47218947830365, -5.1937107658469, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 19.3314941653941, 1.69115345252878, 1.70832296330021, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.43661124663019e-14},
      {-1.03015750727544, 0.0, 0.940400840863422, -2.9258407710754, 0.0, 0.0, 0.0, 0.0, 4.63623866886821, -3.80284633026898, 0.0, 0.0, 0.0, 0.0, -1.17361870806384e-14, 0.0, 0.0, 0.0, 11.565401134477, -1.63559471386624, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.2731316843076, 2.63013526059784, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.01423919225742e-14, 0.0},
      {1.26168012376113, 0.0, 0.0, 4.39781949681095, 0.0, 0.0, -1.11014659841498e-14, 0.0, 0.0, 8.67261700493487, 0.0, 0.0, 0.0, 0.0, 1.40183636832794e-14, -1.61637203484436e-14, 0.0, 0.0, 1.165919317568e-14, 12.0191174248973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8717007662564, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06515764673489e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580398915498, 5.6124860801609, -1.08012344973464, -0.76376261582597, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267039, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.55391889677069e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971952, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24263211362714e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32287565553229, 0.0, 3.86436713231719, -0.341565025531985, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971955, 2.50998007960222, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912986, 0.0, 0.0, 8.87411967464941, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.96188551515597e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847577, -1.67332005306815, -1.18321595661991, 7.74596669241484, -1.19999999999999, -0.979795897113259, 0.346410161513775, 0.282842712474621, 0.200000000000003, 0.0, -1.151409054946e-14, 0.0, -1.15969281804308e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.26922669423102e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772444, 2.44948974278317, 2.8284271247462, -0.999999999999998, 1.30930734141595, 7.09929573971953, -0.414039335605412, -2.04939015319192, -0.478091443733755, 0.169030850945706, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.08716682344658e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0124611797498, 2.12132034355963, -0.408248290463859, 3.17542648054295, 9.07114735222146, 0.0, 7.17137165600637, 0.0, -1.3801311186847, -1.56144011671766, 0.0, -1.27114514413737e-14, 0.0, 0.0, 0.0, -1.89105350382163e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, 0.632455532033676, 4.38178046004134, -0.774596669241488, 0.0, 3.14233761939829, -0.106904496764969, 4.76235235991627, -0.740656079818045, 0.130930734141596, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.18031428662765e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 0.547722557505164, 1.58113883008419, 2.45967477524977, 0.0, 9.07114735222145, 1.8516401995451, 0.0, 5.34522483824849, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, -6.26099033699941, 0.0, 3.83405790253615, 0.0, 0.0, 10.5830052442584, 0.0, 0.0, 5.18459255872628, 0.0, 0.0, 0.0, 1.25836173653064e-14, 1.48358452126538e-14, -1.12491819922707e-14, -1.04421095586587e-14, 0.0, 0.0, -1.67296732023203e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03923048454133, 0.0, 3.16227766016838, -0.447213595499959, 0.0, 0.0, 0.0, 5.89188303637179, -0.534522483824848, 0.0755928946018435, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.900000000000011, 1.33719710960724e-14, 1.46059348668044, 1.42009389360938, 0.0, 0.0, 0.0, 9.07114735222146, 4.93770719878695, -0.698297248755181, 0.0, 0.0, 0.0, 1.32954362671572e-14, 0.0, 1.06165553601881e-14, 0.0, 1.44648983668665e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.73484692283496, 0.0, -6.26099033699942, 2.21359436211785, 0.0, 0.0, 0.0, 0.0, 10.5830052442584, 2.99332590941915, 0.0, 0.0, 0.0, 0.0, 0.0, 1.05984189380888e-14, -1.39797099343912e-14, 0.0, 0.0, -1.35759459229945e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.71576766497729, 0.0, 0.0, -4.69574275274956, 0.0, 0.0, 0.0, 0.0, 0.0, 12.69960629311, 1.04519457838932e-14, 0.0, 0.0, 0.0, 1.04165025265274e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.56904651573302, 5.80288457473996, -2.01017818278146, -1.42141062443801, 8.14215222512714, -2.10229466468019, -1.71651640581398, 0.728256234341415, 0.594618725379071, 0.420458932936045, 9.81070843517429, -1.18450885369837, -1.02581475831037, 0.305838870920592, 0.26486423168198, 0.216260739578387, -0.105945692672791, -0.0917516612761676, -0.0749149177264296, -0.052972846336385, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239552, 3.07059789431495, 1.77281052085584, -1.25356634105601, 2.39356776939084, 6.30376871403132, -0.908295106229243, -2.78313372537744, -0.524404424085076, 0.370809924354784, 1.23603308118261, 9.40174755792012, -0.301561193523221, -2.42752078113807, -0.794200206656967, 0.114434427054264, 0.840917865872095, 0.350641890608829, 0.0660687472643458, -0.0467176592151037, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.02649122047608, 2.74642624930237, -0.792824967172092, 2.24244764232556, 2.14087209644419, -0.33166247903552, 6.49923072370877, 0.0957427107756355, -1.87616630392937, -2.15580611373101, 11.0554159678513, 0.0, 9.44035859331468, 0.0, -1.46249406456536, -2.04706526287665, 0.0, 0.422185670932514, 0.590936840285282, 0.522319308773347, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551268, 1.29756443747035, 3.74574588632199, -1.05945692672795, 0.40458679685634, 5.01426536422407, -0.383824736789368, 1.80936716113937, -1.1080065755349, 0.313391585264003, 0.0, 2.82521847127454, -0.0509731451534303, 8.20651806648289, -0.631738055305789, 0.0483573714561688, -2.84282124887604, -0.22795883518008, 0.139595707137604, -0.039483628456614, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.16466485419836e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715535, 1.16057691494799, 1.34011878852098, 1.89521416591737, 0.361873432227873, 1.96214168703486, 2.74642624930238, -0.56642151559888, 3.17129986868837, -1.82198870938951, 0.0, 11.0554159678513, 1.59571184626057, 0.0, 8.65223156827828, -0.86504295831357, 0.0, -2.49768411251822, -0.998865569685855, 0.441440386136649, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741914, 1.00508909139073, -0.193429485824664, 3.55615782880925, -8.46157280212813, 0.0, 4.45964044034302, 0.0, -0.858258202906997, 2.67027285925186, 0.0, 1.44857443011911e-14, 12.4373429638328, 0.0, 0.0, 8.42792824422442, 0.0, 0.0, -1.62195554683794, -2.2937915319045, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741914, 0.335029697130249, 4.06201920231799, -0.820651806648291, 0.0, 1.69926454679664, -0.0991031208965121, 5.88642506110459, -1.2015614840698, 0.242752078113806, 0.0, 0.0, 0.0, 4.94413232473044, -0.214087209644419, 0.0124858196210728, 5.13809303146607, -0.741619848709577, 0.151382517704883, -0.0305838870920607, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32664991614217, 0.299659670905766, 2.07610309995257, 1.46802658041885, 0.0, 0.868496237346898, 0.709124208342333, 1.31624465810883, 4.91295663090393, -1.4113063856887, 0.0, 0.0, 0.0, 11.0554159678513, 3.82970843102536, -0.223353131420157, 0.0, 5.80409338312194, -1.54743588659732, 0.341938252770102, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1489125293076, 0.259512887494075, 0.749149177264382, 2.75458800949267, 0.0, -8.46157280212811, 1.15147421036811, 0.0, 3.32401972660471, 2.06838446274243, 0.0, 0.0, -1.1283446540405e-14, 0.0, 12.4373429638327, 2.17608171552749, -1.21040313496127e-14, 0.0, 6.28180682119209, -1.77676328054754, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.93808315196469, 7.62808987244124, 1.39628067270975e-14, 3.11415464992886, 0.0, 0.0, -7.52139804633611, 0.0, 0.0, 5.52707620976692, 0.0, 0.0, 0.0, 0.0, 0.0, 14.2141062443803, 1.0319833740378e-14, 1.68289931844567e-14, 0.0, 5.80288457473996, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.856348838577683, 0.0, 2.68023757704196, -0.473803541479344, 0.0, 0.0, 0.0, 5.09779364038993, -0.792824967172097, 0.140152977645348, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.91061171956871, -0.642261628933266, 0.0998865569685892, -0.0176576154454652, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.765941686205081, 0.0, 1.49829835452878, 0.847565541382356, 0.0, 0.0, 0.0, 1.62843044502544, 3.54562104171167, -0.814818121686411, 0.0, -1.00490360530146e-14, 0.0, 0.0, 0.0, 0.0, 11.0554159678513, 7.18070330817253, -1.11676565710082, 0.197418142283054, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.663324958071068, 0.0, 0.692034366650859, 1.5903621287871, 0.0, 0.0, 0.0, -8.46157280212811, 3.07059789431496, 1.19418232635199, 0.0, 0.0, 0.0, -1.73320255518822e-14, 0.0, 0.0, 1.38009491821402e-14, 12.4373429638327, 5.80288457473997, -1.02581475831036, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.541602560309052, -1.25890451024725e-14, 7.62808987244128, 1.79795802543454, 0.0, 0.0, 0.0, 0.0, -7.52139804633611, 3.1910589375405, 0.0, 0.0, 0.0, 0.0, 0.0, -1.97784641917273e-14, 2.38963933169705e-14, 0.0, 14.2141062443803, 3.35029697130245, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-5.36159180343549, 0.0, 0.0, 8.89943818451478, 0.0, 0.0, 0.0, 0.0, 0.0, -5.26497863243527, 0.0, 0.0, 0.0, 0.0, 1.69418316537184e-14, -1.83698225526999e-14, 0.0, -1.32206326378019e-14, 0.0, 16.583123951777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.41593350361253, 5.72988941019467, -2.20543546226844, -1.5594783708393, 8.33749895885383, -2.76779953857106, -2.25989885993662, 1.06532653910461, 0.869835476750492, 0.615066564126914, 10.333118277332, -2.18326971917504, -1.89076704011892, 0.724780051083757, 0.627677936394704, 0.512496888990057, -0.278967971730972, -0.241593350361236, -0.197260144544829, -0.139483985865484, 11.8490505948789, -1.16109782023228, -1.03851746182648, 0.245326690731331, 0.219426862868129, 0.190029237516526, -0.0814411017927947, -0.0728431359084675, -0.0630840061880541, -0.0515078753637702, 0.0313466946954437, 0.0280373360835811, 0.0242810453028231, 0.0198253904711023, 0.0140186680417899, -1.34598912841459e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.18529407725404, 3.45525332069938, 0.997445717412062, -1.41060126129509, 3.23209352764251, 5.2853120825098, -1.36277028773849, -2.89087233497829, -0.393397896234721, 0.55634864026419, 2.33666428910958, 9.02784807228867, -0.732969916135157, -3.93352933905729, -1.19859611757308, 0.309047252182623, 1.64018416088945, 0.65558822317622, 0.089214257119981, -0.126168012376099, 1.1908743922773, 11.55277744383, -0.234843597212088, -2.44096975264613, -0.907332870306512, 0.0736662483163217, 0.810328731479531, 0.395334573318417, 0.120463442338383, -0.031060417514548, -0.31189567416786, -0.164844710568315, -0.0658890955530668, -0.00896637020658499, 0.0126803623514091, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99489143482414, 3.15420030940281, -1.09264703862702, 1.54523626091315, 2.9504842217604, -0.761811750275046, 5.59815020469135, 0.263899331455871, -1.93925611658551, -2.28543525082517, 2.13307290077016, -0.257539376818845, 9.14446135479765, 0.0664963811608087, -2.3610897691446, -3.33842298506508, -0.0230350221379951, 0.817905488277904, 1.15646364545769, 1.02505848514081, 13.0453753561106, 0.0, 11.5766222110848, 0.0, -1.39771878815472, -2.15192884958005, 0.0, 0.360889439280295, 0.555625639776455, 0.595437196138646, 0.0, -0.125015768949705, -0.19247436761616, -0.206265495285702, -0.16668769193294, 0.0, 0.0, 0.0, 0.0, 0.0, 1.07688613330682e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.92724822331886, 1.82834820066013, 2.99085908983326, -1.2440333788203, 0.950146187582608, 5.7406445631131, -0.7211102550928, -0.169967317119744, -1.17961073303082, 0.490653381462661, 0.294392028877592, 4.9761335152812, -0.215472901842836, 5.78174466995659, -1.30185581821821, 0.163532434528625, -3.22682211353225, 0.0385449644663701, 0.267510569439614, -0.111269728052837, 0.0, 2.646387538394, -0.0295875121532846, 10.7636648722209, -0.50012023566364, 0.0216558414515689, -3.57321383950879, -0.581087203147979, 0.130841432732454, -0.0164356280722693, 1.37533064807501, 0.324307824721454, -0.00387391468765233, -0.0268858238268337, 0.011183028438673, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.54346718065853e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.75932887637249, 1.66904592079257, 0.963624111659428, 1.36277028773851, 0.867360833110891, 2.28430636201794, 2.96226264871972, -1.00852844760553, 1.71026313764871, -2.01556443707465, 0.268741924943287, 2.04415543160772, 2.68821895760394, -0.527798662911744, 7.07977053255618, -1.76652739792483, 0.182834820066012, -3.12574097035513, -1.01990506872274, 0.904016610326411, 0.0, 13.0453753561106, 1.45851730441319, 0.0, 11.0940489487798, -0.632607619454904, 0.0, -2.8644711213756, -1.66605356688627, 0.315075748468089, 0.0, 0.992281903807263, 0.735567892896453, 0.181909068193181, -0.147004726489966, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.5735915849389, 1.49284005458436, -0.430945803685668, 3.04724700110022, 0.775791113542717, -0.120185042515463, 5.29905651979672, 0.0346944333244382, -1.52970585407784, 0.901387818866001, -10.576283741361, 0.0, 4.51561078268938, 0.0, -0.699555414372441, 6.36462844462229, 0.0, 0.201944253400487, -1.83730997289732, -2.74825341360596, 0.0, 0.0, 14.3499128917217, 0.0, 0.0, 10.8920630294282, 0.0, 0.0, -1.68739114875268, -3.09993548319961, 0.0, 0.0, 0.487107866980278, 0.894874292847885, 0.903959543974654, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.62882203585591, 0.772618130456572, 3.86595114186568, -1.05140010313426, 0.160604018609907, 3.35889012281481, -0.304724700110022, 3.87851223317102, -1.52475169285616, 0.414677792940096, 0.0, 1.135512111385, -0.0364215679542345, 7.3296991613516, -0.761724681099359, 0.0691050664139833, 0.564240504518048, -0.879563899362189, 0.345781182036182, -0.0940400840863355, 0.0, 0.0, 0.0, 4.46577897103986, -0.114123261162676, 0.00366050530850576, 9.05975063854701, -0.73666248316321, 0.0765562109321156, -0.00694532049720655, -3.48709964663733, -0.0567083043941568, 0.0883994979795855, -0.0347523163751381, 0.0094513840656929, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48690428533296, 0.705300630647557, 2.0360275448199, 1.15175110689978, 0.146610739697702, 1.81702705031799, 1.25178444059442, 0.655663160391219, 3.61359041872287, -1.70346285967311, 0.0, 0.61426725701323, 0.454391937932152, 1.78428514239953, 5.63152770643899, -0.746494073225317, -0.618094504365244, 2.03210252328836, -2.15494277062552, 0.764033484562593, 0.0, 0.0, 0.0, 13.0453753561106, 3.33375383865872, -0.106930204231199, 0.0, 9.68367982311022, -1.32524448062076, 0.13314380468978, 0.0, -3.3545250915713, -0.478206411017787, 0.384353057392906, -0.124241670058192, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32992762321609, 0.630840061880567, 0.728431359084683, 2.57539376818856, 0.13113263207824, 0.711024300256729, 2.23926008187654, -0.205255035576787, 2.58567482211401, 0.761811750275046, 0.0, -10.576283741361, 0.763277533137582, 0.0, 4.13862564412659, 2.68954640486934, 0.0, -1.19471831485577, 3.1056206816986, -2.32269806558126, 0.0, 0.0, 0.0, 0.0, 14.3499128917217, 1.84109468241849, 0.0, 0.0, 9.98274066131697, -1.30996183150503, 0.0, 0.0, -2.88176900403078, -1.51261363209512, 0.763985254692617, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.15175110689978, 0.546323519313518, -0.105140010313426, 3.27118942773249, 9.65295620481434, 0.0, 2.69341127303541, 0.0, -0.518347241175123, 4.25171145123354, 1.18152069786956e-14, -1.38297717451513e-14, -9.91526600752601, 0.0, 0.0, 6.71889089790564, 0.0, 0.0, -1.29305115618718, 1.82865048192213, 0.0, 0.0, 0.0, 0.0, 0.0, 15.9443476574685, 0.0, 0.0, 0.0, 9.45383520059451, 0.0, 0.0, 0.0, -1.81939143264587, -2.94058061635794, 0.0, 0.0, -1.72754963278994e-14, 0.0, 1.13755232036152e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.26168012376112, 0.199489143482416, 3.68560354207934, -0.814411017927958, 0.0, 1.02786571910339, -0.0786795792469428, 6.00856531485323, -1.4536216402544, 0.321208037219811, 0.0, 0.0, 0.0, 3.0280322970267, -0.233098034907103, 0.0178428514239945, 6.99294104721297, -1.36261453366202, 0.32965040232814, -0.0728431359084713, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.80499652729883, -0.304328696433804, 0.0234272339744254, -0.00179327404131563, 5.40219154319688, -0.702817019232742, 0.136947913395215, -0.0331311120155212, 0.00732101061700645, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.15175110689979, 0.182107839771176, 2.20794021658197, 0.892142571199767, 0.0, 0.615765106730374, 0.323209352764248, 2.13307290077016, 3.91870514328393, -1.31949665727937, 0.0, 0.0, 0.0, 1.07496769977314, 1.90844613931509, -0.19274394090962, 1.11713920350151, 6.6110513536048, -2.33689608954555, 0.591817792331162, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.0453753561106, 5.83406921765277, -0.449106857771024, 0.0343775825476163, 0.0, 6.06294257990892, -1.55575179137407, 0.416806037297052, -0.0962371838080749, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03015750727543, 0.162882203585601, 1.12848100903607, 1.99489143482413, 0.0, 0.314718316987777, 0.578174466995654, 0.476969600708466, 4.00571020990215, 0.590096844352083, 0.0, 0.0, -1.31549551242914e-14, -10.576283741361, 1.83186607953019, 0.694437895660746, -1.8047208927113e-14, 2.77627448210728, 4.81120687194239, -1.79915418525287, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.3499128917217, 4.41862723780437, -0.33823069050576, 0.0, 0.0, 6.69662601613678, -2.34333096254029, 0.591780433634515, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.892142571199766, 0.141060126129502, 0.407205508963996, 2.53385243517955, 0.0, 9.65295620481434, 0.695435800330227, 0.0, 2.00755023262381, 3.29336152870135, 0.0, 0.0, 1.11713603382673e-14, 0.0, -9.91526600752598, 1.73481017017153, 1.64166602797602e-14, 0.0, 5.0079655937072, 1.41646657250371, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.9443476574685, 2.44096975264614, 0.0, 0.0, 0.0, 7.0464727188699, -2.27776395106693, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.728431359084693, -7.94708263760857, -1.34962358184755e-14, 2.53908227033119, 0.0, 0.0, 10.2207771580387, 0.0, 0.0, 5.00713776237768, 0.0, 0.0, 0.0, 0.0, 0.0, -8.49879943502226, -1.3318970311563e-14, 0.0, 0.0, 6.93924068068617, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.9373911146521, 0.0, 0.0, 0.0, 0.0, 6.27677936394721, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.728431359084677, 0.0, 2.32737334062816, -0.470200420431705, 0.0, 0.0, 0.0, 4.49691252107735, -0.917928424547683, 0.185449546754728, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.06540869306229, -1.01980390271856, 0.208166599946613, -0.0420560041253752, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.92395326897747, -0.710100291678877, 0.102494148638108, -0.0209215304820305, 0.00422678745046826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.664963811608031, -1.52728632141123e-14, 1.45686271816937, 0.515078753637711, 0.0, 0.0, 0.0, 1.84729532019112, 2.58567482211399, -0.761811750275054, 0.0, 0.0, 0.0, -1.45770491081465e-14, 0.0, 0.0, 1.71994831963703, 5.72533841794525, -1.54195152727693, 0.34168616171361, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.0453753561106, 9.33451074824443, -1.3473205733131, 0.275020660380933, -0.0555625639776416, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.08465016007527e-14, 0.0, 0.0, 0.0, 0.0},
      {0.594761714133172, 0.0, 0.81441101792795, 1.15175110689982, 0.0, 0.0, 0.0, 0.590096844352069, 2.89087233497829, 0.340692571934627, 0.0, 0.0, 0.0, 0.0, -1.12582268745145e-14, -1.00859362139179e-14, -10.576283741361, 3.43474889911913, 3.47218947830365, -1.03874215316937, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.3499128917217, 8.28492607088319, -1.69115345252877, 0.341664592660044, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.03389519168218e-14},
      {0.515078753637708, 0.0, 0.376160336345357, 1.4629203855377, 0.0, 0.0, 0.0, 9.65295620481433, 1.85449546754729, 1.90142316513449, 0.0, 0.0, 0.0, 0.0, -1.08799737057301e-14, 0.0, 0.0, -9.91526600752598, 4.62616045379077, 0.81779735693313, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.9443476574685, 6.50925267372303, -1.31506763029892, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.420560041253713, 0.0, -7.94708263760858, 1.46593983227031, 0.0, 0.0, 0.0, 0.0, 10.2207771580387, 2.89087233497829, 0.0, 0.0, 1.39515011653448e-14, 0.0, 0.0, 0.0, -2.25920784148809e-14, 0.0, -8.49879943502226, 4.00637247496575, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.9373911146521, 3.62390025541881, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06444352251245e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.542378855465, 0.0, 0.0, -6.91050664139873, 0.0, 0.0, 0.0, 0.0, 0.0, 12.2649325896465, -1.24221302592312e-14, 0.0, 0.0, 0.0, -1.26085093097862e-14, 0.0, 1.00262554257505e-14, 0.0, 1.9958678525973e-14, -5.66586629001481, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.34034011235354e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 20.4998755596024, 0.0, 0.0, 0.0, 0.0, 0.0, -1.13399729500939e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.18880599808691e-14}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[56][56] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[56][56] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 56; t++)
        {
          for (unsigned int u = 0; u < 56; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 56; s++)
        {
          for (unsigned int t = 0; t < 56; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.00945067404923496, -0.00609788120679253, 0.00352061335622802, 0.00248944957812477, 0.00705946233325039, -0.00546823600997146, -0.00446479600584757, 0.00315708753234943, 0.00257775117585286, 0.00182274533665715, 0.00298267418725716, -0.00252081977982931, -0.00218309396769447, 0.00195261860521383, 0.00169101731601732, 0.00138070985681771, -0.00112734487734488, -0.000976309302606918, -0.000797153207506481, -0.00056367243867244, 0.00278687112460004, -0.00245778931055954, -0.00219831358911339, 0.00207721109304566, 0.00185791408306669, 0.00160900079398463, -0.00160900079398463, -0.00143913406048031, -0.0012463266558274, -0.00101762145320216, 0.000928957041533346, 0.000830884437218264, 0.000719567030240152, 0.0005875240199394, 0.000415442218609133, 0.00705593524717799, -0.00638233357089081, -0.00582624677716565, 0.00562868913761196, 0.00513826668309062, 0.0045958054359652, -0.00475711057319694, -0.00434262794914382, -0.00388416451811044, -0.00336378514516178, 0.00368484200521179, 0.00336378514516178, 0.00300866089851429, 0.00260557676948629, 0.00212744452363027, -0.00212744452363027, -0.00194208225905522, -0.00173705117965753, -0.00150433044925714, -0.00122828066840393, -0.000868525589828764};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 1.2910299999197e-14, 0.0, 0.0, 0.0, 1.13791354811044e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.82459407806732e-14, 0.0, 0.0, 1.14502076617531e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0075685218886e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495583, 0.0, 8.36660026534078, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.80145229452567e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15685944010291e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.27459512282647e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.09631768083421e-14, 0.0, 0.0, 1.1552363868434e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.499090833947, 0.0, -3.34664010613631, -2.36643191323983, 15.4919333848297, 1.40047939984465e-14, 0.0, 0.692820323027552, 0.565685424949243, 0.400000000000003, 0.0, -2.49005609448537e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.57593122579458e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.43663518857582e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.89897948556634, 0.0, 0.0, 0.0, 14.1985914794391, -0.82807867121082, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06536050760624e-14, 0.0, 0.0, 1.39367297957671e-14, 0.0, 0.0, 1.05249092186598e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.54267715844228e-14, 4.24264068711926, 0.0, 0.0, 0.0, 0.0, 14.3427433120127, 0.0, 0.0, 0.0, 0.0, 0.0, 1.05353075839509e-14, 0.0, 0.0, -3.24774929172378e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15085846777474e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.6, 0.0, 8.76356092008268, -1.54919333848298, 0.0, 0.0, 0.0, 9.52470471983254, -1.48131215963609, 0.261861468283191, 0.0, 0.0, 0.0, 1.2116276143714e-14, 0.0, 0.0, 2.02795020253393e-14, -1.24841587070845e-14, 0.0, -1.13301837530166e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.11769145362398, 0.0, 3.16227766016839, 4.91934955049953, 0.0, 0.0, 0.0, 0.0, 10.690449676497, -2.41897262725906, 0.0, 0.0, 0.0, 0.0, 0.0, 1.51412862395202e-14, 0.0, 0.0, 0.0, -1.52542908860021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.01325198231805e-14},
      {2.54558441227158, 0.0, 0.0, 7.66811580507232, 0.0, 0.0, 0.0, 0.0, 0.0, 10.3691851174526, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.45807581273514e-14, 0.0, -1.39332989590457e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0099560077137e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.6057691494799, 1.13965640310271e-14, 1.12317278033983e-14, 0.0, -4.20458932936039, -3.43303281162797, 0.0, 0.0, 0.0, 19.6214168703486, 0.0, -2.36962160732751e-14, 0.611677741841193, 0.529728463363953, 0.43252147915678, 0.0, 1.5150275997887e-14, 1.06682783267142e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.08329718200539e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.53137212479104, 0.0, 3.54562104171167, -2.50713268211202, 4.78713553878169, 2.10513249875174e-14, 0.0, -5.56626745075489, -1.04880884817015, 0.741619848709568, 0.0, 18.8034951158402, -0.603122387046446, -2.28847070207928e-14, 0.0, 0.0, 1.68183573174417, 0.701283781217659, 0.132137494528686, -0.0934353184302173, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.44061292815194e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.05298244095219, 0.0, -1.58564993434419, 4.48489528465111, 4.28174419288837, 1.20835277214061e-14, 1.11961712189777e-14, 0.191485421551267, -3.75233260785875, -4.31161222746203, 0.0, 0.0, 18.8807171866294, 0.0, 0.0, 0.0, 0.0, 0.844371341865031, 1.18187368057056, 1.04463861754668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.2134084668507e-14, 2.59512887494071, 1.30243580677425e-14, 0.0, 0.0, 10.0285307284481, -0.767649473578736, 1.32152493598616e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 16.4130361329658, -1.26347611061158, 0.0967147429123368, 2.54129405369957e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.23815712294068e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.32115382989598, 0.0, 0.0, 0.0, 3.9242833740697, 5.49285249860477, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06108914491809e-14, 17.3044631365566, -1.73008591662715, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.29781861460725e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.01017818278145, 0.0, 0.0, 0.0, 0.0, 8.91928088068603, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.8558564884488, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.96647939483828, 0.0, 8.12403840463597, -1.64130361329658, 0.0, 0.0, 0.0, 11.7728501222092, -2.40312296813959, 0.485504156227614, 0.0, 0.0, 0.0, 1.23564094401707e-14, 0.0, 0.0, 10.2761860629321, -1.48323969741915, 0.302765035409766, -0.0611677741841213, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.41468916081805e-14, -1.06387139939102e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.65329983228432, 1.07906632212329e-14, 4.15220619990514, 2.93605316083771, 0.0, 0.0, 0.0, 2.63248931621765, 9.82591326180785, -2.82261277137741, 0.0, 0.0, 0.0, 0.0, 1.24131222965466e-14, 1.49900004882226e-14, 0.0, 11.6081867662439, -3.09487177319465, 0.683876505540215, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15581372597817e-14},
      {2.29782505861521, 0.0, 1.49829835452877, 5.50917601898535, 0.0, 0.0, 0.0, 0.0, 6.6480394532094, 4.13676892548486, 0.0, 0.0, 0.0, 0.0, -1.17293975629304e-14, 0.0, 0.0, 1.77288971805021e-14, 12.5636136423842, -3.55352656109507, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.11514820135553e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59891152423402e-14, 0.0},
      {1.87616630392937, 0.0, 0.0, 6.22830929985769, 0.0, 0.0, 0.0, 0.0, 0.0, 11.0541524195338, 0.0, 0.0, 0.0, 0.0, 2.21090682023547e-14, -2.20298115882095e-14, 0.0, 0.0, 0.0, 11.6057691494799, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.33025010156243e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.02243531748197e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.83186700722506, 0.0, -4.4108709245369, -3.11895674167862, 16.6749979177077, 0.0, 0.0, 2.13065307820924, 1.73967095350099, 1.23013312825383, 0.0, -4.36653943835009, -3.78153408023783, 1.41518305777056e-14, 0.0, 0.0, -0.557935943461964, -0.483186700722496, -0.394520289089678, -0.27896797173098, 23.6981011897578, 0.0, 0.0, 0.490653381462662, 0.43885372573626, 0.380058475033051, 0.0, 0.0, 0.0, 0.0, 0.0626933893908886, 0.0560746721671629, 0.0485620906056458, 0.0396507809422063, 0.0280373360835801, -1.53456478450664e-14, 0.0, -1.99429181619326e-14, 1.44789034491149e-14, 1.01988074810049e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 6.91050664139876, 0.0, 0.0, 0.0, 10.5706241650196, -2.725540575477, 0.0, 0.0, 0.0, 4.67332857821917, -1.05010595342034e-14, 0.0, -7.86705867811456, -2.39719223514615, 0.618094504365255, -1.47455891591556e-14, 1.12727459016504e-14, 0.0, 0.0, 0.0, 23.10555488766, -0.46968719442418, 0.0, 0.0, 0.0, 1.62065746295906, 0.790669146636832, 0.240926884676764, -0.0621208350290953, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.80757955956212e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23610364477168e-14, 6.30840061880561, 0.0, 1.32560721454874e-14, 0.0, -1.52362350055009, 11.1963004093827, 0.0, 0.0, 0.0, 4.26614580154031, 0.0, -2.16065093893094e-14, 0.132992762321608, -4.72217953828918, -6.67684597013018, 0.0, 1.9088487167099e-14, 0.0, 0.0, 0.0, 0.0, 23.1532444221696, 0.0, 0.0, 0.0, 0.0, 0.721778878560589, 1.11125127955291, 1.1908743922773, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.38981605247764e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.85449644663771, -1.18136914997961e-14, 5.98171817966649, -2.4880667576406, 1.90029237516522, 0.0, 0.0, -0.339934634239515, -2.35922146606162, 0.981306762925318, -1.26323072778345e-14, 9.9522670305624, -0.430945803685669, -1.49384636824453e-14, -1.23780151626501e-14, 0.0, -6.45364422706455, 0.0770899289327555, 0.535021138879219, -0.222539456105681, 0.0, 0.0, 0.0, 21.5273297444417, -1.00024047132728, 0.0433116829031369, 0.0, 0.0, 0.0, 0.0, 2.75066129615, 0.648615649442914, -0.00774782937530893, -0.0537716476536644, 0.0223660568773436, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.51865775274498, 0.0, 1.92724822331886, 2.72554057547702, 1.73472166622178, 2.21844751832061e-14, 0.0, -2.01705689521107, 3.42052627529741, -4.03112887414929, 0.0, 4.08831086321547, 5.37643791520788, -1.71481853656905e-14, 0.0, -1.06882166763076e-14, 0.365669640132034, -6.25148194071025, -2.03981013744549, 1.80803322065282, 0.0, 0.0, 0.0, 0.0, 22.1880978975596, -1.26521523890981, 0.0, 0.0, 1.14605390115538e-14, 0.0, 0.0, 1.98456380761453, 1.4711357857929, 0.363818136386359, -0.294009452979932, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.71815051937847e-14, 0.0, 0.0, 0.0, 0.0, -1.18769617990554e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.26320395116286e-14},
      {3.14718316987777, 0.0, -0.861891607371333, 6.09449400220043, 1.55158222708543, 0.0, 0.0, 0.0693888666488761, -3.05941170815568, 1.802775637732, -1.21553148106218e-14, 0.0, 9.03122156537878, 0.0, -1.07871246143559e-14, 0.0, 0.0, 0.403888506800963, -3.67461994579464, -5.49650682721193, 0.0, 0.0, 0.0, 0.0, 0.0, 21.7841260588564, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.974215733960555, 1.78974858569577, 1.80791908794931, 0.0, 0.0, -1.60686571624997e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.54523626091313, 0.0, 0.0, 0.0, 6.71778024562962, -0.60944940022004, 1.10275490459957e-14, 0.0, 0.0, 0.0, -1.6456712081289e-14, 0.0, 14.6593983227032, -1.52344936219871, 0.138210132827971, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.119501277094, -1.47332496632642, 0.153112421864223, -0.0138906409944096, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.39995279753084e-14, 1.41060126129512, 0.0, 0.0, 0.0, 3.63405410063597, 2.50356888118885, 0.0, 0.0, 0.0, 0.0, 0.0, -1.45045476356222e-14, 3.56857028479908, 11.263055412878, -1.49298814645065, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 19.3673596462205, -2.65048896124153, 0.26628760937957, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.26168012376112, 0.0, 0.0, 0.0, 1.42204860051345, 4.47852016375307, 0.0, 0.0, 0.0, 0.0, -1.06631060032885e-14, 0.0, 0.0, 8.27725128825318, 5.37909280973866, 0.0, 0.0, 0.0, -1.26802643034984e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 19.9654813226339, -2.61992366301005, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03547418869597e-14, 1.09264703862704, 0.0, 0.0, 0.0, 0.0, 5.38682254607084, 0.0, 0.0, 0.0, 1.43678447654116e-14, 0.0, -1.26850385459499e-14, 0.0, 0.0, 13.4377817958113, 0.0, 0.0, 0.0, -1.19741539833768e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.907670401189, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.16144232859832e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.52336024752224, 0.0, 7.37120708415867, -1.62882203585592, 0.0, 0.0, 0.0, 12.0171306297064, -2.90724328050879, 0.642416074439623, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.9858820944259, -2.72522906732403, 0.659300804656277, -0.145686271816944, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8043830863937, -1.40563403846548, 0.273895826790428, -0.0662622240310403, 0.0146420212340139, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.30350221379959, 0.0, 4.41588043316394, 1.78428514239953, 0.0, 0.0, 0.0, 4.26614580154032, 7.83741028656786, -2.63899331455874, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.23427840700304, 13.2221027072096, -4.67379217909109, 1.18363558466232, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.1258851598178, -3.11150358274814, 0.833612074594105, -0.192474367616153, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.16671184212998e-14, -1.05506262439036e-14, 1.20949219331451e-14, 0.0},
      {2.06031501455085, 0.0, 2.25696201807215, 3.98978286964827, 0.0, 0.0, 0.0, 0.953939201416944, 8.01142041980431, 1.18019368870418, 0.0, 0.0, -1.10987880183744e-14, 0.0, 0.0, 1.33508081524865e-14, -1.28916900933361e-14, 5.55254896421455, 9.62241374388481, -3.59830837050573, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.3932520322736, -4.68666192508058, 1.18356086726903, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.78428514239953, -1.30036122119359e-14, 0.814411017927983, 5.06770487035908, 0.0, 0.0, 0.0, 1.14120304309435e-14, 4.01510046524762, 6.58672305740272, 0.0, 0.0, 0.0, 0.0, 0.0, -1.94269048743982e-14, 1.98645161343897e-14, 0.0, 10.0159311874144, 2.83293314500742, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.0929454377398, -4.55552790213387, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.19426646424874e-14, 0.0, 0.0},
      {1.45686271816937, -1.0799768076155e-14, 0.0, 5.07816454066238, 0.0, 0.0, -1.21979263065773e-14, 0.0, 0.0, 10.0142755247554, -1.19130319852633e-14, 0.0, 0.0, 0.0, 1.61556546574893e-14, -1.95283513114671e-14, 0.0, 0.0, 1.35506876181836e-14, 13.8784813613723, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.5535587278944, 0.0, 0.0, 0.0, 0.0, 0.0, -1.229814494606e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580398915498, 5.6124860801609, -1.08012344973464, -0.76376261582597, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747791, 7.24568837309471, 4.1833001326704, -0.59160797830996, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.84724056670101e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513110646, 0.0, 9.66091783079298, 0.683130051063968, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.14713790139846e-14, 1.71237169977297e-14, 0.0, 0.0, -1.08954728919586e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847577, -1.67332005306815, -1.18321595661991, 7.74596669241484, -1.19999999999999, -0.979795897113259, 0.346410161513775, 0.282842712474621, 0.200000000000003, 0.0, -1.151409054946e-14, 0.0, -1.15969281804308e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.26922669423102e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772444, 2.44948974278317, 2.82842712474621, -0.99999999999999, 9.16515138991168, 7.09929573971954, -0.414039335605405, -2.04939015319191, -0.478091443733754, 0.169030850945706, 0.0, 0.0, 0.0, -1.33543246568772e-14, 1.09049726635857e-14, 0.0, 2.45272869424639e-14, 0.0, 0.0, 1.50613028992996e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0124611797498, 2.12132034355963, -0.40824829046386, 3.17542648054293, 0.0, 0.0, 7.17137165600636, 0.0, -1.38013111868471, -1.56144011671766, 0.0, 0.0, 0.0, 0.0, 0.0, -1.79811931838274e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, -5.69209978830308, 4.38178046004133, -0.774596669241488, 0.0, 10.998181667894, 0.962140470884725, 4.76235235991627, -0.740656079818041, 0.130930734141592, 0.0, 0.0, 0.0, 1.01063973293581e-14, 0.0, 0.0, 0.0, -1.30375612894406e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681198, 2.73861278752582, 1.5811388300842, 2.45967477524976, 0.0, 0.0, 9.25820099772552, 0.0, 5.3452248382485, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24531615432229e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613579, 0.0, 0.0, 3.83405790253616, 0.0, 0.0, 0.0, 0.0, 0.0, 5.18459255872629, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270665, 1.30114842892144e-14, -3.1622776601684, -2.23606797749979, 0.0, 0.0, 0.0, 13.7477270848675, 0.534522483824848, 0.377964473009225, 0.0, 0.0, 0.0, 1.43607271013995e-14, 0.0, 0.0, -2.43670412228116e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.16367050022963e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.8, 1.32427747618133e-14, 3.6514837167011, -2.8401877872188, 0.0, 0.0, 0.0, 1.59418229182701e-14, 12.3442679969674, 1.39659449751035, 0.0, 0.0, 0.0, 0.0, 1.03196509981685e-14, 2.65071218225995e-14, 0.0, -1.24384285458553e-14, -1.52262689000772e-14, -2.8799445467298e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.14359604727581e-14, -1.52773957190921e-14, -1.33794884893401e-14},
      {2.20454076850487, 0.0, 0.0, 6.64078308635358, 0.0, 0.0, 0.0, 0.0, 0.0, 8.97997772825745, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.21719387145091e-14, 0.0, -1.86951149006021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.10337086689505e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.56904651573302, 5.80288457473996, -2.01017818278146, -1.42141062443801, 8.14215222512714, -2.10229466468019, -1.71651640581398, 0.728256234341415, 0.594618725379071, 0.420458932936045, 9.81070843517429, -1.18450885369837, -1.02581475831037, 0.305838870920592, 0.26486423168198, 0.216260739578387, -0.105945692672791, -0.0917516612761676, -0.0749149177264296, -0.052972846336385, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239552, 3.07059789431495, 1.77281052085584, -1.25356634105601, 2.39356776939085, 6.30376871403132, -0.908295106229251, -2.78313372537744, -0.524404424085073, 0.370809924354785, 11.1242977306435, 9.40174755792012, -0.301561193523238, -2.42752078113806, -0.79420020665697, 0.114434427054266, 0.840917865872091, 0.350641890608831, 0.0660687472643452, -0.0467176592151053, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.02649122047608, 2.74642624930237, -0.79282496717209, 2.24244764232556, 2.14087209644419, -0.331662479035533, 6.49923072370878, 0.0957427107756358, -1.87616630392937, -2.15580611373101, 0.0, 0.0, 9.4403585933147, 0.0, -1.46249406456535, -2.04706526287666, 0.0, 0.422185670932512, 0.590936840285283, 0.522319308773346, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551269, 1.29756443747036, 3.74574588632198, -1.05945692672795, -8.09173593712688, 5.01426536422407, -0.383824736789376, 1.80936716113937, -1.1080065755349, 0.313391585263999, 0.0, 12.7134831207354, 1.01946290306867, 8.2065180664829, -0.631738055305792, 0.0483573714561624, -2.84282124887604, -0.227958835180082, 0.1395957071376, -0.0394836284566178, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.16906536108784e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715535, 1.160576914948, 1.34011878852098, 1.89521416591738, 2.53311402559511, 1.96214168703485, 2.74642624930238, -0.566421515598877, 3.17129986868838, -1.82198870938951, 0.0, 0.0, 11.169982923824, 0.0, 8.65223156827829, -0.865042958313569, 0.0, -2.49768411251822, -0.998865569685856, 0.441440386136652, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741913, 1.00508909139072, -0.193429485824663, 3.55615782880926, 0.0, 0.0, 4.45964044034302, 0.0, -0.858258202906993, 2.67027285925187, 0.0, 0.0, 1.02205127091632e-14, 0.0, 0.0, 8.42792824422442, 0.0, 0.0, -1.62195554683794, -2.29379153190449, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741915, 7.03562363973515, 4.062019202318, -0.820651806648287, 0.0, -6.79705818718656, -2.08116553882674, 5.88642506110459, -1.2015614840698, 0.24275207811381, 0.0, 0.0, 0.0, 14.8323969741913, 0.856348838577674, 0.262202212042538, 5.13809303146608, -0.741619848709572, 0.151382517704889, -0.0305838870920605, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.2372868034904e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32664991614217, -2.69693703815181, 2.07610309995256, 1.46802658041886, 0.0, 3.03973683071412, -6.38211787508102, 1.31624465810882, 4.91295663090393, -1.4113063856887, 0.0, 0.0, -2.2592738714644e-14, 0.0, 13.4039795085887, 2.01017818278149, 0.0, 5.80409338312193, -1.54743588659733, 0.341938252770107, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1489125293076, 1.29756443747034, 0.749149177264387, 2.75458800949267, 0.0, 0.0, 5.75737105184054, 0.0, 3.32401972660471, 2.06838446274243, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8804085776374, 0.0, 0.0, 6.28180682119208, -1.77676328054755, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.01213079341215e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.938083151964683, 0.0, 0.0, 3.11415464992885, 0.0, 0.0, 0.0, 0.0, 0.0, 5.52707620976692, 0.0, 0.0, 0.0, 0.0, 1.10545341011773e-14, -1.10149057941048e-14, 0.0, 0.0, 0.0, 5.80288457473997, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.4253953543107, 0.0, 9.38083151964688, 1.89521416591738, 0.0, 0.0, 0.0, -3.39852909359328, -2.77488738510233, -0.560611910581392, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.7988763690296, 0.42817441928883, 0.349602949390067, 0.0706304617818757, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.82970843102536, 0.0, -1.49829835452879, 4.23782770691181, 0.0, 0.0, 0.0, 3.79967103839267, -3.54562104171169, -4.07409060843205, 0.0, 0.0, 0.0, 0.0, 0.0, -1.52158320389315e-14, 0.0, 16.7549743857359, 1.11676565710083, 0.987090711415307, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.01936820004651e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15848226724032e-14, 0.0},
      {-1.32664991614217, 0.0, 1.73008591662712, -3.18072425757424, 0.0, 0.0, 0.0, 0.0, 7.6764947357874, -2.38836465270397, 0.0, 0.0, -1.79238954995876e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 14.5072114368499, 2.05162951662071, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.38270237873247e-14, 0.0},
      {1.62480768092719, 0.0, 0.0, 5.39387407630362, 0.0, 0.0, 0.0, 0.0, 0.0, 9.57317681262151, 0.0, 0.0, 0.0, 0.0, 1.84472351819205e-14, -1.99075298319087e-14, 0.0, 0.0, 0.0, 10.0508909139073, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.11796624108017e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.41593350361253, 5.72988941019467, -2.20543546226844, -1.5594783708393, 8.33749895885383, -2.76779953857106, -2.25989885993662, 1.06532653910461, 0.869835476750492, 0.615066564126914, 10.333118277332, -2.18326971917504, -1.89076704011892, 0.724780051083757, 0.627677936394704, 0.512496888990057, -0.278967971730972, -0.241593350361236, -0.197260144544829, -0.139483985865484, 11.8490505948789, -1.16109782023228, -1.03851746182648, 0.245326690731331, 0.219426862868129, 0.190029237516526, -0.0814411017927947, -0.0728431359084675, -0.0630840061880541, -0.0515078753637702, 0.0313466946954437, 0.0280373360835811, 0.0242810453028231, 0.0198253904711023, 0.0140186680417899, -1.34598912841459e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.18529407725404, 3.45525332069938, 0.997445717412069, -1.4106012612951, 3.23209352764251, 5.28531208250979, -1.3627702877385, -2.8908723349783, -0.393397896234722, 0.556348640264194, 2.33666428910958, 9.02784807228867, -0.732969916135166, -3.93352933905728, -1.19859611757308, 0.309047252182629, 1.64018416088946, 0.655588223176222, 0.0892142571199762, -0.126168012376104, 13.0996183150503, 11.55277744383, -0.23484359721209, -2.44096975264613, -0.907332870306509, 0.0736662483163258, 0.810328731479528, 0.395334573318415, 0.120463442338383, -0.0310604175145496, -0.311895674167861, -0.164844710568313, -0.0658890955530676, -0.0089663702065851, 0.012680362351407, 0.0, 0.0, 0.0, 1.11652798437369e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99489143482415, 3.1542003094028, -1.09264703862703, 1.54523626091315, 2.95048422176041, -0.761811750275038, 5.59815020469136, 0.263899331455871, -1.93925611658551, -2.28543525082517, 2.13307290077015, -0.257539376818854, 9.14446135479765, 0.0664963811608003, -2.36108976914459, -3.33842298506509, -0.0230350221379984, 0.817905488277902, 1.1564636454577, 1.02505848514082, 0.0, 0.0, 11.5766222110848, 0.0, -1.39771878815471, -2.15192884958005, 0.0, 0.360889439280297, 0.555625639776455, 0.595437196138648, 0.0, -0.125015768949706, -0.192474367616159, -0.206265495285701, -0.166687691932938, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.92724822331886, 1.82834820066014, 2.99085908983326, -1.2440333788203, 0.950146187582609, 5.74064456311311, -0.721110255092802, -0.169967317119738, -1.17961073303082, 0.490653381462658, -10.3037210107158, 4.97613351528119, -0.215472901842826, 5.7817446699566, -1.30185581821821, 0.16353243452862, -3.22682211353225, 0.0385449644663744, 0.267510569439616, -0.111269728052839, 0.0, 14.555131461167, 1.03556292536503, 10.7636648722209, -0.500120235663639, 0.0216558414515674, -3.57321383950879, -0.581087203147979, 0.130841432732454, -0.0164356280722681, 1.375330648075, 0.324307824721454, -0.00387391468765176, -0.0268858238268353, 0.0111830284386719, 0.0, 0.0, 0.0, -1.24814777259306e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.01558844222418e-14, 0.0, 0.0, 0.0, 0.0, 1.4259678156057e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.75932887637251, 1.66904592079257, 0.963624111659426, 1.36277028773851, 0.867360833110885, 2.28430636201793, 2.96226264871973, -1.00852844760553, 1.71026313764871, -2.01556443707464, 2.41867732448957, 2.04415543160773, 2.68821895760392, -0.52779866291175, 7.07977053255617, -1.76652739792482, 0.182834820066016, -3.12574097035512, -1.01990506872275, 0.904016610326407, 0.0, 0.0, 13.1266557397187, 0.0, 11.0940489487798, -0.632607619454898, 0.0, -2.8644711213756, -1.66605356688627, 0.315075748468086, 0.0, 0.992281903807264, 0.735567892896454, 0.181909068193181, -0.147004726489968, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.29943670433591e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.57359158493888, 1.49284005458434, -0.430945803685661, 3.04724700110022, 0.775791113542715, -0.12018504251546, 5.29905651979671, 0.0346944333244405, -1.52970585407784, 0.901387818866003, 0.0, 0.0, 4.51561078268939, 0.0, -0.699555414372428, 6.36462844462228, 0.0, 0.201944253400478, -1.83730997289731, -2.74825341360596, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8920630294282, 0.0, 0.0, -1.68739114875268, -3.0999354831996, 0.0, 0.0, 0.487107866980278, 0.894874292847886, 0.903959543974654, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.62882203585591, 0.772618130456559, 3.86595114186569, -1.05140010313426, 9.15442906076461, 3.35889012281481, -0.304724700110017, 3.87851223317103, -1.52475169285616, 0.414677792940103, -1.30025811259761e-14, -9.46260092820843, -2.07602937339136, 7.32969916135159, -0.761724681099364, 0.0691050664139826, 0.564240504518059, -0.879563899362192, 0.34578118203619, -0.0940400840863324, 0.0, 0.0, 0.0, 16.3745228938128, 0.951027176355642, 0.208648802584723, 9.05975063854701, -0.736662483163209, 0.0765562109321155, -0.00694532049720559, -3.48709964663733, -0.0567083043941599, 0.0883994979795876, -0.0347523163751415, 0.00945138406569528, 0.0, -1.00011135325188e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48690428533296, 0.705300630647561, 2.03602754481989, 1.15175110689978, -2.93221479395415, 1.81702705031799, 1.25178444059441, 0.65566316039121, 3.61359041872287, -1.70346285967312, 0.0, 2.7642026565595, -9.0878387586433, 1.78428514239954, 5.631527706439, -0.746494073225328, -0.61809450436525, 2.03210252328837, -2.15494277062552, 0.764033484562603, 0.0, 0.0, 0.0, 0.0, 15.0018922739643, 2.13860408462396, 0.0, 9.68367982311022, -1.32524448062075, 0.133143804689781, 0.0, -3.3545250915713, -0.478206411017786, 0.384353057392912, -0.12424167005819, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.36916607789467e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32992762321609, 0.630840061880566, 0.72843135908468, 2.57539376818855, 0.917928424547682, 0.711024300256724, 2.23926008187653, -0.205255035576784, 2.58567482211401, 0.761811750275059, 0.0, 0.0, 5.34294273196306, 0.0, 4.13862564412659, 2.68954640486934, 0.0, -1.19471831485579, 3.1056206816986, -2.32269806558126, 0.0, 0.0, 0.0, 0.0, 0.0, 12.8876627769294, 0.0, 0.0, 9.98274066131696, -1.30996183150503, 0.0, 0.0, -2.88176900403078, -1.51261363209512, 0.763985254692622, 0.0, 0.0, -1.17185759123372e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1517511068998, 0.546323519313516, -0.105140010313426, 3.2711894277325, 0.0, 0.0, 2.69341127303542, 0.0, -0.518347241175126, 4.25171145123353, 1.14902781575578e-14, 0.0, 0.0, 0.0, 0.0, 6.71889089790564, 0.0, 0.0, -1.29305115618719, 1.82865048192212, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.45383520059451, 0.0, 0.0, 0.0, -1.81939143264587, -2.94058061635795, 0.0, 0.0, 0.0, 0.0, 0.0, 1.05723279563221e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.26168012376111, -6.78263087840206, 3.68560354207933, -0.814411017927962, 0.0, 10.0216907612581, 2.67510569439611, 6.00856531485322, -1.4536216402544, 0.321208037219806, -1.65057976629295e-14, 0.0, 1.17706771112406e-14, -7.57008074256672, -2.27270584034422, -0.606656948415846, 6.99294104721295, -1.36261453366202, 0.329650402328128, -0.0728431359084687, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.7137404500718, 0.760821741084516, 0.228415531250646, 0.0609713174047718, 5.40219154319687, -0.702817019232743, 0.136947913395215, -0.0331311120155195, 0.00732101061700708, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.42496696880162e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1517511068998, 3.82426463519459, 2.20794021658197, 0.892142571199776, 0.0, -2.46306042692148, 6.78739640804926, 2.13307290077016, 3.91870514328393, -1.31949665727937, 0.0, 0.0, 0.0, 3.22490309931941, -7.63378455726036, -4.04762275910194, 1.11713920350153, 6.61105135360481, -2.33689608954555, 0.591817792331165, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.5022076529583, 1.79642743108413, 0.72192923349994, 0.0, 6.06294257990892, -1.55575179137407, 0.416806037297051, -0.0962371838080743, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03015750727543, -1.4659398322703, 1.12848100903607, 1.99489143482414, 0.0, 1.10151410945723, -5.20357020296094, 0.476969600708469, 4.00571020990215, 0.590096844352087, 0.0, 0.0, 0.0, 0.0, 6.41153127835568, -6.24994106094656, 0.0, 2.77627448210729, 4.81120687194239, -1.79915418525286, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.4651953323153, 3.04407621455179, 0.0, 0.0, 6.69662601613678, -2.34333096254029, 0.591780433634514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.892142571199772, 0.705300630647555, 0.407205508963985, 2.53385243517954, 0.0, 0.0, 3.47717900165117, 0.0, 2.00755023262381, 3.29336152870136, 0.0, 0.0, 0.0, 0.0, 0.0, 8.67405085085771, 0.0, 0.0, 5.0079655937072, 1.4164665725037, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.2048487632307, 0.0, 0.0, 0.0, 7.0464727188699, -2.27776395106694, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.728431359084687, 0.0, 0.0, 2.53908227033119, 0.0, 0.0, 0.0, 0.0, 0.0, 5.00713776237768, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.93924068068616, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.2767793639472, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.09901951359278, 0.0, -4.65474668125635, -3.29140294302194, 0.0, 0.0, 0.0, 13.490737563232, 1.83585684909538, 1.29814682728311, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -3.53270434653118, -3.05941170815567, -0.416333199893246, -0.294392028877619, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 21.8326971917504, 0.355050145839447, 0.307482445914322, 0.0418430609640578, 0.0295875121532877, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.61462585708151e-14, 0.0, 0.0, 0.0, 0.0, -1.16102518088945e-14},
      {-2.65985524643218, 0.0, 5.0990195135928, -2.06031501455083, 0.0, 0.0, 0.0, -1.23153021346074, 9.04986187739901, 3.04724700110021, 0.0, 0.0, 1.42882694523272e-14, 0.0, 0.0, 0.0, 3.86988371918332, -3.81689227863017, -5.39683034546924, -1.3667446468544, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 21.00264918355, 0.898213715542062, 0.962572311333254, 0.222250255910583, 0.0, 0.0, 0.0, 0.0, -1.12681836907137e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.18513103827981e-14, 0.0, 0.0, 1.05763921925961e-14},
      {2.97380857066589, 0.0, -0.814411017927952, 5.75875553449899, 0.0, 0.0, 0.0, 1.37689263682151, -2.89087233497831, 1.70346285967313, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 8.01441409794461, -3.47218947830365, -5.1937107658469, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 19.3314941653941, 1.69115345252878, 1.70832296330021, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.43661124663019e-14},
      {-1.03015750727544, 0.0, 0.940400840863422, -2.9258407710754, 0.0, 0.0, 0.0, 0.0, 4.63623866886821, -3.80284633026898, 0.0, 0.0, 0.0, 0.0, -1.17361870806384e-14, 0.0, 0.0, 0.0, 11.565401134477, -1.63559471386624, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.2731316843076, 2.63013526059784, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.01423919225742e-14, 0.0},
      {1.26168012376113, 0.0, 0.0, 4.39781949681095, 0.0, 0.0, -1.11014659841498e-14, 0.0, 0.0, 8.67261700493487, 0.0, 0.0, 0.0, 0.0, 1.40183636832794e-14, -1.61637203484436e-14, 0.0, 0.0, 1.165919317568e-14, 12.0191174248973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8717007662564, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06515764673489e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580398915498, 5.6124860801609, -1.08012344973464, -0.76376261582597, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267039, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.55391889677069e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971952, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24263211362714e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32287565553229, 0.0, 3.86436713231719, -0.341565025531985, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971955, 2.50998007960222, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912986, 0.0, 0.0, 8.87411967464941, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.96188551515597e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847577, -1.67332005306815, -1.18321595661991, 7.74596669241484, -1.19999999999999, -0.979795897113259, 0.346410161513775, 0.282842712474621, 0.200000000000003, 0.0, -1.151409054946e-14, 0.0, -1.15969281804308e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.26922669423102e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772444, 2.44948974278317, 2.8284271247462, -0.999999999999998, 1.30930734141595, 7.09929573971953, -0.414039335605412, -2.04939015319192, -0.478091443733755, 0.169030850945706, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.08716682344658e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0124611797498, 2.12132034355963, -0.408248290463859, 3.17542648054295, 9.07114735222146, 0.0, 7.17137165600637, 0.0, -1.3801311186847, -1.56144011671766, 0.0, -1.27114514413737e-14, 0.0, 0.0, 0.0, -1.89105350382163e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, 0.632455532033676, 4.38178046004134, -0.774596669241488, 0.0, 3.14233761939829, -0.106904496764969, 4.76235235991627, -0.740656079818045, 0.130930734141596, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.18031428662765e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 0.547722557505164, 1.58113883008419, 2.45967477524977, 0.0, 9.07114735222145, 1.8516401995451, 0.0, 5.34522483824849, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, -6.26099033699941, 0.0, 3.83405790253615, 0.0, 0.0, 10.5830052442584, 0.0, 0.0, 5.18459255872628, 0.0, 0.0, 0.0, 1.25836173653064e-14, 1.48358452126538e-14, -1.12491819922707e-14, -1.04421095586587e-14, 0.0, 0.0, -1.67296732023203e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03923048454133, 0.0, 3.16227766016838, -0.447213595499959, 0.0, 0.0, 0.0, 5.89188303637179, -0.534522483824848, 0.0755928946018435, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.900000000000011, 1.33719710960724e-14, 1.46059348668044, 1.42009389360938, 0.0, 0.0, 0.0, 9.07114735222146, 4.93770719878695, -0.698297248755181, 0.0, 0.0, 0.0, 1.32954362671572e-14, 0.0, 1.06165553601881e-14, 0.0, 1.44648983668665e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.73484692283496, 0.0, -6.26099033699942, 2.21359436211785, 0.0, 0.0, 0.0, 0.0, 10.5830052442584, 2.99332590941915, 0.0, 0.0, 0.0, 0.0, 0.0, 1.05984189380888e-14, -1.39797099343912e-14, 0.0, 0.0, -1.35759459229945e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.71576766497729, 0.0, 0.0, -4.69574275274956, 0.0, 0.0, 0.0, 0.0, 0.0, 12.69960629311, 1.04519457838932e-14, 0.0, 0.0, 0.0, 1.04165025265274e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.56904651573302, 5.80288457473996, -2.01017818278146, -1.42141062443801, 8.14215222512714, -2.10229466468019, -1.71651640581398, 0.728256234341415, 0.594618725379071, 0.420458932936045, 9.81070843517429, -1.18450885369837, -1.02581475831037, 0.305838870920592, 0.26486423168198, 0.216260739578387, -0.105945692672791, -0.0917516612761676, -0.0749149177264296, -0.052972846336385, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239552, 3.07059789431495, 1.77281052085584, -1.25356634105601, 2.39356776939084, 6.30376871403132, -0.908295106229243, -2.78313372537744, -0.524404424085076, 0.370809924354784, 1.23603308118261, 9.40174755792012, -0.301561193523221, -2.42752078113807, -0.794200206656967, 0.114434427054264, 0.840917865872095, 0.350641890608829, 0.0660687472643458, -0.0467176592151037, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.02649122047608, 2.74642624930237, -0.792824967172092, 2.24244764232556, 2.14087209644419, -0.33166247903552, 6.49923072370877, 0.0957427107756355, -1.87616630392937, -2.15580611373101, 11.0554159678513, 0.0, 9.44035859331468, 0.0, -1.46249406456536, -2.04706526287665, 0.0, 0.422185670932514, 0.590936840285282, 0.522319308773347, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551268, 1.29756443747035, 3.74574588632199, -1.05945692672795, 0.40458679685634, 5.01426536422407, -0.383824736789368, 1.80936716113937, -1.1080065755349, 0.313391585264003, 0.0, 2.82521847127454, -0.0509731451534303, 8.20651806648289, -0.631738055305789, 0.0483573714561688, -2.84282124887604, -0.22795883518008, 0.139595707137604, -0.039483628456614, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.16466485419836e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715535, 1.16057691494799, 1.34011878852098, 1.89521416591737, 0.361873432227873, 1.96214168703486, 2.74642624930238, -0.56642151559888, 3.17129986868837, -1.82198870938951, 0.0, 11.0554159678513, 1.59571184626057, 0.0, 8.65223156827828, -0.86504295831357, 0.0, -2.49768411251822, -0.998865569685855, 0.441440386136649, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741914, 1.00508909139073, -0.193429485824664, 3.55615782880925, -8.46157280212813, 0.0, 4.45964044034302, 0.0, -0.858258202906997, 2.67027285925186, 0.0, 1.44857443011911e-14, 12.4373429638328, 0.0, 0.0, 8.42792824422442, 0.0, 0.0, -1.62195554683794, -2.2937915319045, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741914, 0.335029697130249, 4.06201920231799, -0.820651806648291, 0.0, 1.69926454679664, -0.0991031208965121, 5.88642506110459, -1.2015614840698, 0.242752078113806, 0.0, 0.0, 0.0, 4.94413232473044, -0.214087209644419, 0.0124858196210728, 5.13809303146607, -0.741619848709577, 0.151382517704883, -0.0305838870920607, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32664991614217, 0.299659670905766, 2.07610309995257, 1.46802658041885, 0.0, 0.868496237346898, 0.709124208342333, 1.31624465810883, 4.91295663090393, -1.4113063856887, 0.0, 0.0, 0.0, 11.0554159678513, 3.82970843102536, -0.223353131420157, 0.0, 5.80409338312194, -1.54743588659732, 0.341938252770102, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1489125293076, 0.259512887494075, 0.749149177264382, 2.75458800949267, 0.0, -8.46157280212811, 1.15147421036811, 0.0, 3.32401972660471, 2.06838446274243, 0.0, 0.0, -1.1283446540405e-14, 0.0, 12.4373429638327, 2.17608171552749, -1.21040313496127e-14, 0.0, 6.28180682119209, -1.77676328054754, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.93808315196469, 7.62808987244124, 1.39628067270975e-14, 3.11415464992886, 0.0, 0.0, -7.52139804633611, 0.0, 0.0, 5.52707620976692, 0.0, 0.0, 0.0, 0.0, 0.0, 14.2141062443803, 1.0319833740378e-14, 1.68289931844567e-14, 0.0, 5.80288457473996, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.856348838577683, 0.0, 2.68023757704196, -0.473803541479344, 0.0, 0.0, 0.0, 5.09779364038993, -0.792824967172097, 0.140152977645348, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.91061171956871, -0.642261628933266, 0.0998865569685892, -0.0176576154454652, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.765941686205081, 0.0, 1.49829835452878, 0.847565541382356, 0.0, 0.0, 0.0, 1.62843044502544, 3.54562104171167, -0.814818121686411, 0.0, -1.00490360530146e-14, 0.0, 0.0, 0.0, 0.0, 11.0554159678513, 7.18070330817253, -1.11676565710082, 0.197418142283054, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.663324958071068, 0.0, 0.692034366650859, 1.5903621287871, 0.0, 0.0, 0.0, -8.46157280212811, 3.07059789431496, 1.19418232635199, 0.0, 0.0, 0.0, -1.73320255518822e-14, 0.0, 0.0, 1.38009491821402e-14, 12.4373429638327, 5.80288457473997, -1.02581475831036, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.541602560309052, -1.25890451024725e-14, 7.62808987244128, 1.79795802543454, 0.0, 0.0, 0.0, 0.0, -7.52139804633611, 3.1910589375405, 0.0, 0.0, 0.0, 0.0, 0.0, -1.97784641917273e-14, 2.38963933169705e-14, 0.0, 14.2141062443803, 3.35029697130245, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-5.36159180343549, 0.0, 0.0, 8.89943818451478, 0.0, 0.0, 0.0, 0.0, 0.0, -5.26497863243527, 0.0, 0.0, 0.0, 0.0, 1.69418316537184e-14, -1.83698225526999e-14, 0.0, -1.32206326378019e-14, 0.0, 16.583123951777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.41593350361253, 5.72988941019467, -2.20543546226844, -1.5594783708393, 8.33749895885383, -2.76779953857106, -2.25989885993662, 1.06532653910461, 0.869835476750492, 0.615066564126914, 10.333118277332, -2.18326971917504, -1.89076704011892, 0.724780051083757, 0.627677936394704, 0.512496888990057, -0.278967971730972, -0.241593350361236, -0.197260144544829, -0.139483985865484, 11.8490505948789, -1.16109782023228, -1.03851746182648, 0.245326690731331, 0.219426862868129, 0.190029237516526, -0.0814411017927947, -0.0728431359084675, -0.0630840061880541, -0.0515078753637702, 0.0313466946954437, 0.0280373360835811, 0.0242810453028231, 0.0198253904711023, 0.0140186680417899, -1.34598912841459e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.18529407725404, 3.45525332069938, 0.997445717412062, -1.41060126129509, 3.23209352764251, 5.2853120825098, -1.36277028773849, -2.89087233497829, -0.393397896234721, 0.55634864026419, 2.33666428910958, 9.02784807228867, -0.732969916135157, -3.93352933905729, -1.19859611757308, 0.309047252182623, 1.64018416088945, 0.65558822317622, 0.089214257119981, -0.126168012376099, 1.1908743922773, 11.55277744383, -0.234843597212088, -2.44096975264613, -0.907332870306512, 0.0736662483163217, 0.810328731479531, 0.395334573318417, 0.120463442338383, -0.031060417514548, -0.31189567416786, -0.164844710568315, -0.0658890955530668, -0.00896637020658499, 0.0126803623514091, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99489143482414, 3.15420030940281, -1.09264703862702, 1.54523626091315, 2.9504842217604, -0.761811750275046, 5.59815020469135, 0.263899331455871, -1.93925611658551, -2.28543525082517, 2.13307290077016, -0.257539376818845, 9.14446135479765, 0.0664963811608087, -2.3610897691446, -3.33842298506508, -0.0230350221379951, 0.817905488277904, 1.15646364545769, 1.02505848514081, 13.0453753561106, 0.0, 11.5766222110848, 0.0, -1.39771878815472, -2.15192884958005, 0.0, 0.360889439280295, 0.555625639776455, 0.595437196138646, 0.0, -0.125015768949705, -0.19247436761616, -0.206265495285702, -0.16668769193294, 0.0, 0.0, 0.0, 0.0, 0.0, 1.07688613330682e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.92724822331886, 1.82834820066013, 2.99085908983326, -1.2440333788203, 0.950146187582608, 5.7406445631131, -0.7211102550928, -0.169967317119744, -1.17961073303082, 0.490653381462661, 0.294392028877592, 4.9761335152812, -0.215472901842836, 5.78174466995659, -1.30185581821821, 0.163532434528625, -3.22682211353225, 0.0385449644663701, 0.267510569439614, -0.111269728052837, 0.0, 2.646387538394, -0.0295875121532846, 10.7636648722209, -0.50012023566364, 0.0216558414515689, -3.57321383950879, -0.581087203147979, 0.130841432732454, -0.0164356280722693, 1.37533064807501, 0.324307824721454, -0.00387391468765233, -0.0268858238268337, 0.011183028438673, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.54346718065853e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.75932887637249, 1.66904592079257, 0.963624111659428, 1.36277028773851, 0.867360833110891, 2.28430636201794, 2.96226264871972, -1.00852844760553, 1.71026313764871, -2.01556443707465, 0.268741924943287, 2.04415543160772, 2.68821895760394, -0.527798662911744, 7.07977053255618, -1.76652739792483, 0.182834820066012, -3.12574097035513, -1.01990506872274, 0.904016610326411, 0.0, 13.0453753561106, 1.45851730441319, 0.0, 11.0940489487798, -0.632607619454904, 0.0, -2.8644711213756, -1.66605356688627, 0.315075748468089, 0.0, 0.992281903807263, 0.735567892896453, 0.181909068193181, -0.147004726489966, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.5735915849389, 1.49284005458436, -0.430945803685668, 3.04724700110022, 0.775791113542717, -0.120185042515463, 5.29905651979672, 0.0346944333244382, -1.52970585407784, 0.901387818866001, -10.576283741361, 0.0, 4.51561078268938, 0.0, -0.699555414372441, 6.36462844462229, 0.0, 0.201944253400487, -1.83730997289732, -2.74825341360596, 0.0, 0.0, 14.3499128917217, 0.0, 0.0, 10.8920630294282, 0.0, 0.0, -1.68739114875268, -3.09993548319961, 0.0, 0.0, 0.487107866980278, 0.894874292847885, 0.903959543974654, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.62882203585591, 0.772618130456572, 3.86595114186568, -1.05140010313426, 0.160604018609907, 3.35889012281481, -0.304724700110022, 3.87851223317102, -1.52475169285616, 0.414677792940096, 0.0, 1.135512111385, -0.0364215679542345, 7.3296991613516, -0.761724681099359, 0.0691050664139833, 0.564240504518048, -0.879563899362189, 0.345781182036182, -0.0940400840863355, 0.0, 0.0, 0.0, 4.46577897103986, -0.114123261162676, 0.00366050530850576, 9.05975063854701, -0.73666248316321, 0.0765562109321156, -0.00694532049720655, -3.48709964663733, -0.0567083043941568, 0.0883994979795855, -0.0347523163751381, 0.0094513840656929, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48690428533296, 0.705300630647557, 2.0360275448199, 1.15175110689978, 0.146610739697702, 1.81702705031799, 1.25178444059442, 0.655663160391219, 3.61359041872287, -1.70346285967311, 0.0, 0.61426725701323, 0.454391937932152, 1.78428514239953, 5.63152770643899, -0.746494073225317, -0.618094504365244, 2.03210252328836, -2.15494277062552, 0.764033484562593, 0.0, 0.0, 0.0, 13.0453753561106, 3.33375383865872, -0.106930204231199, 0.0, 9.68367982311022, -1.32524448062076, 0.13314380468978, 0.0, -3.3545250915713, -0.478206411017787, 0.384353057392906, -0.124241670058192, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32992762321609, 0.630840061880567, 0.728431359084683, 2.57539376818856, 0.13113263207824, 0.711024300256729, 2.23926008187654, -0.205255035576787, 2.58567482211401, 0.761811750275046, 0.0, -10.576283741361, 0.763277533137582, 0.0, 4.13862564412659, 2.68954640486934, 0.0, -1.19471831485577, 3.1056206816986, -2.32269806558126, 0.0, 0.0, 0.0, 0.0, 14.3499128917217, 1.84109468241849, 0.0, 0.0, 9.98274066131697, -1.30996183150503, 0.0, 0.0, -2.88176900403078, -1.51261363209512, 0.763985254692617, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.15175110689978, 0.546323519313518, -0.105140010313426, 3.27118942773249, 9.65295620481434, 0.0, 2.69341127303541, 0.0, -0.518347241175123, 4.25171145123354, 1.18152069786956e-14, -1.38297717451513e-14, -9.91526600752601, 0.0, 0.0, 6.71889089790564, 0.0, 0.0, -1.29305115618718, 1.82865048192213, 0.0, 0.0, 0.0, 0.0, 0.0, 15.9443476574685, 0.0, 0.0, 0.0, 9.45383520059451, 0.0, 0.0, 0.0, -1.81939143264587, -2.94058061635794, 0.0, 0.0, -1.72754963278994e-14, 0.0, 1.13755232036152e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.26168012376112, 0.199489143482416, 3.68560354207934, -0.814411017927958, 0.0, 1.02786571910339, -0.0786795792469428, 6.00856531485323, -1.4536216402544, 0.321208037219811, 0.0, 0.0, 0.0, 3.0280322970267, -0.233098034907103, 0.0178428514239945, 6.99294104721297, -1.36261453366202, 0.32965040232814, -0.0728431359084713, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.80499652729883, -0.304328696433804, 0.0234272339744254, -0.00179327404131563, 5.40219154319688, -0.702817019232742, 0.136947913395215, -0.0331311120155212, 0.00732101061700645, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.15175110689979, 0.182107839771176, 2.20794021658197, 0.892142571199767, 0.0, 0.615765106730374, 0.323209352764248, 2.13307290077016, 3.91870514328393, -1.31949665727937, 0.0, 0.0, 0.0, 1.07496769977314, 1.90844613931509, -0.19274394090962, 1.11713920350151, 6.6110513536048, -2.33689608954555, 0.591817792331162, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.0453753561106, 5.83406921765277, -0.449106857771024, 0.0343775825476163, 0.0, 6.06294257990892, -1.55575179137407, 0.416806037297052, -0.0962371838080749, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03015750727543, 0.162882203585601, 1.12848100903607, 1.99489143482413, 0.0, 0.314718316987777, 0.578174466995654, 0.476969600708466, 4.00571020990215, 0.590096844352083, 0.0, 0.0, -1.31549551242914e-14, -10.576283741361, 1.83186607953019, 0.694437895660746, -1.8047208927113e-14, 2.77627448210728, 4.81120687194239, -1.79915418525287, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.3499128917217, 4.41862723780437, -0.33823069050576, 0.0, 0.0, 6.69662601613678, -2.34333096254029, 0.591780433634515, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.892142571199766, 0.141060126129502, 0.407205508963996, 2.53385243517955, 0.0, 9.65295620481434, 0.695435800330227, 0.0, 2.00755023262381, 3.29336152870135, 0.0, 0.0, 1.11713603382673e-14, 0.0, -9.91526600752598, 1.73481017017153, 1.64166602797602e-14, 0.0, 5.0079655937072, 1.41646657250371, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.9443476574685, 2.44096975264614, 0.0, 0.0, 0.0, 7.0464727188699, -2.27776395106693, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.728431359084693, -7.94708263760857, -1.34962358184755e-14, 2.53908227033119, 0.0, 0.0, 10.2207771580387, 0.0, 0.0, 5.00713776237768, 0.0, 0.0, 0.0, 0.0, 0.0, -8.49879943502226, -1.3318970311563e-14, 0.0, 0.0, 6.93924068068617, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.9373911146521, 0.0, 0.0, 0.0, 0.0, 6.27677936394721, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.728431359084677, 0.0, 2.32737334062816, -0.470200420431705, 0.0, 0.0, 0.0, 4.49691252107735, -0.917928424547683, 0.185449546754728, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.06540869306229, -1.01980390271856, 0.208166599946613, -0.0420560041253752, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.92395326897747, -0.710100291678877, 0.102494148638108, -0.0209215304820305, 0.00422678745046826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.664963811608031, -1.52728632141123e-14, 1.45686271816937, 0.515078753637711, 0.0, 0.0, 0.0, 1.84729532019112, 2.58567482211399, -0.761811750275054, 0.0, 0.0, 0.0, -1.45770491081465e-14, 0.0, 0.0, 1.71994831963703, 5.72533841794525, -1.54195152727693, 0.34168616171361, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.0453753561106, 9.33451074824443, -1.3473205733131, 0.275020660380933, -0.0555625639776416, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.08465016007527e-14, 0.0, 0.0, 0.0, 0.0},
      {0.594761714133172, 0.0, 0.81441101792795, 1.15175110689982, 0.0, 0.0, 0.0, 0.590096844352069, 2.89087233497829, 0.340692571934627, 0.0, 0.0, 0.0, 0.0, -1.12582268745145e-14, -1.00859362139179e-14, -10.576283741361, 3.43474889911913, 3.47218947830365, -1.03874215316937, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.3499128917217, 8.28492607088319, -1.69115345252877, 0.341664592660044, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.03389519168218e-14},
      {0.515078753637708, 0.0, 0.376160336345357, 1.4629203855377, 0.0, 0.0, 0.0, 9.65295620481433, 1.85449546754729, 1.90142316513449, 0.0, 0.0, 0.0, 0.0, -1.08799737057301e-14, 0.0, 0.0, -9.91526600752598, 4.62616045379077, 0.81779735693313, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.9443476574685, 6.50925267372303, -1.31506763029892, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.420560041253713, 0.0, -7.94708263760858, 1.46593983227031, 0.0, 0.0, 0.0, 0.0, 10.2207771580387, 2.89087233497829, 0.0, 0.0, 1.39515011653448e-14, 0.0, 0.0, 0.0, -2.25920784148809e-14, 0.0, -8.49879943502226, 4.00637247496575, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.9373911146521, 3.62390025541881, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06444352251245e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.542378855465, 0.0, 0.0, -6.91050664139873, 0.0, 0.0, 0.0, 0.0, 0.0, 12.2649325896465, -1.24221302592312e-14, 0.0, 0.0, 0.0, -1.26085093097862e-14, 0.0, 1.00262554257505e-14, 0.0, 1.9958678525973e-14, -5.66586629001481, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.34034011235354e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 20.4998755596024, 0.0, 0.0, 0.0, 0.0, 0.0, -1.13399729500939e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.18880599808691e-14}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[56][56] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[56][56] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 56; t++)
        {
          for (unsigned int u = 0; u < 56; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 56; s++)
        {
          for (unsigned int t = 0; t < 56; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.00945067404923496, 0.0, -0.00704122671245607, 0.00248944957812477, 0.0, 0.0, 0.0, 0.00947126259704828, -0.00515550235170571, 0.00182274533665715, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0045093795093795, -0.00292892790782074, 0.00159430641501296, -0.00056367243867244, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00464478520766673, -0.00332353774887305, 0.00215870109072045, -0.00117504803987881, 0.000415442218609129, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0127646671417816, -0.00971041129527609, 0.00694820471863012, -0.00451299134777144, 0.00245656133680786, -0.000868525589828762};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 1.2910299999197e-14, 0.0, 0.0, 0.0, 1.13791354811044e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.82459407806732e-14, 0.0, 0.0, 1.14502076617531e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0075685218886e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495583, 0.0, 8.36660026534078, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.80145229452567e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15685944010291e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.27459512282647e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.09631768083421e-14, 0.0, 0.0, 1.1552363868434e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.499090833947, 0.0, -3.34664010613631, -2.36643191323983, 15.4919333848297, 1.40047939984465e-14, 0.0, 0.692820323027552, 0.565685424949243, 0.400000000000003, 0.0, -2.49005609448537e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.57593122579458e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.43663518857582e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.89897948556634, 0.0, 0.0, 0.0, 14.1985914794391, -0.82807867121082, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06536050760624e-14, 0.0, 0.0, 1.39367297957671e-14, 0.0, 0.0, 1.05249092186598e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.54267715844228e-14, 4.24264068711926, 0.0, 0.0, 0.0, 0.0, 14.3427433120127, 0.0, 0.0, 0.0, 0.0, 0.0, 1.05353075839509e-14, 0.0, 0.0, -3.24774929172378e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15085846777474e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.6, 0.0, 8.76356092008268, -1.54919333848298, 0.0, 0.0, 0.0, 9.52470471983254, -1.48131215963609, 0.261861468283191, 0.0, 0.0, 0.0, 1.2116276143714e-14, 0.0, 0.0, 2.02795020253393e-14, -1.24841587070845e-14, 0.0, -1.13301837530166e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.11769145362398, 0.0, 3.16227766016839, 4.91934955049953, 0.0, 0.0, 0.0, 0.0, 10.690449676497, -2.41897262725906, 0.0, 0.0, 0.0, 0.0, 0.0, 1.51412862395202e-14, 0.0, 0.0, 0.0, -1.52542908860021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.01325198231805e-14},
      {2.54558441227158, 0.0, 0.0, 7.66811580507232, 0.0, 0.0, 0.0, 0.0, 0.0, 10.3691851174526, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.45807581273514e-14, 0.0, -1.39332989590457e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0099560077137e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.6057691494799, 1.13965640310271e-14, 1.12317278033983e-14, 0.0, -4.20458932936039, -3.43303281162797, 0.0, 0.0, 0.0, 19.6214168703486, 0.0, -2.36962160732751e-14, 0.611677741841193, 0.529728463363953, 0.43252147915678, 0.0, 1.5150275997887e-14, 1.06682783267142e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.08329718200539e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.53137212479104, 0.0, 3.54562104171167, -2.50713268211202, 4.78713553878169, 2.10513249875174e-14, 0.0, -5.56626745075489, -1.04880884817015, 0.741619848709568, 0.0, 18.8034951158402, -0.603122387046446, -2.28847070207928e-14, 0.0, 0.0, 1.68183573174417, 0.701283781217659, 0.132137494528686, -0.0934353184302173, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.44061292815194e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.05298244095219, 0.0, -1.58564993434419, 4.48489528465111, 4.28174419288837, 1.20835277214061e-14, 1.11961712189777e-14, 0.191485421551267, -3.75233260785875, -4.31161222746203, 0.0, 0.0, 18.8807171866294, 0.0, 0.0, 0.0, 0.0, 0.844371341865031, 1.18187368057056, 1.04463861754668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.2134084668507e-14, 2.59512887494071, 1.30243580677425e-14, 0.0, 0.0, 10.0285307284481, -0.767649473578736, 1.32152493598616e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 16.4130361329658, -1.26347611061158, 0.0967147429123368, 2.54129405369957e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.23815712294068e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.32115382989598, 0.0, 0.0, 0.0, 3.9242833740697, 5.49285249860477, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06108914491809e-14, 17.3044631365566, -1.73008591662715, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.29781861460725e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.01017818278145, 0.0, 0.0, 0.0, 0.0, 8.91928088068603, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.8558564884488, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.96647939483828, 0.0, 8.12403840463597, -1.64130361329658, 0.0, 0.0, 0.0, 11.7728501222092, -2.40312296813959, 0.485504156227614, 0.0, 0.0, 0.0, 1.23564094401707e-14, 0.0, 0.0, 10.2761860629321, -1.48323969741915, 0.302765035409766, -0.0611677741841213, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.41468916081805e-14, -1.06387139939102e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.65329983228432, 1.07906632212329e-14, 4.15220619990514, 2.93605316083771, 0.0, 0.0, 0.0, 2.63248931621765, 9.82591326180785, -2.82261277137741, 0.0, 0.0, 0.0, 0.0, 1.24131222965466e-14, 1.49900004882226e-14, 0.0, 11.6081867662439, -3.09487177319465, 0.683876505540215, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15581372597817e-14},
      {2.29782505861521, 0.0, 1.49829835452877, 5.50917601898535, 0.0, 0.0, 0.0, 0.0, 6.6480394532094, 4.13676892548486, 0.0, 0.0, 0.0, 0.0, -1.17293975629304e-14, 0.0, 0.0, 1.77288971805021e-14, 12.5636136423842, -3.55352656109507, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.11514820135553e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59891152423402e-14, 0.0},
      {1.87616630392937, 0.0, 0.0, 6.22830929985769, 0.0, 0.0, 0.0, 0.0, 0.0, 11.0541524195338, 0.0, 0.0, 0.0, 0.0, 2.21090682023547e-14, -2.20298115882095e-14, 0.0, 0.0, 0.0, 11.6057691494799, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.33025010156243e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.02243531748197e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.83186700722506, 0.0, -4.4108709245369, -3.11895674167862, 16.6749979177077, 0.0, 0.0, 2.13065307820924, 1.73967095350099, 1.23013312825383, 0.0, -4.36653943835009, -3.78153408023783, 1.41518305777056e-14, 0.0, 0.0, -0.557935943461964, -0.483186700722496, -0.394520289089678, -0.27896797173098, 23.6981011897578, 0.0, 0.0, 0.490653381462662, 0.43885372573626, 0.380058475033051, 0.0, 0.0, 0.0, 0.0, 0.0626933893908886, 0.0560746721671629, 0.0485620906056458, 0.0396507809422063, 0.0280373360835801, -1.53456478450664e-14, 0.0, -1.99429181619326e-14, 1.44789034491149e-14, 1.01988074810049e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 6.91050664139876, 0.0, 0.0, 0.0, 10.5706241650196, -2.725540575477, 0.0, 0.0, 0.0, 4.67332857821917, -1.05010595342034e-14, 0.0, -7.86705867811456, -2.39719223514615, 0.618094504365255, -1.47455891591556e-14, 1.12727459016504e-14, 0.0, 0.0, 0.0, 23.10555488766, -0.46968719442418, 0.0, 0.0, 0.0, 1.62065746295906, 0.790669146636832, 0.240926884676764, -0.0621208350290953, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.80757955956212e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23610364477168e-14, 6.30840061880561, 0.0, 1.32560721454874e-14, 0.0, -1.52362350055009, 11.1963004093827, 0.0, 0.0, 0.0, 4.26614580154031, 0.0, -2.16065093893094e-14, 0.132992762321608, -4.72217953828918, -6.67684597013018, 0.0, 1.9088487167099e-14, 0.0, 0.0, 0.0, 0.0, 23.1532444221696, 0.0, 0.0, 0.0, 0.0, 0.721778878560589, 1.11125127955291, 1.1908743922773, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.38981605247764e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.85449644663771, -1.18136914997961e-14, 5.98171817966649, -2.4880667576406, 1.90029237516522, 0.0, 0.0, -0.339934634239515, -2.35922146606162, 0.981306762925318, -1.26323072778345e-14, 9.9522670305624, -0.430945803685669, -1.49384636824453e-14, -1.23780151626501e-14, 0.0, -6.45364422706455, 0.0770899289327555, 0.535021138879219, -0.222539456105681, 0.0, 0.0, 0.0, 21.5273297444417, -1.00024047132728, 0.0433116829031369, 0.0, 0.0, 0.0, 0.0, 2.75066129615, 0.648615649442914, -0.00774782937530893, -0.0537716476536644, 0.0223660568773436, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.51865775274498, 0.0, 1.92724822331886, 2.72554057547702, 1.73472166622178, 2.21844751832061e-14, 0.0, -2.01705689521107, 3.42052627529741, -4.03112887414929, 0.0, 4.08831086321547, 5.37643791520788, -1.71481853656905e-14, 0.0, -1.06882166763076e-14, 0.365669640132034, -6.25148194071025, -2.03981013744549, 1.80803322065282, 0.0, 0.0, 0.0, 0.0, 22.1880978975596, -1.26521523890981, 0.0, 0.0, 1.14605390115538e-14, 0.0, 0.0, 1.98456380761453, 1.4711357857929, 0.363818136386359, -0.294009452979932, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.71815051937847e-14, 0.0, 0.0, 0.0, 0.0, -1.18769617990554e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.26320395116286e-14},
      {3.14718316987777, 0.0, -0.861891607371333, 6.09449400220043, 1.55158222708543, 0.0, 0.0, 0.0693888666488761, -3.05941170815568, 1.802775637732, -1.21553148106218e-14, 0.0, 9.03122156537878, 0.0, -1.07871246143559e-14, 0.0, 0.0, 0.403888506800963, -3.67461994579464, -5.49650682721193, 0.0, 0.0, 0.0, 0.0, 0.0, 21.7841260588564, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.974215733960555, 1.78974858569577, 1.80791908794931, 0.0, 0.0, -1.60686571624997e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.54523626091313, 0.0, 0.0, 0.0, 6.71778024562962, -0.60944940022004, 1.10275490459957e-14, 0.0, 0.0, 0.0, -1.6456712081289e-14, 0.0, 14.6593983227032, -1.52344936219871, 0.138210132827971, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.119501277094, -1.47332496632642, 0.153112421864223, -0.0138906409944096, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.39995279753084e-14, 1.41060126129512, 0.0, 0.0, 0.0, 3.63405410063597, 2.50356888118885, 0.0, 0.0, 0.0, 0.0, 0.0, -1.45045476356222e-14, 3.56857028479908, 11.263055412878, -1.49298814645065, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 19.3673596462205, -2.65048896124153, 0.26628760937957, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.26168012376112, 0.0, 0.0, 0.0, 1.42204860051345, 4.47852016375307, 0.0, 0.0, 0.0, 0.0, -1.06631060032885e-14, 0.0, 0.0, 8.27725128825318, 5.37909280973866, 0.0, 0.0, 0.0, -1.26802643034984e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 19.9654813226339, -2.61992366301005, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03547418869597e-14, 1.09264703862704, 0.0, 0.0, 0.0, 0.0, 5.38682254607084, 0.0, 0.0, 0.0, 1.43678447654116e-14, 0.0, -1.26850385459499e-14, 0.0, 0.0, 13.4377817958113, 0.0, 0.0, 0.0, -1.19741539833768e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.907670401189, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.16144232859832e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.52336024752224, 0.0, 7.37120708415867, -1.62882203585592, 0.0, 0.0, 0.0, 12.0171306297064, -2.90724328050879, 0.642416074439623, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.9858820944259, -2.72522906732403, 0.659300804656277, -0.145686271816944, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8043830863937, -1.40563403846548, 0.273895826790428, -0.0662622240310403, 0.0146420212340139, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.30350221379959, 0.0, 4.41588043316394, 1.78428514239953, 0.0, 0.0, 0.0, 4.26614580154032, 7.83741028656786, -2.63899331455874, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.23427840700304, 13.2221027072096, -4.67379217909109, 1.18363558466232, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.1258851598178, -3.11150358274814, 0.833612074594105, -0.192474367616153, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.16671184212998e-14, -1.05506262439036e-14, 1.20949219331451e-14, 0.0},
      {2.06031501455085, 0.0, 2.25696201807215, 3.98978286964827, 0.0, 0.0, 0.0, 0.953939201416944, 8.01142041980431, 1.18019368870418, 0.0, 0.0, -1.10987880183744e-14, 0.0, 0.0, 1.33508081524865e-14, -1.28916900933361e-14, 5.55254896421455, 9.62241374388481, -3.59830837050573, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.3932520322736, -4.68666192508058, 1.18356086726903, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.78428514239953, -1.30036122119359e-14, 0.814411017927983, 5.06770487035908, 0.0, 0.0, 0.0, 1.14120304309435e-14, 4.01510046524762, 6.58672305740272, 0.0, 0.0, 0.0, 0.0, 0.0, -1.94269048743982e-14, 1.98645161343897e-14, 0.0, 10.0159311874144, 2.83293314500742, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.0929454377398, -4.55552790213387, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.19426646424874e-14, 0.0, 0.0},
      {1.45686271816937, -1.0799768076155e-14, 0.0, 5.07816454066238, 0.0, 0.0, -1.21979263065773e-14, 0.0, 0.0, 10.0142755247554, -1.19130319852633e-14, 0.0, 0.0, 0.0, 1.61556546574893e-14, -1.95283513114671e-14, 0.0, 0.0, 1.35506876181836e-14, 13.8784813613723, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.5535587278944, 0.0, 0.0, 0.0, 0.0, 0.0, -1.229814494606e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580398915498, 5.6124860801609, -1.08012344973464, -0.76376261582597, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747791, 7.24568837309471, 4.1833001326704, -0.59160797830996, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.84724056670101e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513110646, 0.0, 9.66091783079298, 0.683130051063968, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.14713790139846e-14, 1.71237169977297e-14, 0.0, 0.0, -1.08954728919586e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847577, -1.67332005306815, -1.18321595661991, 7.74596669241484, -1.19999999999999, -0.979795897113259, 0.346410161513775, 0.282842712474621, 0.200000000000003, 0.0, -1.151409054946e-14, 0.0, -1.15969281804308e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.26922669423102e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772444, 2.44948974278317, 2.82842712474621, -0.99999999999999, 9.16515138991168, 7.09929573971954, -0.414039335605405, -2.04939015319191, -0.478091443733754, 0.169030850945706, 0.0, 0.0, 0.0, -1.33543246568772e-14, 1.09049726635857e-14, 0.0, 2.45272869424639e-14, 0.0, 0.0, 1.50613028992996e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0124611797498, 2.12132034355963, -0.40824829046386, 3.17542648054293, 0.0, 0.0, 7.17137165600636, 0.0, -1.38013111868471, -1.56144011671766, 0.0, 0.0, 0.0, 0.0, 0.0, -1.79811931838274e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, -5.69209978830308, 4.38178046004133, -0.774596669241488, 0.0, 10.998181667894, 0.962140470884725, 4.76235235991627, -0.740656079818041, 0.130930734141592, 0.0, 0.0, 0.0, 1.01063973293581e-14, 0.0, 0.0, 0.0, -1.30375612894406e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681198, 2.73861278752582, 1.5811388300842, 2.45967477524976, 0.0, 0.0, 9.25820099772552, 0.0, 5.3452248382485, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24531615432229e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613579, 0.0, 0.0, 3.83405790253616, 0.0, 0.0, 0.0, 0.0, 0.0, 5.18459255872629, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270665, 1.30114842892144e-14, -3.1622776601684, -2.23606797749979, 0.0, 0.0, 0.0, 13.7477270848675, 0.534522483824848, 0.377964473009225, 0.0, 0.0, 0.0, 1.43607271013995e-14, 0.0, 0.0, -2.43670412228116e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.16367050022963e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.8, 1.32427747618133e-14, 3.6514837167011, -2.8401877872188, 0.0, 0.0, 0.0, 1.59418229182701e-14, 12.3442679969674, 1.39659449751035, 0.0, 0.0, 0.0, 0.0, 1.03196509981685e-14, 2.65071218225995e-14, 0.0, -1.24384285458553e-14, -1.52262689000772e-14, -2.8799445467298e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.14359604727581e-14, -1.52773957190921e-14, -1.33794884893401e-14},
      {2.20454076850487, 0.0, 0.0, 6.64078308635358, 0.0, 0.0, 0.0, 0.0, 0.0, 8.97997772825745, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.21719387145091e-14, 0.0, -1.86951149006021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.10337086689505e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.56904651573302, 5.80288457473996, -2.01017818278146, -1.42141062443801, 8.14215222512714, -2.10229466468019, -1.71651640581398, 0.728256234341415, 0.594618725379071, 0.420458932936045, 9.81070843517429, -1.18450885369837, -1.02581475831037, 0.305838870920592, 0.26486423168198, 0.216260739578387, -0.105945692672791, -0.0917516612761676, -0.0749149177264296, -0.052972846336385, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239552, 3.07059789431495, 1.77281052085584, -1.25356634105601, 2.39356776939085, 6.30376871403132, -0.908295106229251, -2.78313372537744, -0.524404424085073, 0.370809924354785, 11.1242977306435, 9.40174755792012, -0.301561193523238, -2.42752078113806, -0.79420020665697, 0.114434427054266, 0.840917865872091, 0.350641890608831, 0.0660687472643452, -0.0467176592151053, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.02649122047608, 2.74642624930237, -0.79282496717209, 2.24244764232556, 2.14087209644419, -0.331662479035533, 6.49923072370878, 0.0957427107756358, -1.87616630392937, -2.15580611373101, 0.0, 0.0, 9.4403585933147, 0.0, -1.46249406456535, -2.04706526287666, 0.0, 0.422185670932512, 0.590936840285283, 0.522319308773346, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551269, 1.29756443747036, 3.74574588632198, -1.05945692672795, -8.09173593712688, 5.01426536422407, -0.383824736789376, 1.80936716113937, -1.1080065755349, 0.313391585263999, 0.0, 12.7134831207354, 1.01946290306867, 8.2065180664829, -0.631738055305792, 0.0483573714561624, -2.84282124887604, -0.227958835180082, 0.1395957071376, -0.0394836284566178, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.16906536108784e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715535, 1.160576914948, 1.34011878852098, 1.89521416591738, 2.53311402559511, 1.96214168703485, 2.74642624930238, -0.566421515598877, 3.17129986868838, -1.82198870938951, 0.0, 0.0, 11.169982923824, 0.0, 8.65223156827829, -0.865042958313569, 0.0, -2.49768411251822, -0.998865569685856, 0.441440386136652, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741913, 1.00508909139072, -0.193429485824663, 3.55615782880926, 0.0, 0.0, 4.45964044034302, 0.0, -0.858258202906993, 2.67027285925187, 0.0, 0.0, 1.02205127091632e-14, 0.0, 0.0, 8.42792824422442, 0.0, 0.0, -1.62195554683794, -2.29379153190449, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741915, 7.03562363973515, 4.062019202318, -0.820651806648287, 0.0, -6.79705818718656, -2.08116553882674, 5.88642506110459, -1.2015614840698, 0.24275207811381, 0.0, 0.0, 0.0, 14.8323969741913, 0.856348838577674, 0.262202212042538, 5.13809303146608, -0.741619848709572, 0.151382517704889, -0.0305838870920605, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.2372868034904e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32664991614217, -2.69693703815181, 2.07610309995256, 1.46802658041886, 0.0, 3.03973683071412, -6.38211787508102, 1.31624465810882, 4.91295663090393, -1.4113063856887, 0.0, 0.0, -2.2592738714644e-14, 0.0, 13.4039795085887, 2.01017818278149, 0.0, 5.80409338312193, -1.54743588659733, 0.341938252770107, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1489125293076, 1.29756443747034, 0.749149177264387, 2.75458800949267, 0.0, 0.0, 5.75737105184054, 0.0, 3.32401972660471, 2.06838446274243, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8804085776374, 0.0, 0.0, 6.28180682119208, -1.77676328054755, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.01213079341215e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.938083151964683, 0.0, 0.0, 3.11415464992885, 0.0, 0.0, 0.0, 0.0, 0.0, 5.52707620976692, 0.0, 0.0, 0.0, 0.0, 1.10545341011773e-14, -1.10149057941048e-14, 0.0, 0.0, 0.0, 5.80288457473997, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.4253953543107, 0.0, 9.38083151964688, 1.89521416591738, 0.0, 0.0, 0.0, -3.39852909359328, -2.77488738510233, -0.560611910581392, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.7988763690296, 0.42817441928883, 0.349602949390067, 0.0706304617818757, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.82970843102536, 0.0, -1.49829835452879, 4.23782770691181, 0.0, 0.0, 0.0, 3.79967103839267, -3.54562104171169, -4.07409060843205, 0.0, 0.0, 0.0, 0.0, 0.0, -1.52158320389315e-14, 0.0, 16.7549743857359, 1.11676565710083, 0.987090711415307, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.01936820004651e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15848226724032e-14, 0.0},
      {-1.32664991614217, 0.0, 1.73008591662712, -3.18072425757424, 0.0, 0.0, 0.0, 0.0, 7.6764947357874, -2.38836465270397, 0.0, 0.0, -1.79238954995876e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 14.5072114368499, 2.05162951662071, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.38270237873247e-14, 0.0},
      {1.62480768092719, 0.0, 0.0, 5.39387407630362, 0.0, 0.0, 0.0, 0.0, 0.0, 9.57317681262151, 0.0, 0.0, 0.0, 0.0, 1.84472351819205e-14, -1.99075298319087e-14, 0.0, 0.0, 0.0, 10.0508909139073, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.11796624108017e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.41593350361253, 5.72988941019467, -2.20543546226844, -1.5594783708393, 8.33749895885383, -2.76779953857106, -2.25989885993662, 1.06532653910461, 0.869835476750492, 0.615066564126914, 10.333118277332, -2.18326971917504, -1.89076704011892, 0.724780051083757, 0.627677936394704, 0.512496888990057, -0.278967971730972, -0.241593350361236, -0.197260144544829, -0.139483985865484, 11.8490505948789, -1.16109782023228, -1.03851746182648, 0.245326690731331, 0.219426862868129, 0.190029237516526, -0.0814411017927947, -0.0728431359084675, -0.0630840061880541, -0.0515078753637702, 0.0313466946954437, 0.0280373360835811, 0.0242810453028231, 0.0198253904711023, 0.0140186680417899, -1.34598912841459e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.18529407725404, 3.45525332069938, 0.997445717412069, -1.4106012612951, 3.23209352764251, 5.28531208250979, -1.3627702877385, -2.8908723349783, -0.393397896234722, 0.556348640264194, 2.33666428910958, 9.02784807228867, -0.732969916135166, -3.93352933905728, -1.19859611757308, 0.309047252182629, 1.64018416088946, 0.655588223176222, 0.0892142571199762, -0.126168012376104, 13.0996183150503, 11.55277744383, -0.23484359721209, -2.44096975264613, -0.907332870306509, 0.0736662483163258, 0.810328731479528, 0.395334573318415, 0.120463442338383, -0.0310604175145496, -0.311895674167861, -0.164844710568313, -0.0658890955530676, -0.0089663702065851, 0.012680362351407, 0.0, 0.0, 0.0, 1.11652798437369e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99489143482415, 3.1542003094028, -1.09264703862703, 1.54523626091315, 2.95048422176041, -0.761811750275038, 5.59815020469136, 0.263899331455871, -1.93925611658551, -2.28543525082517, 2.13307290077015, -0.257539376818854, 9.14446135479765, 0.0664963811608003, -2.36108976914459, -3.33842298506509, -0.0230350221379984, 0.817905488277902, 1.1564636454577, 1.02505848514082, 0.0, 0.0, 11.5766222110848, 0.0, -1.39771878815471, -2.15192884958005, 0.0, 0.360889439280297, 0.555625639776455, 0.595437196138648, 0.0, -0.125015768949706, -0.192474367616159, -0.206265495285701, -0.166687691932938, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.92724822331886, 1.82834820066014, 2.99085908983326, -1.2440333788203, 0.950146187582609, 5.74064456311311, -0.721110255092802, -0.169967317119738, -1.17961073303082, 0.490653381462658, -10.3037210107158, 4.97613351528119, -0.215472901842826, 5.7817446699566, -1.30185581821821, 0.16353243452862, -3.22682211353225, 0.0385449644663744, 0.267510569439616, -0.111269728052839, 0.0, 14.555131461167, 1.03556292536503, 10.7636648722209, -0.500120235663639, 0.0216558414515674, -3.57321383950879, -0.581087203147979, 0.130841432732454, -0.0164356280722681, 1.375330648075, 0.324307824721454, -0.00387391468765176, -0.0268858238268353, 0.0111830284386719, 0.0, 0.0, 0.0, -1.24814777259306e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.01558844222418e-14, 0.0, 0.0, 0.0, 0.0, 1.4259678156057e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.75932887637251, 1.66904592079257, 0.963624111659426, 1.36277028773851, 0.867360833110885, 2.28430636201793, 2.96226264871973, -1.00852844760553, 1.71026313764871, -2.01556443707464, 2.41867732448957, 2.04415543160773, 2.68821895760392, -0.52779866291175, 7.07977053255617, -1.76652739792482, 0.182834820066016, -3.12574097035512, -1.01990506872275, 0.904016610326407, 0.0, 0.0, 13.1266557397187, 0.0, 11.0940489487798, -0.632607619454898, 0.0, -2.8644711213756, -1.66605356688627, 0.315075748468086, 0.0, 0.992281903807264, 0.735567892896454, 0.181909068193181, -0.147004726489968, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.29943670433591e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.57359158493888, 1.49284005458434, -0.430945803685661, 3.04724700110022, 0.775791113542715, -0.12018504251546, 5.29905651979671, 0.0346944333244405, -1.52970585407784, 0.901387818866003, 0.0, 0.0, 4.51561078268939, 0.0, -0.699555414372428, 6.36462844462228, 0.0, 0.201944253400478, -1.83730997289731, -2.74825341360596, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8920630294282, 0.0, 0.0, -1.68739114875268, -3.0999354831996, 0.0, 0.0, 0.487107866980278, 0.894874292847886, 0.903959543974654, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.62882203585591, 0.772618130456559, 3.86595114186569, -1.05140010313426, 9.15442906076461, 3.35889012281481, -0.304724700110017, 3.87851223317103, -1.52475169285616, 0.414677792940103, -1.30025811259761e-14, -9.46260092820843, -2.07602937339136, 7.32969916135159, -0.761724681099364, 0.0691050664139826, 0.564240504518059, -0.879563899362192, 0.34578118203619, -0.0940400840863324, 0.0, 0.0, 0.0, 16.3745228938128, 0.951027176355642, 0.208648802584723, 9.05975063854701, -0.736662483163209, 0.0765562109321155, -0.00694532049720559, -3.48709964663733, -0.0567083043941599, 0.0883994979795876, -0.0347523163751415, 0.00945138406569528, 0.0, -1.00011135325188e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48690428533296, 0.705300630647561, 2.03602754481989, 1.15175110689978, -2.93221479395415, 1.81702705031799, 1.25178444059441, 0.65566316039121, 3.61359041872287, -1.70346285967312, 0.0, 2.7642026565595, -9.0878387586433, 1.78428514239954, 5.631527706439, -0.746494073225328, -0.61809450436525, 2.03210252328837, -2.15494277062552, 0.764033484562603, 0.0, 0.0, 0.0, 0.0, 15.0018922739643, 2.13860408462396, 0.0, 9.68367982311022, -1.32524448062075, 0.133143804689781, 0.0, -3.3545250915713, -0.478206411017786, 0.384353057392912, -0.12424167005819, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.36916607789467e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32992762321609, 0.630840061880566, 0.72843135908468, 2.57539376818855, 0.917928424547682, 0.711024300256724, 2.23926008187653, -0.205255035576784, 2.58567482211401, 0.761811750275059, 0.0, 0.0, 5.34294273196306, 0.0, 4.13862564412659, 2.68954640486934, 0.0, -1.19471831485579, 3.1056206816986, -2.32269806558126, 0.0, 0.0, 0.0, 0.0, 0.0, 12.8876627769294, 0.0, 0.0, 9.98274066131696, -1.30996183150503, 0.0, 0.0, -2.88176900403078, -1.51261363209512, 0.763985254692622, 0.0, 0.0, -1.17185759123372e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1517511068998, 0.546323519313516, -0.105140010313426, 3.2711894277325, 0.0, 0.0, 2.69341127303542, 0.0, -0.518347241175126, 4.25171145123353, 1.14902781575578e-14, 0.0, 0.0, 0.0, 0.0, 6.71889089790564, 0.0, 0.0, -1.29305115618719, 1.82865048192212, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.45383520059451, 0.0, 0.0, 0.0, -1.81939143264587, -2.94058061635795, 0.0, 0.0, 0.0, 0.0, 0.0, 1.05723279563221e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.26168012376111, -6.78263087840206, 3.68560354207933, -0.814411017927962, 0.0, 10.0216907612581, 2.67510569439611, 6.00856531485322, -1.4536216402544, 0.321208037219806, -1.65057976629295e-14, 0.0, 1.17706771112406e-14, -7.57008074256672, -2.27270584034422, -0.606656948415846, 6.99294104721295, -1.36261453366202, 0.329650402328128, -0.0728431359084687, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.7137404500718, 0.760821741084516, 0.228415531250646, 0.0609713174047718, 5.40219154319687, -0.702817019232743, 0.136947913395215, -0.0331311120155195, 0.00732101061700708, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.42496696880162e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1517511068998, 3.82426463519459, 2.20794021658197, 0.892142571199776, 0.0, -2.46306042692148, 6.78739640804926, 2.13307290077016, 3.91870514328393, -1.31949665727937, 0.0, 0.0, 0.0, 3.22490309931941, -7.63378455726036, -4.04762275910194, 1.11713920350153, 6.61105135360481, -2.33689608954555, 0.591817792331165, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.5022076529583, 1.79642743108413, 0.72192923349994, 0.0, 6.06294257990892, -1.55575179137407, 0.416806037297051, -0.0962371838080743, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03015750727543, -1.4659398322703, 1.12848100903607, 1.99489143482414, 0.0, 1.10151410945723, -5.20357020296094, 0.476969600708469, 4.00571020990215, 0.590096844352087, 0.0, 0.0, 0.0, 0.0, 6.41153127835568, -6.24994106094656, 0.0, 2.77627448210729, 4.81120687194239, -1.79915418525286, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.4651953323153, 3.04407621455179, 0.0, 0.0, 6.69662601613678, -2.34333096254029, 0.591780433634514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.892142571199772, 0.705300630647555, 0.407205508963985, 2.53385243517954, 0.0, 0.0, 3.47717900165117, 0.0, 2.00755023262381, 3.29336152870136, 0.0, 0.0, 0.0, 0.0, 0.0, 8.67405085085771, 0.0, 0.0, 5.0079655937072, 1.4164665725037, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.2048487632307, 0.0, 0.0, 0.0, 7.0464727188699, -2.27776395106694, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.728431359084687, 0.0, 0.0, 2.53908227033119, 0.0, 0.0, 0.0, 0.0, 0.0, 5.00713776237768, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.93924068068616, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.2767793639472, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.09901951359278, 0.0, -4.65474668125635, -3.29140294302194, 0.0, 0.0, 0.0, 13.490737563232, 1.83585684909538, 1.29814682728311, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -3.53270434653118, -3.05941170815567, -0.416333199893246, -0.294392028877619, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 21.8326971917504, 0.355050145839447, 0.307482445914322, 0.0418430609640578, 0.0295875121532877, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.61462585708151e-14, 0.0, 0.0, 0.0, 0.0, -1.16102518088945e-14},
      {-2.65985524643218, 0.0, 5.0990195135928, -2.06031501455083, 0.0, 0.0, 0.0, -1.23153021346074, 9.04986187739901, 3.04724700110021, 0.0, 0.0, 1.42882694523272e-14, 0.0, 0.0, 0.0, 3.86988371918332, -3.81689227863017, -5.39683034546924, -1.3667446468544, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 21.00264918355, 0.898213715542062, 0.962572311333254, 0.222250255910583, 0.0, 0.0, 0.0, 0.0, -1.12681836907137e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.18513103827981e-14, 0.0, 0.0, 1.05763921925961e-14},
      {2.97380857066589, 0.0, -0.814411017927952, 5.75875553449899, 0.0, 0.0, 0.0, 1.37689263682151, -2.89087233497831, 1.70346285967313, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 8.01441409794461, -3.47218947830365, -5.1937107658469, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 19.3314941653941, 1.69115345252878, 1.70832296330021, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.43661124663019e-14},
      {-1.03015750727544, 0.0, 0.940400840863422, -2.9258407710754, 0.0, 0.0, 0.0, 0.0, 4.63623866886821, -3.80284633026898, 0.0, 0.0, 0.0, 0.0, -1.17361870806384e-14, 0.0, 0.0, 0.0, 11.565401134477, -1.63559471386624, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.2731316843076, 2.63013526059784, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.01423919225742e-14, 0.0},
      {1.26168012376113, 0.0, 0.0, 4.39781949681095, 0.0, 0.0, -1.11014659841498e-14, 0.0, 0.0, 8.67261700493487, 0.0, 0.0, 0.0, 0.0, 1.40183636832794e-14, -1.61637203484436e-14, 0.0, 0.0, 1.165919317568e-14, 12.0191174248973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8717007662564, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06515764673489e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580398915498, 5.6124860801609, -1.08012344973464, -0.76376261582597, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267039, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.55391889677069e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971952, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24263211362714e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32287565553229, 0.0, 3.86436713231719, -0.341565025531985, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971955, 2.50998007960222, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912986, 0.0, 0.0, 8.87411967464941, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.96188551515597e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847577, -1.67332005306815, -1.18321595661991, 7.74596669241484, -1.19999999999999, -0.979795897113259, 0.346410161513775, 0.282842712474621, 0.200000000000003, 0.0, -1.151409054946e-14, 0.0, -1.15969281804308e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.26922669423102e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772444, 2.44948974278317, 2.8284271247462, -0.999999999999998, 1.30930734141595, 7.09929573971953, -0.414039335605412, -2.04939015319192, -0.478091443733755, 0.169030850945706, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.08716682344658e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0124611797498, 2.12132034355963, -0.408248290463859, 3.17542648054295, 9.07114735222146, 0.0, 7.17137165600637, 0.0, -1.3801311186847, -1.56144011671766, 0.0, -1.27114514413737e-14, 0.0, 0.0, 0.0, -1.89105350382163e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, 0.632455532033676, 4.38178046004134, -0.774596669241488, 0.0, 3.14233761939829, -0.106904496764969, 4.76235235991627, -0.740656079818045, 0.130930734141596, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.18031428662765e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 0.547722557505164, 1.58113883008419, 2.45967477524977, 0.0, 9.07114735222145, 1.8516401995451, 0.0, 5.34522483824849, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, -6.26099033699941, 0.0, 3.83405790253615, 0.0, 0.0, 10.5830052442584, 0.0, 0.0, 5.18459255872628, 0.0, 0.0, 0.0, 1.25836173653064e-14, 1.48358452126538e-14, -1.12491819922707e-14, -1.04421095586587e-14, 0.0, 0.0, -1.67296732023203e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03923048454133, 0.0, 3.16227766016838, -0.447213595499959, 0.0, 0.0, 0.0, 5.89188303637179, -0.534522483824848, 0.0755928946018435, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.900000000000011, 1.33719710960724e-14, 1.46059348668044, 1.42009389360938, 0.0, 0.0, 0.0, 9.07114735222146, 4.93770719878695, -0.698297248755181, 0.0, 0.0, 0.0, 1.32954362671572e-14, 0.0, 1.06165553601881e-14, 0.0, 1.44648983668665e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.73484692283496, 0.0, -6.26099033699942, 2.21359436211785, 0.0, 0.0, 0.0, 0.0, 10.5830052442584, 2.99332590941915, 0.0, 0.0, 0.0, 0.0, 0.0, 1.05984189380888e-14, -1.39797099343912e-14, 0.0, 0.0, -1.35759459229945e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.71576766497729, 0.0, 0.0, -4.69574275274956, 0.0, 0.0, 0.0, 0.0, 0.0, 12.69960629311, 1.04519457838932e-14, 0.0, 0.0, 0.0, 1.04165025265274e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.56904651573302, 5.80288457473996, -2.01017818278146, -1.42141062443801, 8.14215222512714, -2.10229466468019, -1.71651640581398, 0.728256234341415, 0.594618725379071, 0.420458932936045, 9.81070843517429, -1.18450885369837, -1.02581475831037, 0.305838870920592, 0.26486423168198, 0.216260739578387, -0.105945692672791, -0.0917516612761676, -0.0749149177264296, -0.052972846336385, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239552, 3.07059789431495, 1.77281052085584, -1.25356634105601, 2.39356776939084, 6.30376871403132, -0.908295106229243, -2.78313372537744, -0.524404424085076, 0.370809924354784, 1.23603308118261, 9.40174755792012, -0.301561193523221, -2.42752078113807, -0.794200206656967, 0.114434427054264, 0.840917865872095, 0.350641890608829, 0.0660687472643458, -0.0467176592151037, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.02649122047608, 2.74642624930237, -0.792824967172092, 2.24244764232556, 2.14087209644419, -0.33166247903552, 6.49923072370877, 0.0957427107756355, -1.87616630392937, -2.15580611373101, 11.0554159678513, 0.0, 9.44035859331468, 0.0, -1.46249406456536, -2.04706526287665, 0.0, 0.422185670932514, 0.590936840285282, 0.522319308773347, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551268, 1.29756443747035, 3.74574588632199, -1.05945692672795, 0.40458679685634, 5.01426536422407, -0.383824736789368, 1.80936716113937, -1.1080065755349, 0.313391585264003, 0.0, 2.82521847127454, -0.0509731451534303, 8.20651806648289, -0.631738055305789, 0.0483573714561688, -2.84282124887604, -0.22795883518008, 0.139595707137604, -0.039483628456614, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.16466485419836e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715535, 1.16057691494799, 1.34011878852098, 1.89521416591737, 0.361873432227873, 1.96214168703486, 2.74642624930238, -0.56642151559888, 3.17129986868837, -1.82198870938951, 0.0, 11.0554159678513, 1.59571184626057, 0.0, 8.65223156827828, -0.86504295831357, 0.0, -2.49768411251822, -0.998865569685855, 0.441440386136649, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741914, 1.00508909139073, -0.193429485824664, 3.55615782880925, -8.46157280212813, 0.0, 4.45964044034302, 0.0, -0.858258202906997, 2.67027285925186, 0.0, 1.44857443011911e-14, 12.4373429638328, 0.0, 0.0, 8.42792824422442, 0.0, 0.0, -1.62195554683794, -2.2937915319045, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741914, 0.335029697130249, 4.06201920231799, -0.820651806648291, 0.0, 1.69926454679664, -0.0991031208965121, 5.88642506110459, -1.2015614840698, 0.242752078113806, 0.0, 0.0, 0.0, 4.94413232473044, -0.214087209644419, 0.0124858196210728, 5.13809303146607, -0.741619848709577, 0.151382517704883, -0.0305838870920607, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32664991614217, 0.299659670905766, 2.07610309995257, 1.46802658041885, 0.0, 0.868496237346898, 0.709124208342333, 1.31624465810883, 4.91295663090393, -1.4113063856887, 0.0, 0.0, 0.0, 11.0554159678513, 3.82970843102536, -0.223353131420157, 0.0, 5.80409338312194, -1.54743588659732, 0.341938252770102, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1489125293076, 0.259512887494075, 0.749149177264382, 2.75458800949267, 0.0, -8.46157280212811, 1.15147421036811, 0.0, 3.32401972660471, 2.06838446274243, 0.0, 0.0, -1.1283446540405e-14, 0.0, 12.4373429638327, 2.17608171552749, -1.21040313496127e-14, 0.0, 6.28180682119209, -1.77676328054754, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.93808315196469, 7.62808987244124, 1.39628067270975e-14, 3.11415464992886, 0.0, 0.0, -7.52139804633611, 0.0, 0.0, 5.52707620976692, 0.0, 0.0, 0.0, 0.0, 0.0, 14.2141062443803, 1.0319833740378e-14, 1.68289931844567e-14, 0.0, 5.80288457473996, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.856348838577683, 0.0, 2.68023757704196, -0.473803541479344, 0.0, 0.0, 0.0, 5.09779364038993, -0.792824967172097, 0.140152977645348, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.91061171956871, -0.642261628933266, 0.0998865569685892, -0.0176576154454652, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.765941686205081, 0.0, 1.49829835452878, 0.847565541382356, 0.0, 0.0, 0.0, 1.62843044502544, 3.54562104171167, -0.814818121686411, 0.0, -1.00490360530146e-14, 0.0, 0.0, 0.0, 0.0, 11.0554159678513, 7.18070330817253, -1.11676565710082, 0.197418142283054, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.663324958071068, 0.0, 0.692034366650859, 1.5903621287871, 0.0, 0.0, 0.0, -8.46157280212811, 3.07059789431496, 1.19418232635199, 0.0, 0.0, 0.0, -1.73320255518822e-14, 0.0, 0.0, 1.38009491821402e-14, 12.4373429638327, 5.80288457473997, -1.02581475831036, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.541602560309052, -1.25890451024725e-14, 7.62808987244128, 1.79795802543454, 0.0, 0.0, 0.0, 0.0, -7.52139804633611, 3.1910589375405, 0.0, 0.0, 0.0, 0.0, 0.0, -1.97784641917273e-14, 2.38963933169705e-14, 0.0, 14.2141062443803, 3.35029697130245, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-5.36159180343549, 0.0, 0.0, 8.89943818451478, 0.0, 0.0, 0.0, 0.0, 0.0, -5.26497863243527, 0.0, 0.0, 0.0, 0.0, 1.69418316537184e-14, -1.83698225526999e-14, 0.0, -1.32206326378019e-14, 0.0, 16.583123951777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.41593350361253, 5.72988941019467, -2.20543546226844, -1.5594783708393, 8.33749895885383, -2.76779953857106, -2.25989885993662, 1.06532653910461, 0.869835476750492, 0.615066564126914, 10.333118277332, -2.18326971917504, -1.89076704011892, 0.724780051083757, 0.627677936394704, 0.512496888990057, -0.278967971730972, -0.241593350361236, -0.197260144544829, -0.139483985865484, 11.8490505948789, -1.16109782023228, -1.03851746182648, 0.245326690731331, 0.219426862868129, 0.190029237516526, -0.0814411017927947, -0.0728431359084675, -0.0630840061880541, -0.0515078753637702, 0.0313466946954437, 0.0280373360835811, 0.0242810453028231, 0.0198253904711023, 0.0140186680417899, -1.34598912841459e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.18529407725404, 3.45525332069938, 0.997445717412062, -1.41060126129509, 3.23209352764251, 5.2853120825098, -1.36277028773849, -2.89087233497829, -0.393397896234721, 0.55634864026419, 2.33666428910958, 9.02784807228867, -0.732969916135157, -3.93352933905729, -1.19859611757308, 0.309047252182623, 1.64018416088945, 0.65558822317622, 0.089214257119981, -0.126168012376099, 1.1908743922773, 11.55277744383, -0.234843597212088, -2.44096975264613, -0.907332870306512, 0.0736662483163217, 0.810328731479531, 0.395334573318417, 0.120463442338383, -0.031060417514548, -0.31189567416786, -0.164844710568315, -0.0658890955530668, -0.00896637020658499, 0.0126803623514091, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99489143482414, 3.15420030940281, -1.09264703862702, 1.54523626091315, 2.9504842217604, -0.761811750275046, 5.59815020469135, 0.263899331455871, -1.93925611658551, -2.28543525082517, 2.13307290077016, -0.257539376818845, 9.14446135479765, 0.0664963811608087, -2.3610897691446, -3.33842298506508, -0.0230350221379951, 0.817905488277904, 1.15646364545769, 1.02505848514081, 13.0453753561106, 0.0, 11.5766222110848, 0.0, -1.39771878815472, -2.15192884958005, 0.0, 0.360889439280295, 0.555625639776455, 0.595437196138646, 0.0, -0.125015768949705, -0.19247436761616, -0.206265495285702, -0.16668769193294, 0.0, 0.0, 0.0, 0.0, 0.0, 1.07688613330682e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.92724822331886, 1.82834820066013, 2.99085908983326, -1.2440333788203, 0.950146187582608, 5.7406445631131, -0.7211102550928, -0.169967317119744, -1.17961073303082, 0.490653381462661, 0.294392028877592, 4.9761335152812, -0.215472901842836, 5.78174466995659, -1.30185581821821, 0.163532434528625, -3.22682211353225, 0.0385449644663701, 0.267510569439614, -0.111269728052837, 0.0, 2.646387538394, -0.0295875121532846, 10.7636648722209, -0.50012023566364, 0.0216558414515689, -3.57321383950879, -0.581087203147979, 0.130841432732454, -0.0164356280722693, 1.37533064807501, 0.324307824721454, -0.00387391468765233, -0.0268858238268337, 0.011183028438673, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.54346718065853e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.75932887637249, 1.66904592079257, 0.963624111659428, 1.36277028773851, 0.867360833110891, 2.28430636201794, 2.96226264871972, -1.00852844760553, 1.71026313764871, -2.01556443707465, 0.268741924943287, 2.04415543160772, 2.68821895760394, -0.527798662911744, 7.07977053255618, -1.76652739792483, 0.182834820066012, -3.12574097035513, -1.01990506872274, 0.904016610326411, 0.0, 13.0453753561106, 1.45851730441319, 0.0, 11.0940489487798, -0.632607619454904, 0.0, -2.8644711213756, -1.66605356688627, 0.315075748468089, 0.0, 0.992281903807263, 0.735567892896453, 0.181909068193181, -0.147004726489966, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.5735915849389, 1.49284005458436, -0.430945803685668, 3.04724700110022, 0.775791113542717, -0.120185042515463, 5.29905651979672, 0.0346944333244382, -1.52970585407784, 0.901387818866001, -10.576283741361, 0.0, 4.51561078268938, 0.0, -0.699555414372441, 6.36462844462229, 0.0, 0.201944253400487, -1.83730997289732, -2.74825341360596, 0.0, 0.0, 14.3499128917217, 0.0, 0.0, 10.8920630294282, 0.0, 0.0, -1.68739114875268, -3.09993548319961, 0.0, 0.0, 0.487107866980278, 0.894874292847885, 0.903959543974654, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.62882203585591, 0.772618130456572, 3.86595114186568, -1.05140010313426, 0.160604018609907, 3.35889012281481, -0.304724700110022, 3.87851223317102, -1.52475169285616, 0.414677792940096, 0.0, 1.135512111385, -0.0364215679542345, 7.3296991613516, -0.761724681099359, 0.0691050664139833, 0.564240504518048, -0.879563899362189, 0.345781182036182, -0.0940400840863355, 0.0, 0.0, 0.0, 4.46577897103986, -0.114123261162676, 0.00366050530850576, 9.05975063854701, -0.73666248316321, 0.0765562109321156, -0.00694532049720655, -3.48709964663733, -0.0567083043941568, 0.0883994979795855, -0.0347523163751381, 0.0094513840656929, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48690428533296, 0.705300630647557, 2.0360275448199, 1.15175110689978, 0.146610739697702, 1.81702705031799, 1.25178444059442, 0.655663160391219, 3.61359041872287, -1.70346285967311, 0.0, 0.61426725701323, 0.454391937932152, 1.78428514239953, 5.63152770643899, -0.746494073225317, -0.618094504365244, 2.03210252328836, -2.15494277062552, 0.764033484562593, 0.0, 0.0, 0.0, 13.0453753561106, 3.33375383865872, -0.106930204231199, 0.0, 9.68367982311022, -1.32524448062076, 0.13314380468978, 0.0, -3.3545250915713, -0.478206411017787, 0.384353057392906, -0.124241670058192, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32992762321609, 0.630840061880567, 0.728431359084683, 2.57539376818856, 0.13113263207824, 0.711024300256729, 2.23926008187654, -0.205255035576787, 2.58567482211401, 0.761811750275046, 0.0, -10.576283741361, 0.763277533137582, 0.0, 4.13862564412659, 2.68954640486934, 0.0, -1.19471831485577, 3.1056206816986, -2.32269806558126, 0.0, 0.0, 0.0, 0.0, 14.3499128917217, 1.84109468241849, 0.0, 0.0, 9.98274066131697, -1.30996183150503, 0.0, 0.0, -2.88176900403078, -1.51261363209512, 0.763985254692617, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.15175110689978, 0.546323519313518, -0.105140010313426, 3.27118942773249, 9.65295620481434, 0.0, 2.69341127303541, 0.0, -0.518347241175123, 4.25171145123354, 1.18152069786956e-14, -1.38297717451513e-14, -9.91526600752601, 0.0, 0.0, 6.71889089790564, 0.0, 0.0, -1.29305115618718, 1.82865048192213, 0.0, 0.0, 0.0, 0.0, 0.0, 15.9443476574685, 0.0, 0.0, 0.0, 9.45383520059451, 0.0, 0.0, 0.0, -1.81939143264587, -2.94058061635794, 0.0, 0.0, -1.72754963278994e-14, 0.0, 1.13755232036152e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.26168012376112, 0.199489143482416, 3.68560354207934, -0.814411017927958, 0.0, 1.02786571910339, -0.0786795792469428, 6.00856531485323, -1.4536216402544, 0.321208037219811, 0.0, 0.0, 0.0, 3.0280322970267, -0.233098034907103, 0.0178428514239945, 6.99294104721297, -1.36261453366202, 0.32965040232814, -0.0728431359084713, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.80499652729883, -0.304328696433804, 0.0234272339744254, -0.00179327404131563, 5.40219154319688, -0.702817019232742, 0.136947913395215, -0.0331311120155212, 0.00732101061700645, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.15175110689979, 0.182107839771176, 2.20794021658197, 0.892142571199767, 0.0, 0.615765106730374, 0.323209352764248, 2.13307290077016, 3.91870514328393, -1.31949665727937, 0.0, 0.0, 0.0, 1.07496769977314, 1.90844613931509, -0.19274394090962, 1.11713920350151, 6.6110513536048, -2.33689608954555, 0.591817792331162, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.0453753561106, 5.83406921765277, -0.449106857771024, 0.0343775825476163, 0.0, 6.06294257990892, -1.55575179137407, 0.416806037297052, -0.0962371838080749, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03015750727543, 0.162882203585601, 1.12848100903607, 1.99489143482413, 0.0, 0.314718316987777, 0.578174466995654, 0.476969600708466, 4.00571020990215, 0.590096844352083, 0.0, 0.0, -1.31549551242914e-14, -10.576283741361, 1.83186607953019, 0.694437895660746, -1.8047208927113e-14, 2.77627448210728, 4.81120687194239, -1.79915418525287, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.3499128917217, 4.41862723780437, -0.33823069050576, 0.0, 0.0, 6.69662601613678, -2.34333096254029, 0.591780433634515, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.892142571199766, 0.141060126129502, 0.407205508963996, 2.53385243517955, 0.0, 9.65295620481434, 0.695435800330227, 0.0, 2.00755023262381, 3.29336152870135, 0.0, 0.0, 1.11713603382673e-14, 0.0, -9.91526600752598, 1.73481017017153, 1.64166602797602e-14, 0.0, 5.0079655937072, 1.41646657250371, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.9443476574685, 2.44096975264614, 0.0, 0.0, 0.0, 7.0464727188699, -2.27776395106693, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.728431359084693, -7.94708263760857, -1.34962358184755e-14, 2.53908227033119, 0.0, 0.0, 10.2207771580387, 0.0, 0.0, 5.00713776237768, 0.0, 0.0, 0.0, 0.0, 0.0, -8.49879943502226, -1.3318970311563e-14, 0.0, 0.0, 6.93924068068617, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.9373911146521, 0.0, 0.0, 0.0, 0.0, 6.27677936394721, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.728431359084677, 0.0, 2.32737334062816, -0.470200420431705, 0.0, 0.0, 0.0, 4.49691252107735, -0.917928424547683, 0.185449546754728, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.06540869306229, -1.01980390271856, 0.208166599946613, -0.0420560041253752, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.92395326897747, -0.710100291678877, 0.102494148638108, -0.0209215304820305, 0.00422678745046826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.664963811608031, -1.52728632141123e-14, 1.45686271816937, 0.515078753637711, 0.0, 0.0, 0.0, 1.84729532019112, 2.58567482211399, -0.761811750275054, 0.0, 0.0, 0.0, -1.45770491081465e-14, 0.0, 0.0, 1.71994831963703, 5.72533841794525, -1.54195152727693, 0.34168616171361, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.0453753561106, 9.33451074824443, -1.3473205733131, 0.275020660380933, -0.0555625639776416, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.08465016007527e-14, 0.0, 0.0, 0.0, 0.0},
      {0.594761714133172, 0.0, 0.81441101792795, 1.15175110689982, 0.0, 0.0, 0.0, 0.590096844352069, 2.89087233497829, 0.340692571934627, 0.0, 0.0, 0.0, 0.0, -1.12582268745145e-14, -1.00859362139179e-14, -10.576283741361, 3.43474889911913, 3.47218947830365, -1.03874215316937, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.3499128917217, 8.28492607088319, -1.69115345252877, 0.341664592660044, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.03389519168218e-14},
      {0.515078753637708, 0.0, 0.376160336345357, 1.4629203855377, 0.0, 0.0, 0.0, 9.65295620481433, 1.85449546754729, 1.90142316513449, 0.0, 0.0, 0.0, 0.0, -1.08799737057301e-14, 0.0, 0.0, -9.91526600752598, 4.62616045379077, 0.81779735693313, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.9443476574685, 6.50925267372303, -1.31506763029892, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.420560041253713, 0.0, -7.94708263760858, 1.46593983227031, 0.0, 0.0, 0.0, 0.0, 10.2207771580387, 2.89087233497829, 0.0, 0.0, 1.39515011653448e-14, 0.0, 0.0, 0.0, -2.25920784148809e-14, 0.0, -8.49879943502226, 4.00637247496575, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.9373911146521, 3.62390025541881, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06444352251245e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.542378855465, 0.0, 0.0, -6.91050664139873, 0.0, 0.0, 0.0, 0.0, 0.0, 12.2649325896465, -1.24221302592312e-14, 0.0, 0.0, 0.0, -1.26085093097862e-14, 0.0, 1.00262554257505e-14, 0.0, 1.9958678525973e-14, -5.66586629001481, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.34034011235354e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 20.4998755596024, 0.0, 0.0, 0.0, 0.0, 0.0, -1.13399729500939e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.18880599808691e-14}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[56][56] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[56][56] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 56; t++)
        {
          for (unsigned int u = 0; u < 56; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 56; s++)
        {
          for (unsigned int t = 0; t < 56; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.00945067404923495, 0.0, 0.0, -0.0074683487343743, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0109364720199429, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00563672438672438, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00623163327913697, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0182390373864041};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 1.2910299999197e-14, 0.0, 0.0, 0.0, 1.13791354811044e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.82459407806732e-14, 0.0, 0.0, 1.14502076617531e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0075685218886e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495583, 0.0, 8.36660026534078, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.80145229452567e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15685944010291e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.27459512282647e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.09631768083421e-14, 0.0, 0.0, 1.1552363868434e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.499090833947, 0.0, -3.34664010613631, -2.36643191323983, 15.4919333848297, 1.40047939984465e-14, 0.0, 0.692820323027552, 0.565685424949243, 0.400000000000003, 0.0, -2.49005609448537e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.57593122579458e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.43663518857582e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.89897948556634, 0.0, 0.0, 0.0, 14.1985914794391, -0.82807867121082, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06536050760624e-14, 0.0, 0.0, 1.39367297957671e-14, 0.0, 0.0, 1.05249092186598e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.54267715844228e-14, 4.24264068711926, 0.0, 0.0, 0.0, 0.0, 14.3427433120127, 0.0, 0.0, 0.0, 0.0, 0.0, 1.05353075839509e-14, 0.0, 0.0, -3.24774929172378e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15085846777474e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.6, 0.0, 8.76356092008268, -1.54919333848298, 0.0, 0.0, 0.0, 9.52470471983254, -1.48131215963609, 0.261861468283191, 0.0, 0.0, 0.0, 1.2116276143714e-14, 0.0, 0.0, 2.02795020253393e-14, -1.24841587070845e-14, 0.0, -1.13301837530166e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.11769145362398, 0.0, 3.16227766016839, 4.91934955049953, 0.0, 0.0, 0.0, 0.0, 10.690449676497, -2.41897262725906, 0.0, 0.0, 0.0, 0.0, 0.0, 1.51412862395202e-14, 0.0, 0.0, 0.0, -1.52542908860021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.01325198231805e-14},
      {2.54558441227158, 0.0, 0.0, 7.66811580507232, 0.0, 0.0, 0.0, 0.0, 0.0, 10.3691851174526, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.45807581273514e-14, 0.0, -1.39332989590457e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0099560077137e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.6057691494799, 1.13965640310271e-14, 1.12317278033983e-14, 0.0, -4.20458932936039, -3.43303281162797, 0.0, 0.0, 0.0, 19.6214168703486, 0.0, -2.36962160732751e-14, 0.611677741841193, 0.529728463363953, 0.43252147915678, 0.0, 1.5150275997887e-14, 1.06682783267142e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.08329718200539e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.53137212479104, 0.0, 3.54562104171167, -2.50713268211202, 4.78713553878169, 2.10513249875174e-14, 0.0, -5.56626745075489, -1.04880884817015, 0.741619848709568, 0.0, 18.8034951158402, -0.603122387046446, -2.28847070207928e-14, 0.0, 0.0, 1.68183573174417, 0.701283781217659, 0.132137494528686, -0.0934353184302173, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.44061292815194e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.05298244095219, 0.0, -1.58564993434419, 4.48489528465111, 4.28174419288837, 1.20835277214061e-14, 1.11961712189777e-14, 0.191485421551267, -3.75233260785875, -4.31161222746203, 0.0, 0.0, 18.8807171866294, 0.0, 0.0, 0.0, 0.0, 0.844371341865031, 1.18187368057056, 1.04463861754668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.2134084668507e-14, 2.59512887494071, 1.30243580677425e-14, 0.0, 0.0, 10.0285307284481, -0.767649473578736, 1.32152493598616e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 16.4130361329658, -1.26347611061158, 0.0967147429123368, 2.54129405369957e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.23815712294068e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.32115382989598, 0.0, 0.0, 0.0, 3.9242833740697, 5.49285249860477, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06108914491809e-14, 17.3044631365566, -1.73008591662715, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.29781861460725e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.01017818278145, 0.0, 0.0, 0.0, 0.0, 8.91928088068603, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.8558564884488, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.96647939483828, 0.0, 8.12403840463597, -1.64130361329658, 0.0, 0.0, 0.0, 11.7728501222092, -2.40312296813959, 0.485504156227614, 0.0, 0.0, 0.0, 1.23564094401707e-14, 0.0, 0.0, 10.2761860629321, -1.48323969741915, 0.302765035409766, -0.0611677741841213, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.41468916081805e-14, -1.06387139939102e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.65329983228432, 1.07906632212329e-14, 4.15220619990514, 2.93605316083771, 0.0, 0.0, 0.0, 2.63248931621765, 9.82591326180785, -2.82261277137741, 0.0, 0.0, 0.0, 0.0, 1.24131222965466e-14, 1.49900004882226e-14, 0.0, 11.6081867662439, -3.09487177319465, 0.683876505540215, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15581372597817e-14},
      {2.29782505861521, 0.0, 1.49829835452877, 5.50917601898535, 0.0, 0.0, 0.0, 0.0, 6.6480394532094, 4.13676892548486, 0.0, 0.0, 0.0, 0.0, -1.17293975629304e-14, 0.0, 0.0, 1.77288971805021e-14, 12.5636136423842, -3.55352656109507, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.11514820135553e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59891152423402e-14, 0.0},
      {1.87616630392937, 0.0, 0.0, 6.22830929985769, 0.0, 0.0, 0.0, 0.0, 0.0, 11.0541524195338, 0.0, 0.0, 0.0, 0.0, 2.21090682023547e-14, -2.20298115882095e-14, 0.0, 0.0, 0.0, 11.6057691494799, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.33025010156243e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.02243531748197e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.83186700722506, 0.0, -4.4108709245369, -3.11895674167862, 16.6749979177077, 0.0, 0.0, 2.13065307820924, 1.73967095350099, 1.23013312825383, 0.0, -4.36653943835009, -3.78153408023783, 1.41518305777056e-14, 0.0, 0.0, -0.557935943461964, -0.483186700722496, -0.394520289089678, -0.27896797173098, 23.6981011897578, 0.0, 0.0, 0.490653381462662, 0.43885372573626, 0.380058475033051, 0.0, 0.0, 0.0, 0.0, 0.0626933893908886, 0.0560746721671629, 0.0485620906056458, 0.0396507809422063, 0.0280373360835801, -1.53456478450664e-14, 0.0, -1.99429181619326e-14, 1.44789034491149e-14, 1.01988074810049e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 6.91050664139876, 0.0, 0.0, 0.0, 10.5706241650196, -2.725540575477, 0.0, 0.0, 0.0, 4.67332857821917, -1.05010595342034e-14, 0.0, -7.86705867811456, -2.39719223514615, 0.618094504365255, -1.47455891591556e-14, 1.12727459016504e-14, 0.0, 0.0, 0.0, 23.10555488766, -0.46968719442418, 0.0, 0.0, 0.0, 1.62065746295906, 0.790669146636832, 0.240926884676764, -0.0621208350290953, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.80757955956212e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23610364477168e-14, 6.30840061880561, 0.0, 1.32560721454874e-14, 0.0, -1.52362350055009, 11.1963004093827, 0.0, 0.0, 0.0, 4.26614580154031, 0.0, -2.16065093893094e-14, 0.132992762321608, -4.72217953828918, -6.67684597013018, 0.0, 1.9088487167099e-14, 0.0, 0.0, 0.0, 0.0, 23.1532444221696, 0.0, 0.0, 0.0, 0.0, 0.721778878560589, 1.11125127955291, 1.1908743922773, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.38981605247764e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.85449644663771, -1.18136914997961e-14, 5.98171817966649, -2.4880667576406, 1.90029237516522, 0.0, 0.0, -0.339934634239515, -2.35922146606162, 0.981306762925318, -1.26323072778345e-14, 9.9522670305624, -0.430945803685669, -1.49384636824453e-14, -1.23780151626501e-14, 0.0, -6.45364422706455, 0.0770899289327555, 0.535021138879219, -0.222539456105681, 0.0, 0.0, 0.0, 21.5273297444417, -1.00024047132728, 0.0433116829031369, 0.0, 0.0, 0.0, 0.0, 2.75066129615, 0.648615649442914, -0.00774782937530893, -0.0537716476536644, 0.0223660568773436, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.51865775274498, 0.0, 1.92724822331886, 2.72554057547702, 1.73472166622178, 2.21844751832061e-14, 0.0, -2.01705689521107, 3.42052627529741, -4.03112887414929, 0.0, 4.08831086321547, 5.37643791520788, -1.71481853656905e-14, 0.0, -1.06882166763076e-14, 0.365669640132034, -6.25148194071025, -2.03981013744549, 1.80803322065282, 0.0, 0.0, 0.0, 0.0, 22.1880978975596, -1.26521523890981, 0.0, 0.0, 1.14605390115538e-14, 0.0, 0.0, 1.98456380761453, 1.4711357857929, 0.363818136386359, -0.294009452979932, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.71815051937847e-14, 0.0, 0.0, 0.0, 0.0, -1.18769617990554e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.26320395116286e-14},
      {3.14718316987777, 0.0, -0.861891607371333, 6.09449400220043, 1.55158222708543, 0.0, 0.0, 0.0693888666488761, -3.05941170815568, 1.802775637732, -1.21553148106218e-14, 0.0, 9.03122156537878, 0.0, -1.07871246143559e-14, 0.0, 0.0, 0.403888506800963, -3.67461994579464, -5.49650682721193, 0.0, 0.0, 0.0, 0.0, 0.0, 21.7841260588564, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.974215733960555, 1.78974858569577, 1.80791908794931, 0.0, 0.0, -1.60686571624997e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.54523626091313, 0.0, 0.0, 0.0, 6.71778024562962, -0.60944940022004, 1.10275490459957e-14, 0.0, 0.0, 0.0, -1.6456712081289e-14, 0.0, 14.6593983227032, -1.52344936219871, 0.138210132827971, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.119501277094, -1.47332496632642, 0.153112421864223, -0.0138906409944096, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.39995279753084e-14, 1.41060126129512, 0.0, 0.0, 0.0, 3.63405410063597, 2.50356888118885, 0.0, 0.0, 0.0, 0.0, 0.0, -1.45045476356222e-14, 3.56857028479908, 11.263055412878, -1.49298814645065, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 19.3673596462205, -2.65048896124153, 0.26628760937957, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.26168012376112, 0.0, 0.0, 0.0, 1.42204860051345, 4.47852016375307, 0.0, 0.0, 0.0, 0.0, -1.06631060032885e-14, 0.0, 0.0, 8.27725128825318, 5.37909280973866, 0.0, 0.0, 0.0, -1.26802643034984e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 19.9654813226339, -2.61992366301005, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03547418869597e-14, 1.09264703862704, 0.0, 0.0, 0.0, 0.0, 5.38682254607084, 0.0, 0.0, 0.0, 1.43678447654116e-14, 0.0, -1.26850385459499e-14, 0.0, 0.0, 13.4377817958113, 0.0, 0.0, 0.0, -1.19741539833768e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.907670401189, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.16144232859832e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.52336024752224, 0.0, 7.37120708415867, -1.62882203585592, 0.0, 0.0, 0.0, 12.0171306297064, -2.90724328050879, 0.642416074439623, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.9858820944259, -2.72522906732403, 0.659300804656277, -0.145686271816944, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8043830863937, -1.40563403846548, 0.273895826790428, -0.0662622240310403, 0.0146420212340139, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.30350221379959, 0.0, 4.41588043316394, 1.78428514239953, 0.0, 0.0, 0.0, 4.26614580154032, 7.83741028656786, -2.63899331455874, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.23427840700304, 13.2221027072096, -4.67379217909109, 1.18363558466232, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.1258851598178, -3.11150358274814, 0.833612074594105, -0.192474367616153, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.16671184212998e-14, -1.05506262439036e-14, 1.20949219331451e-14, 0.0},
      {2.06031501455085, 0.0, 2.25696201807215, 3.98978286964827, 0.0, 0.0, 0.0, 0.953939201416944, 8.01142041980431, 1.18019368870418, 0.0, 0.0, -1.10987880183744e-14, 0.0, 0.0, 1.33508081524865e-14, -1.28916900933361e-14, 5.55254896421455, 9.62241374388481, -3.59830837050573, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.3932520322736, -4.68666192508058, 1.18356086726903, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.78428514239953, -1.30036122119359e-14, 0.814411017927983, 5.06770487035908, 0.0, 0.0, 0.0, 1.14120304309435e-14, 4.01510046524762, 6.58672305740272, 0.0, 0.0, 0.0, 0.0, 0.0, -1.94269048743982e-14, 1.98645161343897e-14, 0.0, 10.0159311874144, 2.83293314500742, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.0929454377398, -4.55552790213387, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.19426646424874e-14, 0.0, 0.0},
      {1.45686271816937, -1.0799768076155e-14, 0.0, 5.07816454066238, 0.0, 0.0, -1.21979263065773e-14, 0.0, 0.0, 10.0142755247554, -1.19130319852633e-14, 0.0, 0.0, 0.0, 1.61556546574893e-14, -1.95283513114671e-14, 0.0, 0.0, 1.35506876181836e-14, 13.8784813613723, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.5535587278944, 0.0, 0.0, 0.0, 0.0, 0.0, -1.229814494606e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580398915498, 5.6124860801609, -1.08012344973464, -0.76376261582597, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747791, 7.24568837309471, 4.1833001326704, -0.59160797830996, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.84724056670101e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513110646, 0.0, 9.66091783079298, 0.683130051063968, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.14713790139846e-14, 1.71237169977297e-14, 0.0, 0.0, -1.08954728919586e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847577, -1.67332005306815, -1.18321595661991, 7.74596669241484, -1.19999999999999, -0.979795897113259, 0.346410161513775, 0.282842712474621, 0.200000000000003, 0.0, -1.151409054946e-14, 0.0, -1.15969281804308e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.26922669423102e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772444, 2.44948974278317, 2.82842712474621, -0.99999999999999, 9.16515138991168, 7.09929573971954, -0.414039335605405, -2.04939015319191, -0.478091443733754, 0.169030850945706, 0.0, 0.0, 0.0, -1.33543246568772e-14, 1.09049726635857e-14, 0.0, 2.45272869424639e-14, 0.0, 0.0, 1.50613028992996e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0124611797498, 2.12132034355963, -0.40824829046386, 3.17542648054293, 0.0, 0.0, 7.17137165600636, 0.0, -1.38013111868471, -1.56144011671766, 0.0, 0.0, 0.0, 0.0, 0.0, -1.79811931838274e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, -5.69209978830308, 4.38178046004133, -0.774596669241488, 0.0, 10.998181667894, 0.962140470884725, 4.76235235991627, -0.740656079818041, 0.130930734141592, 0.0, 0.0, 0.0, 1.01063973293581e-14, 0.0, 0.0, 0.0, -1.30375612894406e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681198, 2.73861278752582, 1.5811388300842, 2.45967477524976, 0.0, 0.0, 9.25820099772552, 0.0, 5.3452248382485, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24531615432229e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613579, 0.0, 0.0, 3.83405790253616, 0.0, 0.0, 0.0, 0.0, 0.0, 5.18459255872629, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270665, 1.30114842892144e-14, -3.1622776601684, -2.23606797749979, 0.0, 0.0, 0.0, 13.7477270848675, 0.534522483824848, 0.377964473009225, 0.0, 0.0, 0.0, 1.43607271013995e-14, 0.0, 0.0, -2.43670412228116e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.16367050022963e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.8, 1.32427747618133e-14, 3.6514837167011, -2.8401877872188, 0.0, 0.0, 0.0, 1.59418229182701e-14, 12.3442679969674, 1.39659449751035, 0.0, 0.0, 0.0, 0.0, 1.03196509981685e-14, 2.65071218225995e-14, 0.0, -1.24384285458553e-14, -1.52262689000772e-14, -2.8799445467298e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.14359604727581e-14, -1.52773957190921e-14, -1.33794884893401e-14},
      {2.20454076850487, 0.0, 0.0, 6.64078308635358, 0.0, 0.0, 0.0, 0.0, 0.0, 8.97997772825745, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.21719387145091e-14, 0.0, -1.86951149006021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.10337086689505e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.56904651573302, 5.80288457473996, -2.01017818278146, -1.42141062443801, 8.14215222512714, -2.10229466468019, -1.71651640581398, 0.728256234341415, 0.594618725379071, 0.420458932936045, 9.81070843517429, -1.18450885369837, -1.02581475831037, 0.305838870920592, 0.26486423168198, 0.216260739578387, -0.105945692672791, -0.0917516612761676, -0.0749149177264296, -0.052972846336385, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239552, 3.07059789431495, 1.77281052085584, -1.25356634105601, 2.39356776939085, 6.30376871403132, -0.908295106229251, -2.78313372537744, -0.524404424085073, 0.370809924354785, 11.1242977306435, 9.40174755792012, -0.301561193523238, -2.42752078113806, -0.79420020665697, 0.114434427054266, 0.840917865872091, 0.350641890608831, 0.0660687472643452, -0.0467176592151053, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.02649122047608, 2.74642624930237, -0.79282496717209, 2.24244764232556, 2.14087209644419, -0.331662479035533, 6.49923072370878, 0.0957427107756358, -1.87616630392937, -2.15580611373101, 0.0, 0.0, 9.4403585933147, 0.0, -1.46249406456535, -2.04706526287666, 0.0, 0.422185670932512, 0.590936840285283, 0.522319308773346, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551269, 1.29756443747036, 3.74574588632198, -1.05945692672795, -8.09173593712688, 5.01426536422407, -0.383824736789376, 1.80936716113937, -1.1080065755349, 0.313391585263999, 0.0, 12.7134831207354, 1.01946290306867, 8.2065180664829, -0.631738055305792, 0.0483573714561624, -2.84282124887604, -0.227958835180082, 0.1395957071376, -0.0394836284566178, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.16906536108784e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715535, 1.160576914948, 1.34011878852098, 1.89521416591738, 2.53311402559511, 1.96214168703485, 2.74642624930238, -0.566421515598877, 3.17129986868838, -1.82198870938951, 0.0, 0.0, 11.169982923824, 0.0, 8.65223156827829, -0.865042958313569, 0.0, -2.49768411251822, -0.998865569685856, 0.441440386136652, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741913, 1.00508909139072, -0.193429485824663, 3.55615782880926, 0.0, 0.0, 4.45964044034302, 0.0, -0.858258202906993, 2.67027285925187, 0.0, 0.0, 1.02205127091632e-14, 0.0, 0.0, 8.42792824422442, 0.0, 0.0, -1.62195554683794, -2.29379153190449, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741915, 7.03562363973515, 4.062019202318, -0.820651806648287, 0.0, -6.79705818718656, -2.08116553882674, 5.88642506110459, -1.2015614840698, 0.24275207811381, 0.0, 0.0, 0.0, 14.8323969741913, 0.856348838577674, 0.262202212042538, 5.13809303146608, -0.741619848709572, 0.151382517704889, -0.0305838870920605, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.2372868034904e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32664991614217, -2.69693703815181, 2.07610309995256, 1.46802658041886, 0.0, 3.03973683071412, -6.38211787508102, 1.31624465810882, 4.91295663090393, -1.4113063856887, 0.0, 0.0, -2.2592738714644e-14, 0.0, 13.4039795085887, 2.01017818278149, 0.0, 5.80409338312193, -1.54743588659733, 0.341938252770107, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1489125293076, 1.29756443747034, 0.749149177264387, 2.75458800949267, 0.0, 0.0, 5.75737105184054, 0.0, 3.32401972660471, 2.06838446274243, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8804085776374, 0.0, 0.0, 6.28180682119208, -1.77676328054755, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.01213079341215e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.938083151964683, 0.0, 0.0, 3.11415464992885, 0.0, 0.0, 0.0, 0.0, 0.0, 5.52707620976692, 0.0, 0.0, 0.0, 0.0, 1.10545341011773e-14, -1.10149057941048e-14, 0.0, 0.0, 0.0, 5.80288457473997, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.4253953543107, 0.0, 9.38083151964688, 1.89521416591738, 0.0, 0.0, 0.0, -3.39852909359328, -2.77488738510233, -0.560611910581392, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.7988763690296, 0.42817441928883, 0.349602949390067, 0.0706304617818757, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.82970843102536, 0.0, -1.49829835452879, 4.23782770691181, 0.0, 0.0, 0.0, 3.79967103839267, -3.54562104171169, -4.07409060843205, 0.0, 0.0, 0.0, 0.0, 0.0, -1.52158320389315e-14, 0.0, 16.7549743857359, 1.11676565710083, 0.987090711415307, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.01936820004651e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15848226724032e-14, 0.0},
      {-1.32664991614217, 0.0, 1.73008591662712, -3.18072425757424, 0.0, 0.0, 0.0, 0.0, 7.6764947357874, -2.38836465270397, 0.0, 0.0, -1.79238954995876e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 14.5072114368499, 2.05162951662071, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.38270237873247e-14, 0.0},
      {1.62480768092719, 0.0, 0.0, 5.39387407630362, 0.0, 0.0, 0.0, 0.0, 0.0, 9.57317681262151, 0.0, 0.0, 0.0, 0.0, 1.84472351819205e-14, -1.99075298319087e-14, 0.0, 0.0, 0.0, 10.0508909139073, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.11796624108017e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.41593350361253, 5.72988941019467, -2.20543546226844, -1.5594783708393, 8.33749895885383, -2.76779953857106, -2.25989885993662, 1.06532653910461, 0.869835476750492, 0.615066564126914, 10.333118277332, -2.18326971917504, -1.89076704011892, 0.724780051083757, 0.627677936394704, 0.512496888990057, -0.278967971730972, -0.241593350361236, -0.197260144544829, -0.139483985865484, 11.8490505948789, -1.16109782023228, -1.03851746182648, 0.245326690731331, 0.219426862868129, 0.190029237516526, -0.0814411017927947, -0.0728431359084675, -0.0630840061880541, -0.0515078753637702, 0.0313466946954437, 0.0280373360835811, 0.0242810453028231, 0.0198253904711023, 0.0140186680417899, -1.34598912841459e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.18529407725404, 3.45525332069938, 0.997445717412069, -1.4106012612951, 3.23209352764251, 5.28531208250979, -1.3627702877385, -2.8908723349783, -0.393397896234722, 0.556348640264194, 2.33666428910958, 9.02784807228867, -0.732969916135166, -3.93352933905728, -1.19859611757308, 0.309047252182629, 1.64018416088946, 0.655588223176222, 0.0892142571199762, -0.126168012376104, 13.0996183150503, 11.55277744383, -0.23484359721209, -2.44096975264613, -0.907332870306509, 0.0736662483163258, 0.810328731479528, 0.395334573318415, 0.120463442338383, -0.0310604175145496, -0.311895674167861, -0.164844710568313, -0.0658890955530676, -0.0089663702065851, 0.012680362351407, 0.0, 0.0, 0.0, 1.11652798437369e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99489143482415, 3.1542003094028, -1.09264703862703, 1.54523626091315, 2.95048422176041, -0.761811750275038, 5.59815020469136, 0.263899331455871, -1.93925611658551, -2.28543525082517, 2.13307290077015, -0.257539376818854, 9.14446135479765, 0.0664963811608003, -2.36108976914459, -3.33842298506509, -0.0230350221379984, 0.817905488277902, 1.1564636454577, 1.02505848514082, 0.0, 0.0, 11.5766222110848, 0.0, -1.39771878815471, -2.15192884958005, 0.0, 0.360889439280297, 0.555625639776455, 0.595437196138648, 0.0, -0.125015768949706, -0.192474367616159, -0.206265495285701, -0.166687691932938, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.92724822331886, 1.82834820066014, 2.99085908983326, -1.2440333788203, 0.950146187582609, 5.74064456311311, -0.721110255092802, -0.169967317119738, -1.17961073303082, 0.490653381462658, -10.3037210107158, 4.97613351528119, -0.215472901842826, 5.7817446699566, -1.30185581821821, 0.16353243452862, -3.22682211353225, 0.0385449644663744, 0.267510569439616, -0.111269728052839, 0.0, 14.555131461167, 1.03556292536503, 10.7636648722209, -0.500120235663639, 0.0216558414515674, -3.57321383950879, -0.581087203147979, 0.130841432732454, -0.0164356280722681, 1.375330648075, 0.324307824721454, -0.00387391468765176, -0.0268858238268353, 0.0111830284386719, 0.0, 0.0, 0.0, -1.24814777259306e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.01558844222418e-14, 0.0, 0.0, 0.0, 0.0, 1.4259678156057e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.75932887637251, 1.66904592079257, 0.963624111659426, 1.36277028773851, 0.867360833110885, 2.28430636201793, 2.96226264871973, -1.00852844760553, 1.71026313764871, -2.01556443707464, 2.41867732448957, 2.04415543160773, 2.68821895760392, -0.52779866291175, 7.07977053255617, -1.76652739792482, 0.182834820066016, -3.12574097035512, -1.01990506872275, 0.904016610326407, 0.0, 0.0, 13.1266557397187, 0.0, 11.0940489487798, -0.632607619454898, 0.0, -2.8644711213756, -1.66605356688627, 0.315075748468086, 0.0, 0.992281903807264, 0.735567892896454, 0.181909068193181, -0.147004726489968, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.29943670433591e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.57359158493888, 1.49284005458434, -0.430945803685661, 3.04724700110022, 0.775791113542715, -0.12018504251546, 5.29905651979671, 0.0346944333244405, -1.52970585407784, 0.901387818866003, 0.0, 0.0, 4.51561078268939, 0.0, -0.699555414372428, 6.36462844462228, 0.0, 0.201944253400478, -1.83730997289731, -2.74825341360596, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8920630294282, 0.0, 0.0, -1.68739114875268, -3.0999354831996, 0.0, 0.0, 0.487107866980278, 0.894874292847886, 0.903959543974654, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.62882203585591, 0.772618130456559, 3.86595114186569, -1.05140010313426, 9.15442906076461, 3.35889012281481, -0.304724700110017, 3.87851223317103, -1.52475169285616, 0.414677792940103, -1.30025811259761e-14, -9.46260092820843, -2.07602937339136, 7.32969916135159, -0.761724681099364, 0.0691050664139826, 0.564240504518059, -0.879563899362192, 0.34578118203619, -0.0940400840863324, 0.0, 0.0, 0.0, 16.3745228938128, 0.951027176355642, 0.208648802584723, 9.05975063854701, -0.736662483163209, 0.0765562109321155, -0.00694532049720559, -3.48709964663733, -0.0567083043941599, 0.0883994979795876, -0.0347523163751415, 0.00945138406569528, 0.0, -1.00011135325188e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48690428533296, 0.705300630647561, 2.03602754481989, 1.15175110689978, -2.93221479395415, 1.81702705031799, 1.25178444059441, 0.65566316039121, 3.61359041872287, -1.70346285967312, 0.0, 2.7642026565595, -9.0878387586433, 1.78428514239954, 5.631527706439, -0.746494073225328, -0.61809450436525, 2.03210252328837, -2.15494277062552, 0.764033484562603, 0.0, 0.0, 0.0, 0.0, 15.0018922739643, 2.13860408462396, 0.0, 9.68367982311022, -1.32524448062075, 0.133143804689781, 0.0, -3.3545250915713, -0.478206411017786, 0.384353057392912, -0.12424167005819, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.36916607789467e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32992762321609, 0.630840061880566, 0.72843135908468, 2.57539376818855, 0.917928424547682, 0.711024300256724, 2.23926008187653, -0.205255035576784, 2.58567482211401, 0.761811750275059, 0.0, 0.0, 5.34294273196306, 0.0, 4.13862564412659, 2.68954640486934, 0.0, -1.19471831485579, 3.1056206816986, -2.32269806558126, 0.0, 0.0, 0.0, 0.0, 0.0, 12.8876627769294, 0.0, 0.0, 9.98274066131696, -1.30996183150503, 0.0, 0.0, -2.88176900403078, -1.51261363209512, 0.763985254692622, 0.0, 0.0, -1.17185759123372e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1517511068998, 0.546323519313516, -0.105140010313426, 3.2711894277325, 0.0, 0.0, 2.69341127303542, 0.0, -0.518347241175126, 4.25171145123353, 1.14902781575578e-14, 0.0, 0.0, 0.0, 0.0, 6.71889089790564, 0.0, 0.0, -1.29305115618719, 1.82865048192212, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.45383520059451, 0.0, 0.0, 0.0, -1.81939143264587, -2.94058061635795, 0.0, 0.0, 0.0, 0.0, 0.0, 1.05723279563221e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.26168012376111, -6.78263087840206, 3.68560354207933, -0.814411017927962, 0.0, 10.0216907612581, 2.67510569439611, 6.00856531485322, -1.4536216402544, 0.321208037219806, -1.65057976629295e-14, 0.0, 1.17706771112406e-14, -7.57008074256672, -2.27270584034422, -0.606656948415846, 6.99294104721295, -1.36261453366202, 0.329650402328128, -0.0728431359084687, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.7137404500718, 0.760821741084516, 0.228415531250646, 0.0609713174047718, 5.40219154319687, -0.702817019232743, 0.136947913395215, -0.0331311120155195, 0.00732101061700708, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.42496696880162e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1517511068998, 3.82426463519459, 2.20794021658197, 0.892142571199776, 0.0, -2.46306042692148, 6.78739640804926, 2.13307290077016, 3.91870514328393, -1.31949665727937, 0.0, 0.0, 0.0, 3.22490309931941, -7.63378455726036, -4.04762275910194, 1.11713920350153, 6.61105135360481, -2.33689608954555, 0.591817792331165, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.5022076529583, 1.79642743108413, 0.72192923349994, 0.0, 6.06294257990892, -1.55575179137407, 0.416806037297051, -0.0962371838080743, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03015750727543, -1.4659398322703, 1.12848100903607, 1.99489143482414, 0.0, 1.10151410945723, -5.20357020296094, 0.476969600708469, 4.00571020990215, 0.590096844352087, 0.0, 0.0, 0.0, 0.0, 6.41153127835568, -6.24994106094656, 0.0, 2.77627448210729, 4.81120687194239, -1.79915418525286, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.4651953323153, 3.04407621455179, 0.0, 0.0, 6.69662601613678, -2.34333096254029, 0.591780433634514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.892142571199772, 0.705300630647555, 0.407205508963985, 2.53385243517954, 0.0, 0.0, 3.47717900165117, 0.0, 2.00755023262381, 3.29336152870136, 0.0, 0.0, 0.0, 0.0, 0.0, 8.67405085085771, 0.0, 0.0, 5.0079655937072, 1.4164665725037, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.2048487632307, 0.0, 0.0, 0.0, 7.0464727188699, -2.27776395106694, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.728431359084687, 0.0, 0.0, 2.53908227033119, 0.0, 0.0, 0.0, 0.0, 0.0, 5.00713776237768, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.93924068068616, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.2767793639472, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.09901951359278, 0.0, -4.65474668125635, -3.29140294302194, 0.0, 0.0, 0.0, 13.490737563232, 1.83585684909538, 1.29814682728311, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -3.53270434653118, -3.05941170815567, -0.416333199893246, -0.294392028877619, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 21.8326971917504, 0.355050145839447, 0.307482445914322, 0.0418430609640578, 0.0295875121532877, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.61462585708151e-14, 0.0, 0.0, 0.0, 0.0, -1.16102518088945e-14},
      {-2.65985524643218, 0.0, 5.0990195135928, -2.06031501455083, 0.0, 0.0, 0.0, -1.23153021346074, 9.04986187739901, 3.04724700110021, 0.0, 0.0, 1.42882694523272e-14, 0.0, 0.0, 0.0, 3.86988371918332, -3.81689227863017, -5.39683034546924, -1.3667446468544, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 21.00264918355, 0.898213715542062, 0.962572311333254, 0.222250255910583, 0.0, 0.0, 0.0, 0.0, -1.12681836907137e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.18513103827981e-14, 0.0, 0.0, 1.05763921925961e-14},
      {2.97380857066589, 0.0, -0.814411017927952, 5.75875553449899, 0.0, 0.0, 0.0, 1.37689263682151, -2.89087233497831, 1.70346285967313, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 8.01441409794461, -3.47218947830365, -5.1937107658469, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 19.3314941653941, 1.69115345252878, 1.70832296330021, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.43661124663019e-14},
      {-1.03015750727544, 0.0, 0.940400840863422, -2.9258407710754, 0.0, 0.0, 0.0, 0.0, 4.63623866886821, -3.80284633026898, 0.0, 0.0, 0.0, 0.0, -1.17361870806384e-14, 0.0, 0.0, 0.0, 11.565401134477, -1.63559471386624, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.2731316843076, 2.63013526059784, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.01423919225742e-14, 0.0},
      {1.26168012376113, 0.0, 0.0, 4.39781949681095, 0.0, 0.0, -1.11014659841498e-14, 0.0, 0.0, 8.67261700493487, 0.0, 0.0, 0.0, 0.0, 1.40183636832794e-14, -1.61637203484436e-14, 0.0, 0.0, 1.165919317568e-14, 12.0191174248973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8717007662564, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06515764673489e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580398915498, 5.6124860801609, -1.08012344973464, -0.76376261582597, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267039, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.55391889677069e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971952, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24263211362714e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32287565553229, 0.0, 3.86436713231719, -0.341565025531985, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971955, 2.50998007960222, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912986, 0.0, 0.0, 8.87411967464941, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.96188551515597e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.7495454169735, 5.79655069847577, -1.67332005306815, -1.18321595661991, 7.74596669241484, -1.19999999999999, -0.979795897113259, 0.346410161513775, 0.282842712474621, 0.200000000000003, 0.0, -1.151409054946e-14, 0.0, -1.15969281804308e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.26922669423102e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772444, 2.44948974278317, 2.8284271247462, -0.999999999999998, 1.30930734141595, 7.09929573971953, -0.414039335605412, -2.04939015319192, -0.478091443733755, 0.169030850945706, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.08716682344658e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0124611797498, 2.12132034355963, -0.408248290463859, 3.17542648054295, 9.07114735222146, 0.0, 7.17137165600637, 0.0, -1.3801311186847, -1.56144011671766, 0.0, -1.27114514413737e-14, 0.0, 0.0, 0.0, -1.89105350382163e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8, 0.632455532033676, 4.38178046004134, -0.774596669241488, 0.0, 3.14233761939829, -0.106904496764969, 4.76235235991627, -0.740656079818045, 0.130930734141596, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.18031428662765e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 0.547722557505164, 1.58113883008419, 2.45967477524977, 0.0, 9.07114735222145, 1.8516401995451, 0.0, 5.34522483824849, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613578, -6.26099033699941, 0.0, 3.83405790253615, 0.0, 0.0, 10.5830052442584, 0.0, 0.0, 5.18459255872628, 0.0, 0.0, 0.0, 1.25836173653064e-14, 1.48358452126538e-14, -1.12491819922707e-14, -1.04421095586587e-14, 0.0, 0.0, -1.67296732023203e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03923048454133, 0.0, 3.16227766016838, -0.447213595499959, 0.0, 0.0, 0.0, 5.89188303637179, -0.534522483824848, 0.0755928946018435, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.900000000000011, 1.33719710960724e-14, 1.46059348668044, 1.42009389360938, 0.0, 0.0, 0.0, 9.07114735222146, 4.93770719878695, -0.698297248755181, 0.0, 0.0, 0.0, 1.32954362671572e-14, 0.0, 1.06165553601881e-14, 0.0, 1.44648983668665e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.73484692283496, 0.0, -6.26099033699942, 2.21359436211785, 0.0, 0.0, 0.0, 0.0, 10.5830052442584, 2.99332590941915, 0.0, 0.0, 0.0, 0.0, 0.0, 1.05984189380888e-14, -1.39797099343912e-14, 0.0, 0.0, -1.35759459229945e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.71576766497729, 0.0, 0.0, -4.69574275274956, 0.0, 0.0, 0.0, 0.0, 0.0, 12.69960629311, 1.04519457838932e-14, 0.0, 0.0, 0.0, 1.04165025265274e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.56904651573302, 5.80288457473996, -2.01017818278146, -1.42141062443801, 8.14215222512714, -2.10229466468019, -1.71651640581398, 0.728256234341415, 0.594618725379071, 0.420458932936045, 9.81070843517429, -1.18450885369837, -1.02581475831037, 0.305838870920592, 0.26486423168198, 0.216260739578387, -0.105945692672791, -0.0917516612761676, -0.0749149177264296, -0.052972846336385, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239552, 3.07059789431495, 1.77281052085584, -1.25356634105601, 2.39356776939084, 6.30376871403132, -0.908295106229243, -2.78313372537744, -0.524404424085076, 0.370809924354784, 1.23603308118261, 9.40174755792012, -0.301561193523221, -2.42752078113807, -0.794200206656967, 0.114434427054264, 0.840917865872095, 0.350641890608829, 0.0660687472643458, -0.0467176592151037, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.02649122047608, 2.74642624930237, -0.792824967172092, 2.24244764232556, 2.14087209644419, -0.33166247903552, 6.49923072370877, 0.0957427107756355, -1.87616630392937, -2.15580611373101, 11.0554159678513, 0.0, 9.44035859331468, 0.0, -1.46249406456536, -2.04706526287665, 0.0, 0.422185670932514, 0.590936840285282, 0.522319308773347, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551268, 1.29756443747035, 3.74574588632199, -1.05945692672795, 0.40458679685634, 5.01426536422407, -0.383824736789368, 1.80936716113937, -1.1080065755349, 0.313391585264003, 0.0, 2.82521847127454, -0.0509731451534303, 8.20651806648289, -0.631738055305789, 0.0483573714561688, -2.84282124887604, -0.22795883518008, 0.139595707137604, -0.039483628456614, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.16466485419836e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715535, 1.16057691494799, 1.34011878852098, 1.89521416591737, 0.361873432227873, 1.96214168703486, 2.74642624930238, -0.56642151559888, 3.17129986868837, -1.82198870938951, 0.0, 11.0554159678513, 1.59571184626057, 0.0, 8.65223156827828, -0.86504295831357, 0.0, -2.49768411251822, -0.998865569685855, 0.441440386136649, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741914, 1.00508909139073, -0.193429485824664, 3.55615782880925, -8.46157280212813, 0.0, 4.45964044034302, 0.0, -0.858258202906997, 2.67027285925186, 0.0, 1.44857443011911e-14, 12.4373429638328, 0.0, 0.0, 8.42792824422442, 0.0, 0.0, -1.62195554683794, -2.2937915319045, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741914, 0.335029697130249, 4.06201920231799, -0.820651806648291, 0.0, 1.69926454679664, -0.0991031208965121, 5.88642506110459, -1.2015614840698, 0.242752078113806, 0.0, 0.0, 0.0, 4.94413232473044, -0.214087209644419, 0.0124858196210728, 5.13809303146607, -0.741619848709577, 0.151382517704883, -0.0305838870920607, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32664991614217, 0.299659670905766, 2.07610309995257, 1.46802658041885, 0.0, 0.868496237346898, 0.709124208342333, 1.31624465810883, 4.91295663090393, -1.4113063856887, 0.0, 0.0, 0.0, 11.0554159678513, 3.82970843102536, -0.223353131420157, 0.0, 5.80409338312194, -1.54743588659732, 0.341938252770102, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.1489125293076, 0.259512887494075, 0.749149177264382, 2.75458800949267, 0.0, -8.46157280212811, 1.15147421036811, 0.0, 3.32401972660471, 2.06838446274243, 0.0, 0.0, -1.1283446540405e-14, 0.0, 12.4373429638327, 2.17608171552749, -1.21040313496127e-14, 0.0, 6.28180682119209, -1.77676328054754, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.93808315196469, 7.62808987244124, 1.39628067270975e-14, 3.11415464992886, 0.0, 0.0, -7.52139804633611, 0.0, 0.0, 5.52707620976692, 0.0, 0.0, 0.0, 0.0, 0.0, 14.2141062443803, 1.0319833740378e-14, 1.68289931844567e-14, 0.0, 5.80288457473996, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.856348838577683, 0.0, 2.68023757704196, -0.473803541479344, 0.0, 0.0, 0.0, 5.09779364038993, -0.792824967172097, 0.140152977645348, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.91061171956871, -0.642261628933266, 0.0998865569685892, -0.0176576154454652, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.765941686205081, 0.0, 1.49829835452878, 0.847565541382356, 0.0, 0.0, 0.0, 1.62843044502544, 3.54562104171167, -0.814818121686411, 0.0, -1.00490360530146e-14, 0.0, 0.0, 0.0, 0.0, 11.0554159678513, 7.18070330817253, -1.11676565710082, 0.197418142283054, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.663324958071068, 0.0, 0.692034366650859, 1.5903621287871, 0.0, 0.0, 0.0, -8.46157280212811, 3.07059789431496, 1.19418232635199, 0.0, 0.0, 0.0, -1.73320255518822e-14, 0.0, 0.0, 1.38009491821402e-14, 12.4373429638327, 5.80288457473997, -1.02581475831036, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.541602560309052, -1.25890451024725e-14, 7.62808987244128, 1.79795802543454, 0.0, 0.0, 0.0, 0.0, -7.52139804633611, 3.1910589375405, 0.0, 0.0, 0.0, 0.0, 0.0, -1.97784641917273e-14, 2.38963933169705e-14, 0.0, 14.2141062443803, 3.35029697130245, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-5.36159180343549, 0.0, 0.0, 8.89943818451478, 0.0, 0.0, 0.0, 0.0, 0.0, -5.26497863243527, 0.0, 0.0, 0.0, 0.0, 1.69418316537184e-14, -1.83698225526999e-14, 0.0, -1.32206326378019e-14, 0.0, 16.583123951777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.41593350361253, 5.72988941019467, -2.20543546226844, -1.5594783708393, 8.33749895885383, -2.76779953857106, -2.25989885993662, 1.06532653910461, 0.869835476750492, 0.615066564126914, 10.333118277332, -2.18326971917504, -1.89076704011892, 0.724780051083757, 0.627677936394704, 0.512496888990057, -0.278967971730972, -0.241593350361236, -0.197260144544829, -0.139483985865484, 11.8490505948789, -1.16109782023228, -1.03851746182648, 0.245326690731331, 0.219426862868129, 0.190029237516526, -0.0814411017927947, -0.0728431359084675, -0.0630840061880541, -0.0515078753637702, 0.0313466946954437, 0.0280373360835811, 0.0242810453028231, 0.0198253904711023, 0.0140186680417899, -1.34598912841459e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.18529407725404, 3.45525332069938, 0.997445717412062, -1.41060126129509, 3.23209352764251, 5.2853120825098, -1.36277028773849, -2.89087233497829, -0.393397896234721, 0.55634864026419, 2.33666428910958, 9.02784807228867, -0.732969916135157, -3.93352933905729, -1.19859611757308, 0.309047252182623, 1.64018416088945, 0.65558822317622, 0.089214257119981, -0.126168012376099, 1.1908743922773, 11.55277744383, -0.234843597212088, -2.44096975264613, -0.907332870306512, 0.0736662483163217, 0.810328731479531, 0.395334573318417, 0.120463442338383, -0.031060417514548, -0.31189567416786, -0.164844710568315, -0.0658890955530668, -0.00896637020658499, 0.0126803623514091, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99489143482414, 3.15420030940281, -1.09264703862702, 1.54523626091315, 2.9504842217604, -0.761811750275046, 5.59815020469135, 0.263899331455871, -1.93925611658551, -2.28543525082517, 2.13307290077016, -0.257539376818845, 9.14446135479765, 0.0664963811608087, -2.3610897691446, -3.33842298506508, -0.0230350221379951, 0.817905488277904, 1.15646364545769, 1.02505848514081, 13.0453753561106, 0.0, 11.5766222110848, 0.0, -1.39771878815472, -2.15192884958005, 0.0, 0.360889439280295, 0.555625639776455, 0.595437196138646, 0.0, -0.125015768949705, -0.19247436761616, -0.206265495285702, -0.16668769193294, 0.0, 0.0, 0.0, 0.0, 0.0, 1.07688613330682e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.92724822331886, 1.82834820066013, 2.99085908983326, -1.2440333788203, 0.950146187582608, 5.7406445631131, -0.7211102550928, -0.169967317119744, -1.17961073303082, 0.490653381462661, 0.294392028877592, 4.9761335152812, -0.215472901842836, 5.78174466995659, -1.30185581821821, 0.163532434528625, -3.22682211353225, 0.0385449644663701, 0.267510569439614, -0.111269728052837, 0.0, 2.646387538394, -0.0295875121532846, 10.7636648722209, -0.50012023566364, 0.0216558414515689, -3.57321383950879, -0.581087203147979, 0.130841432732454, -0.0164356280722693, 1.37533064807501, 0.324307824721454, -0.00387391468765233, -0.0268858238268337, 0.011183028438673, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.54346718065853e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.75932887637249, 1.66904592079257, 0.963624111659428, 1.36277028773851, 0.867360833110891, 2.28430636201794, 2.96226264871972, -1.00852844760553, 1.71026313764871, -2.01556443707465, 0.268741924943287, 2.04415543160772, 2.68821895760394, -0.527798662911744, 7.07977053255618, -1.76652739792483, 0.182834820066012, -3.12574097035513, -1.01990506872274, 0.904016610326411, 0.0, 13.0453753561106, 1.45851730441319, 0.0, 11.0940489487798, -0.632607619454904, 0.0, -2.8644711213756, -1.66605356688627, 0.315075748468089, 0.0, 0.992281903807263, 0.735567892896453, 0.181909068193181, -0.147004726489966, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.5735915849389, 1.49284005458436, -0.430945803685668, 3.04724700110022, 0.775791113542717, -0.120185042515463, 5.29905651979672, 0.0346944333244382, -1.52970585407784, 0.901387818866001, -10.576283741361, 0.0, 4.51561078268938, 0.0, -0.699555414372441, 6.36462844462229, 0.0, 0.201944253400487, -1.83730997289732, -2.74825341360596, 0.0, 0.0, 14.3499128917217, 0.0, 0.0, 10.8920630294282, 0.0, 0.0, -1.68739114875268, -3.09993548319961, 0.0, 0.0, 0.487107866980278, 0.894874292847885, 0.903959543974654, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.62882203585591, 0.772618130456572, 3.86595114186568, -1.05140010313426, 0.160604018609907, 3.35889012281481, -0.304724700110022, 3.87851223317102, -1.52475169285616, 0.414677792940096, 0.0, 1.135512111385, -0.0364215679542345, 7.3296991613516, -0.761724681099359, 0.0691050664139833, 0.564240504518048, -0.879563899362189, 0.345781182036182, -0.0940400840863355, 0.0, 0.0, 0.0, 4.46577897103986, -0.114123261162676, 0.00366050530850576, 9.05975063854701, -0.73666248316321, 0.0765562109321156, -0.00694532049720655, -3.48709964663733, -0.0567083043941568, 0.0883994979795855, -0.0347523163751381, 0.0094513840656929, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48690428533296, 0.705300630647557, 2.0360275448199, 1.15175110689978, 0.146610739697702, 1.81702705031799, 1.25178444059442, 0.655663160391219, 3.61359041872287, -1.70346285967311, 0.0, 0.61426725701323, 0.454391937932152, 1.78428514239953, 5.63152770643899, -0.746494073225317, -0.618094504365244, 2.03210252328836, -2.15494277062552, 0.764033484562593, 0.0, 0.0, 0.0, 13.0453753561106, 3.33375383865872, -0.106930204231199, 0.0, 9.68367982311022, -1.32524448062076, 0.13314380468978, 0.0, -3.3545250915713, -0.478206411017787, 0.384353057392906, -0.124241670058192, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32992762321609, 0.630840061880567, 0.728431359084683, 2.57539376818856, 0.13113263207824, 0.711024300256729, 2.23926008187654, -0.205255035576787, 2.58567482211401, 0.761811750275046, 0.0, -10.576283741361, 0.763277533137582, 0.0, 4.13862564412659, 2.68954640486934, 0.0, -1.19471831485577, 3.1056206816986, -2.32269806558126, 0.0, 0.0, 0.0, 0.0, 14.3499128917217, 1.84109468241849, 0.0, 0.0, 9.98274066131697, -1.30996183150503, 0.0, 0.0, -2.88176900403078, -1.51261363209512, 0.763985254692617, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.15175110689978, 0.546323519313518, -0.105140010313426, 3.27118942773249, 9.65295620481434, 0.0, 2.69341127303541, 0.0, -0.518347241175123, 4.25171145123354, 1.18152069786956e-14, -1.38297717451513e-14, -9.91526600752601, 0.0, 0.0, 6.71889089790564, 0.0, 0.0, -1.29305115618718, 1.82865048192213, 0.0, 0.0, 0.0, 0.0, 0.0, 15.9443476574685, 0.0, 0.0, 0.0, 9.45383520059451, 0.0, 0.0, 0.0, -1.81939143264587, -2.94058061635794, 0.0, 0.0, -1.72754963278994e-14, 0.0, 1.13755232036152e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.26168012376112, 0.199489143482416, 3.68560354207934, -0.814411017927958, 0.0, 1.02786571910339, -0.0786795792469428, 6.00856531485323, -1.4536216402544, 0.321208037219811, 0.0, 0.0, 0.0, 3.0280322970267, -0.233098034907103, 0.0178428514239945, 6.99294104721297, -1.36261453366202, 0.32965040232814, -0.0728431359084713, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.80499652729883, -0.304328696433804, 0.0234272339744254, -0.00179327404131563, 5.40219154319688, -0.702817019232742, 0.136947913395215, -0.0331311120155212, 0.00732101061700645, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.15175110689979, 0.182107839771176, 2.20794021658197, 0.892142571199767, 0.0, 0.615765106730374, 0.323209352764248, 2.13307290077016, 3.91870514328393, -1.31949665727937, 0.0, 0.0, 0.0, 1.07496769977314, 1.90844613931509, -0.19274394090962, 1.11713920350151, 6.6110513536048, -2.33689608954555, 0.591817792331162, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.0453753561106, 5.83406921765277, -0.449106857771024, 0.0343775825476163, 0.0, 6.06294257990892, -1.55575179137407, 0.416806037297052, -0.0962371838080749, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.03015750727543, 0.162882203585601, 1.12848100903607, 1.99489143482413, 0.0, 0.314718316987777, 0.578174466995654, 0.476969600708466, 4.00571020990215, 0.590096844352083, 0.0, 0.0, -1.31549551242914e-14, -10.576283741361, 1.83186607953019, 0.694437895660746, -1.8047208927113e-14, 2.77627448210728, 4.81120687194239, -1.79915418525287, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.3499128917217, 4.41862723780437, -0.33823069050576, 0.0, 0.0, 6.69662601613678, -2.34333096254029, 0.591780433634515, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.892142571199766, 0.141060126129502, 0.407205508963996, 2.53385243517955, 0.0, 9.65295620481434, 0.695435800330227, 0.0, 2.00755023262381, 3.29336152870135, 0.0, 0.0, 1.11713603382673e-14, 0.0, -9.91526600752598, 1.73481017017153, 1.64166602797602e-14, 0.0, 5.0079655937072, 1.41646657250371, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.9443476574685, 2.44096975264614, 0.0, 0.0, 0.0, 7.0464727188699, -2.27776395106693, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.728431359084693, -7.94708263760857, -1.34962358184755e-14, 2.53908227033119, 0.0, 0.0, 10.2207771580387, 0.0, 0.0, 5.00713776237768, 0.0, 0.0, 0.0, 0.0, 0.0, -8.49879943502226, -1.3318970311563e-14, 0.0, 0.0, 6.93924068068617, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.9373911146521, 0.0, 0.0, 0.0, 0.0, 6.27677936394721, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.728431359084677, 0.0, 2.32737334062816, -0.470200420431705, 0.0, 0.0, 0.0, 4.49691252107735, -0.917928424547683, 0.185449546754728, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.06540869306229, -1.01980390271856, 0.208166599946613, -0.0420560041253752, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.92395326897747, -0.710100291678877, 0.102494148638108, -0.0209215304820305, 0.00422678745046826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.664963811608031, -1.52728632141123e-14, 1.45686271816937, 0.515078753637711, 0.0, 0.0, 0.0, 1.84729532019112, 2.58567482211399, -0.761811750275054, 0.0, 0.0, 0.0, -1.45770491081465e-14, 0.0, 0.0, 1.71994831963703, 5.72533841794525, -1.54195152727693, 0.34168616171361, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.0453753561106, 9.33451074824443, -1.3473205733131, 0.275020660380933, -0.0555625639776416, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.08465016007527e-14, 0.0, 0.0, 0.0, 0.0},
      {0.594761714133172, 0.0, 0.81441101792795, 1.15175110689982, 0.0, 0.0, 0.0, 0.590096844352069, 2.89087233497829, 0.340692571934627, 0.0, 0.0, 0.0, 0.0, -1.12582268745145e-14, -1.00859362139179e-14, -10.576283741361, 3.43474889911913, 3.47218947830365, -1.03874215316937, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.3499128917217, 8.28492607088319, -1.69115345252877, 0.341664592660044, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.03389519168218e-14},
      {0.515078753637708, 0.0, 0.376160336345357, 1.4629203855377, 0.0, 0.0, 0.0, 9.65295620481433, 1.85449546754729, 1.90142316513449, 0.0, 0.0, 0.0, 0.0, -1.08799737057301e-14, 0.0, 0.0, -9.91526600752598, 4.62616045379077, 0.81779735693313, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.9443476574685, 6.50925267372303, -1.31506763029892, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.420560041253713, 0.0, -7.94708263760858, 1.46593983227031, 0.0, 0.0, 0.0, 0.0, 10.2207771580387, 2.89087233497829, 0.0, 0.0, 1.39515011653448e-14, 0.0, 0.0, 0.0, -2.25920784148809e-14, 0.0, -8.49879943502226, 4.00637247496575, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.9373911146521, 3.62390025541881, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06444352251245e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.542378855465, 0.0, 0.0, -6.91050664139873, 0.0, 0.0, 0.0, 0.0, 0.0, 12.2649325896465, -1.24221302592312e-14, 0.0, 0.0, 0.0, -1.26085093097862e-14, 0.0, 1.00262554257505e-14, 0.0, 1.9958678525973e-14, -5.66586629001481, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.34034011235354e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 20.4998755596024, 0.0, 0.0, 0.0, 0.0, 0.0, -1.13399729500939e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.18880599808691e-14}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[56][56] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[56][56] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 56; t++)
        {
          for (unsigned int u = 0; u < 56; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 56; s++)
        {
          for (unsigned int t = 0; t < 56; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[3