// This code conforms with the UFC specification version 2.0.0
// and was automatically generated by FFC version 0.9.10.
//
// This code was generated with the option '-l dolfin' and
// contains DOLFIN-specific wrappers that depend on DOLFIN.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   False
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'dolfin'
//   log_level:                      10
//   log_prefix:                     ''
//   no_ferari:                      True
//   optimize:                       True
//   output_dir:                     '.'
//   precision:                      15
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'auto'
//   split:                          False
//   swig_binary:                    'swig'
//   swig_path:                      ''

#ifndef __STOKES_H
#define __STOKES_H

#include <cmath>
#include <stdexcept>
#include <fstream>
#include <ufc.h>

/// This class defines the interface for a finite element.

class stokes_finite_element_0: public ufc::finite_element
{
public:

  /// Constructor
  stokes_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~stokes_finite_element_0()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 2, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::tetrahedron;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 3;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 3;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 10;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[3][0] + x[2][0] + x[1][0] - x[0][0];
    const double C1 = x[3][1] + x[2][1] + x[1][1] - x[0][1];
    const double C2 = x[3][2] + x[2][2] + x[1][2] - x[0][2];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*coordinates[0] - C0) + d_10*(2.0*coordinates[1] - C1) + d_20*(2.0*coordinates[2] - C2)) / detJ;
    double Y = (d_01*(2.0*coordinates[0] - C0) + d_11*(2.0*coordinates[1] - C1) + d_21*(2.0*coordinates[2] - C2)) / detJ;
    double Z = (d_02*(2.0*coordinates[0] - C0) + d_12*(2.0*coordinates[1] - C1) + d_22*(2.0*coordinates[2] - C2)) / detJ;
    
    
    // Reset values.
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {-0.0577350269189626, -0.0608580619450185, -0.0351364184463153, -0.0248451997499977, 0.0650600048632355, 0.050395263067897, 0.0411475599898912, 0.0290957186981323, 0.0237565548366599, 0.0167984210226323};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {-0.0577350269189625, 0.0608580619450185, -0.0351364184463153, -0.0248451997499977, 0.0650600048632355, -0.050395263067897, -0.0411475599898912, 0.0290957186981323, 0.0237565548366599, 0.0167984210226323};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {-0.0577350269189626, 0.0, 0.0702728368926306, -0.0248451997499977, 0.0, 0.0, 0.0, 0.0872871560943969, -0.0475131096733199, 0.0167984210226323};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {-0.0577350269189626, 0.0, 0.0, 0.074535599249993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.100790526135794};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, 0.0, 0.140545673785261, 0.0993807989999906, 0.0, 0.0, 0.0, 0.0, 0.1187827741833, -0.0671936840905293};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.230940107675851, 0.121716123890037, -0.0702728368926306, 0.0993807989999907, 0.0, 0.0, 0.102868899974728, 0.0, -0.0593913870916499, -0.0671936840905293};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, 0.121716123890037, 0.0702728368926307, -0.0993807989999907, 0.0, 0.100790526135794, -0.0205737799949456, -0.087287156094397, -0.01187827741833, 0.0167984210226323};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, -0.121716123890037, -0.0702728368926307, 0.0993807989999906, 0.0, 0.0, -0.102868899974728, 0.0, -0.0593913870916499, -0.0671936840905293};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, -0.121716123890037, 0.0702728368926306, -0.0993807989999906, 0.0, -0.100790526135794, 0.0205737799949456, -0.0872871560943969, -0.01187827741833, 0.0167984210226323};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, 0.0, -0.140545673785261, -0.0993807989999906, -0.130120009726471, 0.0, 0.0, 0.0290957186981323, 0.02375655483666, 0.0167984210226323};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 10; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    const double K_00 = d_00 / detJ;
    const double K_01 = d_10 / detJ;
    const double K_02 = d_20 / detJ;
    const double K_10 = d_01 / detJ;
    const double K_11 = d_11 / detJ;
    const double K_12 = d_21 / detJ;
    const double K_20 = d_02 / detJ;
    const double K_21 = d_12 / detJ;
    const double K_22 = d_22 / detJ;
    
    // Compute constants
    const double C0 = x[3][0] + x[2][0] + x[1][0] - x[0][0];
    const double C1 = x[3][1] + x[2][1] + x[1][1] - x[0][1];
    const double C2 = x[3][2] + x[2][2] + x[1][2] - x[0][2];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*coordinates[0] - C0) + d_10*(2.0*coordinates[1] - C1) + d_20*(2.0*coordinates[2] - C2)) / detJ;
    double Y = (d_01*(2.0*coordinates[0] - C0) + d_11*(2.0*coordinates[1] - C1) + d_21*(2.0*coordinates[2] - C2)) / detJ;
    double Z = (d_02*(2.0*coordinates[0] - C0) + d_12*(2.0*coordinates[1] - C1) + d_22*(2.0*coordinates[2] - C2)) / detJ;
    
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K_00, K_01, K_02}, {K_10, K_11, K_12}, {K_20, K_21, K_22}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {-0.0577350269189626, -0.0608580619450185, -0.0351364184463153, -0.0248451997499977, 0.0650600048632355, 0.050395263067897, 0.0411475599898912, 0.0290957186981323, 0.0237565548366599, 0.0167984210226323};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534075, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.683130051063973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {-0.0577350269189625, 0.0608580619450185, -0.0351364184463153, -0.0248451997499977, 0.0650600048632355, -0.050395263067897, -0.0411475599898912, 0.0290957186981323, 0.0237565548366599, 0.0167984210226323};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534075, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.683130051063973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {-0.0577350269189626, 0.0, 0.0702728368926306, -0.0248451997499977, 0.0, 0.0, 0.0, 0.0872871560943969, -0.0475131096733199, 0.0167984210226323};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534075, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.683130051063973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {-0.0577350269189626, 0.0, 0.0, 0.074535599249993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.100790526135794};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534075, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.683130051063973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, 0.0, 0.140545673785261, 0.0993807989999906, 0.0, 0.0, 0.0, 0.0, 0.1187827741833, -0.0671936840905293};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534075, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.683130051063973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.230940107675851, 0.121716123890037, -0.0702728368926306, 0.0993807989999907, 0.0, 0.0, 0.102868899974728, 0.0, -0.0593913870916499, -0.0671936840905293};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534075, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.683130051063973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, 0.121716123890037, 0.0702728368926307, -0.0993807989999907, 0.0, 0.100790526135794, -0.0205737799949456, -0.087287156094397, -0.01187827741833, 0.0167984210226323};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534075, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.683130051063973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, -0.121716123890037, -0.0702728368926307, 0.0993807989999906, 0.0, 0.0, -0.102868899974728, 0.0, -0.0593913870916499, -0.0671936840905293};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534075, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.683130051063973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, -0.121716123890037, 0.0702728368926306, -0.0993807989999906, 0.0, -0.100790526135794, 0.0205737799949456, -0.0872871560943969, -0.01187827741833, 0.0167984210226323};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534075, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.683130051063973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, 0.0, -0.140545673785261, -0.0993807989999906, -0.130120009726471, 0.0, 0.0, 0.0290957186981323, 0.02375655483666, 0.0167984210226323};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534075, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.683130051063973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 10; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[3];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      y[2] = x[0][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      y[2] = x[1][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      y[2] = x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = x[3][0];
      y[1] = x[3][1];
      y[2] = x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.5*x[2][0] + 0.5*x[3][0];
      y[1] = 0.5*x[2][1] + 0.5*x[3][1];
      y[2] = 0.5*x[2][2] + 0.5*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.5*x[1][0] + 0.5*x[3][0];
      y[1] = 0.5*x[1][1] + 0.5*x[3][1];
      y[2] = 0.5*x[1][2] + 0.5*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 6:
      {
        y[0] = 0.5*x[1][0] + 0.5*x[2][0];
      y[1] = 0.5*x[1][1] + 0.5*x[2][1];
      y[2] = 0.5*x[1][2] + 0.5*x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 7:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[3][0];
      y[1] = 0.5*x[0][1] + 0.5*x[3][1];
      y[2] = 0.5*x[0][2] + 0.5*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 8:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[2][0];
      y[1] = 0.5*x[0][1] + 0.5*x[2][1];
      y[2] = 0.5*x[0][2] + 0.5*x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 9:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[1][0];
      y[1] = 0.5*x[0][1] + 0.5*x[1][1];
      y[2] = 0.5*x[0][2] + 0.5*x[1][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[3];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    y[2] = x[0][2];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    y[2] = x[1][2];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    y[2] = x[2][2];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = x[3][0];
    y[1] = x[3][1];
    y[2] = x[3][2];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.5*x[2][0] + 0.5*x[3][0];
    y[1] = 0.5*x[2][1] + 0.5*x[3][1];
    y[2] = 0.5*x[2][2] + 0.5*x[3][2];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.5*x[1][0] + 0.5*x[3][0];
    y[1] = 0.5*x[1][1] + 0.5*x[3][1];
    y[2] = 0.5*x[1][2] + 0.5*x[3][2];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
    y[0] = 0.5*x[1][0] + 0.5*x[2][0];
    y[1] = 0.5*x[1][1] + 0.5*x[2][1];
    y[2] = 0.5*x[1][2] + 0.5*x[2][2];
    f.evaluate(vals, y, c);
    values[6] = vals[0];
    y[0] = 0.5*x[0][0] + 0.5*x[3][0];
    y[1] = 0.5*x[0][1] + 0.5*x[3][1];
    y[2] = 0.5*x[0][2] + 0.5*x[3][2];
    f.evaluate(vals, y, c);
    values[7] = vals[0];
    y[0] = 0.5*x[0][0] + 0.5*x[2][0];
    y[1] = 0.5*x[0][1] + 0.5*x[2][1];
    y[2] = 0.5*x[0][2] + 0.5*x[2][2];
    f.evaluate(vals, y, c);
    values[8] = vals[0];
    y[0] = 0.5*x[0][0] + 0.5*x[1][0];
    y[1] = 0.5*x[0][1] + 0.5*x[1][1];
    y[2] = 0.5*x[0][2] + 0.5*x[1][2];
    f.evaluate(vals, y, c);
    values[9] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
    vertex_values[3] = dof_values[3];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new stokes_finite_element_0();
  }

};

/// This class defines the interface for a finite element.

class stokes_finite_element_1: public ufc::finite_element
{
public:

  /// Constructor
  stokes_finite_element_1() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~stokes_finite_element_1()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "VectorElement('Lagrange', Cell('tetrahedron', Space(3)), 2, 3, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::tetrahedron;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 3;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 3;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 30;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 1;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return 3;
        break;
      }
    }
    
    return 0;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[3][0] + x[2][0] + x[1][0] - x[0][0];
    const double C1 = x[3][1] + x[2][1] + x[1][1] - x[0][1];
    const double C2 = x[3][2] + x[2][2] + x[1][2] - x[0][2];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*coordinates[0] - C0) + d_10*(2.0*coordinates[1] - C1) + d_20*(2.0*coordinates[2] - C2)) / detJ;
    double Y = (d_01*(2.0*coordinates[0] - C0) + d_11*(2.0*coordinates[1] - C1) + d_21*(2.0*coordinates[2] - C2)) / detJ;
    double Z = (d_02*(2.0*coordinates[0] - C0) + d_12*(2.0*coordinates[1] - C1) + d_22*(2.0*coordinates[2] - C2)) / detJ;
    
    
    // Reset values.
    values[0] = 0.0;
    values[1] = 0.0;
    values[2] = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {-0.0577350269189626, -0.0608580619450185, -0.0351364184463153, -0.0248451997499977, 0.0650600048632355, 0.050395263067897, 0.0411475599898912, 0.0290957186981323, 0.0237565548366599, 0.0167984210226323};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {-0.0577350269189625, 0.0608580619450185, -0.0351364184463153, -0.0248451997499977, 0.0650600048632355, -0.050395263067897, -0.0411475599898912, 0.0290957186981323, 0.0237565548366599, 0.0167984210226323};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {-0.0577350269189626, 0.0, 0.0702728368926306, -0.0248451997499977, 0.0, 0.0, 0.0, 0.0872871560943969, -0.0475131096733199, 0.0167984210226323};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {-0.0577350269189626, 0.0, 0.0, 0.074535599249993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.100790526135794};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, 0.0, 0.140545673785261, 0.0993807989999906, 0.0, 0.0, 0.0, 0.0, 0.1187827741833, -0.0671936840905293};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.230940107675851, 0.121716123890037, -0.0702728368926306, 0.0993807989999907, 0.0, 0.0, 0.102868899974728, 0.0, -0.0593913870916499, -0.0671936840905293};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, 0.121716123890037, 0.0702728368926307, -0.0993807989999907, 0.0, 0.100790526135794, -0.0205737799949456, -0.087287156094397, -0.01187827741833, 0.0167984210226323};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, -0.121716123890037, -0.0702728368926307, 0.0993807989999906, 0.0, 0.0, -0.102868899974728, 0.0, -0.0593913870916499, -0.0671936840905293};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, -0.121716123890037, 0.0702728368926306, -0.0993807989999906, 0.0, -0.100790526135794, 0.0205737799949456, -0.0872871560943969, -0.01187827741833, 0.0167984210226323};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, 0.0, -0.140545673785261, -0.0993807989999906, -0.130120009726471, 0.0, 0.0, 0.0290957186981323, 0.02375655483666, 0.0167984210226323};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 10:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {-0.0577350269189626, -0.0608580619450185, -0.0351364184463153, -0.0248451997499977, 0.0650600048632355, 0.050395263067897, 0.0411475599898912, 0.0290957186981323, 0.0237565548366599, 0.0167984210226323};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 11:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {-0.0577350269189625, 0.0608580619450185, -0.0351364184463153, -0.0248451997499977, 0.0650600048632355, -0.050395263067897, -0.0411475599898912, 0.0290957186981323, 0.0237565548366599, 0.0167984210226323};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 12:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {-0.0577350269189626, 0.0, 0.0702728368926306, -0.0248451997499977, 0.0, 0.0, 0.0, 0.0872871560943969, -0.0475131096733199, 0.0167984210226323};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 13:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {-0.0577350269189626, 0.0, 0.0, 0.074535599249993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.100790526135794};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 14:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, 0.0, 0.140545673785261, 0.0993807989999906, 0.0, 0.0, 0.0, 0.0, 0.1187827741833, -0.0671936840905293};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 15:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.230940107675851, 0.121716123890037, -0.0702728368926306, 0.0993807989999907, 0.0, 0.0, 0.102868899974728, 0.0, -0.0593913870916499, -0.0671936840905293};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 16:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, 0.121716123890037, 0.0702728368926307, -0.0993807989999907, 0.0, 0.100790526135794, -0.0205737799949456, -0.087287156094397, -0.01187827741833, 0.0167984210226323};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 17:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, -0.121716123890037, -0.0702728368926307, 0.0993807989999906, 0.0, 0.0, -0.102868899974728, 0.0, -0.0593913870916499, -0.0671936840905293};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 18:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, -0.121716123890037, 0.0702728368926306, -0.0993807989999906, 0.0, -0.100790526135794, 0.0205737799949456, -0.0872871560943969, -0.01187827741833, 0.0167984210226323};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 19:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, 0.0, -0.140545673785261, -0.0993807989999906, -0.130120009726471, 0.0, 0.0, 0.0290957186981323, 0.02375655483666, 0.0167984210226323};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 20:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {-0.0577350269189626, -0.0608580619450185, -0.0351364184463153, -0.0248451997499977, 0.0650600048632355, 0.050395263067897, 0.0411475599898912, 0.0290957186981323, 0.0237565548366599, 0.0167984210226323};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 21:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {-0.0577350269189625, 0.0608580619450185, -0.0351364184463153, -0.0248451997499977, 0.0650600048632355, -0.050395263067897, -0.0411475599898912, 0.0290957186981323, 0.0237565548366599, 0.0167984210226323};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 22:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {-0.0577350269189626, 0.0, 0.0702728368926306, -0.0248451997499977, 0.0, 0.0, 0.0, 0.0872871560943969, -0.0475131096733199, 0.0167984210226323};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 23:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {-0.0577350269189626, 0.0, 0.0, 0.074535599249993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.100790526135794};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 24:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, 0.0, 0.140545673785261, 0.0993807989999906, 0.0, 0.0, 0.0, 0.0, 0.1187827741833, -0.0671936840905293};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 25:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.230940107675851, 0.121716123890037, -0.0702728368926306, 0.0993807989999907, 0.0, 0.0, 0.102868899974728, 0.0, -0.0593913870916499, -0.0671936840905293};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 26:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, 0.121716123890037, 0.0702728368926307, -0.0993807989999907, 0.0, 0.100790526135794, -0.0205737799949456, -0.087287156094397, -0.01187827741833, 0.0167984210226323};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 27:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, -0.121716123890037, -0.0702728368926307, 0.0993807989999906, 0.0, 0.0, -0.102868899974728, 0.0, -0.0593913870916499, -0.0671936840905293};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 28:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, -0.121716123890037, 0.0702728368926306, -0.0993807989999906, 0.0, -0.100790526135794, 0.0205737799949456, -0.0872871560943969, -0.01187827741833, 0.0167984210226323};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 29:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, 0.0, -0.140545673785261, -0.0993807989999906, -0.130120009726471, 0.0, 0.0, 0.0290957186981323, 0.02375655483666, 0.0167984210226323};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values[3] = {0.0, 0.0, 0.0};
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 30; r++)
    {
      evaluate_basis(r, dof_values, coordinates, c);
      for (unsigned int s = 0; s < 3; s++)
      {
        values[r*3 + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    const double K_00 = d_00 / detJ;
    const double K_01 = d_10 / detJ;
    const double K_02 = d_20 / detJ;
    const double K_10 = d_01 / detJ;
    const double K_11 = d_11 / detJ;
    const double K_12 = d_21 / detJ;
    const double K_20 = d_02 / detJ;
    const double K_21 = d_12 / detJ;
    const double K_22 = d_22 / detJ;
    
    // Compute constants
    const double C0 = x[3][0] + x[2][0] + x[1][0] - x[0][0];
    const double C1 = x[3][1] + x[2][1] + x[1][1] - x[0][1];
    const double C2 = x[3][2] + x[2][2] + x[1][2] - x[0][2];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*coordinates[0] - C0) + d_10*(2.0*coordinates[1] - C1) + d_20*(2.0*coordinates[2] - C2)) / detJ;
    double Y = (d_01*(2.0*coordinates[0] - C0) + d_11*(2.0*coordinates[1] - C1) + d_21*(2.0*coordinates[2] - C2)) / detJ;
    double Z = (d_02*(2.0*coordinates[0] - C0) + d_12*(2.0*coordinates[1] - C1) + d_22*(2.0*coordinates[2] - C2)) / detJ;
    
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K_00, K_01, K_02}, {K_10, K_11, K_12}, {K_20, K_21, K_22}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < 3*num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {-0.0577350269189626, -0.0608580619450185, -0.0351364184463153, -0.0248451997499977, 0.0650600048632355, 0.050395263067897, 0.0411475599898912, 0.0290957186981323, 0.0237565548366599, 0.0167984210226323};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534075, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.683130051063973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {-0.0577350269189625, 0.0608580619450185, -0.0351364184463153, -0.0248451997499977, 0.0650600048632355, -0.050395263067897, -0.0411475599898912, 0.0290957186981323, 0.0237565548366599, 0.0167984210226323};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534075, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.683130051063973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {-0.0577350269189626, 0.0, 0.0702728368926306, -0.0248451997499977, 0.0, 0.0, 0.0, 0.0872871560943969, -0.0475131096733199, 0.0167984210226323};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534075, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.683130051063973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {-0.0577350269189626, 0.0, 0.0, 0.074535599249993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.100790526135794};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534075, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.683130051063973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, 0.0, 0.140545673785261, 0.0993807989999906, 0.0, 0.0, 0.0, 0.0, 0.1187827741833, -0.0671936840905293};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534075, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.683130051063973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.230940107675851, 0.121716123890037, -0.0702728368926306, 0.0993807989999907, 0.0, 0.0, 0.102868899974728, 0.0, -0.0593913870916499, -0.0671936840905293};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534075, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.683130051063973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, 0.121716123890037, 0.0702728368926307, -0.0993807989999907, 0.0, 0.100790526135794, -0.0205737799949456, -0.087287156094397, -0.01187827741833, 0.0167984210226323};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534075, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.683130051063973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, -0.121716123890037, -0.0702728368926307, 0.0993807989999906, 0.0, 0.0, -0.102868899974728, 0.0, -0.0593913870916499, -0.0671936840905293};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534075, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.683130051063973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, -0.121716123890037, 0.0702728368926306, -0.0993807989999906, 0.0, -0.100790526135794, 0.0205737799949456, -0.0872871560943969, -0.01187827741833, 0.0167984210226323};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534075, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.683130051063973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, 0.0, -0.140545673785261, -0.0993807989999906, -0.130120009726471, 0.0, 0.0, 0.0290957186981323, 0.02375655483666, 0.0167984210226323};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534075, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.683130051063973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 10:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {-0.0577350269189626, -0.0608580619450185, -0.0351364184463153, -0.0248451997499977, 0.0650600048632355, 0.050395263067897, 0.0411475599898912, 0.0290957186981323, 0.0237565548366599, 0.0167984210226323};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534075, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.683130051063973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 11:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {-0.0577350269189625, 0.0608580619450185, -0.0351364184463153, -0.0248451997499977, 0.0650600048632355, -0.050395263067897, -0.0411475599898912, 0.0290957186981323, 0.0237565548366599, 0.0167984210226323};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534075, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.683130051063973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 12:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {-0.0577350269189626, 0.0, 0.0702728368926306, -0.0248451997499977, 0.0, 0.0, 0.0, 0.0872871560943969, -0.0475131096733199, 0.0167984210226323};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534075, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.683130051063973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 13:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {-0.0577350269189626, 0.0, 0.0, 0.074535599249993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.100790526135794};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534075, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.683130051063973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 14:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, 0.0, 0.140545673785261, 0.0993807989999906, 0.0, 0.0, 0.0, 0.0, 0.1187827741833, -0.0671936840905293};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534075, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.683130051063973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 15:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.230940107675851, 0.121716123890037, -0.0702728368926306, 0.0993807989999907, 0.0, 0.0, 0.102868899974728, 0.0, -0.0593913870916499, -0.0671936840905293};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534075, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.683130051063973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 16:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, 0.121716123890037, 0.0702728368926307, -0.0993807989999907, 0.0, 0.100790526135794, -0.0205737799949456, -0.087287156094397, -0.01187827741833, 0.0167984210226323};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534075, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.683130051063973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 17:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, -0.121716123890037, -0.0702728368926307, 0.0993807989999906, 0.0, 0.0, -0.102868899974728, 0.0, -0.0593913870916499, -0.0671936840905293};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534075, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.683130051063973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 18:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, -0.121716123890037, 0.0702728368926306, -0.0993807989999906, 0.0, -0.100790526135794, 0.0205737799949456, -0.0872871560943969, -0.01187827741833, 0.0167984210226323};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534075, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.683130051063973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 19:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, 0.0, -0.140545673785261, -0.0993807989999906, -0.130120009726471, 0.0, 0.0, 0.0290957186981323, 0.02375655483666, 0.0167984210226323};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534075, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.683130051063973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 20:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {-0.0577350269189626, -0.0608580619450185, -0.0351364184463153, -0.0248451997499977, 0.0650600048632355, 0.050395263067897, 0.0411475599898912, 0.0290957186981323, 0.0237565548366599, 0.0167984210226323};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534075, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.683130051063973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 21:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {-0.0577350269189625, 0.0608580619450185, -0.0351364184463153, -0.0248451997499977, 0.0650600048632355, -0.050395263067897, -0.0411475599898912, 0.0290957186981323, 0.0237565548366599, 0.0167984210226323};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534075, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.683130051063973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 22:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {-0.0577350269189626, 0.0, 0.0702728368926306, -0.0248451997499977, 0.0, 0.0, 0.0, 0.0872871560943969, -0.0475131096733199, 0.0167984210226323};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534075, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.683130051063973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 23:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {-0.0577350269189626, 0.0, 0.0, 0.074535599249993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.100790526135794};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534075, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.683130051063973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 24:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, 0.0, 0.140545673785261, 0.0993807989999906, 0.0, 0.0, 0.0, 0.0, 0.1187827741833, -0.0671936840905293};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534075, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.683130051063973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 25:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.230940107675851, 0.121716123890037, -0.0702728368926306, 0.0993807989999907, 0.0, 0.0, 0.102868899974728, 0.0, -0.0593913870916499, -0.0671936840905293};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534075, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.683130051063973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 26:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, 0.121716123890037, 0.0702728368926307, -0.0993807989999907, 0.0, 0.100790526135794, -0.0205737799949456, -0.087287156094397, -0.01187827741833, 0.0167984210226323};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534075, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.683130051063973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 27:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, -0.121716123890037, -0.0702728368926307, 0.0993807989999906, 0.0, 0.0, -0.102868899974728, 0.0, -0.0593913870916499, -0.0671936840905293};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534075, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.683130051063973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 28:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, -0.121716123890037, 0.0702728368926306, -0.0993807989999906, 0.0, -0.100790526135794, 0.0205737799949456, -0.0872871560943969, -0.01187827741833, 0.0167984210226323};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534075, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.683130051063973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 29:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, 0.0, -0.140545673785261, -0.0993807989999906, -0.130120009726471, 0.0, 0.0, 0.0290957186981323, 0.02375655483666, 0.0167984210226323};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534075, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.683130051063973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[3*num_derivatives];
    for (unsigned int r = 0; r < 3*num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 30; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < 3*num_derivatives; s++)
      {
        values[r*3*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[3];
    
    // Declare variable for physical coordinates.
    double y[3];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      y[2] = x[0][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      y[2] = x[1][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      y[2] = x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = x[3][0];
      y[1] = x[3][1];
      y[2] = x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.5*x[2][0] + 0.5*x[3][0];
      y[1] = 0.5*x[2][1] + 0.5*x[3][1];
      y[2] = 0.5*x[2][2] + 0.5*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.5*x[1][0] + 0.5*x[3][0];
      y[1] = 0.5*x[1][1] + 0.5*x[3][1];
      y[2] = 0.5*x[1][2] + 0.5*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 6:
      {
        y[0] = 0.5*x[1][0] + 0.5*x[2][0];
      y[1] = 0.5*x[1][1] + 0.5*x[2][1];
      y[2] = 0.5*x[1][2] + 0.5*x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 7:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[3][0];
      y[1] = 0.5*x[0][1] + 0.5*x[3][1];
      y[2] = 0.5*x[0][2] + 0.5*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 8:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[2][0];
      y[1] = 0.5*x[0][1] + 0.5*x[2][1];
      y[2] = 0.5*x[0][2] + 0.5*x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 9:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[1][0];
      y[1] = 0.5*x[0][1] + 0.5*x[1][1];
      y[2] = 0.5*x[0][2] + 0.5*x[1][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 10:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      y[2] = x[0][2];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 11:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      y[2] = x[1][2];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 12:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      y[2] = x[2][2];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 13:
      {
        y[0] = x[3][0];
      y[1] = x[3][1];
      y[2] = x[3][2];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 14:
      {
        y[0] = 0.5*x[2][0] + 0.5*x[3][0];
      y[1] = 0.5*x[2][1] + 0.5*x[3][1];
      y[2] = 0.5*x[2][2] + 0.5*x[3][2];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 15:
      {
        y[0] = 0.5*x[1][0] + 0.5*x[3][0];
      y[1] = 0.5*x[1][1] + 0.5*x[3][1];
      y[2] = 0.5*x[1][2] + 0.5*x[3][2];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 16:
      {
        y[0] = 0.5*x[1][0] + 0.5*x[2][0];
      y[1] = 0.5*x[1][1] + 0.5*x[2][1];
      y[2] = 0.5*x[1][2] + 0.5*x[2][2];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 17:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[3][0];
      y[1] = 0.5*x[0][1] + 0.5*x[3][1];
      y[2] = 0.5*x[0][2] + 0.5*x[3][2];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 18:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[2][0];
      y[1] = 0.5*x[0][1] + 0.5*x[2][1];
      y[2] = 0.5*x[0][2] + 0.5*x[2][2];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 19:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[1][0];
      y[1] = 0.5*x[0][1] + 0.5*x[1][1];
      y[2] = 0.5*x[0][2] + 0.5*x[1][2];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 20:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      y[2] = x[0][2];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 21:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      y[2] = x[1][2];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 22:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      y[2] = x[2][2];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 23:
      {
        y[0] = x[3][0];
      y[1] = x[3][1];
      y[2] = x[3][2];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 24:
      {
        y[0] = 0.5*x[2][0] + 0.5*x[3][0];
      y[1] = 0.5*x[2][1] + 0.5*x[3][1];
      y[2] = 0.5*x[2][2] + 0.5*x[3][2];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 25:
      {
        y[0] = 0.5*x[1][0] + 0.5*x[3][0];
      y[1] = 0.5*x[1][1] + 0.5*x[3][1];
      y[2] = 0.5*x[1][2] + 0.5*x[3][2];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 26:
      {
        y[0] = 0.5*x[1][0] + 0.5*x[2][0];
      y[1] = 0.5*x[1][1] + 0.5*x[2][1];
      y[2] = 0.5*x[1][2] + 0.5*x[2][2];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 27:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[3][0];
      y[1] = 0.5*x[0][1] + 0.5*x[3][1];
      y[2] = 0.5*x[0][2] + 0.5*x[3][2];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 28:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[2][0];
      y[1] = 0.5*x[0][1] + 0.5*x[2][1];
      y[2] = 0.5*x[0][2] + 0.5*x[2][2];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 29:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[1][0];
      y[1] = 0.5*x[0][1] + 0.5*x[1][1];
      y[2] = 0.5*x[0][2] + 0.5*x[1][2];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[3];
    
    // Declare variable for physical coordinates.
    double y[3];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    y[2] = x[0][2];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    y[2] = x[1][2];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    y[2] = x[2][2];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = x[3][0];
    y[1] = x[3][1];
    y[2] = x[3][2];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.5*x[2][0] + 0.5*x[3][0];
    y[1] = 0.5*x[2][1] + 0.5*x[3][1];
    y[2] = 0.5*x[2][2] + 0.5*x[3][2];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.5*x[1][0] + 0.5*x[3][0];
    y[1] = 0.5*x[1][1] + 0.5*x[3][1];
    y[2] = 0.5*x[1][2] + 0.5*x[3][2];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
    y[0] = 0.5*x[1][0] + 0.5*x[2][0];
    y[1] = 0.5*x[1][1] + 0.5*x[2][1];
    y[2] = 0.5*x[1][2] + 0.5*x[2][2];
    f.evaluate(vals, y, c);
    values[6] = vals[0];
    y[0] = 0.5*x[0][0] + 0.5*x[3][0];
    y[1] = 0.5*x[0][1] + 0.5*x[3][1];
    y[2] = 0.5*x[0][2] + 0.5*x[3][2];
    f.evaluate(vals, y, c);
    values[7] = vals[0];
    y[0] = 0.5*x[0][0] + 0.5*x[2][0];
    y[1] = 0.5*x[0][1] + 0.5*x[2][1];
    y[2] = 0.5*x[0][2] + 0.5*x[2][2];
    f.evaluate(vals, y, c);
    values[8] = vals[0];
    y[0] = 0.5*x[0][0] + 0.5*x[1][0];
    y[1] = 0.5*x[0][1] + 0.5*x[1][1];
    y[2] = 0.5*x[0][2] + 0.5*x[1][2];
    f.evaluate(vals, y, c);
    values[9] = vals[0];
    y[0] = x[0][0];
    y[1] = x[0][1];
    y[2] = x[0][2];
    f.evaluate(vals, y, c);
    values[10] = vals[1];
    y[0] = x[1][0];
    y[1] = x[1][1];
    y[2] = x[1][2];
    f.evaluate(vals, y, c);
    values[11] = vals[1];
    y[0] = x[2][0];
    y[1] = x[2][1];
    y[2] = x[2][2];
    f.evaluate(vals, y, c);
    values[12] = vals[1];
    y[0] = x[3][0];
    y[1] = x[3][1];
    y[2] = x[3][2];
    f.evaluate(vals, y, c);
    values[13] = vals[1];
    y[0] = 0.5*x[2][0] + 0.5*x[3][0];
    y[1] = 0.5*x[2][1] + 0.5*x[3][1];
    y[2] = 0.5*x[2][2] + 0.5*x[3][2];
    f.evaluate(vals, y, c);
    values[14] = vals[1];
    y[0] = 0.5*x[1][0] + 0.5*x[3][0];
    y[1] = 0.5*x[1][1] + 0.5*x[3][1];
    y[2] = 0.5*x[1][2] + 0.5*x[3][2];
    f.evaluate(vals, y, c);
    values[15] = vals[1];
    y[0] = 0.5*x[1][0] + 0.5*x[2][0];
    y[1] = 0.5*x[1][1] + 0.5*x[2][1];
    y[2] = 0.5*x[1][2] + 0.5*x[2][2];
    f.evaluate(vals, y, c);
    values[16] = vals[1];
    y[0] = 0.5*x[0][0] + 0.5*x[3][0];
    y[1] = 0.5*x[0][1] + 0.5*x[3][1];
    y[2] = 0.5*x[0][2] + 0.5*x[3][2];
    f.evaluate(vals, y, c);
    values[17] = vals[1];
    y[0] = 0.5*x[0][0] + 0.5*x[2][0];
    y[1] = 0.5*x[0][1] + 0.5*x[2][1];
    y[2] = 0.5*x[0][2] + 0.5*x[2][2];
    f.evaluate(vals, y, c);
    values[18] = vals[1];
    y[0] = 0.5*x[0][0] + 0.5*x[1][0];
    y[1] = 0.5*x[0][1] + 0.5*x[1][1];
    y[2] = 0.5*x[0][2] + 0.5*x[1][2];
    f.evaluate(vals, y, c);
    values[19] = vals[1];
    y[0] = x[0][0];
    y[1] = x[0][1];
    y[2] = x[0][2];
    f.evaluate(vals, y, c);
    values[20] = vals[2];
    y[0] = x[1][0];
    y[1] = x[1][1];
    y[2] = x[1][2];
    f.evaluate(vals, y, c);
    values[21] = vals[2];
    y[0] = x[2][0];
    y[1] = x[2][1];
    y[2] = x[2][2];
    f.evaluate(vals, y, c);
    values[22] = vals[2];
    y[0] = x[3][0];
    y[1] = x[3][1];
    y[2] = x[3][2];
    f.evaluate(vals, y, c);
    values[23] = vals[2];
    y[0] = 0.5*x[2][0] + 0.5*x[3][0];
    y[1] = 0.5*x[2][1] + 0.5*x[3][1];
    y[2] = 0.5*x[2][2] + 0.5*x[3][2];
    f.evaluate(vals, y, c);
    values[24] = vals[2];
    y[0] = 0.5*x[1][0] + 0.5*x[3][0];
    y[1] = 0.5*x[1][1] + 0.5*x[3][1];
    y[2] = 0.5*x[1][2] + 0.5*x[3][2];
    f.evaluate(vals, y, c);
    values[25] = vals[2];
    y[0] = 0.5*x[1][0] + 0.5*x[2][0];
    y[1] = 0.5*x[1][1] + 0.5*x[2][1];
    y[2] = 0.5*x[1][2] + 0.5*x[2][2];
    f.evaluate(vals, y, c);
    values[26] = vals[2];
    y[0] = 0.5*x[0][0] + 0.5*x[3][0];
    y[1] = 0.5*x[0][1] + 0.5*x[3][1];
    y[2] = 0.5*x[0][2] + 0.5*x[3][2];
    f.evaluate(vals, y, c);
    values[27] = vals[2];
    y[0] = 0.5*x[0][0] + 0.5*x[2][0];
    y[1] = 0.5*x[0][1] + 0.5*x[2][1];
    y[2] = 0.5*x[0][2] + 0.5*x[2][2];
    f.evaluate(vals, y, c);
    values[28] = vals[2];
    y[0] = 0.5*x[0][0] + 0.5*x[1][0];
    y[1] = 0.5*x[0][1] + 0.5*x[1][1];
    y[2] = 0.5*x[0][2] + 0.5*x[1][2];
    f.evaluate(vals, y, c);
    values[29] = vals[2];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[3] = dof_values[1];
    vertex_values[6] = dof_values[2];
    vertex_values[9] = dof_values[3];
    // Evaluate function and change variables
    vertex_values[1] = dof_values[10];
    vertex_values[4] = dof_values[11];
    vertex_values[7] = dof_values[12];
    vertex_values[10] = dof_values[13];
    // Evaluate function and change variables
    vertex_values[2] = dof_values[20];
    vertex_values[5] = dof_values[21];
    vertex_values[8] = dof_values[22];
    vertex_values[11] = dof_values[23];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 3;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new stokes_finite_element_0();
        break;
      }
    case 1:
      {
        return new stokes_finite_element_0();
        break;
      }
    case 2:
      {
        return new stokes_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new stokes_finite_element_1();
  }

};

/// This class defines the interface for a finite element.

class stokes_finite_element_2: public ufc::finite_element
{
public:

  /// Constructor
  stokes_finite_element_2() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~stokes_finite_element_2()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::tetrahedron;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 3;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 3;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 4;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[3][0] + x[2][0] + x[1][0] - x[0][0];
    const double C1 = x[3][1] + x[2][1] + x[1][1] - x[0][1];
    const double C2 = x[3][2] + x[2][2] + x[1][2] - x[0][2];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*coordinates[0] - C0) + d_10*(2.0*coordinates[1] - C1) + d_20*(2.0*coordinates[2] - C2)) / detJ;
    double Y = (d_01*(2.0*coordinates[0] - C0) + d_11*(2.0*coordinates[1] - C1) + d_21*(2.0*coordinates[2] - C2)) / detJ;
    double Z = (d_02*(2.0*coordinates[0] - C0) + d_12*(2.0*coordinates[1] - C1) + d_22*(2.0*coordinates[2] - C2)) / detJ;
    
    
    // Reset values.
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 4; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    const double K_00 = d_00 / detJ;
    const double K_01 = d_10 / detJ;
    const double K_02 = d_20 / detJ;
    const double K_10 = d_01 / detJ;
    const double K_11 = d_11 / detJ;
    const double K_12 = d_21 / detJ;
    const double K_20 = d_02 / detJ;
    const double K_21 = d_12 / detJ;
    const double K_22 = d_22 / detJ;
    
    // Compute constants
    const double C0 = x[3][0] + x[2][0] + x[1][0] - x[0][0];
    const double C1 = x[3][1] + x[2][1] + x[1][1] - x[0][1];
    const double C2 = x[3][2] + x[2][2] + x[1][2] - x[0][2];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*coordinates[0] - C0) + d_10*(2.0*coordinates[1] - C1) + d_20*(2.0*coordinates[2] - C2)) / detJ;
    double Y = (d_01*(2.0*coordinates[0] - C0) + d_11*(2.0*coordinates[1] - C1) + d_21*(2.0*coordinates[2] - C2)) / detJ;
    double Z = (d_02*(2.0*coordinates[0] - C0) + d_12*(2.0*coordinates[1] - C1) + d_22*(2.0*coordinates[2] - C2)) / detJ;
    
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K_00, K_01, K_02}, {K_10, K_11, K_12}, {K_20, K_21, K_22}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 4; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[3];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      y[2] = x[0][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      y[2] = x[1][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      y[2] = x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = x[3][0];
      y[1] = x[3][1];
      y[2] = x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[3];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    y[2] = x[0][2];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    y[2] = x[1][2];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    y[2] = x[2][2];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = x[3][0];
    y[1] = x[3][1];
    y[2] = x[3][2];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
    vertex_values[3] = dof_values[3];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new stokes_finite_element_2();
  }

};

/// This class defines the interface for a finite element.

class stokes_finite_element_3: public ufc::finite_element
{
public:

  /// Constructor
  stokes_finite_element_3() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~stokes_finite_element_3()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "MixedElement(*[VectorElement('Lagrange', Cell('tetrahedron', Space(3)), 2, 3, None), FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 1, None)], **{'value_shape': (4,) })";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::tetrahedron;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 3;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 3;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 34;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 1;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return 4;
        break;
      }
    }
    
    return 0;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[3][0] + x[2][0] + x[1][0] - x[0][0];
    const double C1 = x[3][1] + x[2][1] + x[1][1] - x[0][1];
    const double C2 = x[3][2] + x[2][2] + x[1][2] - x[0][2];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*coordinates[0] - C0) + d_10*(2.0*coordinates[1] - C1) + d_20*(2.0*coordinates[2] - C2)) / detJ;
    double Y = (d_01*(2.0*coordinates[0] - C0) + d_11*(2.0*coordinates[1] - C1) + d_21*(2.0*coordinates[2] - C2)) / detJ;
    double Z = (d_02*(2.0*coordinates[0] - C0) + d_12*(2.0*coordinates[1] - C1) + d_22*(2.0*coordinates[2] - C2)) / detJ;
    
    
    // Reset values.
    values[0] = 0.0;
    values[1] = 0.0;
    values[2] = 0.0;
    values[3] = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {-0.0577350269189626, -0.0608580619450185, -0.0351364184463153, -0.0248451997499977, 0.0650600048632355, 0.050395263067897, 0.0411475599898912, 0.0290957186981323, 0.0237565548366599, 0.0167984210226323};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {-0.0577350269189625, 0.0608580619450185, -0.0351364184463153, -0.0248451997499977, 0.0650600048632355, -0.050395263067897, -0.0411475599898912, 0.0290957186981323, 0.0237565548366599, 0.0167984210226323};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {-0.0577350269189626, 0.0, 0.0702728368926306, -0.0248451997499977, 0.0, 0.0, 0.0, 0.0872871560943969, -0.0475131096733199, 0.0167984210226323};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {-0.0577350269189626, 0.0, 0.0, 0.074535599249993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.100790526135794};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, 0.0, 0.140545673785261, 0.0993807989999906, 0.0, 0.0, 0.0, 0.0, 0.1187827741833, -0.0671936840905293};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.230940107675851, 0.121716123890037, -0.0702728368926306, 0.0993807989999907, 0.0, 0.0, 0.102868899974728, 0.0, -0.0593913870916499, -0.0671936840905293};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, 0.121716123890037, 0.0702728368926307, -0.0993807989999907, 0.0, 0.100790526135794, -0.0205737799949456, -0.087287156094397, -0.01187827741833, 0.0167984210226323};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, -0.121716123890037, -0.0702728368926307, 0.0993807989999906, 0.0, 0.0, -0.102868899974728, 0.0, -0.0593913870916499, -0.0671936840905293};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, -0.121716123890037, 0.0702728368926306, -0.0993807989999906, 0.0, -0.100790526135794, 0.0205737799949456, -0.0872871560943969, -0.01187827741833, 0.0167984210226323};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, 0.0, -0.140545673785261, -0.0993807989999906, -0.130120009726471, 0.0, 0.0, 0.0290957186981323, 0.02375655483666, 0.0167984210226323};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 10:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {-0.0577350269189626, -0.0608580619450185, -0.0351364184463153, -0.0248451997499977, 0.0650600048632355, 0.050395263067897, 0.0411475599898912, 0.0290957186981323, 0.0237565548366599, 0.0167984210226323};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 11:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {-0.0577350269189625, 0.0608580619450185, -0.0351364184463153, -0.0248451997499977, 0.0650600048632355, -0.050395263067897, -0.0411475599898912, 0.0290957186981323, 0.0237565548366599, 0.0167984210226323};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 12:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {-0.0577350269189626, 0.0, 0.0702728368926306, -0.0248451997499977, 0.0, 0.0, 0.0, 0.0872871560943969, -0.0475131096733199, 0.0167984210226323};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 13:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {-0.0577350269189626, 0.0, 0.0, 0.074535599249993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.100790526135794};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 14:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, 0.0, 0.140545673785261, 0.0993807989999906, 0.0, 0.0, 0.0, 0.0, 0.1187827741833, -0.0671936840905293};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 15:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.230940107675851, 0.121716123890037, -0.0702728368926306, 0.0993807989999907, 0.0, 0.0, 0.102868899974728, 0.0, -0.0593913870916499, -0.0671936840905293};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 16:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, 0.121716123890037, 0.0702728368926307, -0.0993807989999907, 0.0, 0.100790526135794, -0.0205737799949456, -0.087287156094397, -0.01187827741833, 0.0167984210226323};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 17:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, -0.121716123890037, -0.0702728368926307, 0.0993807989999906, 0.0, 0.0, -0.102868899974728, 0.0, -0.0593913870916499, -0.0671936840905293};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 18:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, -0.121716123890037, 0.0702728368926306, -0.0993807989999906, 0.0, -0.100790526135794, 0.0205737799949456, -0.0872871560943969, -0.01187827741833, 0.0167984210226323};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 19:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, 0.0, -0.140545673785261, -0.0993807989999906, -0.130120009726471, 0.0, 0.0, 0.0290957186981323, 0.02375655483666, 0.0167984210226323};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 20:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {-0.0577350269189626, -0.0608580619450185, -0.0351364184463153, -0.0248451997499977, 0.0650600048632355, 0.050395263067897, 0.0411475599898912, 0.0290957186981323, 0.0237565548366599, 0.0167984210226323};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 21:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {-0.0577350269189625, 0.0608580619450185, -0.0351364184463153, -0.0248451997499977, 0.0650600048632355, -0.050395263067897, -0.0411475599898912, 0.0290957186981323, 0.0237565548366599, 0.0167984210226323};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 22:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {-0.0577350269189626, 0.0, 0.0702728368926306, -0.0248451997499977, 0.0, 0.0, 0.0, 0.0872871560943969, -0.0475131096733199, 0.0167984210226323};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 23:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {-0.0577350269189626, 0.0, 0.0, 0.074535599249993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.100790526135794};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 24:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, 0.0, 0.140545673785261, 0.0993807989999906, 0.0, 0.0, 0.0, 0.0, 0.1187827741833, -0.0671936840905293};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 25:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.230940107675851, 0.121716123890037, -0.0702728368926306, 0.0993807989999907, 0.0, 0.0, 0.102868899974728, 0.0, -0.0593913870916499, -0.0671936840905293};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 26:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, 0.121716123890037, 0.0702728368926307, -0.0993807989999907, 0.0, 0.100790526135794, -0.0205737799949456, -0.087287156094397, -0.01187827741833, 0.0167984210226323};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 27:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, -0.121716123890037, -0.0702728368926307, 0.0993807989999906, 0.0, 0.0, -0.102868899974728, 0.0, -0.0593913870916499, -0.0671936840905293};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 28:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, -0.121716123890037, 0.0702728368926306, -0.0993807989999906, 0.0, -0.100790526135794, 0.0205737799949456, -0.0872871560943969, -0.01187827741833, 0.0167984210226323};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 29:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, 0.0, -0.140545673785261, -0.0993807989999906, -0.130120009726471, 0.0, 0.0, 0.0290957186981323, 0.02375655483666, 0.0167984210226323};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 30:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        values[3] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 31:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        values[3] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 32:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        values[3] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 33:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        values[3] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values[4] = {0.0, 0.0, 0.0, 0.0};
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 34; r++)
    {
      evaluate_basis(r, dof_values, coordinates, c);
      for (unsigned int s = 0; s < 4; s++)
      {
        values[r*4 + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    const double K_00 = d_00 / detJ;
    const double K_01 = d_10 / detJ;
    const double K_02 = d_20 / detJ;
    const double K_10 = d_01 / detJ;
    const double K_11 = d_11 / detJ;
    const double K_12 = d_21 / detJ;
    const double K_20 = d_02 / detJ;
    const double K_21 = d_12 / detJ;
    const double K_22 = d_22 / detJ;
    
    // Compute constants
    const double C0 = x[3][0] + x[2][0] + x[1][0] - x[0][0];
    const double C1 = x[3][1] + x[2][1] + x[1][1] - x[0][1];
    const double C2 = x[3][2] + x[2][2] + x[1][2] - x[0][2];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*coordinates[0] - C0) + d_10*(2.0*coordinates[1] - C1) + d_20*(2.0*coordinates[2] - C2)) / detJ;
    double Y = (d_01*(2.0*coordinates[0] - C0) + d_11*(2.0*coordinates[1] - C1) + d_21*(2.0*coordinates[2] - C2)) / detJ;
    double Z = (d_02*(2.0*coordinates[0] - C0) + d_12*(2.0*coordinates[1] - C1) + d_22*(2.0*coordinates[2] - C2)) / detJ;
    
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K_00, K_01, K_02}, {K_10, K_11, K_12}, {K_20, K_21, K_22}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < 4*num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {-0.0577350269189626, -0.0608580619450185, -0.0351364184463153, -0.0248451997499977, 0.0650600048632355, 0.050395263067897, 0.0411475599898912, 0.0290957186981323, 0.0237565548366599, 0.0167984210226323};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534075, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.683130051063973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {-0.0577350269189625, 0.0608580619450185, -0.0351364184463153, -0.0248451997499977, 0.0650600048632355, -0.050395263067897, -0.0411475599898912, 0.0290957186981323, 0.0237565548366599, 0.0167984210226323};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534075, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.683130051063973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {-0.0577350269189626, 0.0, 0.0702728368926306, -0.0248451997499977, 0.0, 0.0, 0.0, 0.0872871560943969, -0.0475131096733199, 0.0167984210226323};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534075, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.683130051063973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {-0.0577350269189626, 0.0, 0.0, 0.074535599249993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.100790526135794};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534075, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.683130051063973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, 0.0, 0.140545673785261, 0.0993807989999906, 0.0, 0.0, 0.0, 0.0, 0.1187827741833, -0.0671936840905293};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534075, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.683130051063973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.230940107675851, 0.121716123890037, -0.0702728368926306, 0.0993807989999907, 0.0, 0.0, 0.102868899974728, 0.0, -0.0593913870916499, -0.0671936840905293};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534075, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.683130051063973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, 0.121716123890037, 0.0702728368926307, -0.0993807989999907, 0.0, 0.100790526135794, -0.0205737799949456, -0.087287156094397, -0.01187827741833, 0.0167984210226323};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534075, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.683130051063973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, -0.121716123890037, -0.0702728368926307, 0.0993807989999906, 0.0, 0.0, -0.102868899974728, 0.0, -0.0593913870916499, -0.0671936840905293};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534075, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.683130051063973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.0 + 2.0*r)/(1.0 + r) - basisvalues[tt]*tmp1*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.0 + Y) + (2.0 + Z + 3.0*Y)/2.0);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.0 + r + s + Z*(2.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 2.0*r + 2.0*s + 2.0*t)/(2.0*(1.0 + t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp6 = (3.0 + 2.0*r + 2.0*s + 2.0*t)*(4.0 + 4.0*r*r + 4.0*s*s + 8.0*r*s + 8.0*r + 8.0*s)/(2.0*(1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            tmp7 = (2.0 + t + 2.0*r + 2.0*s)*(4.0 + 2.0*r + 2.0*s + 2.0*t)*t/((1.0 + t)*(2.0 + 2.0*r + 2.0*s + 2.0*t)*(3.0 + t + 2.0*r + 2.0*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s)*(1.5 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.23094010767585, -0.121716123890037, 0.0702728368926306, -0.0993807989999906, 0.0, -0.100790526135794, 0.0205737799949456, -0.0872871560943969, -0.01187827741833, 0.0167984210226323};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495584, 0.0, 8.36660026534075, -1.18321595661992, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677394, 0.0, 0.0, 8.69482604771366, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 7.24568837309472, 4.18330013267038, -0.591607978309961, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 0.0, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106459, 0.0, 9.66091783079296, 0.683130051063973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920393, 0.0, 0.0, 7.52994023880668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.95803989154981, 5.61248608016091, -1.08012344973464, -0.763762615825973, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461894, 4.18330013267038, -0.591607978309962, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, 7.09929573971954, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, 0.0, 3.86436713231718, -0.341565025531987, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, 0.0, 7.09929573971954, 2.50998007960223, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912987, 0.0, 0.0, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }