// This code conforms with the UFC specification version 2.0.0
// and was automatically generated by FFC version 0.9.10.
//
// This code was generated with the option '-l dolfin' and
// contains DOLFIN-specific wrappers that depend on DOLFIN.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   False
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'dolfin'
//   log_level:                      10
//   log_prefix:                     ''
//   no_ferari:                      True
//   optimize:                       True
//   output_dir:                     '.'
//   precision:                      15
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'auto'
//   split:                          False
//   swig_binary:                    'swig'
//   swig_path:                      ''

#ifndef __POISSON2D_5_H
#define __POISSON2D_5_H

#include <cmath>
#include <stdexcept>
#include <fstream>
#include <ufc.h>

/// This class defines the interface for a finite element.

class poisson2d_5_finite_element_0: public ufc::finite_element
{
public:

  /// Constructor
  poisson2d_5_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~poisson2d_5_finite_element_0()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('triangle', Space(2)), 5, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 21;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Reset values.
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.0 + 2.0*r)/(1.0 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.5 + r + Y*(1.5 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[21] = \
      {0.0154328860973252, -0.0094506740492349, -0.00545634920634915, 0.0301875307266957, 0.0233831607535234, 0.013500274155551, -0.0231997605826757, -0.0196073763651313, -0.0151878084249949, -0.00876868528257128, 0.0213898651255978, 0.0188640878998484, 0.0159430641501296, 0.0123494443881937, 0.00712995504186596, -0.0179891757560038, -0.0162718217101153, -0.0143503978743156, -0.0121282998205249, -0.00939454064454067, -0.00542394057003844};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 21; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.0 + 2.0*r)/(1.0 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.5 + r + Y*(1.5 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[21] = \
      {0.0154328860973253, 0.00945067404923495, -0.00545634920634919, 0.0301875307266957, -0.0233831607535234, 0.013500274155551, 0.0231997605826757, -0.0196073763651313, 0.0151878084249949, -0.00876868528257128, 0.0213898651255978, -0.0188640878998484, 0.0159430641501296, -0.0123494443881937, 0.00712995504186593, 0.0179891757560038, -0.0162718217101153, 0.0143503978743156, -0.0121282998205248, 0.00939454064454063, -0.00542394057003841};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 21; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.0 + 2.0*r)/(1.0 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.5 + r + Y*(1.5 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[21] = \
      {0.0154328860973254, 0.0, 0.0109126984126984, 0.0, 0.0, 0.0405008224666531, 0.0, 0.0, 0.0, 0.0350747411302851, 0.0, 0.0, 0.0, 0.0, 0.0356497752093297, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0325436434202305};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 21; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.0 + 2.0*r)/(1.0 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.5 + r + Y*(1.5 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[21] = \
      {0.0350747411302852, 0.126008987323133, -0.0843253968253967, 0.101882916202598, -0.0286443719230662, 0.00202504112333266, 0.0773325352755857, -0.0261431684868418, 0.0, 0.00584579018838086, 0.0356497752093297, 0.012576058599899, -0.0385290716961465, 0.0442521757243607, -0.0297081460077747, 0.0, 0.0325436434202306, -0.051661432347536, 0.0582158391385193, -0.0526094276094276, 0.0325436434202305};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 21; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.0 + 2.0*r)/(1.0 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.5 + r + Y*(1.5 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[21] = \
      {0.0350747411302849, -0.0329341671412733, 0.121527777777778, -0.0113203240225109, 0.075410693430113, -0.0222754523566592, 0.0, 0.104572673947367, -0.101252056166633, 0.0584579018838084, 0.0, 0.0565922636995451, -0.0093001207542422, -0.0401356942616295, 0.0415914044108846, 0.0, 0.0, 0.0516614323475361, -0.101877718492409, 0.118371212121212, -0.0813591085505763};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 21; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.0 + 2.0*r)/(1.0 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.5 + r + Y*(1.5 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[21] = \
      {0.0350747411302851, 0.0887790592503889, -0.0892857142857142, 0.0301875307266956, 0.0432588473940182, -0.0594012062844245, 0.0, 0.0261431684868417, 0.101252056166633, -0.116915803767617, 0.0, 0.0, 0.0744009660339381, -0.0308736109704841, -0.0118832584031099, 0.0, 0.0, 0.0, 0.0679184789949393, -0.131523569023569, 0.108478811400768};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 21; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.0 + 2.0*r)/(1.0 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.5 + r + Y*(1.5 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[21] = \
      {0.0350747411302849, -0.010023442173431, 0.151289682539682, 0.0, 0.0502737956200753, 0.093151891673302, 0.0, 0.0, 0.0506260280833163, 0.0643036920721894, 0.0, 0.0, 0.0, 0.0720384255977965, -0.0237665168062197, 0.0, 0.0, 0.0, 0.0, 0.0657617845117845, -0.0813591085505764};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 21; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.0 + 2.0*r)/(1.0 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.5 + r + Y*(1.5 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[21] = \
      {0.0350747411302849, -0.126008987323133, -0.0843253968253968, 0.101882916202598, 0.0286443719230662, 0.00202504112333274, -0.0773325352755858, -0.0261431684868417, 0.0, 0.00584579018838083, 0.0356497752093297, -0.0125760585998989, -0.0385290716961465, -0.0442521757243607, -0.0297081460077748, 0.0, 0.0325436434202305, 0.0516614323475361, 0.0582158391385193, 0.0526094276094276, 0.0325436434202305};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 21; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.0 + 2.0*r)/(1.0 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.5 + r + Y*(1.5 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[21] = \
      {0.035074741130285, 0.0329341671412732, 0.121527777777778, -0.0113203240225108, -0.075410693430113, -0.0222754523566593, 0.0, 0.104572673947367, 0.101252056166633, 0.0584579018838085, 0.0, -0.0565922636995451, -0.00930012075424217, 0.0401356942616295, 0.0415914044108847, 0.0, 0.0, -0.0516614323475361, -0.101877718492409, -0.118371212121212, -0.0813591085505763};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 21; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.0 + 2.0*r)/(1.0 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.5 + r + Y*(1.5 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[21] = \
      {0.0350747411302851, -0.0887790592503889, -0.0892857142857142, 0.0301875307266956, -0.0432588473940183, -0.0594012062844244, 0.0, 0.0261431684868417, -0.101252056166633, -0.116915803767617, 0.0, 0.0, 0.074400966033938, 0.0308736109704842, -0.01188325840311, 0.0, 0.0, 0.0, 0.0679184789949392, 0.131523569023569, 0.108478811400768};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 21; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 10:
      {
        
      // Array of basisvalues.
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.0 + 2.0*r)/(1.0 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.5 + r + Y*(1.5 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[21] = \
      {0.0350747411302849, 0.010023442173431, 0.151289682539683, 0.0, -0.0502737956200753, 0.0931518916733021, 0.0, 0.0, -0.0506260280833163, 0.0643036920721894, 0.0, 0.0, 0.0, -0.0720384255977965, -0.0237665168062197, 0.0, 0.0, 0.0, 0.0, -0.0657617845117846, -0.0813591085505764};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 21; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 11:
      {
        
      // Array of basisvalues.
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.0 + 2.0*r)/(1.0 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.5 + r + Y*(1.5 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[21] = \
      {0.0350747411302849, -0.136032429496563, -0.0669642857142857, 0.0369797251402022, 0.0789181675431415, 0.0600762199922021, -0.00773325352755866, -0.0457505448519731, -0.055688630891648, -0.0379976362244755, -0.0641695953767935, -0.012576058599899, 0.017271652829307, 0.0277862498734358, 0.0202015392852868, 0.0899458787800191, 0.0488154651303458, 0.0200905570240418, 0.00242565996410494, -0.0056367243867244, -0.00542394057003842};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 21; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 12:
      {
        
      // Array of basisvalues.
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.0 + 2.0*r)/(1.0 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.5 + r + Y*(1.5 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[21] = \
      {0.0350747411302853, 0.121713226391662, -0.0322420634920635, -0.0671672558668979, -0.0321518460360947, 0.0276755620188795, 0.139198563496054, 0.0653579212171044, -0.0101252056166633, -0.0292289509419042, 0.0427797302511957, -0.0565922636995451, -0.0332147169794367, 0.00926208329114528, 0.0202015392852869, -0.179891757560038, -0.0325436434202306, 0.0114803182994524, 0.00970263985641995, -0.00187890812890815, -0.00542394057003845};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 21; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 13:
      {
        
      // Array of basisvalues.
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.0 + 2.0*r)/(1.0 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.5 + r + Y*(1.5 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[21] = \
      {0.0350747411302852, -0.121713226391662, -0.0322420634920636, -0.0671672558668978, 0.0321518460360947, 0.0276755620188796, -0.139198563496054, 0.0653579212171044, 0.0101252056166633, -0.0292289509419043, 0.0427797302511955, 0.0565922636995451, -0.0332147169794366, -0.0092620832911453, 0.0202015392852868, 0.179891757560038, -0.0325436434202305, -0.0114803182994525, 0.00970263985641989, 0.00187890812890816, -0.0054239405700384};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 21; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 14:
      {
        
      // Array of basisvalues.
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.0 + 2.0*r)/(1.0 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.5 + r + Y*(1.5 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[21] = \
      {0.035074741130285, 0.136032429496564, -0.0669642857142856, 0.0369797251402022, -0.0789181675431414, 0.060076219992202, 0.00773325352755864, -0.0457505448519731, 0.0556886308916479, -0.0379976362244755, -0.0641695953767934, 0.0125760585998989, 0.017271652829307, -0.0277862498734358, 0.0202015392852869, -0.0899458787800192, 0.0488154651303458, -0.0200905570240418, 0.00242565996410498, 0.0056367243867244, -0.00542394057003847};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 21; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 15:
      {
        
      // Array of basisvalues.
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.0 + 2.0*r)/(1.0 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.5 + r + Y*(1.5 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[21] = \
      {0.280597929042281, -0.214788046573521, -0.124007936507937, 0.0905625921800872, 0.116915803767617, 0.0, 0.154665070551172, 0.0784295054605253, 0.101252056166633, 0.0818410626373319, -0.142599100837319, 0.0251521171997979, -0.0318861283002592, -0.107028518031012, -0.0950660672248791, 0.0, -0.130174573680922, -0.103322864695072, -0.0291079195692595, 0.0263047138047138, 0.0325436434202306};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 21; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 16:
      {
        
      // Array of basisvalues.
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.0 + 2.0*r)/(1.0 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.5 + r + Y*(1.5 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[21] = \
      {0.0350747411302854, 0.0, -0.124007936507936, -0.38489101676537, 0.0, 0.101252056166633, 0.0, -0.104572673947367, 0.0, 0.0467663215070469, 0.213898651255978, 0.0, 0.140830399992811, 0.0, -0.0950660672248791, 0.0, 0.195261860521383, 0.0, -0.0582158391385195, 0.0, 0.0325436434202304};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 21; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 17:
      {
        
      // Array of basisvalues.
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.0 + 2.0*r)/(1.0 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.5 + r + Y*(1.5 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[21] = \
      {0.280597929042281, 0.214788046573521, -0.124007936507937, 0.090562592180087, -0.116915803767617, 0.0, -0.154665070551172, 0.0784295054605253, -0.101252056166633, 0.0818410626373318, -0.142599100837319, -0.0251521171997978, -0.0318861283002592, 0.107028518031012, -0.0950660672248792, 0.0, -0.130174573680922, 0.103322864695072, -0.0291079195692596, -0.0263047138047138, 0.0325436434202306};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 21; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 18:
      {
        
      // Array of basisvalues.
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.0 + 2.0*r)/(1.0 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.5 + r + Y*(1.5 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[21] = \
      {0.0350747411302851, -0.107394023286761, 0.0620039682539685, 0.0113203240225107, -0.306903984889995, -0.253130140416582, 0.0, -0.104572673947367, 0.0, 0.0467663215070467, 0.0, 0.169776791098635, 0.00930012075424217, 0.126581804978985, 0.172307246845093, 0.0, 0.0, 0.154984297042608, 0.101877718492409, -0.0394570707070707, -0.0813591085505763};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 21; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 19:
      {
        
      // Array of basisvalues.
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.0 + 2.0*r)/(1.0 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.5 + r + Y*(1.5 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[21] = \
      {0.035074741130285, 0.107394023286761, 0.0620039682539682, 0.011320324022511, 0.306903984889995, -0.253130140416582, 0.0, -0.104572673947367, 0.0, 0.0467663215070468, 0.0, -0.169776791098635, 0.00930012075424224, -0.126581804978985, 0.172307246845093, 0.0, 0.0, -0.154984297042608, 0.101877718492409, 0.0394570707070707, -0.0813591085505763};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 21; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 20:
      {
        
      // Array of basisvalues.
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.0 + 2.0*r)/(1.0 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.5 + r + Y*(1.5 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[21] = \
      {0.280597929042281, 0.0, 0.248015873015873, -0.0603750614533913, 0.0, 0.13500274155551, 0.0, -0.0522863369736835, 0.0, -0.210448446781711, 0.0, 0.0, -0.148801932067876, 0.0, -0.142599100837319, 0.0, 0.0, 0.0, -0.135836957989878, 0.0, 0.108478811400768};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 21; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 21; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.0 + 2.0*r)/(1.0 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.5 + r + Y*(1.5 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[21] = \
      {0.0154328860973252, -0.0094506740492349, -0.00545634920634915, 0.0301875307266957, 0.0233831607535234, 0.013500274155551, -0.0231997605826757, -0.0196073763651313, -0.0151878084249949, -0.00876868528257128, 0.0213898651255978, 0.0188640878998484, 0.0159430641501296, 0.0123494443881937, 0.00712995504186596, -0.0179891757560038, -0.0162718217101153, -0.0143503978743156, -0.0121282998205249, -0.00939454064454067, -0.00542394057003844};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050515, 0.0, 0.0, 0.0, 0.0, 1.42730188533123e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.99999999999999, 0.0, 7.07106781186548, 0.0, 1.0172418463128e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212919, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660784, 0.0, -1.35448938231154e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004132, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690618, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 1.24344978758018e-14, 0.0, -3.83325938999964, 0.0, 17.7482393492988, 0.0, 0.553283335172475, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.7328638264797, 0.0, 3.34664010613632, 4.36435780471984, -1.35687344541151e-14, -5.07468037933238, 0.0, 17.0084012854152, 0.0, 1.52127765851135, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, -1.4210854715202e-14, 0.0, 9.14285714285712, 0.0, 0.0, 0.0, 14.8461497791618, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0},
      {3.09838667696594, 0.0, 7.66811580507235, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 1.06611606826009e-14, 9.29516003089783, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.41602560309062, 0.0, -4.37680963545756, 15.7321327225523, 0.0, 2.01017818278147, 0.0, -4.03686713879668, 0.0, -0.515811962199112, 21.7990825495019, 0.0, 0.451335466924227, 0.0, 0.057669530554236, 0.0, -1.00566098266321e-14, 0.0, -1.12643938743361e-14, 0.0, 0.0},
      {0.0, 6.85714285714284, 1.4210854715202e-14, 0.0, 9.97292252418865, 0.0, 4.32049379893856, 0.0, -7.27309832077594, 1.77635683940025e-14, 0.0, 21.2540192277445, 0.0, 1.49078803979367, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.32049379893857, 0.0, 5.93552661441899, 1.79284291400159, 0.0, -0.32071349029493, 0.0, 9.20087412456472, 0.0, -5.96639619853421, 0.0, 0.0, 19.8022632451351, 0.0, 2.5302403842553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.53330375599989, -1.06581410364015e-14, 0.0, 6.33793245113119, 0.0, 1.67653770533037e-14, 0.0, 13.5526185435788, 0.0, 0.0, 0.0, 0.0, 16.6675169851115, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.82842712474619, 0.0, 7.31428571428574, 0.0, 0.0, 11.337638238025, 0.0, 0.0, 0.0, 12.9299525702683, 0.0, 0.0, 0.0, 0.0, 9.93858693195778, 0.0, 0.0, 0.0, 0.0, 0.0, 1.14352971536391e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278317, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175272, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999999, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063972, -1.05830052442583, 0.305505046330393, 1.041420495798e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823012, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454315, 3.91918358845309, 0.0, 9.69948452238571, 4.2, -1.1869079656298e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.00000000000001, 0.0, -2.82842712474618, 0.0, -1.19730614311919e-14, 12.1243556529821, 0.0, 0.0, 1.26921260252476e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505165, -1.89736659610102, 7.42307488958089, -1.91662969499982, 0.663940002206985, 8.87411967464942, -1.07142857142858, 0.276641667586235, -0.0958314847499854, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923786, 1.67332005306817, 2.18217890235992, 5.74704893215391, -2.53734018966619, 10.062305898749, 8.50420064270762, -2.19577516413422, 0.760638829255681, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.00000000000001, 1.2247448713916, 3.53553390593274, -7.37711113563318, 4.57142857142855, 1.64957219768464, 0.0, 11.4997781699989, 7.42307488958092, -2.57142857142858, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848298, 6.64078308635361, 3.83405790253616, 0.0, -6.19677335393189, 5.3665631459995, 0.0, -1.02942565495247e-14, 13.4164078649988, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.32934244475986e-14, 0.0},
      {-3.57770876399966, 0.0, 8.85437744847149, 0.0, 0.0, -3.09838667696592, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 1.35447209004269e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 2.02338146237935e-14},
      {2.70801280154531, 5.6856424977521, -2.18840481772877, 7.86606636127614, -2.61129805863298, 1.00508909139073, 9.55297122675762, -2.01843356939834, 0.670059394260476, -0.257905981099553, 10.899541274751, -1.06805465250648, 0.225667733462114, -0.0749149177264327, 0.0288347652771179, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278317, 3.42857142857142, 0.989743318610801, 3.04933917230522, 4.98646126209433, -2.72741187029098, 2.16024689946928, 8.34624849531681, -3.63654916038797, 1.51635079315151, 12.0498962651137, 10.6270096138723, -2.24536559755125, 0.745394019896836, -0.286902292026516, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.16024689946929, 1.8142294704443, 2.96776330720949, 0.896421457000799, 5.41604758366941, -0.160356745147461, -9.52579344415678, 4.60043706228236, 5.34522483824849, -2.98319809926711, 0.0, 13.3887736279041, 9.90113162256757, -3.28687867566959, 1.26512019212765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835056, 0.766651877999943, 3.83609779052925, 8.63680425592141, 3.1689662255656, 3.65920700676628, 0.0, -8.74817765279707, 6.77630927178941, 0.521640530957299, 0.0, 0.0, 15.0623703313921, 8.33375849255573, -3.20766513935892, 0.0, -1.48137784516813e-14, 0.0, 0.0, 0.0, 0.0},
      {1.41421356237309, -6.73025456655335, 3.65714285714287, 0.0, 9.45502781700869, 5.66881911901251, 0.0, 1.28309015871647e-14, -6.99854212223765, 6.46497628513417, 0.0, 0.0, 0.0, 17.2141375215909, 4.96929346597889, 0.0, 0.0, 0.0, 0.0, 0.0, 1.01585406753202e-14},
      {5.71547606649407, 0.0, -4.61880215351702, -1.21498923528475e-14, 0.0, 12.7279220613579, 0.0, 1.13715737024626e-14, -2.43583362115028e-14, -3.26598632371091, 0.0, 0.0, 0.0, 0.0, 20.0831604418561, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 21; t++)
        {
          for (unsigned int u = 0; u < 21; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 21; s++)
        {
          for (unsigned int t = 0; t < 21; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.0 + 2.0*r)/(1.0 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.5 + r + Y*(1.5 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[21] = \
      {0.0154328860973253, 0.00945067404923495, -0.00545634920634919, 0.0301875307266957, -0.0233831607535234, 0.013500274155551, 0.0231997605826757, -0.0196073763651313, 0.0151878084249949, -0.00876868528257128, 0.0213898651255978, -0.0188640878998484, 0.0159430641501296, -0.0123494443881937, 0.00712995504186593, 0.0179891757560038, -0.0162718217101153, 0.0143503978743156, -0.0121282998205248, 0.00939454064454063, -0.00542394057003841};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050515, 0.0, 0.0, 0.0, 0.0, 1.42730188533123e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.99999999999999, 0.0, 7.07106781186548, 0.0, 1.0172418463128e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212919, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660784, 0.0, -1.35448938231154e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004132, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690618, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 1.24344978758018e-14, 0.0, -3.83325938999964, 0.0, 17.7482393492988, 0.0, 0.553283335172475, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.7328638264797, 0.0, 3.34664010613632, 4.36435780471984, -1.35687344541151e-14, -5.07468037933238, 0.0, 17.0084012854152, 0.0, 1.52127765851135, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, -1.4210854715202e-14, 0.0, 9.14285714285712, 0.0, 0.0, 0.0, 14.8461497791618, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0},
      {3.09838667696594, 0.0, 7.66811580507235, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 1.06611606826009e-14, 9.29516003089783, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.41602560309062, 0.0, -4.37680963545756, 15.7321327225523, 0.0, 2.01017818278147, 0.0, -4.03686713879668, 0.0, -0.515811962199112, 21.7990825495019, 0.0, 0.451335466924227, 0.0, 0.057669530554236, 0.0, -1.00566098266321e-14, 0.0, -1.12643938743361e-14, 0.0, 0.0},
      {0.0, 6.85714285714284, 1.4210854715202e-14, 0.0, 9.97292252418865, 0.0, 4.32049379893856, 0.0, -7.27309832077594, 1.77635683940025e-14, 0.0, 21.2540192277445, 0.0, 1.49078803979367, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.32049379893857, 0.0, 5.93552661441899, 1.79284291400159, 0.0, -0.32071349029493, 0.0, 9.20087412456472, 0.0, -5.96639619853421, 0.0, 0.0, 19.8022632451351, 0.0, 2.5302403842553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.53330375599989, -1.06581410364015e-14, 0.0, 6.33793245113119, 0.0, 1.67653770533037e-14, 0.0, 13.5526185435788, 0.0, 0.0, 0.0, 0.0, 16.6675169851115, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.82842712474619, 0.0, 7.31428571428574, 0.0, 0.0, 11.337638238025, 0.0, 0.0, 0.0, 12.9299525702683, 0.0, 0.0, 0.0, 0.0, 9.93858693195778, 0.0, 0.0, 0.0, 0.0, 0.0, 1.14352971536391e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278317, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175272, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999999, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063972, -1.05830052442583, 0.305505046330393, 1.041420495798e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823012, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454315, 3.91918358845309, 0.0, 9.69948452238571, 4.2, -1.1869079656298e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.00000000000001, 0.0, -2.82842712474618, 0.0, -1.19730614311919e-14, 12.1243556529821, 0.0, 0.0, 1.26921260252476e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505165, -1.89736659610102, 7.42307488958089, -1.91662969499982, 0.663940002206985, 8.87411967464942, -1.07142857142858, 0.276641667586235, -0.0958314847499854, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923786, 1.67332005306817, 2.18217890235992, 5.74704893215391, -2.53734018966619, 10.062305898749, 8.50420064270762, -2.19577516413422, 0.760638829255681, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.00000000000001, 1.2247448713916, 3.53553390593274, -7.37711113563318, 4.57142857142855, 1.64957219768464, 0.0, 11.4997781699989, 7.42307488958092, -2.57142857142858, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848298, 6.64078308635361, 3.83405790253616, 0.0, -6.19677335393189, 5.3665631459995, 0.0, -1.02942565495247e-14, 13.4164078649988, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.32934244475986e-14, 0.0},
      {-3.57770876399966, 0.0, 8.85437744847149, 0.0, 0.0, -3.09838667696592, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 1.35447209004269e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 2.02338146237935e-14},
      {2.70801280154531, 5.6856424977521, -2.18840481772877, 7.86606636127614, -2.61129805863298, 1.00508909139073, 9.55297122675762, -2.01843356939834, 0.670059394260476, -0.257905981099553, 10.899541274751, -1.06805465250648, 0.225667733462114, -0.0749149177264327, 0.0288347652771179, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278317, 3.42857142857142, 0.989743318610801, 3.04933917230522, 4.98646126209433, -2.72741187029098, 2.16024689946928, 8.34624849531681, -3.63654916038797, 1.51635079315151, 12.0498962651137, 10.6270096138723, -2.24536559755125, 0.745394019896836, -0.286902292026516, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.16024689946929, 1.8142294704443, 2.96776330720949, 0.896421457000799, 5.41604758366941, -0.160356745147461, -9.52579344415678, 4.60043706228236, 5.34522483824849, -2.98319809926711, 0.0, 13.3887736279041, 9.90113162256757, -3.28687867566959, 1.26512019212765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835056, 0.766651877999943, 3.83609779052925, 8.63680425592141, 3.1689662255656, 3.65920700676628, 0.0, -8.74817765279707, 6.77630927178941, 0.521640530957299, 0.0, 0.0, 15.0623703313921, 8.33375849255573, -3.20766513935892, 0.0, -1.48137784516813e-14, 0.0, 0.0, 0.0, 0.0},
      {1.41421356237309, -6.73025456655335, 3.65714285714287, 0.0, 9.45502781700869, 5.66881911901251, 0.0, 1.28309015871647e-14, -6.99854212223765, 6.46497628513417, 0.0, 0.0, 0.0, 17.2141375215909, 4.96929346597889, 0.0, 0.0, 0.0, 0.0, 0.0, 1.01585406753202e-14},
      {5.71547606649407, 0.0, -4.61880215351702, -1.21498923528475e-14, 0.0, 12.7279220613579, 0.0, 1.13715737024626e-14, -2.43583362115028e-14, -3.26598632371091, 0.0, 0.0, 0.0, 0.0, 20.0831604418561, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 21; t++)
        {
          for (unsigned int u = 0; u < 21; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 21; s++)
        {
          for (unsigned int t = 0; t < 21; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.0 + 2.0*r)/(1.0 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.5 + r + Y*(1.5 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[21] = \
      {0.0154328860973254, 0.0, 0.0109126984126984, 0.0, 0.0, 0.0405008224666531, 0.0, 0.0, 0.0, 0.0350747411302851, 0.0, 0.0, 0.0, 0.0, 0.0356497752093297, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0325436434202305};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050515, 0.0, 0.0, 0.0, 0.0, 1.42730188533123e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.99999999999999, 0.0, 7.07106781186548, 0.0, 1.0172418463128e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212919, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660784, 0.0, -1.35448938231154e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004132, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690618, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 1.24344978758018e-14, 0.0, -3.83325938999964, 0.0, 17.7482393492988, 0.0, 0.553283335172475, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.7328638264797, 0.0, 3.34664010613632, 4.36435780471984, -1.35687344541151e-14, -5.07468037933238, 0.0, 17.0084012854152, 0.0, 1.52127765851135, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, -1.4210854715202e-14, 0.0, 9.14285714285712, 0.0, 0.0, 0.0, 14.8461497791618, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0},
      {3.09838667696594, 0.0, 7.66811580507235, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 1.06611606826009e-14, 9.29516003089783, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.41602560309062, 0.0, -4.37680963545756, 15.7321327225523, 0.0, 2.01017818278147, 0.0, -4.03686713879668, 0.0, -0.515811962199112, 21.7990825495019, 0.0, 0.451335466924227, 0.0, 0.057669530554236, 0.0, -1.00566098266321e-14, 0.0, -1.12643938743361e-14, 0.0, 0.0},
      {0.0, 6.85714285714284, 1.4210854715202e-14, 0.0, 9.97292252418865, 0.0, 4.32049379893856, 0.0, -7.27309832077594, 1.77635683940025e-14, 0.0, 21.2540192277445, 0.0, 1.49078803979367, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.32049379893857, 0.0, 5.93552661441899, 1.79284291400159, 0.0, -0.32071349029493, 0.0, 9.20087412456472, 0.0, -5.96639619853421, 0.0, 0.0, 19.8022632451351, 0.0, 2.5302403842553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.53330375599989, -1.06581410364015e-14, 0.0, 6.33793245113119, 0.0, 1.67653770533037e-14, 0.0, 13.5526185435788, 0.0, 0.0, 0.0, 0.0, 16.6675169851115, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.82842712474619, 0.0, 7.31428571428574, 0.0, 0.0, 11.337638238025, 0.0, 0.0, 0.0, 12.9299525702683, 0.0, 0.0, 0.0, 0.0, 9.93858693195778, 0.0, 0.0, 0.0, 0.0, 0.0, 1.14352971536391e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278317, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175272, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999999, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063972, -1.05830052442583, 0.305505046330393, 1.041420495798e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823012, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454315, 3.91918358845309, 0.0, 9.69948452238571, 4.2, -1.1869079656298e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.00000000000001, 0.0, -2.82842712474618, 0.0, -1.19730614311919e-14, 12.1243556529821, 0.0, 0.0, 1.26921260252476e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505165, -1.89736659610102, 7.42307488958089, -1.91662969499982, 0.663940002206985, 8.87411967464942, -1.07142857142858, 0.276641667586235, -0.0958314847499854, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923786, 1.67332005306817, 2.18217890235992, 5.74704893215391, -2.53734018966619, 10.062305898749, 8.50420064270762, -2.19577516413422, 0.760638829255681, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.00000000000001, 1.2247448713916, 3.53553390593274, -7.37711113563318, 4.57142857142855, 1.64957219768464, 0.0, 11.4997781699989, 7.42307488958092, -2.57142857142858, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848298, 6.64078308635361, 3.83405790253616, 0.0, -6.19677335393189, 5.3665631459995, 0.0, -1.02942565495247e-14, 13.4164078649988, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.32934244475986e-14, 0.0},
      {-3.57770876399966, 0.0, 8.85437744847149, 0.0, 0.0, -3.09838667696592, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 1.35447209004269e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 2.02338146237935e-14},
      {2.70801280154531, 5.6856424977521, -2.18840481772877, 7.86606636127614, -2.61129805863298, 1.00508909139073, 9.55297122675762, -2.01843356939834, 0.670059394260476, -0.257905981099553, 10.899541274751, -1.06805465250648, 0.225667733462114, -0.0749149177264327, 0.0288347652771179, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278317, 3.42857142857142, 0.989743318610801, 3.04933917230522, 4.98646126209433, -2.72741187029098, 2.16024689946928, 8.34624849531681, -3.63654916038797, 1.51635079315151, 12.0498962651137, 10.6270096138723, -2.24536559755125, 0.745394019896836, -0.286902292026516, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.16024689946929, 1.8142294704443, 2.96776330720949, 0.896421457000799, 5.41604758366941, -0.160356745147461, -9.52579344415678, 4.60043706228236, 5.34522483824849, -2.98319809926711, 0.0, 13.3887736279041, 9.90113162256757, -3.28687867566959, 1.26512019212765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835056, 0.766651877999943, 3.83609779052925, 8.63680425592141, 3.1689662255656, 3.65920700676628, 0.0, -8.74817765279707, 6.77630927178941, 0.521640530957299, 0.0, 0.0, 15.0623703313921, 8.33375849255573, -3.20766513935892, 0.0, -1.48137784516813e-14, 0.0, 0.0, 0.0, 0.0},
      {1.41421356237309, -6.73025456655335, 3.65714285714287, 0.0, 9.45502781700869, 5.66881911901251, 0.0, 1.28309015871647e-14, -6.99854212223765, 6.46497628513417, 0.0, 0.0, 0.0, 17.2141375215909, 4.96929346597889, 0.0, 0.0, 0.0, 0.0, 0.0, 1.01585406753202e-14},
      {5.71547606649407, 0.0, -4.61880215351702, -1.21498923528475e-14, 0.0, 12.7279220613579, 0.0, 1.13715737024626e-14, -2.43583362115028e-14, -3.26598632371091, 0.0, 0.0, 0.0, 0.0, 20.0831604418561, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 21; t++)
        {
          for (unsigned int u = 0; u < 21; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 21; s++)
        {
          for (unsigned int t = 0; t < 21; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.0 + 2.0*r)/(1.0 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.5 + r + Y*(1.5 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[21] = \
      {0.0350747411302852, 0.126008987323133, -0.0843253968253967, 0.101882916202598, -0.0286443719230662, 0.00202504112333266, 0.0773325352755857, -0.0261431684868418, 0.0, 0.00584579018838086, 0.0356497752093297, 0.012576058599899, -0.0385290716961465, 0.0442521757243607, -0.0297081460077747, 0.0, 0.0325436434202306, -0.051661432347536, 0.0582158391385193, -0.0526094276094276, 0.0325436434202305};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050515, 0.0, 0.0, 0.0, 0.0, 1.42730188533123e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.99999999999999, 0.0, 7.07106781186548, 0.0, 1.0172418463128e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212919, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660784, 0.0, -1.35448938231154e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004132, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690618, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 1.24344978758018e-14, 0.0, -3.83325938999964, 0.0, 17.7482393492988, 0.0, 0.553283335172475, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.7328638264797, 0.0, 3.34664010613632, 4.36435780471984, -1.35687344541151e-14, -5.07468037933238, 0.0, 17.0084012854152, 0.0, 1.52127765851135, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, -1.4210854715202e-14, 0.0, 9.14285714285712, 0.0, 0.0, 0.0, 14.8461497791618, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0},
      {3.09838667696594, 0.0, 7.66811580507235, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 1.06611606826009e-14, 9.29516003089783, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.41602560309062, 0.0, -4.37680963545756, 15.7321327225523, 0.0, 2.01017818278147, 0.0, -4.03686713879668, 0.0, -0.515811962199112, 21.7990825495019, 0.0, 0.451335466924227, 0.0, 0.057669530554236, 0.0, -1.00566098266321e-14, 0.0, -1.12643938743361e-14, 0.0, 0.0},
      {0.0, 6.85714285714284, 1.4210854715202e-14, 0.0, 9.97292252418865, 0.0, 4.32049379893856, 0.0, -7.27309832077594, 1.77635683940025e-14, 0.0, 21.2540192277445, 0.0, 1.49078803979367, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.32049379893857, 0.0, 5.93552661441899, 1.79284291400159, 0.0, -0.32071349029493, 0.0, 9.20087412456472, 0.0, -5.96639619853421, 0.0, 0.0, 19.8022632451351, 0.0, 2.5302403842553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.53330375599989, -1.06581410364015e-14, 0.0, 6.33793245113119, 0.0, 1.67653770533037e-14, 0.0, 13.5526185435788, 0.0, 0.0, 0.0, 0.0, 16.6675169851115, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.82842712474619, 0.0, 7.31428571428574, 0.0, 0.0, 11.337638238025, 0.0, 0.0, 0.0, 12.9299525702683, 0.0, 0.0, 0.0, 0.0, 9.93858693195778, 0.0, 0.0, 0.0, 0.0, 0.0, 1.14352971536391e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278317, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175272, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999999, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063972, -1.05830052442583, 0.305505046330393, 1.041420495798e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823012, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454315, 3.91918358845309, 0.0, 9.69948452238571, 4.2, -1.1869079656298e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.00000000000001, 0.0, -2.82842712474618, 0.0, -1.19730614311919e-14, 12.1243556529821, 0.0, 0.0, 1.26921260252476e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505165, -1.89736659610102, 7.42307488958089, -1.91662969499982, 0.663940002206985, 8.87411967464942, -1.07142857142858, 0.276641667586235, -0.0958314847499854, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923786, 1.67332005306817, 2.18217890235992, 5.74704893215391, -2.53734018966619, 10.062305898749, 8.50420064270762, -2.19577516413422, 0.760638829255681, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.00000000000001, 1.2247448713916, 3.53553390593274, -7.37711113563318, 4.57142857142855, 1.64957219768464, 0.0, 11.4997781699989, 7.42307488958092, -2.57142857142858, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848298, 6.64078308635361, 3.83405790253616, 0.0, -6.19677335393189, 5.3665631459995, 0.0, -1.02942565495247e-14, 13.4164078649988, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.32934244475986e-14, 0.0},
      {-3.57770876399966, 0.0, 8.85437744847149, 0.0, 0.0, -3.09838667696592, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 1.35447209004269e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 2.02338146237935e-14},
      {2.70801280154531, 5.6856424977521, -2.18840481772877, 7.86606636127614, -2.61129805863298, 1.00508909139073, 9.55297122675762, -2.01843356939834, 0.670059394260476, -0.257905981099553, 10.899541274751, -1.06805465250648, 0.225667733462114, -0.0749149177264327, 0.0288347652771179, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278317, 3.42857142857142, 0.989743318610801, 3.04933917230522, 4.98646126209433, -2.72741187029098, 2.16024689946928, 8.34624849531681, -3.63654916038797, 1.51635079315151, 12.0498962651137, 10.6270096138723, -2.24536559755125, 0.745394019896836, -0.286902292026516, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.16024689946929, 1.8142294704443, 2.96776330720949, 0.896421457000799, 5.41604758366941, -0.160356745147461, -9.52579344415678, 4.60043706228236, 5.34522483824849, -2.98319809926711, 0.0, 13.3887736279041, 9.90113162256757, -3.28687867566959, 1.26512019212765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835056, 0.766651877999943, 3.83609779052925, 8.63680425592141, 3.1689662255656, 3.65920700676628, 0.0, -8.74817765279707, 6.77630927178941, 0.521640530957299, 0.0, 0.0, 15.0623703313921, 8.33375849255573, -3.20766513935892, 0.0, -1.48137784516813e-14, 0.0, 0.0, 0.0, 0.0},
      {1.41421356237309, -6.73025456655335, 3.65714285714287, 0.0, 9.45502781700869, 5.66881911901251, 0.0, 1.28309015871647e-14, -6.99854212223765, 6.46497628513417, 0.0, 0.0, 0.0, 17.2141375215909, 4.96929346597889, 0.0, 0.0, 0.0, 0.0, 0.0, 1.01585406753202e-14},
      {5.71547606649407, 0.0, -4.61880215351702, -1.21498923528475e-14, 0.0, 12.7279220613579, 0.0, 1.13715737024626e-14, -2.43583362115028e-14, -3.26598632371091, 0.0, 0.0, 0.0, 0.0, 20.0831604418561, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 21; t++)
        {
          for (unsigned int u = 0; u < 21; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 21; s++)
        {
          for (unsigned int t = 0; t < 21; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.0 + 2.0*r)/(1.0 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.5 + r + Y*(1.5 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[21] = \
      {0.0350747411302849, -0.0329341671412733, 0.121527777777778, -0.0113203240225109, 0.075410693430113, -0.0222754523566592, 0.0, 0.104572673947367, -0.101252056166633, 0.0584579018838084, 0.0, 0.0565922636995451, -0.0093001207542422, -0.0401356942616295, 0.0415914044108846, 0.0, 0.0, 0.0516614323475361, -0.101877718492409, 0.118371212121212, -0.0813591085505763};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050515, 0.0, 0.0, 0.0, 0.0, 1.42730188533123e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.99999999999999, 0.0, 7.07106781186548, 0.0, 1.0172418463128e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212919, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660784, 0.0, -1.35448938231154e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004132, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690618, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 1.24344978758018e-14, 0.0, -3.83325938999964, 0.0, 17.7482393492988, 0.0, 0.553283335172475, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.7328638264797, 0.0, 3.34664010613632, 4.36435780471984, -1.35687344541151e-14, -5.07468037933238, 0.0, 17.0084012854152, 0.0, 1.52127765851135, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, -1.4210854715202e-14, 0.0, 9.14285714285712, 0.0, 0.0, 0.0, 14.8461497791618, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0},
      {3.09838667696594, 0.0, 7.66811580507235, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 1.06611606826009e-14, 9.29516003089783, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.41602560309062, 0.0, -4.37680963545756, 15.7321327225523, 0.0, 2.01017818278147, 0.0, -4.03686713879668, 0.0, -0.515811962199112, 21.7990825495019, 0.0, 0.451335466924227, 0.0, 0.057669530554236, 0.0, -1.00566098266321e-14, 0.0, -1.12643938743361e-14, 0.0, 0.0},
      {0.0, 6.85714285714284, 1.4210854715202e-14, 0.0, 9.97292252418865, 0.0, 4.32049379893856, 0.0, -7.27309832077594, 1.77635683940025e-14, 0.0, 21.2540192277445, 0.0, 1.49078803979367, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.32049379893857, 0.0, 5.93552661441899, 1.79284291400159, 0.0, -0.32071349029493, 0.0, 9.20087412456472, 0.0, -5.96639619853421, 0.0, 0.0, 19.8022632451351, 0.0, 2.5302403842553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.53330375599989, -1.06581410364015e-14, 0.0, 6.33793245113119, 0.0, 1.67653770533037e-14, 0.0, 13.5526185435788, 0.0, 0.0, 0.0, 0.0, 16.6675169851115, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.82842712474619, 0.0, 7.31428571428574, 0.0, 0.0, 11.337638238025, 0.0, 0.0, 0.0, 12.9299525702683, 0.0, 0.0, 0.0, 0.0, 9.93858693195778, 0.0, 0.0, 0.0, 0.0, 0.0, 1.14352971536391e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278317, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175272, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999999, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063972, -1.05830052442583, 0.305505046330393, 1.041420495798e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823012, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454315, 3.91918358845309, 0.0, 9.69948452238571, 4.2, -1.1869079656298e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.00000000000001, 0.0, -2.82842712474618, 0.0, -1.19730614311919e-14, 12.1243556529821, 0.0, 0.0, 1.26921260252476e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505165, -1.89736659610102, 7.42307488958089, -1.91662969499982, 0.663940002206985, 8.87411967464942, -1.07142857142858, 0.276641667586235, -0.0958314847499854, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923786, 1.67332005306817, 2.18217890235992, 5.74704893215391, -2.53734018966619, 10.062305898749, 8.50420064270762, -2.19577516413422, 0.760638829255681, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.00000000000001, 1.2247448713916, 3.53553390593274, -7.37711113563318, 4.57142857142855, 1.64957219768464, 0.0, 11.4997781699989, 7.42307488958092, -2.57142857142858, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848298, 6.64078308635361, 3.83405790253616, 0.0, -6.19677335393189, 5.3665631459995, 0.0, -1.02942565495247e-14, 13.4164078649988, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.32934244475986e-14, 0.0},
      {-3.57770876399966, 0.0, 8.85437744847149, 0.0, 0.0, -3.09838667696592, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 1.35447209004269e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 2.02338146237935e-14},
      {2.70801280154531, 5.6856424977521, -2.18840481772877, 7.86606636127614, -2.61129805863298, 1.00508909139073, 9.55297122675762, -2.01843356939834, 0.670059394260476, -0.257905981099553, 10.899541274751, -1.06805465250648, 0.225667733462114, -0.0749149177264327, 0.0288347652771179, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278317, 3.42857142857142, 0.989743318610801, 3.04933917230522, 4.98646126209433, -2.72741187029098, 2.16024689946928, 8.34624849531681, -3.63654916038797, 1.51635079315151, 12.0498962651137, 10.6270096138723, -2.24536559755125, 0.745394019896836, -0.286902292026516, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.16024689946929, 1.8142294704443, 2.96776330720949, 0.896421457000799, 5.41604758366941, -0.160356745147461, -9.52579344415678, 4.60043706228236, 5.34522483824849, -2.98319809926711, 0.0, 13.3887736279041, 9.90113162256757, -3.28687867566959, 1.26512019212765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835056, 0.766651877999943, 3.83609779052925, 8.63680425592141, 3.1689662255656, 3.65920700676628, 0.0, -8.74817765279707, 6.77630927178941, 0.521640530957299, 0.0, 0.0, 15.0623703313921, 8.33375849255573, -3.20766513935892, 0.0, -1.48137784516813e-14, 0.0, 0.0, 0.0, 0.0},
      {1.41421356237309, -6.73025456655335, 3.65714285714287, 0.0, 9.45502781700869, 5.66881911901251, 0.0, 1.28309015871647e-14, -6.99854212223765, 6.46497628513417, 0.0, 0.0, 0.0, 17.2141375215909, 4.96929346597889, 0.0, 0.0, 0.0, 0.0, 0.0, 1.01585406753202e-14},
      {5.71547606649407, 0.0, -4.61880215351702, -1.21498923528475e-14, 0.0, 12.7279220613579, 0.0, 1.13715737024626e-14, -2.43583362115028e-14, -3.26598632371091, 0.0, 0.0, 0.0, 0.0, 20.0831604418561, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 21; t++)
        {
          for (unsigned int u = 0; u < 21; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 21; s++)
        {
          for (unsigned int t = 0; t < 21; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.0 + 2.0*r)/(1.0 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.5 + r + Y*(1.5 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[21] = \
      {0.0350747411302851, 0.0887790592503889, -0.0892857142857142, 0.0301875307266956, 0.0432588473940182, -0.0594012062844245, 0.0, 0.0261431684868417, 0.101252056166633, -0.116915803767617, 0.0, 0.0, 0.0744009660339381, -0.0308736109704841, -0.0118832584031099, 0.0, 0.0, 0.0, 0.0679184789949393, -0.131523569023569, 0.108478811400768};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050515, 0.0, 0.0, 0.0, 0.0, 1.42730188533123e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.99999999999999, 0.0, 7.07106781186548, 0.0, 1.0172418463128e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212919, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660784, 0.0, -1.35448938231154e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004132, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690618, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 1.24344978758018e-14, 0.0, -3.83325938999964, 0.0, 17.7482393492988, 0.0, 0.553283335172475, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.7328638264797, 0.0, 3.34664010613632, 4.36435780471984, -1.35687344541151e-14, -5.07468037933238, 0.0, 17.0084012854152, 0.0, 1.52127765851135, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, -1.4210854715202e-14, 0.0, 9.14285714285712, 0.0, 0.0, 0.0, 14.8461497791618, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0},
      {3.09838667696594, 0.0, 7.66811580507235, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 1.06611606826009e-14, 9.29516003089783, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.41602560309062, 0.0, -4.37680963545756, 15.7321327225523, 0.0, 2.01017818278147, 0.0, -4.03686713879668, 0.0, -0.515811962199112, 21.7990825495019, 0.0, 0.451335466924227, 0.0, 0.057669530554236, 0.0, -1.00566098266321e-14, 0.0, -1.12643938743361e-14, 0.0, 0.0},
      {0.0, 6.85714285714284, 1.4210854715202e-14, 0.0, 9.97292252418865, 0.0, 4.32049379893856, 0.0, -7.27309832077594, 1.77635683940025e-14, 0.0, 21.2540192277445, 0.0, 1.49078803979367, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.32049379893857, 0.0, 5.93552661441899, 1.79284291400159, 0.0, -0.32071349029493, 0.0, 9.20087412456472, 0.0, -5.96639619853421, 0.0, 0.0, 19.8022632451351, 0.0, 2.5302403842553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.53330375599989, -1.06581410364015e-14, 0.0, 6.33793245113119, 0.0, 1.67653770533037e-14, 0.0, 13.5526185435788, 0.0, 0.0, 0.0, 0.0, 16.6675169851115, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.82842712474619, 0.0, 7.31428571428574, 0.0, 0.0, 11.337638238025, 0.0, 0.0, 0.0, 12.9299525702683, 0.0, 0.0, 0.0, 0.0, 9.93858693195778, 0.0, 0.0, 0.0, 0.0, 0.0, 1.14352971536391e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278317, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175272, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999999, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063972, -1.05830052442583, 0.305505046330393, 1.041420495798e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823012, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454315, 3.91918358845309, 0.0, 9.69948452238571, 4.2, -1.1869079656298e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.00000000000001, 0.0, -2.82842712474618, 0.0, -1.19730614311919e-14, 12.1243556529821, 0.0, 0.0, 1.26921260252476e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505165, -1.89736659610102, 7.42307488958089, -1.91662969499982, 0.663940002206985, 8.87411967464942, -1.07142857142858, 0.276641667586235, -0.0958314847499854, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923786, 1.67332005306817, 2.18217890235992, 5.74704893215391, -2.53734018966619, 10.062305898749, 8.50420064270762, -2.19577516413422, 0.760638829255681, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.00000000000001, 1.2247448713916, 3.53553390593274, -7.37711113563318, 4.57142857142855, 1.64957219768464, 0.0, 11.4997781699989, 7.42307488958092, -2.57142857142858, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848298, 6.64078308635361, 3.83405790253616, 0.0, -6.19677335393189, 5.3665631459995, 0.0, -1.02942565495247e-14, 13.4164078649988, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.32934244475986e-14, 0.0},
      {-3.57770876399966, 0.0, 8.85437744847149, 0.0, 0.0, -3.09838667696592, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 1.35447209004269e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 2.02338146237935e-14},
      {2.70801280154531, 5.6856424977521, -2.18840481772877, 7.86606636127614, -2.61129805863298, 1.00508909139073, 9.55297122675762, -2.01843356939834, 0.670059394260476, -0.257905981099553, 10.899541274751, -1.06805465250648, 0.225667733462114, -0.0749149177264327, 0.0288347652771179, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278317, 3.42857142857142, 0.989743318610801, 3.04933917230522, 4.98646126209433, -2.72741187029098, 2.16024689946928, 8.34624849531681, -3.63654916038797, 1.51635079315151, 12.0498962651137, 10.6270096138723, -2.24536559755125, 0.745394019896836, -0.286902292026516, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.16024689946929, 1.8142294704443, 2.96776330720949, 0.896421457000799, 5.41604758366941, -0.160356745147461, -9.52579344415678, 4.60043706228236, 5.34522483824849, -2.98319809926711, 0.0, 13.3887736279041, 9.90113162256757, -3.28687867566959, 1.26512019212765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835056, 0.766651877999943, 3.83609779052925, 8.63680425592141, 3.1689662255656, 3.65920700676628, 0.0, -8.74817765279707, 6.77630927178941, 0.521640530957299, 0.0, 0.0, 15.0623703313921, 8.33375849255573, -3.20766513935892, 0.0, -1.48137784516813e-14, 0.0, 0.0, 0.0, 0.0},
      {1.41421356237309, -6.73025456655335, 3.65714285714287, 0.0, 9.45502781700869, 5.66881911901251, 0.0, 1.28309015871647e-14, -6.99854212223765, 6.46497628513417, 0.0, 0.0, 0.0, 17.2141375215909, 4.96929346597889, 0.0, 0.0, 0.0, 0.0, 0.0, 1.01585406753202e-14},
      {5.71547606649407, 0.0, -4.61880215351702, -1.21498923528475e-14, 0.0, 12.7279220613579, 0.0, 1.13715737024626e-14, -2.43583362115028e-14, -3.26598632371091, 0.0, 0.0, 0.0, 0.0, 20.0831604418561, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 21; t++)
        {
          for (unsigned int u = 0; u < 21; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 21; s++)
        {
          for (unsigned int t = 0; t < 21; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.0 + 2.0*r)/(1.0 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.5 + r + Y*(1.5 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[21] = \
      {0.0350747411302849, -0.010023442173431, 0.151289682539682, 0.0, 0.0502737956200753, 0.093151891673302, 0.0, 0.0, 0.0506260280833163, 0.0643036920721894, 0.0, 0.0, 0.0, 0.0720384255977965, -0.0237665168062197, 0.0, 0.0, 0.0, 0.0, 0.0657617845117845, -0.0813591085505764};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050515, 0.0, 0.0, 0.0, 0.0, 1.42730188533123e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.99999999999999, 0.0, 7.07106781186548, 0.0, 1.0172418463128e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212919, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660784, 0.0, -1.35448938231154e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004132, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690618, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 1.24344978758018e-14, 0.0, -3.83325938999964, 0.0, 17.7482393492988, 0.0, 0.553283335172475, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.7328638264797, 0.0, 3.34664010613632, 4.36435780471984, -1.35687344541151e-14, -5.07468037933238, 0.0, 17.0084012854152, 0.0, 1.52127765851135, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, -1.4210854715202e-14, 0.0, 9.14285714285712, 0.0, 0.0, 0.0, 14.8461497791618, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0},
      {3.09838667696594, 0.0, 7.66811580507235, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 1.06611606826009e-14, 9.29516003089783, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.41602560309062, 0.0, -4.37680963545756, 15.7321327225523, 0.0, 2.01017818278147, 0.0, -4.03686713879668, 0.0, -0.515811962199112, 21.7990825495019, 0.0, 0.451335466924227, 0.0, 0.057669530554236, 0.0, -1.00566098266321e-14, 0.0, -1.12643938743361e-14, 0.0, 0.0},
      {0.0, 6.85714285714284, 1.4210854715202e-14, 0.0, 9.97292252418865, 0.0, 4.32049379893856, 0.0, -7.27309832077594, 1.77635683940025e-14, 0.0, 21.2540192277445, 0.0, 1.49078803979367, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.32049379893857, 0.0, 5.93552661441899, 1.79284291400159, 0.0, -0.32071349029493, 0.0, 9.20087412456472, 0.0, -5.96639619853421, 0.0, 0.0, 19.8022632451351, 0.0, 2.5302403842553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.53330375599989, -1.06581410364015e-14, 0.0, 6.33793245113119, 0.0, 1.67653770533037e-14, 0.0, 13.5526185435788, 0.0, 0.0, 0.0, 0.0, 16.6675169851115, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.82842712474619, 0.0, 7.31428571428574, 0.0, 0.0, 11.337638238025, 0.0, 0.0, 0.0, 12.9299525702683, 0.0, 0.0, 0.0, 0.0, 9.93858693195778, 0.0, 0.0, 0.0, 0.0, 0.0, 1.14352971536391e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278317, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175272, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999999, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063972, -1.05830052442583, 0.305505046330393, 1.041420495798e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823012, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454315, 3.91918358845309, 0.0, 9.69948452238571, 4.2, -1.1869079656298e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.00000000000001, 0.0, -2.82842712474618, 0.0, -1.19730614311919e-14, 12.1243556529821, 0.0, 0.0, 1.26921260252476e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505165, -1.89736659610102, 7.42307488958089, -1.91662969499982, 0.663940002206985, 8.87411967464942, -1.07142857142858, 0.276641667586235, -0.0958314847499854, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923786, 1.67332005306817, 2.18217890235992, 5.74704893215391, -2.53734018966619, 10.062305898749, 8.50420064270762, -2.19577516413422, 0.760638829255681, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.00000000000001, 1.2247448713916, 3.53553390593274, -7.37711113563318, 4.57142857142855, 1.64957219768464, 0.0, 11.4997781699989, 7.42307488958092, -2.57142857142858, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848298, 6.64078308635361, 3.83405790253616, 0.0, -6.19677335393189, 5.3665631459995, 0.0, -1.02942565495247e-14, 13.4164078649988, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.32934244475986e-14, 0.0},
      {-3.57770876399966, 0.0, 8.85437744847149, 0.0, 0.0, -3.09838667696592, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 1.35447209004269e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 2.02338146237935e-14},
      {2.70801280154531, 5.6856424977521, -2.18840481772877, 7.86606636127614, -2.61129805863298, 1.00508909139073, 9.55297122675762, -2.01843356939834, 0.670059394260476, -0.257905981099553, 10.899541274751, -1.06805465250648, 0.225667733462114, -0.0749149177264327, 0.0288347652771179, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278317, 3.42857142857142, 0.989743318610801, 3.04933917230522, 4.98646126209433, -2.72741187029098, 2.16024689946928, 8.34624849531681, -3.63654916038797, 1.51635079315151, 12.0498962651137, 10.6270096138723, -2.24536559755125, 0.745394019896836, -0.286902292026516, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.16024689946929, 1.8142294704443, 2.96776330720949, 0.896421457000799, 5.41604758366941, -0.160356745147461, -9.52579344415678, 4.60043706228236, 5.34522483824849, -2.98319809926711, 0.0, 13.3887736279041, 9.90113162256757, -3.28687867566959, 1.26512019212765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835056, 0.766651877999943, 3.83609779052925, 8.63680425592141, 3.1689662255656, 3.65920700676628, 0.0, -8.74817765279707, 6.77630927178941, 0.521640530957299, 0.0, 0.0, 15.0623703313921, 8.33375849255573, -3.20766513935892, 0.0, -1.48137784516813e-14, 0.0, 0.0, 0.0, 0.0},
      {1.41421356237309, -6.73025456655335, 3.65714285714287, 0.0, 9.45502781700869, 5.66881911901251, 0.0, 1.28309015871647e-14, -6.99854212223765, 6.46497628513417, 0.0, 0.0, 0.0, 17.2141375215909, 4.96929346597889, 0.0, 0.0, 0.0, 0.0, 0.0, 1.01585406753202e-14},
      {5.71547606649407, 0.0, -4.61880215351702, -1.21498923528475e-14, 0.0, 12.7279220613579, 0.0, 1.13715737024626e-14, -2.43583362115028e-14, -3.26598632371091, 0.0, 0.0, 0.0, 0.0, 20.0831604418561, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 21; t++)
        {
          for (unsigned int u = 0; u < 21; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 21; s++)
        {
          for (unsigned int t = 0; t < 21; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.0 + 2.0*r)/(1.0 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.5 + r + Y*(1.5 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[21] = \
      {0.0350747411302849, -0.126008987323133, -0.0843253968253968, 0.101882916202598, 0.0286443719230662, 0.00202504112333274, -0.0773325352755858, -0.0261431684868417, 0.0, 0.00584579018838083, 0.0356497752093297, -0.0125760585998989, -0.0385290716961465, -0.0442521757243607, -0.0297081460077748, 0.0, 0.0325436434202305, 0.0516614323475361, 0.0582158391385193, 0.0526094276094276, 0.0325436434202305};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050515, 0.0, 0.0, 0.0, 0.0, 1.42730188533123e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.99999999999999, 0.0, 7.07106781186548, 0.0, 1.0172418463128e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212919, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660784, 0.0, -1.35448938231154e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004132, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690618, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 1.24344978758018e-14, 0.0, -3.83325938999964, 0.0, 17.7482393492988, 0.0, 0.553283335172475, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.7328638264797, 0.0, 3.34664010613632, 4.36435780471984, -1.35687344541151e-14, -5.07468037933238, 0.0, 17.0084012854152, 0.0, 1.52127765851135, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, -1.4210854715202e-14, 0.0, 9.14285714285712, 0.0, 0.0, 0.0, 14.8461497791618, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0},
      {3.09838667696594, 0.0, 7.66811580507235, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 1.06611606826009e-14, 9.29516003089783, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.41602560309062, 0.0, -4.37680963545756, 15.7321327225523, 0.0, 2.01017818278147, 0.0, -4.03686713879668, 0.0, -0.515811962199112, 21.7990825495019, 0.0, 0.451335466924227, 0.0, 0.057669530554236, 0.0, -1.00566098266321e-14, 0.0, -1.12643938743361e-14, 0.0, 0.0},
      {0.0, 6.85714285714284, 1.4210854715202e-14, 0.0, 9.97292252418865, 0.0, 4.32049379893856, 0.0, -7.27309832077594, 1.77635683940025e-14, 0.0, 21.2540192277445, 0.0, 1.49078803979367, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.32049379893857, 0.0, 5.93552661441899, 1.79284291400159, 0.0, -0.32071349029493, 0.0, 9.20087412456472, 0.0, -5.96639619853421, 0.0, 0.0, 19.8022632451351, 0.0, 2.5302403842553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.53330375599989, -1.06581410364015e-14, 0.0, 6.33793245113119, 0.0, 1.67653770533037e-14, 0.0, 13.5526185435788, 0.0, 0.0, 0.0, 0.0, 16.6675169851115, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.82842712474619, 0.0, 7.31428571428574, 0.0, 0.0, 11.337638238025, 0.0, 0.0, 0.0, 12.9299525702683, 0.0, 0.0, 0.0, 0.0, 9.93858693195778, 0.0, 0.0, 0.0, 0.0, 0.0, 1.14352971536391e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278317, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175272, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999999, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063972, -1.05830052442583, 0.305505046330393, 1.041420495798e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823012, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454315, 3.91918358845309, 0.0, 9.69948452238571, 4.2, -1.1869079656298e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.00000000000001, 0.0, -2.82842712474618, 0.0, -1.19730614311919e-14, 12.1243556529821, 0.0, 0.0, 1.26921260252476e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505165, -1.89736659610102, 7.42307488958089, -1.91662969499982, 0.663940002206985, 8.87411967464942, -1.07142857142858, 0.276641667586235, -0.0958314847499854, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923786, 1.67332005306817, 2.18217890235992, 5.74704893215391, -2.53734018966619, 10.062305898749, 8.50420064270762, -2.19577516413422, 0.760638829255681, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.00000000000001, 1.2247448713916, 3.53553390593274, -7.37711113563318, 4.57142857142855, 1.64957219768464, 0.0, 11.4997781699989, 7.42307488958092, -2.57142857142858, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848298, 6.64078308635361, 3.83405790253616, 0.0, -6.19677335393189, 5.3665631459995, 0.0, -1.02942565495247e-14, 13.4164078649988, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.32934244475986e-14, 0.0},
      {-3.57770876399966, 0.0, 8.85437744847149, 0.0, 0.0, -3.09838667696592, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 1.35447209004269e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 2.02338146237935e-14},
      {2.70801280154531, 5.6856424977521, -2.18840481772877, 7.86606636127614, -2.61129805863298, 1.00508909139073, 9.55297122675762, -2.01843356939834, 0.670059394260476, -0.257905981099553, 10.899541274751, -1.06805465250648, 0.225667733462114, -0.0749149177264327, 0.0288347652771179, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278317, 3.42857142857142, 0.989743318610801, 3.04933917230522, 4.98646126209433, -2.72741187029098, 2.16024689946928, 8.34624849531681, -3.63654916038797, 1.51635079315151, 12.0498962651137, 10.6270096138723, -2.24536559755125, 0.745394019896836, -0.286902292026516, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.16024689946929, 1.8142294704443, 2.96776330720949, 0.896421457000799, 5.41604758366941, -0.160356745147461, -9.52579344415678, 4.60043706228236, 5.34522483824849, -2.98319809926711, 0.0, 13.3887736279041, 9.90113162256757, -3.28687867566959, 1.26512019212765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835056, 0.766651877999943, 3.83609779052925, 8.63680425592141, 3.1689662255656, 3.65920700676628, 0.0, -8.74817765279707, 6.77630927178941, 0.521640530957299, 0.0, 0.0, 15.0623703313921, 8.33375849255573, -3.20766513935892, 0.0, -1.48137784516813e-14, 0.0, 0.0, 0.0, 0.0},
      {1.41421356237309, -6.73025456655335, 3.65714285714287, 0.0, 9.45502781700869, 5.66881911901251, 0.0, 1.28309015871647e-14, -6.99854212223765, 6.46497628513417, 0.0, 0.0, 0.0, 17.2141375215909, 4.96929346597889, 0.0, 0.0, 0.0, 0.0, 0.0, 1.01585406753202e-14},
      {5.71547606649407, 0.0, -4.61880215351702, -1.21498923528475e-14, 0.0, 12.7279220613579, 0.0, 1.13715737024626e-14, -2.43583362115028e-14, -3.26598632371091, 0.0, 0.0, 0.0, 0.0, 20.0831604418561, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 21; t++)
        {
          for (unsigned int u = 0; u < 21; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 21; s++)
        {
          for (unsigned int t = 0; t < 21; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.0 + 2.0*r)/(1.0 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.5 + r + Y*(1.5 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[21] = \
      {0.035074741130285, 0.0329341671412732, 0.121527777777778, -0.0113203240225108, -0.075410693430113, -0.0222754523566593, 0.0, 0.104572673947367, 0.101252056166633, 0.0584579018838085, 0.0, -0.0565922636995451, -0.00930012075424217, 0.0401356942616295, 0.0415914044108847, 0.0, 0.0, -0.0516614323475361, -0.101877718492409, -0.118371212121212, -0.0813591085505763};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050515, 0.0, 0.0, 0.0, 0.0, 1.42730188533123e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.99999999999999, 0.0, 7.07106781186548, 0.0, 1.0172418463128e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212919, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660784, 0.0, -1.35448938231154e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004132, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690618, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 1.24344978758018e-14, 0.0, -3.83325938999964, 0.0, 17.7482393492988, 0.0, 0.553283335172475, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.7328638264797, 0.0, 3.34664010613632, 4.36435780471984, -1.35687344541151e-14, -5.07468037933238, 0.0, 17.0084012854152, 0.0, 1.52127765851135, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, -1.4210854715202e-14, 0.0, 9.14285714285712, 0.0, 0.0, 0.0, 14.8461497791618, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0},
      {3.09838667696594, 0.0, 7.66811580507235, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 1.06611606826009e-14, 9.29516003089783, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.41602560309062, 0.0, -4.37680963545756, 15.7321327225523, 0.0, 2.01017818278147, 0.0, -4.03686713879668, 0.0, -0.515811962199112, 21.7990825495019, 0.0, 0.451335466924227, 0.0, 0.057669530554236, 0.0, -1.00566098266321e-14, 0.0, -1.12643938743361e-14, 0.0, 0.0},
      {0.0, 6.85714285714284, 1.4210854715202e-14, 0.0, 9.97292252418865, 0.0, 4.32049379893856, 0.0, -7.27309832077594, 1.77635683940025e-14, 0.0, 21.2540192277445, 0.0, 1.49078803979367, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.32049379893857, 0.0, 5.93552661441899, 1.79284291400159, 0.0, -0.32071349029493, 0.0, 9.20087412456472, 0.0, -5.96639619853421, 0.0, 0.0, 19.8022632451351, 0.0, 2.5302403842553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.53330375599989, -1.06581410364015e-14, 0.0, 6.33793245113119, 0.0, 1.67653770533037e-14, 0.0, 13.5526185435788, 0.0, 0.0, 0.0, 0.0, 16.6675169851115, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.82842712474619, 0.0, 7.31428571428574, 0.0, 0.0, 11.337638238025, 0.0, 0.0, 0.0, 12.9299525702683, 0.0, 0.0, 0.0, 0.0, 9.93858693195778, 0.0, 0.0, 0.0, 0.0, 0.0, 1.14352971536391e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278317, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175272, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999999, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063972, -1.05830052442583, 0.305505046330393, 1.041420495798e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823012, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454315, 3.91918358845309, 0.0, 9.69948452238571, 4.2, -1.1869079656298e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.00000000000001, 0.0, -2.82842712474618, 0.0, -1.19730614311919e-14, 12.1243556529821, 0.0, 0.0, 1.26921260252476e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505165, -1.89736659610102, 7.42307488958089, -1.91662969499982, 0.663940002206985, 8.87411967464942, -1.07142857142858, 0.276641667586235, -0.0958314847499854, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923786, 1.67332005306817, 2.18217890235992, 5.74704893215391, -2.53734018966619, 10.062305898749, 8.50420064270762, -2.19577516413422, 0.760638829255681, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.00000000000001, 1.2247448713916, 3.53553390593274, -7.37711113563318, 4.57142857142855, 1.64957219768464, 0.0, 11.4997781699989, 7.42307488958092, -2.57142857142858, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848298, 6.64078308635361, 3.83405790253616, 0.0, -6.19677335393189, 5.3665631459995, 0.0, -1.02942565495247e-14, 13.4164078649988, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.32934244475986e-14, 0.0},
      {-3.57770876399966, 0.0, 8.85437744847149, 0.0, 0.0, -3.09838667696592, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 1.35447209004269e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 2.02338146237935e-14},
      {2.70801280154531, 5.6856424977521, -2.18840481772877, 7.86606636127614, -2.61129805863298, 1.00508909139073, 9.55297122675762, -2.01843356939834, 0.670059394260476, -0.257905981099553, 10.899541274751, -1.06805465250648, 0.225667733462114, -0.0749149177264327, 0.0288347652771179, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278317, 3.42857142857142, 0.989743318610801, 3.04933917230522, 4.98646126209433, -2.72741187029098, 2.16024689946928, 8.34624849531681, -3.63654916038797, 1.51635079315151, 12.0498962651137, 10.6270096138723, -2.24536559755125, 0.745394019896836, -0.286902292026516, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.16024689946929, 1.8142294704443, 2.96776330720949, 0.896421457000799, 5.41604758366941, -0.160356745147461, -9.52579344415678, 4.60043706228236, 5.34522483824849, -2.98319809926711, 0.0, 13.3887736279041, 9.90113162256757, -3.28687867566959, 1.26512019212765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835056, 0.766651877999943, 3.83609779052925, 8.63680425592141, 3.1689662255656, 3.65920700676628, 0.0, -8.74817765279707, 6.77630927178941, 0.521640530957299, 0.0, 0.0, 15.0623703313921, 8.33375849255573, -3.20766513935892, 0.0, -1.48137784516813e-14, 0.0, 0.0, 0.0, 0.0},
      {1.41421356237309, -6.73025456655335, 3.65714285714287, 0.0, 9.45502781700869, 5.66881911901251, 0.0, 1.28309015871647e-14, -6.99854212223765, 6.46497628513417, 0.0, 0.0, 0.0, 17.2141375215909, 4.96929346597889, 0.0, 0.0, 0.0, 0.0, 0.0, 1.01585406753202e-14},
      {5.71547606649407, 0.0, -4.61880215351702, -1.21498923528475e-14, 0.0, 12.7279220613579, 0.0, 1.13715737024626e-14, -2.43583362115028e-14, -3.26598632371091, 0.0, 0.0, 0.0, 0.0, 20.0831604418561, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 21; t++)
        {
          for (unsigned int u = 0; u < 21; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 21; s++)
        {
          for (unsigned int t = 0; t < 21; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.0 + 2.0*r)/(1.0 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.5 + r + Y*(1.5 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[21] = \
      {0.0350747411302851, -0.0887790592503889, -0.0892857142857142, 0.0301875307266956, -0.0432588473940183, -0.0594012062844244, 0.0, 0.0261431684868417, -0.101252056166633, -0.116915803767617, 0.0, 0.0, 0.074400966033938, 0.0308736109704842, -0.01188325840311, 0.0, 0.0, 0.0, 0.0679184789949392, 0.131523569023569, 0.108478811400768};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050515, 0.0, 0.0, 0.0, 0.0, 1.42730188533123e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.99999999999999, 0.0, 7.07106781186548, 0.0, 1.0172418463128e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212919, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660784, 0.0, -1.35448938231154e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004132, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690618, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 1.24344978758018e-14, 0.0, -3.83325938999964, 0.0, 17.7482393492988, 0.0, 0.553283335172475, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.7328638264797, 0.0, 3.34664010613632, 4.36435780471984, -1.35687344541151e-14, -5.07468037933238, 0.0, 17.0084012854152, 0.0, 1.52127765851135, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, -1.4210854715202e-14, 0.0, 9.14285714285712, 0.0, 0.0, 0.0, 14.8461497791618, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0},
      {3.09838667696594, 0.0, 7.66811580507235, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 1.06611606826009e-14, 9.29516003089783, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.41602560309062, 0.0, -4.37680963545756, 15.7321327225523, 0.0, 2.01017818278147, 0.0, -4.03686713879668, 0.0, -0.515811962199112, 21.7990825495019, 0.0, 0.451335466924227, 0.0, 0.057669530554236, 0.0, -1.00566098266321e-14, 0.0, -1.12643938743361e-14, 0.0, 0.0},
      {0.0, 6.85714285714284, 1.4210854715202e-14, 0.0, 9.97292252418865, 0.0, 4.32049379893856, 0.0, -7.27309832077594, 1.77635683940025e-14, 0.0, 21.2540192277445, 0.0, 1.49078803979367, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.32049379893857, 0.0, 5.93552661441899, 1.79284291400159, 0.0, -0.32071349029493, 0.0, 9.20087412456472, 0.0, -5.96639619853421, 0.0, 0.0, 19.8022632451351, 0.0, 2.5302403842553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.53330375599989, -1.06581410364015e-14, 0.0, 6.33793245113119, 0.0, 1.67653770533037e-14, 0.0, 13.5526185435788, 0.0, 0.0, 0.0, 0.0, 16.6675169851115, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.82842712474619, 0.0, 7.31428571428574, 0.0, 0.0, 11.337638238025, 0.0, 0.0, 0.0, 12.9299525702683, 0.0, 0.0, 0.0, 0.0, 9.93858693195778, 0.0, 0.0, 0.0, 0.0, 0.0, 1.14352971536391e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278317, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175272, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999999, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063972, -1.05830052442583, 0.305505046330393, 1.041420495798e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823012, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454315, 3.91918358845309, 0.0, 9.69948452238571, 4.2, -1.1869079656298e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.00000000000001, 0.0, -2.82842712474618, 0.0, -1.19730614311919e-14, 12.1243556529821, 0.0, 0.0, 1.26921260252476e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505165, -1.89736659610102, 7.42307488958089, -1.91662969499982, 0.663940002206985, 8.87411967464942, -1.07142857142858, 0.276641667586235, -0.0958314847499854, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923786, 1.67332005306817, 2.18217890235992, 5.74704893215391, -2.53734018966619, 10.062305898749, 8.50420064270762, -2.19577516413422, 0.760638829255681, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.00000000000001, 1.2247448713916, 3.53553390593274, -7.37711113563318, 4.57142857142855, 1.64957219768464, 0.0, 11.4997781699989, 7.42307488958092, -2.57142857142858, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848298, 6.64078308635361, 3.83405790253616, 0.0, -6.19677335393189, 5.3665631459995, 0.0, -1.02942565495247e-14, 13.4164078649988, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.32934244475986e-14, 0.0},
      {-3.57770876399966, 0.0, 8.85437744847149, 0.0, 0.0, -3.09838667696592, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 1.35447209004269e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 2.02338146237935e-14},
      {2.70801280154531, 5.6856424977521, -2.18840481772877, 7.86606636127614, -2.61129805863298, 1.00508909139073, 9.55297122675762, -2.01843356939834, 0.670059394260476, -0.257905981099553, 10.899541274751, -1.06805465250648, 0.225667733462114, -0.0749149177264327, 0.0288347652771179, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278317, 3.42857142857142, 0.989743318610801, 3.04933917230522, 4.98646126209433, -2.72741187029098, 2.16024689946928, 8.34624849531681, -3.63654916038797, 1.51635079315151, 12.0498962651137, 10.6270096138723, -2.24536559755125, 0.745394019896836, -0.286902292026516, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.16024689946929, 1.8142294704443, 2.96776330720949, 0.896421457000799, 5.41604758366941, -0.160356745147461, -9.52579344415678, 4.60043706228236, 5.34522483824849, -2.98319809926711, 0.0, 13.3887736279041, 9.90113162256757, -3.28687867566959, 1.26512019212765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835056, 0.766651877999943, 3.83609779052925, 8.63680425592141, 3.1689662255656, 3.65920700676628, 0.0, -8.74817765279707, 6.77630927178941, 0.521640530957299, 0.0, 0.0, 15.0623703313921, 8.33375849255573, -3.20766513935892, 0.0, -1.48137784516813e-14, 0.0, 0.0, 0.0, 0.0},
      {1.41421356237309, -6.73025456655335, 3.65714285714287, 0.0, 9.45502781700869, 5.66881911901251, 0.0, 1.28309015871647e-14, -6.99854212223765, 6.46497628513417, 0.0, 0.0, 0.0, 17.2141375215909, 4.96929346597889, 0.0, 0.0, 0.0, 0.0, 0.0, 1.01585406753202e-14},
      {5.71547606649407, 0.0, -4.61880215351702, -1.21498923528475e-14, 0.0, 12.7279220613579, 0.0, 1.13715737024626e-14, -2.43583362115028e-14, -3.26598632371091, 0.0, 0.0, 0.0, 0.0, 20.0831604418561, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 21; t++)
        {
          for (unsigned int u = 0; u < 21; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 21; s++)
        {
          for (unsigned int t = 0; t < 21; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 10:
      {
        
      // Array of basisvalues.
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.0 + 2.0*r)/(1.0 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.5 + r + Y*(1.5 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[21] = \
      {0.0350747411302849, 0.010023442173431, 0.151289682539683, 0.0, -0.0502737956200753, 0.0931518916733021, 0.0, 0.0, -0.0506260280833163, 0.0643036920721894, 0.0, 0.0, 0.0, -0.0720384255977965, -0.0237665168062197, 0.0, 0.0, 0.0, 0.0, -0.0657617845117846, -0.0813591085505764};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050515, 0.0, 0.0, 0.0, 0.0, 1.42730188533123e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.99999999999999, 0.0, 7.07106781186548, 0.0, 1.0172418463128e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212919, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660784, 0.0, -1.35448938231154e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004132, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690618, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 1.24344978758018e-14, 0.0, -3.83325938999964, 0.0, 17.7482393492988, 0.0, 0.553283335172475, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.7328638264797, 0.0, 3.34664010613632, 4.36435780471984, -1.35687344541151e-14, -5.07468037933238, 0.0, 17.0084012854152, 0.0, 1.52127765851135, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, -1.4210854715202e-14, 0.0, 9.14285714285712, 0.0, 0.0, 0.0, 14.8461497791618, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0},
      {3.09838667696594, 0.0, 7.66811580507235, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 1.06611606826009e-14, 9.29516003089783, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.41602560309062, 0.0, -4.37680963545756, 15.7321327225523, 0.0, 2.01017818278147, 0.0, -4.03686713879668, 0.0, -0.515811962199112, 21.7990825495019, 0.0, 0.451335466924227, 0.0, 0.057669530554236, 0.0, -1.00566098266321e-14, 0.0, -1.12643938743361e-14, 0.0, 0.0},
      {0.0, 6.85714285714284, 1.4210854715202e-14, 0.0, 9.97292252418865, 0.0, 4.32049379893856, 0.0, -7.27309832077594, 1.77635683940025e-14, 0.0, 21.2540192277445, 0.0, 1.49078803979367, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.32049379893857, 0.0, 5.93552661441899, 1.79284291400159, 0.0, -0.32071349029493, 0.0, 9.20087412456472, 0.0, -5.96639619853421, 0.0, 0.0, 19.8022632451351, 0.0, 2.5302403842553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.53330375599989, -1.06581410364015e-14, 0.0, 6.33793245113119, 0.0, 1.67653770533037e-14, 0.0, 13.5526185435788, 0.0, 0.0, 0.0, 0.0, 16.6675169851115, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.82842712474619, 0.0, 7.31428571428574, 0.0, 0.0, 11.337638238025, 0.0, 0.0, 0.0, 12.9299525702683, 0.0, 0.0, 0.0, 0.0, 9.93858693195778, 0.0, 0.0, 0.0, 0.0, 0.0, 1.14352971536391e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278317, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175272, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999999, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063972, -1.05830052442583, 0.305505046330393, 1.041420495798e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823012, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454315, 3.91918358845309, 0.0, 9.69948452238571, 4.2, -1.1869079656298e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.00000000000001, 0.0, -2.82842712474618, 0.0, -1.19730614311919e-14, 12.1243556529821, 0.0, 0.0, 1.26921260252476e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505165, -1.89736659610102, 7.42307488958089, -1.91662969499982, 0.663940002206985, 8.87411967464942, -1.07142857142858, 0.276641667586235, -0.0958314847499854, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923786, 1.67332005306817, 2.18217890235992, 5.74704893215391, -2.53734018966619, 10.062305898749, 8.50420064270762, -2.19577516413422, 0.760638829255681, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.00000000000001, 1.2247448713916, 3.53553390593274, -7.37711113563318, 4.57142857142855, 1.64957219768464, 0.0, 11.4997781699989, 7.42307488958092, -2.57142857142858, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848298, 6.64078308635361, 3.83405790253616, 0.0, -6.19677335393189, 5.3665631459995, 0.0, -1.02942565495247e-14, 13.4164078649988, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.32934244475986e-14, 0.0},
      {-3.57770876399966, 0.0, 8.85437744847149, 0.0, 0.0, -3.09838667696592, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 1.35447209004269e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 2.02338146237935e-14},
      {2.70801280154531, 5.6856424977521, -2.18840481772877, 7.86606636127614, -2.61129805863298, 1.00508909139073, 9.55297122675762, -2.01843356939834, 0.670059394260476, -0.257905981099553, 10.899541274751, -1.06805465250648, 0.225667733462114, -0.0749149177264327, 0.0288347652771179, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278317, 3.42857142857142, 0.989743318610801, 3.04933917230522, 4.98646126209433, -2.72741187029098, 2.16024689946928, 8.34624849531681, -3.63654916038797, 1.51635079315151, 12.0498962651137, 10.6270096138723, -2.24536559755125, 0.745394019896836, -0.286902292026516, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.16024689946929, 1.8142294704443, 2.96776330720949, 0.896421457000799, 5.41604758366941, -0.160356745147461, -9.52579344415678, 4.60043706228236, 5.34522483824849, -2.98319809926711, 0.0, 13.3887736279041, 9.90113162256757, -3.28687867566959, 1.26512019212765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835056, 0.766651877999943, 3.83609779052925, 8.63680425592141, 3.1689662255656, 3.65920700676628, 0.0, -8.74817765279707, 6.77630927178941, 0.521640530957299, 0.0, 0.0, 15.0623703313921, 8.33375849255573, -3.20766513935892, 0.0, -1.48137784516813e-14, 0.0, 0.0, 0.0, 0.0},
      {1.41421356237309, -6.73025456655335, 3.65714285714287, 0.0, 9.45502781700869, 5.66881911901251, 0.0, 1.28309015871647e-14, -6.99854212223765, 6.46497628513417, 0.0, 0.0, 0.0, 17.2141375215909, 4.96929346597889, 0.0, 0.0, 0.0, 0.0, 0.0, 1.01585406753202e-14},
      {5.71547606649407, 0.0, -4.61880215351702, -1.21498923528475e-14, 0.0, 12.7279220613579, 0.0, 1.13715737024626e-14, -2.43583362115028e-14, -3.26598632371091, 0.0, 0.0, 0.0, 0.0, 20.0831604418561, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 21; t++)
        {
          for (unsigned int u = 0; u < 21; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 21; s++)
        {
          for (unsigned int t = 0; t < 21; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 11:
      {
        
      // Array of basisvalues.
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.0 + 2.0*r)/(1.0 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.5 + r + Y*(1.5 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[21] = \
      {0.0350747411302849, -0.136032429496563, -0.0669642857142857, 0.0369797251402022, 0.0789181675431415, 0.0600762199922021, -0.00773325352755866, -0.0457505448519731, -0.055688630891648, -0.0379976362244755, -0.0641695953767935, -0.012576058599899, 0.017271652829307, 0.0277862498734358, 0.0202015392852868, 0.0899458787800191, 0.0488154651303458, 0.0200905570240418, 0.00242565996410494, -0.0056367243867244, -0.00542394057003842};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050515, 0.0, 0.0, 0.0, 0.0, 1.42730188533123e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.99999999999999, 0.0, 7.07106781186548, 0.0, 1.0172418463128e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212919, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660784, 0.0, -1.35448938231154e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004132, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690618, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 1.24344978758018e-14, 0.0, -3.83325938999964, 0.0, 17.7482393492988, 0.0, 0.553283335172475, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.7328638264797, 0.0, 3.34664010613632, 4.36435780471984, -1.35687344541151e-14, -5.07468037933238, 0.0, 17.0084012854152, 0.0, 1.52127765851135, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, -1.4210854715202e-14, 0.0, 9.14285714285712, 0.0, 0.0, 0.0, 14.8461497791618, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0},
      {3.09838667696594, 0.0, 7.66811580507235, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 1.06611606826009e-14, 9.29516003089783, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.41602560309062, 0.0, -4.37680963545756, 15.7321327225523, 0.0, 2.01017818278147, 0.0, -4.03686713879668, 0.0, -0.515811962199112, 21.7990825495019, 0.0, 0.451335466924227, 0.0, 0.057669530554236, 0.0, -1.00566098266321e-14, 0.0, -1.12643938743361e-14, 0.0, 0.0},
      {0.0, 6.85714285714284, 1.4210854715202e-14, 0.0, 9.97292252418865, 0.0, 4.32049379893856, 0.0, -7.27309832077594, 1.77635683940025e-14, 0.0, 21.2540192277445, 0.0, 1.49078803979367, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.32049379893857, 0.0, 5.93552661441899, 1.79284291400159, 0.0, -0.32071349029493, 0.0, 9.20087412456472, 0.0, -5.96639619853421, 0.0, 0.0, 19.8022632451351, 0.0, 2.5302403842553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.53330375599989, -1.06581410364015e-14, 0.0, 6.33793245113119, 0.0, 1.67653770533037e-14, 0.0, 13.5526185435788, 0.0, 0.0, 0.0, 0.0, 16.6675169851115, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.82842712474619, 0.0, 7.31428571428574, 0.0, 0.0, 11.337638238025, 0.0, 0.0, 0.0, 12.9299525702683, 0.0, 0.0, 0.0, 0.0, 9.93858693195778, 0.0, 0.0, 0.0, 0.0, 0.0, 1.14352971536391e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278317, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175272, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999999, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063972, -1.05830052442583, 0.305505046330393, 1.041420495798e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823012, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454315, 3.91918358845309, 0.0, 9.69948452238571, 4.2, -1.1869079656298e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.00000000000001, 0.0, -2.82842712474618, 0.0, -1.19730614311919e-14, 12.1243556529821, 0.0, 0.0, 1.26921260252476e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505165, -1.89736659610102, 7.42307488958089, -1.91662969499982, 0.663940002206985, 8.87411967464942, -1.07142857142858, 0.276641667586235, -0.0958314847499854, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923786, 1.67332005306817, 2.18217890235992, 5.74704893215391, -2.53734018966619, 10.062305898749, 8.50420064270762, -2.19577516413422, 0.760638829255681, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.00000000000001, 1.2247448713916, 3.53553390593274, -7.37711113563318, 4.57142857142855, 1.64957219768464, 0.0, 11.4997781699989, 7.42307488958092, -2.57142857142858, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848298, 6.64078308635361, 3.83405790253616, 0.0, -6.19677335393189, 5.3665631459995, 0.0, -1.02942565495247e-14, 13.4164078649988, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.32934244475986e-14, 0.0},
      {-3.57770876399966, 0.0, 8.85437744847149, 0.0, 0.0, -3.09838667696592, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 1.35447209004269e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 2.02338146237935e-14},
      {2.70801280154531, 5.6856424977521, -2.18840481772877, 7.86606636127614, -2.61129805863298, 1.00508909139073, 9.55297122675762, -2.01843356939834, 0.670059394260476, -0.257905981099553, 10.899541274751, -1.06805465250648, 0.225667733462114, -0.0749149177264327, 0.0288347652771179, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278317, 3.42857142857142, 0.989743318610801, 3.04933917230522, 4.98646126209433, -2.72741187029098, 2.16024689946928, 8.34624849531681, -3.63654916038797, 1.51635079315151, 12.0498962651137, 10.6270096138723, -2.24536559755125, 0.745394019896836, -0.286902292026516, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.16024689946929, 1.8142294704443, 2.96776330720949, 0.896421457000799, 5.41604758366941, -0.160356745147461, -9.52579344415678, 4.60043706228236, 5.34522483824849, -2.98319809926711, 0.0, 13.3887736279041, 9.90113162256757, -3.28687867566959, 1.26512019212765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835056, 0.766651877999943, 3.83609779052925, 8.63680425592141, 3.1689662255656, 3.65920700676628, 0.0, -8.74817765279707, 6.77630927178941, 0.521640530957299, 0.0, 0.0, 15.0623703313921, 8.33375849255573, -3.20766513935892, 0.0, -1.48137784516813e-14, 0.0, 0.0, 0.0, 0.0},
      {1.41421356237309, -6.73025456655335, 3.65714285714287, 0.0, 9.45502781700869, 5.66881911901251, 0.0, 1.28309015871647e-14, -6.99854212223765, 6.46497628513417, 0.0, 0.0, 0.0, 17.2141375215909, 4.96929346597889, 0.0, 0.0, 0.0, 0.0, 0.0, 1.01585406753202e-14},
      {5.71547606649407, 0.0, -4.61880215351702, -1.21498923528475e-14, 0.0, 12.7279220613579, 0.0, 1.13715737024626e-14, -2.43583362115028e-14, -3.26598632371091, 0.0, 0.0, 0.0, 0.0, 20.0831604418561, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 21; t++)
        {
          for (unsigned int u = 0; u < 21; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 21; s++)
        {
          for (unsigned int t = 0; t < 21; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 12:
      {
        
      // Array of basisvalues.
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.0 + 2.0*r)/(1.0 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.5 + r + Y*(1.5 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[21] = \
      {0.0350747411302853, 0.121713226391662, -0.0322420634920635, -0.0671672558668979, -0.0321518460360947, 0.0276755620188795, 0.139198563496054, 0.0653579212171044, -0.0101252056166633, -0.0292289509419042, 0.0427797302511957, -0.0565922636995451, -0.0332147169794367, 0.00926208329114528, 0.0202015392852869, -0.179891757560038, -0.0325436434202306, 0.0114803182994524, 0.00970263985641995, -0.00187890812890815, -0.00542394057003845};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050515, 0.0, 0.0, 0.0, 0.0, 1.42730188533123e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.99999999999999, 0.0, 7.07106781186548, 0.0, 1.0172418463128e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212919, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660784, 0.0, -1.35448938231154e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004132, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690618, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 1.24344978758018e-14, 0.0, -3.83325938999964, 0.0, 17.7482393492988, 0.0, 0.553283335172475, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.7328638264797, 0.0, 3.34664010613632, 4.36435780471984, -1.35687344541151e-14, -5.07468037933238, 0.0, 17.0084012854152, 0.0, 1.52127765851135, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, -1.4210854715202e-14, 0.0, 9.14285714285712, 0.0, 0.0, 0.0, 14.8461497791618, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0},
      {3.09838667696594, 0.0, 7.66811580507235, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 1.06611606826009e-14, 9.29516003089783, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.41602560309062, 0.0, -4.37680963545756, 15.7321327225523, 0.0, 2.01017818278147, 0.0, -4.03686713879668, 0.0, -0.515811962199112, 21.7990825495019, 0.0, 0.451335466924227, 0.0, 0.057669530554236, 0.0, -1.00566098266321e-14, 0.0, -1.12643938743361e-14, 0.0, 0.0},
      {0.0, 6.85714285714284, 1.4210854715202e-14, 0.0, 9.97292252418865, 0.0, 4.32049379893856, 0.0, -7.27309832077594, 1.77635683940025e-14, 0.0, 21.2540192277445, 0.0, 1.49078803979367, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.32049379893857, 0.0, 5.93552661441899, 1.79284291400159, 0.0, -0.32071349029493, 0.0, 9.20087412456472, 0.0, -5.96639619853421, 0.0, 0.0, 19.8022632451351, 0.0, 2.5302403842553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.53330375599989, -1.06581410364015e-14, 0.0, 6.33793245113119, 0.0, 1.67653770533037e-14, 0.0, 13.5526185435788, 0.0, 0.0, 0.0, 0.0, 16.6675169851115, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.82842712474619, 0.0, 7.31428571428574, 0.0, 0.0, 11.337638238025, 0.0, 0.0, 0.0, 12.9299525702683, 0.0, 0.0, 0.0, 0.0, 9.93858693195778, 0.0, 0.0, 0.0, 0.0, 0.0, 1.14352971536391e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278317, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175272, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999999, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063972, -1.05830052442583, 0.305505046330393, 1.041420495798e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823012, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454315, 3.91918358845309, 0.0, 9.69948452238571, 4.2, -1.1869079656298e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.00000000000001, 0.0, -2.82842712474618, 0.0, -1.19730614311919e-14, 12.1243556529821, 0.0, 0.0, 1.26921260252476e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505165, -1.89736659610102, 7.42307488958089, -1.91662969499982, 0.663940002206985, 8.87411967464942, -1.07142857142858, 0.276641667586235, -0.0958314847499854, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923786, 1.67332005306817, 2.18217890235992, 5.74704893215391, -2.53734018966619, 10.062305898749, 8.50420064270762, -2.19577516413422, 0.760638829255681, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.00000000000001, 1.2247448713916, 3.53553390593274, -7.37711113563318, 4.57142857142855, 1.64957219768464, 0.0, 11.4997781699989, 7.42307488958092, -2.57142857142858, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848298, 6.64078308635361, 3.83405790253616, 0.0, -6.19677335393189, 5.3665631459995, 0.0, -1.02942565495247e-14, 13.4164078649988, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.32934244475986e-14, 0.0},
      {-3.57770876399966, 0.0, 8.85437744847149, 0.0, 0.0, -3.09838667696592, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 1.35447209004269e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 2.02338146237935e-14},
      {2.70801280154531, 5.6856424977521, -2.18840481772877, 7.86606636127614, -2.61129805863298, 1.00508909139073, 9.55297122675762, -2.01843356939834, 0.670059394260476, -0.257905981099553, 10.899541274751, -1.06805465250648, 0.225667733462114, -0.0749149177264327, 0.0288347652771179, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278317, 3.42857142857142, 0.989743318610801, 3.04933917230522, 4.98646126209433, -2.72741187029098, 2.16024689946928, 8.34624849531681, -3.63654916038797, 1.51635079315151, 12.0498962651137, 10.6270096138723, -2.24536559755125, 0.745394019896836, -0.286902292026516, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.16024689946929, 1.8142294704443, 2.96776330720949, 0.896421457000799, 5.41604758366941, -0.160356745147461, -9.52579344415678, 4.60043706228236, 5.34522483824849, -2.98319809926711, 0.0, 13.3887736279041, 9.90113162256757, -3.28687867566959, 1.26512019212765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835056, 0.766651877999943, 3.83609779052925, 8.63680425592141, 3.1689662255656, 3.65920700676628, 0.0, -8.74817765279707, 6.77630927178941, 0.521640530957299, 0.0, 0.0, 15.0623703313921, 8.33375849255573, -3.20766513935892, 0.0, -1.48137784516813e-14, 0.0, 0.0, 0.0, 0.0},
      {1.41421356237309, -6.73025456655335, 3.65714285714287, 0.0, 9.45502781700869, 5.66881911901251, 0.0, 1.28309015871647e-14, -6.99854212223765, 6.46497628513417, 0.0, 0.0, 0.0, 17.2141375215909, 4.96929346597889, 0.0, 0.0, 0.0, 0.0, 0.0, 1.01585406753202e-14},
      {5.71547606649407, 0.0, -4.61880215351702, -1.21498923528475e-14, 0.0, 12.7279220613579, 0.0, 1.13715737024626e-14, -2.43583362115028e-14, -3.26598632371091, 0.0, 0.0, 0.0, 0.0, 20.0831604418561, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 21; t++)
        {
          for (unsigned int u = 0; u < 21; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 21; s++)
        {
          for (unsigned int t = 0; t < 21; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 13:
      {
        
      // Array of basisvalues.
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.0 + 2.0*r)/(1.0 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.5 + r + Y*(1.5 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[21] = \
      {0.0350747411302852, -0.121713226391662, -0.0322420634920636, -0.0671672558668978, 0.0321518460360947, 0.0276755620188796, -0.139198563496054, 0.0653579212171044, 0.0101252056166633, -0.0292289509419043, 0.0427797302511955, 0.0565922636995451, -0.0332147169794366, -0.0092620832911453, 0.0202015392852868, 0.179891757560038, -0.0325436434202305, -0.0114803182994525, 0.00970263985641989, 0.00187890812890816, -0.0054239405700384};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050515, 0.0, 0.0, 0.0, 0.0, 1.42730188533123e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.99999999999999, 0.0, 7.07106781186548, 0.0, 1.0172418463128e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212919, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660784, 0.0, -1.35448938231154e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004132, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690618, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 1.24344978758018e-14, 0.0, -3.83325938999964, 0.0, 17.7482393492988, 0.0, 0.553283335172475, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.7328638264797, 0.0, 3.34664010613632, 4.36435780471984, -1.35687344541151e-14, -5.07468037933238, 0.0, 17.0084012854152, 0.0, 1.52127765851135, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, -1.4210854715202e-14, 0.0, 9.14285714285712, 0.0, 0.0, 0.0, 14.8461497791618, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0},
      {3.09838667696594, 0.0, 7.66811580507235, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 1.06611606826009e-14, 9.29516003089783, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.41602560309062, 0.0, -4.37680963545756, 15.7321327225523, 0.0, 2.01017818278147, 0.0, -4.03686713879668, 0.0, -0.515811962199112, 21.7990825495019, 0.0, 0.451335466924227, 0.0, 0.057669530554236, 0.0, -1.00566098266321e-14, 0.0, -1.12643938743361e-14, 0.0, 0.0},
      {0.0, 6.85714285714284, 1.4210854715202e-14, 0.0, 9.97292252418865, 0.0, 4.32049379893856, 0.0, -7.27309832077594, 1.77635683940025e-14, 0.0, 21.2540192277445, 0.0, 1.49078803979367, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.32049379893857, 0.0, 5.93552661441899, 1.79284291400159, 0.0, -0.32071349029493, 0.0, 9.20087412456472, 0.0, -5.96639619853421, 0.0, 0.0, 19.8022632451351, 0.0, 2.5302403842553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.53330375599989, -1.06581410364015e-14, 0.0, 6.33793245113119, 0.0, 1.67653770533037e-14, 0.0, 13.5526185435788, 0.0, 0.0, 0.0, 0.0, 16.6675169851115, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.82842712474619, 0.0, 7.31428571428574, 0.0, 0.0, 11.337638238025, 0.0, 0.0, 0.0, 12.9299525702683, 0.0, 0.0, 0.0, 0.0, 9.93858693195778, 0.0, 0.0, 0.0, 0.0, 0.0, 1.14352971536391e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278317, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175272, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999999, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063972, -1.05830052442583, 0.305505046330393, 1.041420495798e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823012, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454315, 3.91918358845309, 0.0, 9.69948452238571, 4.2, -1.1869079656298e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.00000000000001, 0.0, -2.82842712474618, 0.0, -1.19730614311919e-14, 12.1243556529821, 0.0, 0.0, 1.26921260252476e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505165, -1.89736659610102, 7.42307488958089, -1.91662969499982, 0.663940002206985, 8.87411967464942, -1.07142857142858, 0.276641667586235, -0.0958314847499854, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923786, 1.67332005306817, 2.18217890235992, 5.74704893215391, -2.53734018966619, 10.062305898749, 8.50420064270762, -2.19577516413422, 0.760638829255681, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.00000000000001, 1.2247448713916, 3.53553390593274, -7.37711113563318, 4.57142857142855, 1.64957219768464, 0.0, 11.4997781699989, 7.42307488958092, -2.57142857142858, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848298, 6.64078308635361, 3.83405790253616, 0.0, -6.19677335393189, 5.3665631459995, 0.0, -1.02942565495247e-14, 13.4164078649988, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.32934244475986e-14, 0.0},
      {-3.57770876399966, 0.0, 8.85437744847149, 0.0, 0.0, -3.09838667696592, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 1.35447209004269e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 2.02338146237935e-14},
      {2.70801280154531, 5.6856424977521, -2.18840481772877, 7.86606636127614, -2.61129805863298, 1.00508909139073, 9.55297122675762, -2.01843356939834, 0.670059394260476, -0.257905981099553, 10.899541274751, -1.06805465250648, 0.225667733462114, -0.0749149177264327, 0.0288347652771179, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278317, 3.42857142857142, 0.989743318610801, 3.04933917230522, 4.98646126209433, -2.72741187029098, 2.16024689946928, 8.34624849531681, -3.63654916038797, 1.51635079315151, 12.0498962651137, 10.6270096138723, -2.24536559755125, 0.745394019896836, -0.286902292026516, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.16024689946929, 1.8142294704443, 2.96776330720949, 0.896421457000799, 5.41604758366941, -0.160356745147461, -9.52579344415678, 4.60043706228236, 5.34522483824849, -2.98319809926711, 0.0, 13.3887736279041, 9.90113162256757, -3.28687867566959, 1.26512019212765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835056, 0.766651877999943, 3.83609779052925, 8.63680425592141, 3.1689662255656, 3.65920700676628, 0.0, -8.74817765279707, 6.77630927178941, 0.521640530957299, 0.0, 0.0, 15.0623703313921, 8.33375849255573, -3.20766513935892, 0.0, -1.48137784516813e-14, 0.0, 0.0, 0.0, 0.0},
      {1.41421356237309, -6.73025456655335, 3.65714285714287, 0.0, 9.45502781700869, 5.66881911901251, 0.0, 1.28309015871647e-14, -6.99854212223765, 6.46497628513417, 0.0, 0.0, 0.0, 17.2141375215909, 4.96929346597889, 0.0, 0.0, 0.0, 0.0, 0.0, 1.01585406753202e-14},
      {5.71547606649407, 0.0, -4.61880215351702, -1.21498923528475e-14, 0.0, 12.7279220613579, 0.0, 1.13715737024626e-14, -2.43583362115028e-14, -3.26598632371091, 0.0, 0.0, 0.0, 0.0, 20.0831604418561, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 21; t++)
        {
          for (unsigned int u = 0; u < 21; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 21; s++)
        {
          for (unsigned int t = 0; t < 21; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 14:
      {
        
      // Array of basisvalues.
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.0 + 2.0*r)/(1.0 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.5 + r + Y*(1.5 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[21] = \
      {0.035074741130285, 0.136032429496564, -0.0669642857142856, 0.0369797251402022, -0.0789181675431414, 0.060076219992202, 0.00773325352755864, -0.0457505448519731, 0.0556886308916479, -0.0379976362244755, -0.0641695953767934, 0.0125760585998989, 0.017271652829307, -0.0277862498734358, 0.0202015392852869, -0.0899458787800192, 0.0488154651303458, -0.0200905570240418, 0.00242565996410498, 0.0056367243867244, -0.00542394057003847};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050515, 0.0, 0.0, 0.0, 0.0, 1.42730188533123e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.99999999999999, 0.0, 7.07106781186548, 0.0, 1.0172418463128e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212919, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660784, 0.0, -1.35448938231154e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004132, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690618, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 1.24344978758018e-14, 0.0, -3.83325938999964, 0.0, 17.7482393492988, 0.0, 0.553283335172475, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.7328638264797, 0.0, 3.34664010613632, 4.36435780471984, -1.35687344541151e-14, -5.07468037933238, 0.0, 17.0084012854152, 0.0, 1.52127765851135, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, -1.4210854715202e-14, 0.0, 9.14285714285712, 0.0, 0.0, 0.0, 14.8461497791618, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0},
      {3.09838667696594, 0.0, 7.66811580507235, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 1.06611606826009e-14, 9.29516003089783, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.41602560309062, 0.0, -4.37680963545756, 15.7321327225523, 0.0, 2.01017818278147, 0.0, -4.03686713879668, 0.0, -0.515811962199112, 21.7990825495019, 0.0, 0.451335466924227, 0.0, 0.057669530554236, 0.0, -1.00566098266321e-14, 0.0, -1.12643938743361e-14, 0.0, 0.0},
      {0.0, 6.85714285714284, 1.4210854715202e-14, 0.0, 9.97292252418865, 0.0, 4.32049379893856, 0.0, -7.27309832077594, 1.77635683940025e-14, 0.0, 21.2540192277445, 0.0, 1.49078803979367, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.32049379893857, 0.0, 5.93552661441899, 1.79284291400159, 0.0, -0.32071349029493, 0.0, 9.20087412456472, 0.0, -5.96639619853421, 0.0, 0.0, 19.8022632451351, 0.0, 2.5302403842553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.53330375599989, -1.06581410364015e-14, 0.0, 6.33793245113119, 0.0, 1.67653770533037e-14, 0.0, 13.5526185435788, 0.0, 0.0, 0.0, 0.0, 16.6675169851115, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.82842712474619, 0.0, 7.31428571428574, 0.0, 0.0, 11.337638238025, 0.0, 0.0, 0.0, 12.9299525702683, 0.0, 0.0, 0.0, 0.0, 9.93858693195778, 0.0, 0.0, 0.0, 0.0, 0.0, 1.14352971536391e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278317, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175272, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999999, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063972, -1.05830052442583, 0.305505046330393, 1.041420495798e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823012, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454315, 3.91918358845309, 0.0, 9.69948452238571, 4.2, -1.1869079656298e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.00000000000001, 0.0, -2.82842712474618, 0.0, -1.19730614311919e-14, 12.1243556529821, 0.0, 0.0, 1.26921260252476e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505165, -1.89736659610102, 7.42307488958089, -1.91662969499982, 0.663940002206985, 8.87411967464942, -1.07142857142858, 0.276641667586235, -0.0958314847499854, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923786, 1.67332005306817, 2.18217890235992, 5.74704893215391, -2.53734018966619, 10.062305898749, 8.50420064270762, -2.19577516413422, 0.760638829255681, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.00000000000001, 1.2247448713916, 3.53553390593274, -7.37711113563318, 4.57142857142855, 1.64957219768464, 0.0, 11.4997781699989, 7.42307488958092, -2.57142857142858, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848298, 6.64078308635361, 3.83405790253616, 0.0, -6.19677335393189, 5.3665631459995, 0.0, -1.02942565495247e-14, 13.4164078649988, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.32934244475986e-14, 0.0},
      {-3.57770876399966, 0.0, 8.85437744847149, 0.0, 0.0, -3.09838667696592, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 1.35447209004269e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 2.02338146237935e-14},
      {2.70801280154531, 5.6856424977521, -2.18840481772877, 7.86606636127614, -2.61129805863298, 1.00508909139073, 9.55297122675762, -2.01843356939834, 0.670059394260476, -0.257905981099553, 10.899541274751, -1.06805465250648, 0.225667733462114, -0.0749149177264327, 0.0288347652771179, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278317, 3.42857142857142, 0.989743318610801, 3.04933917230522, 4.98646126209433, -2.72741187029098, 2.16024689946928, 8.34624849531681, -3.63654916038797, 1.51635079315151, 12.0498962651137, 10.6270096138723, -2.24536559755125, 0.745394019896836, -0.286902292026516, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.16024689946929, 1.8142294704443, 2.96776330720949, 0.896421457000799, 5.41604758366941, -0.160356745147461, -9.52579344415678, 4.60043706228236, 5.34522483824849, -2.98319809926711, 0.0, 13.3887736279041, 9.90113162256757, -3.28687867566959, 1.26512019212765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835056, 0.766651877999943, 3.83609779052925, 8.63680425592141, 3.1689662255656, 3.65920700676628, 0.0, -8.74817765279707, 6.77630927178941, 0.521640530957299, 0.0, 0.0, 15.0623703313921, 8.33375849255573, -3.20766513935892, 0.0, -1.48137784516813e-14, 0.0, 0.0, 0.0, 0.0},
      {1.41421356237309, -6.73025456655335, 3.65714285714287, 0.0, 9.45502781700869, 5.66881911901251, 0.0, 1.28309015871647e-14, -6.99854212223765, 6.46497628513417, 0.0, 0.0, 0.0, 17.2141375215909, 4.96929346597889, 0.0, 0.0, 0.0, 0.0, 0.0, 1.01585406753202e-14},
      {5.71547606649407, 0.0, -4.61880215351702, -1.21498923528475e-14, 0.0, 12.7279220613579, 0.0, 1.13715737024626e-14, -2.43583362115028e-14, -3.26598632371091, 0.0, 0.0, 0.0, 0.0, 20.0831604418561, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 21; t++)
        {
          for (unsigned int u = 0; u < 21; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 21; s++)
        {
          for (unsigned int t = 0; t < 21; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 15:
      {
        
      // Array of basisvalues.
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.0 + 2.0*r)/(1.0 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.5 + r + Y*(1.5 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[21] = \
      {0.280597929042281, -0.214788046573521, -0.124007936507937, 0.0905625921800872, 0.116915803767617, 0.0, 0.154665070551172, 0.0784295054605253, 0.101252056166633, 0.0818410626373319, -0.142599100837319, 0.0251521171997979, -0.0318861283002592, -0.107028518031012, -0.0950660672248791, 0.0, -0.130174573680922, -0.103322864695072, -0.0291079195692595, 0.0263047138047138, 0.0325436434202306};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050515, 0.0, 0.0, 0.0, 0.0, 1.42730188533123e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.99999999999999, 0.0, 7.07106781186548, 0.0, 1.0172418463128e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212919, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660784, 0.0, -1.35448938231154e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004132, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690618, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 1.24344978758018e-14, 0.0, -3.83325938999964, 0.0, 17.7482393492988, 0.0, 0.553283335172475, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.7328638264797, 0.0, 3.34664010613632, 4.36435780471984, -1.35687344541151e-14, -5.07468037933238, 0.0, 17.0084012854152, 0.0, 1.52127765851135, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, -1.4210854715202e-14, 0.0, 9.14285714285712, 0.0, 0.0, 0.0, 14.8461497791618, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0},
      {3.09838667696594, 0.0, 7.66811580507235, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 1.06611606826009e-14, 9.29516003089783, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.41602560309062, 0.0, -4.37680963545756, 15.7321327225523, 0.0, 2.01017818278147, 0.0, -4.03686713879668, 0.0, -0.515811962199112, 21.7990825495019, 0.0, 0.451335466924227, 0.0, 0.057669530554236, 0.0, -1.00566098266321e-14, 0.0, -1.12643938743361e-14, 0.0, 0.0},
      {0.0, 6.85714285714284, 1.4210854715202e-14, 0.0, 9.97292252418865, 0.0, 4.32049379893856, 0.0, -7.27309832077594, 1.77635683940025e-14, 0.0, 21.2540192277445, 0.0, 1.49078803979367, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.32049379893857, 0.0, 5.93552661441899, 1.79284291400159, 0.0, -0.32071349029493, 0.0, 9.20087412456472, 0.0, -5.96639619853421, 0.0, 0.0, 19.8022632451351, 0.0, 2.5302403842553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.53330375599989, -1.06581410364015e-14, 0.0, 6.33793245113119, 0.0, 1.67653770533037e-14, 0.0, 13.5526185435788, 0.0, 0.0, 0.0, 0.0, 16.6675169851115, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.82842712474619, 0.0, 7.31428571428574, 0.0, 0.0, 11.337638238025, 0.0, 0.0, 0.0, 12.9299525702683, 0.0, 0.0, 0.0, 0.0, 9.93858693195778, 0.0, 0.0, 0.0, 0.0, 0.0, 1.14352971536391e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278317, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175272, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999999, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063972, -1.05830052442583, 0.305505046330393, 1.041420495798e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823012, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454315, 3.91918358845309, 0.0, 9.69948452238571, 4.2, -1.1869079656298e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.00000000000001, 0.0, -2.82842712474618, 0.0, -1.19730614311919e-14, 12.1243556529821, 0.0, 0.0, 1.26921260252476e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505165, -1.89736659610102, 7.42307488958089, -1.91662969499982, 0.663940002206985, 8.87411967464942, -1.07142857142858, 0.276641667586235, -0.0958314847499854, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923786, 1.67332005306817, 2.18217890235992, 5.74704893215391, -2.53734018966619, 10.062305898749, 8.50420064270762, -2.19577516413422, 0.760638829255681, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.00000000000001, 1.2247448713916, 3.53553390593274, -7.37711113563318, 4.57142857142855, 1.64957219768464, 0.0, 11.4997781699989, 7.42307488958092, -2.57142857142858, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848298, 6.64078308635361, 3.83405790253616, 0.0, -6.19677335393189, 5.3665631459995, 0.0, -1.02942565495247e-14, 13.4164078649988, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.32934244475986e-14, 0.0},
      {-3.57770876399966, 0.0, 8.85437744847149, 0.0, 0.0, -3.09838667696592, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 1.35447209004269e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 2.02338146237935e-14},
      {2.70801280154531, 5.6856424977521, -2.18840481772877, 7.86606636127614, -2.61129805863298, 1.00508909139073, 9.55297122675762, -2.01843356939834, 0.670059394260476, -0.257905981099553, 10.899541274751, -1.06805465250648, 0.225667733462114, -0.0749149177264327, 0.0288347652771179, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278317, 3.42857142857142, 0.989743318610801, 3.04933917230522, 4.98646126209433, -2.72741187029098, 2.16024689946928, 8.34624849531681, -3.63654916038797, 1.51635079315151, 12.0498962651137, 10.6270096138723, -2.24536559755125, 0.745394019896836, -0.286902292026516, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.16024689946929, 1.8142294704443, 2.96776330720949, 0.896421457000799, 5.41604758366941, -0.160356745147461, -9.52579344415678, 4.60043706228236, 5.34522483824849, -2.98319809926711, 0.0, 13.3887736279041, 9.90113162256757, -3.28687867566959, 1.26512019212765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835056, 0.766651877999943, 3.83609779052925, 8.63680425592141, 3.1689662255656, 3.65920700676628, 0.0, -8.74817765279707, 6.77630927178941, 0.521640530957299, 0.0, 0.0, 15.0623703313921, 8.33375849255573, -3.20766513935892, 0.0, -1.48137784516813e-14, 0.0, 0.0, 0.0, 0.0},
      {1.41421356237309, -6.73025456655335, 3.65714285714287, 0.0, 9.45502781700869, 5.66881911901251, 0.0, 1.28309015871647e-14, -6.99854212223765, 6.46497628513417, 0.0, 0.0, 0.0, 17.2141375215909, 4.96929346597889, 0.0, 0.0, 0.0, 0.0, 0.0, 1.01585406753202e-14},
      {5.71547606649407, 0.0, -4.61880215351702, -1.21498923528475e-14, 0.0, 12.7279220613579, 0.0, 1.13715737024626e-14, -2.43583362115028e-14, -3.26598632371091, 0.0, 0.0, 0.0, 0.0, 20.0831604418561, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 21; t++)
        {
          for (unsigned int u = 0; u < 21; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 21; s++)
        {
          for (unsigned int t = 0; t < 21; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 16:
      {
        
      // Array of basisvalues.
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.0 + 2.0*r)/(1.0 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.5 + r + Y*(1.5 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[21] = \
      {0.0350747411302854, 0.0, -0.124007936507936, -0.38489101676537, 0.0, 0.101252056166633, 0.0, -0.104572673947367, 0.0, 0.0467663215070469, 0.213898651255978, 0.0, 0.140830399992811, 0.0, -0.0950660672248791, 0.0, 0.195261860521383, 0.0, -0.0582158391385195, 0.0, 0.0325436434202304};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050515, 0.0, 0.0, 0.0, 0.0, 1.42730188533123e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.99999999999999, 0.0, 7.07106781186548, 0.0, 1.0172418463128e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212919, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660784, 0.0, -1.35448938231154e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004132, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690618, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 1.24344978758018e-14, 0.0, -3.83325938999964, 0.0, 17.7482393492988, 0.0, 0.553283335172475, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.7328638264797, 0.0, 3.34664010613632, 4.36435780471984, -1.35687344541151e-14, -5.07468037933238, 0.0, 17.0084012854152, 0.0, 1.52127765851135, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, -1.4210854715202e-14, 0.0, 9.14285714285712, 0.0, 0.0, 0.0, 14.8461497791618, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0},
      {3.09838667696594, 0.0, 7.66811580507235, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 1.06611606826009e-14, 9.29516003089783, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.41602560309062, 0.0, -4.37680963545756, 15.7321327225523, 0.0, 2.01017818278147, 0.0, -4.03686713879668, 0.0, -0.515811962199112, 21.7990825495019, 0.0, 0.451335466924227, 0.0, 0.057669530554236, 0.0, -1.00566098266321e-14, 0.0, -1.12643938743361e-14, 0.0, 0.0},
      {0.0, 6.85714285714284, 1.4210854715202e-14, 0.0, 9.97292252418865, 0.0, 4.32049379893856, 0.0, -7.27309832077594, 1.77635683940025e-14, 0.0, 21.2540192277445, 0.0, 1.49078803979367, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.32049379893857, 0.0, 5.93552661441899, 1.79284291400159, 0.0, -0.32071349029493, 0.0, 9.20087412456472, 0.0, -5.96639619853421, 0.0, 0.0, 19.8022632451351, 0.0, 2.5302403842553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.53330375599989, -1.06581410364015e-14, 0.0, 6.33793245113119, 0.0, 1.67653770533037e-14, 0.0, 13.5526185435788, 0.0, 0.0, 0.0, 0.0, 16.6675169851115, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.82842712474619, 0.0, 7.31428571428574, 0.0, 0.0, 11.337638238025, 0.0, 0.0, 0.0, 12.9299525702683, 0.0, 0.0, 0.0, 0.0, 9.93858693195778, 0.0, 0.0, 0.0, 0.0, 0.0, 1.14352971536391e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278317, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175272, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999999, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063972, -1.05830052442583, 0.305505046330393, 1.041420495798e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823012, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454315, 3.91918358845309, 0.0, 9.69948452238571, 4.2, -1.1869079656298e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.00000000000001, 0.0, -2.82842712474618, 0.0, -1.19730614311919e-14, 12.1243556529821, 0.0, 0.0, 1.26921260252476e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505165, -1.89736659610102, 7.42307488958089, -1.91662969499982, 0.663940002206985, 8.87411967464942, -1.07142857142858, 0.276641667586235, -0.0958314847499854, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923786, 1.67332005306817, 2.18217890235992, 5.74704893215391, -2.53734018966619, 10.062305898749, 8.50420064270762, -2.19577516413422, 0.760638829255681, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.00000000000001, 1.2247448713916, 3.53553390593274, -7.37711113563318, 4.57142857142855, 1.64957219768464, 0.0, 11.4997781699989, 7.42307488958092, -2.57142857142858, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848298, 6.64078308635361, 3.83405790253616, 0.0, -6.19677335393189, 5.3665631459995, 0.0, -1.02942565495247e-14, 13.4164078649988, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.32934244475986e-14, 0.0},
      {-3.57770876399966, 0.0, 8.85437744847149, 0.0, 0.0, -3.09838667696592, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 1.35447209004269e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 2.02338146237935e-14},
      {2.70801280154531, 5.6856424977521, -2.18840481772877, 7.86606636127614, -2.61129805863298, 1.00508909139073, 9.55297122675762, -2.01843356939834, 0.670059394260476, -0.257905981099553, 10.899541274751, -1.06805465250648, 0.225667733462114, -0.0749149177264327, 0.0288347652771179, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278317, 3.42857142857142, 0.989743318610801, 3.04933917230522, 4.98646126209433, -2.72741187029098, 2.16024689946928, 8.34624849531681, -3.63654916038797, 1.51635079315151, 12.0498962651137, 10.6270096138723, -2.24536559755125, 0.745394019896836, -0.286902292026516, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.16024689946929, 1.8142294704443, 2.96776330720949, 0.896421457000799, 5.41604758366941, -0.160356745147461, -9.52579344415678, 4.60043706228236, 5.34522483824849, -2.98319809926711, 0.0, 13.3887736279041, 9.90113162256757, -3.28687867566959, 1.26512019212765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835056, 0.766651877999943, 3.83609779052925, 8.63680425592141, 3.1689662255656, 3.65920700676628, 0.0, -8.74817765279707, 6.77630927178941, 0.521640530957299, 0.0, 0.0, 15.0623703313921, 8.33375849255573, -3.20766513935892, 0.0, -1.48137784516813e-14, 0.0, 0.0, 0.0, 0.0},
      {1.41421356237309, -6.73025456655335, 3.65714285714287, 0.0, 9.45502781700869, 5.66881911901251, 0.0, 1.28309015871647e-14, -6.99854212223765, 6.46497628513417, 0.0, 0.0, 0.0, 17.2141375215909, 4.96929346597889, 0.0, 0.0, 0.0, 0.0, 0.0, 1.01585406753202e-14},
      {5.71547606649407, 0.0, -4.61880215351702, -1.21498923528475e-14, 0.0, 12.7279220613579, 0.0, 1.13715737024626e-14, -2.43583362115028e-14, -3.26598632371091, 0.0, 0.0, 0.0, 0.0, 20.0831604418561, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 21; t++)
        {
          for (unsigned int u = 0; u < 21; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 21; s++)
        {
          for (unsigned int t = 0; t < 21; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 17:
      {
        
      // Array of basisvalues.
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.0 + 2.0*r)/(1.0 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.5 + r + Y*(1.5 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[21] = \
      {0.280597929042281, 0.214788046573521, -0.124007936507937, 0.090562592180087, -0.116915803767617, 0.0, -0.154665070551172, 0.0784295054605253, -0.101252056166633, 0.0818410626373318, -0.142599100837319, -0.0251521171997978, -0.0318861283002592, 0.107028518031012, -0.0950660672248792, 0.0, -0.130174573680922, 0.103322864695072, -0.0291079195692596, -0.0263047138047138, 0.0325436434202306};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050515, 0.0, 0.0, 0.0, 0.0, 1.42730188533123e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.99999999999999, 0.0, 7.07106781186548, 0.0, 1.0172418463128e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212919, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660784, 0.0, -1.35448938231154e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004132, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690618, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 1.24344978758018e-14, 0.0, -3.83325938999964, 0.0, 17.7482393492988, 0.0, 0.553283335172475, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.7328638264797, 0.0, 3.34664010613632, 4.36435780471984, -1.35687344541151e-14, -5.07468037933238, 0.0, 17.0084012854152, 0.0, 1.52127765851135, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, -1.4210854715202e-14, 0.0, 9.14285714285712, 0.0, 0.0, 0.0, 14.8461497791618, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0},
      {3.09838667696594, 0.0, 7.66811580507235, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 1.06611606826009e-14, 9.29516003089783, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.41602560309062, 0.0, -4.37680963545756, 15.7321327225523, 0.0, 2.01017818278147, 0.0, -4.03686713879668, 0.0, -0.515811962199112, 21.7990825495019, 0.0, 0.451335466924227, 0.0, 0.057669530554236, 0.0, -1.00566098266321e-14, 0.0, -1.12643938743361e-14, 0.0, 0.0},
      {0.0, 6.85714285714284, 1.4210854715202e-14, 0.0, 9.97292252418865, 0.0, 4.32049379893856, 0.0, -7.27309832077594, 1.77635683940025e-14, 0.0, 21.2540192277445, 0.0, 1.49078803979367, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.32049379893857, 0.0, 5.93552661441899, 1.79284291400159, 0.0, -0.32071349029493, 0.0, 9.20087412456472, 0.0, -5.96639619853421, 0.0, 0.0, 19.8022632451351, 0.0, 2.5302403842553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.53330375599989, -1.06581410364015e-14, 0.0, 6.33793245113119, 0.0, 1.67653770533037e-14, 0.0, 13.5526185435788, 0.0, 0.0, 0.0, 0.0, 16.6675169851115, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.82842712474619, 0.0, 7.31428571428574, 0.0, 0.0, 11.337638238025, 0.0, 0.0, 0.0, 12.9299525702683, 0.0, 0.0, 0.0, 0.0, 9.93858693195778, 0.0, 0.0, 0.0, 0.0, 0.0, 1.14352971536391e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278317, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175272, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999999, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063972, -1.05830052442583, 0.305505046330393, 1.041420495798e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823012, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454315, 3.91918358845309, 0.0, 9.69948452238571, 4.2, -1.1869079656298e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.00000000000001, 0.0, -2.82842712474618, 0.0, -1.19730614311919e-14, 12.1243556529821, 0.0, 0.0, 1.26921260252476e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505165, -1.89736659610102, 7.42307488958089, -1.91662969499982, 0.663940002206985, 8.87411967464942, -1.07142857142858, 0.276641667586235, -0.0958314847499854, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923786, 1.67332005306817, 2.18217890235992, 5.74704893215391, -2.53734018966619, 10.062305898749, 8.50420064270762, -2.19577516413422, 0.760638829255681, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.00000000000001, 1.2247448713916, 3.53553390593274, -7.37711113563318, 4.57142857142855, 1.64957219768464, 0.0, 11.4997781699989, 7.42307488958092, -2.57142857142858, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848298, 6.64078308635361, 3.83405790253616, 0.0, -6.19677335393189, 5.3665631459995, 0.0, -1.02942565495247e-14, 13.4164078649988, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.32934244475986e-14, 0.0},
      {-3.57770876399966, 0.0, 8.85437744847149, 0.0, 0.0, -3.09838667696592, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 1.35447209004269e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 2.02338146237935e-14},
      {2.70801280154531, 5.6856424977521, -2.18840481772877, 7.86606636127614, -2.61129805863298, 1.00508909139073, 9.55297122675762, -2.01843356939834, 0.670059394260476, -0.257905981099553, 10.899541274751, -1.06805465250648, 0.225667733462114, -0.0749149177264327, 0.0288347652771179, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278317, 3.42857142857142, 0.989743318610801, 3.04933917230522, 4.98646126209433, -2.72741187029098, 2.16024689946928, 8.34624849531681, -3.63654916038797, 1.51635079315151, 12.0498962651137, 10.6270096138723, -2.24536559755125, 0.745394019896836, -0.286902292026516, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.16024689946929, 1.8142294704443, 2.96776330720949, 0.896421457000799, 5.41604758366941, -0.160356745147461, -9.52579344415678, 4.60043706228236, 5.34522483824849, -2.98319809926711, 0.0, 13.3887736279041, 9.90113162256757, -3.28687867566959, 1.26512019212765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835056, 0.766651877999943, 3.83609779052925, 8.63680425592141, 3.1689662255656, 3.65920700676628, 0.0, -8.74817765279707, 6.77630927178941, 0.521640530957299, 0.0, 0.0, 15.0623703313921, 8.33375849255573, -3.20766513935892, 0.0, -1.48137784516813e-14, 0.0, 0.0, 0.0, 0.0},
      {1.41421356237309, -6.73025456655335, 3.65714285714287, 0.0, 9.45502781700869, 5.66881911901251, 0.0, 1.28309015871647e-14, -6.99854212223765, 6.46497628513417, 0.0, 0.0, 0.0, 17.2141375215909, 4.96929346597889, 0.0, 0.0, 0.0, 0.0, 0.0, 1.01585406753202e-14},
      {5.71547606649407, 0.0, -4.61880215351702, -1.21498923528475e-14, 0.0, 12.7279220613579, 0.0, 1.13715737024626e-14, -2.43583362115028e-14, -3.26598632371091, 0.0, 0.0, 0.0, 0.0, 20.0831604418561, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 21; t++)
        {
          for (unsigned int u = 0; u < 21; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 21; s++)
        {
          for (unsigned int t = 0; t < 21; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 18:
      {
        
      // Array of basisvalues.
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.0 + 2.0*r)/(1.0 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.5 + r + Y*(1.5 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[21] = \
      {0.0350747411302851, -0.107394023286761, 0.0620039682539685, 0.0113203240225107, -0.306903984889995, -0.253130140416582, 0.0, -0.104572673947367, 0.0, 0.0467663215070467, 0.0, 0.169776791098635, 0.00930012075424217, 0.126581804978985, 0.172307246845093, 0.0, 0.0, 0.154984297042608, 0.101877718492409, -0.0394570707070707, -0.0813591085505763};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050515, 0.0, 0.0, 0.0, 0.0, 1.42730188533123e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.99999999999999, 0.0, 7.07106781186548, 0.0, 1.0172418463128e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212919, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660784, 0.0, -1.35448938231154e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004132, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690618, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 1.24344978758018e-14, 0.0, -3.83325938999964, 0.0, 17.7482393492988, 0.0, 0.553283335172475, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.7328638264797, 0.0, 3.34664010613632, 4.36435780471984, -1.35687344541151e-14, -5.07468037933238, 0.0, 17.0084012854152, 0.0, 1.52127765851135, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, -1.4210854715202e-14, 0.0, 9.14285714285712, 0.0, 0.0, 0.0, 14.8461497791618, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0},
      {3.09838667696594, 0.0, 7.66811580507235, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 1.06611606826009e-14, 9.29516003089783, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.41602560309062, 0.0, -4.37680963545756, 15.7321327225523, 0.0, 2.01017818278147, 0.0, -4.03686713879668, 0.0, -0.515811962199112, 21.7990825495019, 0.0, 0.451335466924227, 0.0, 0.057669530554236, 0.0, -1.00566098266321e-14, 0.0, -1.12643938743361e-14, 0.0, 0.0},
      {0.0, 6.85714285714284, 1.4210854715202e-14, 0.0, 9.97292252418865, 0.0, 4.32049379893856, 0.0, -7.27309832077594, 1.77635683940025e-14, 0.0, 21.2540192277445, 0.0, 1.49078803979367, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.32049379893857, 0.0, 5.93552661441899, 1.79284291400159, 0.0, -0.32071349029493, 0.0, 9.20087412456472, 0.0, -5.96639619853421, 0.0, 0.0, 19.8022632451351, 0.0, 2.5302403842553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.53330375599989, -1.06581410364015e-14, 0.0, 6.33793245113119, 0.0, 1.67653770533037e-14, 0.0, 13.5526185435788, 0.0, 0.0, 0.0, 0.0, 16.6675169851115, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.82842712474619, 0.0, 7.31428571428574, 0.0, 0.0, 11.337638238025, 0.0, 0.0, 0.0, 12.9299525702683, 0.0, 0.0, 0.0, 0.0, 9.93858693195778, 0.0, 0.0, 0.0, 0.0, 0.0, 1.14352971536391e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278317, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175272, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999999, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063972, -1.05830052442583, 0.305505046330393, 1.041420495798e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823012, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454315, 3.91918358845309, 0.0, 9.69948452238571, 4.2, -1.1869079656298e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.00000000000001, 0.0, -2.82842712474618, 0.0, -1.19730614311919e-14, 12.1243556529821, 0.0, 0.0, 1.26921260252476e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505165, -1.89736659610102, 7.42307488958089, -1.91662969499982, 0.663940002206985, 8.87411967464942, -1.07142857142858, 0.276641667586235, -0.0958314847499854, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923786, 1.67332005306817, 2.18217890235992, 5.74704893215391, -2.53734018966619, 10.062305898749, 8.50420064270762, -2.19577516413422, 0.760638829255681, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.00000000000001, 1.2247448713916, 3.53553390593274, -7.37711113563318, 4.57142857142855, 1.64957219768464, 0.0, 11.4997781699989, 7.42307488958092, -2.57142857142858, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848298, 6.64078308635361, 3.83405790253616, 0.0, -6.19677335393189, 5.3665631459995, 0.0, -1.02942565495247e-14, 13.4164078649988, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.32934244475986e-14, 0.0},
      {-3.57770876399966, 0.0, 8.85437744847149, 0.0, 0.0, -3.09838667696592, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 1.35447209004269e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 2.02338146237935e-14},
      {2.70801280154531, 5.6856424977521, -2.18840481772877, 7.86606636127614, -2.61129805863298, 1.00508909139073, 9.55297122675762, -2.01843356939834, 0.670059394260476, -0.257905981099553, 10.899541274751, -1.06805465250648, 0.225667733462114, -0.0749149177264327, 0.0288347652771179, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278317, 3.42857142857142, 0.989743318610801, 3.04933917230522, 4.98646126209433, -2.72741187029098, 2.16024689946928, 8.34624849531681, -3.63654916038797, 1.51635079315151, 12.0498962651137, 10.6270096138723, -2.24536559755125, 0.745394019896836, -0.286902292026516, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.16024689946929, 1.8142294704443, 2.96776330720949, 0.896421457000799, 5.41604758366941, -0.160356745147461, -9.52579344415678, 4.60043706228236, 5.34522483824849, -2.98319809926711, 0.0, 13.3887736279041, 9.90113162256757, -3.28687867566959, 1.26512019212765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835056, 0.766651877999943, 3.83609779052925, 8.63680425592141, 3.1689662255656, 3.65920700676628, 0.0, -8.74817765279707, 6.77630927178941, 0.521640530957299, 0.0, 0.0, 15.0623703313921, 8.33375849255573, -3.20766513935892, 0.0, -1.48137784516813e-14, 0.0, 0.0, 0.0, 0.0},
      {1.41421356237309, -6.73025456655335, 3.65714285714287, 0.0, 9.45502781700869, 5.66881911901251, 0.0, 1.28309015871647e-14, -6.99854212223765, 6.46497628513417, 0.0, 0.0, 0.0, 17.2141375215909, 4.96929346597889, 0.0, 0.0, 0.0, 0.0, 0.0, 1.01585406753202e-14},
      {5.71547606649407, 0.0, -4.61880215351702, -1.21498923528475e-14, 0.0, 12.7279220613579, 0.0, 1.13715737024626e-14, -2.43583362115028e-14, -3.26598632371091, 0.0, 0.0, 0.0, 0.0, 20.0831604418561, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 21; t++)
        {
          for (unsigned int u = 0; u < 21; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 21; s++)
        {
          for (unsigned int t = 0; t < 21; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 19:
      {
        
      // Array of basisvalues.
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.0 + 2.0*r)/(1.0 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.5 + r + Y*(1.5 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[21] = \
      {0.035074741130285, 0.107394023286761, 0.0620039682539682, 0.011320324022511, 0.306903984889995, -0.253130140416582, 0.0, -0.104572673947367, 0.0, 0.0467663215070468, 0.0, -0.169776791098635, 0.00930012075424224, -0.126581804978985, 0.172307246845093, 0.0, 0.0, -0.154984297042608, 0.101877718492409, 0.0394570707070707, -0.0813591085505763};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050515, 0.0, 0.0, 0.0, 0.0, 1.42730188533123e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.99999999999999, 0.0, 7.07106781186548, 0.0, 1.0172418463128e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212919, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660784, 0.0, -1.35448938231154e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004132, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690618, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 1.24344978758018e-14, 0.0, -3.83325938999964, 0.0, 17.7482393492988, 0.0, 0.553283335172475, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.7328638264797, 0.0, 3.34664010613632, 4.36435780471984, -1.35687344541151e-14, -5.07468037933238, 0.0, 17.0084012854152, 0.0, 1.52127765851135, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, -1.4210854715202e-14, 0.0, 9.14285714285712, 0.0, 0.0, 0.0, 14.8461497791618, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0},
      {3.09838667696594, 0.0, 7.66811580507235, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 1.06611606826009e-14, 9.29516003089783, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.41602560309062, 0.0, -4.37680963545756, 15.7321327225523, 0.0, 2.01017818278147, 0.0, -4.03686713879668, 0.0, -0.515811962199112, 21.7990825495019, 0.0, 0.451335466924227, 0.0, 0.057669530554236, 0.0, -1.00566098266321e-14, 0.0, -1.12643938743361e-14, 0.0, 0.0},
      {0.0, 6.85714285714284, 1.4210854715202e-14, 0.0, 9.97292252418865, 0.0, 4.32049379893856, 0.0, -7.27309832077594, 1.77635683940025e-14, 0.0, 21.2540192277445, 0.0, 1.49078803979367, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.32049379893857, 0.0, 5.93552661441899, 1.79284291400159, 0.0, -0.32071349029493, 0.0, 9.20087412456472, 0.0, -5.96639619853421, 0.0, 0.0, 19.8022632451351, 0.0, 2.5302403842553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.53330375599989, -1.06581410364015e-14, 0.0, 6.33793245113119, 0.0, 1.67653770533037e-14, 0.0, 13.5526185435788, 0.0, 0.0, 0.0, 0.0, 16.6675169851115, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.82842712474619, 0.0, 7.31428571428574, 0.0, 0.0, 11.337638238025, 0.0, 0.0, 0.0, 12.9299525702683, 0.0, 0.0, 0.0, 0.0, 9.93858693195778, 0.0, 0.0, 0.0, 0.0, 0.0, 1.14352971536391e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278317, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175272, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999999, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063972, -1.05830052442583, 0.305505046330393, 1.041420495798e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823012, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454315, 3.91918358845309, 0.0, 9.69948452238571, 4.2, -1.1869079656298e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.00000000000001, 0.0, -2.82842712474618, 0.0, -1.19730614311919e-14, 12.1243556529821, 0.0, 0.0, 1.26921260252476e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505165, -1.89736659610102, 7.42307488958089, -1.91662969499982, 0.663940002206985, 8.87411967464942, -1.07142857142858, 0.276641667586235, -0.0958314847499854, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923786, 1.67332005306817, 2.18217890235992, 5.74704893215391, -2.53734018966619, 10.062305898749, 8.50420064270762, -2.19577516413422, 0.760638829255681, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.00000000000001, 1.2247448713916, 3.53553390593274, -7.37711113563318, 4.57142857142855, 1.64957219768464, 0.0, 11.4997781699989, 7.42307488958092, -2.57142857142858, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848298, 6.64078308635361, 3.83405790253616, 0.0, -6.19677335393189, 5.3665631459995, 0.0, -1.02942565495247e-14, 13.4164078649988, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.32934244475986e-14, 0.0},
      {-3.57770876399966, 0.0, 8.85437744847149, 0.0, 0.0, -3.09838667696592, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 1.35447209004269e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 2.02338146237935e-14},
      {2.70801280154531, 5.6856424977521, -2.18840481772877, 7.86606636127614, -2.61129805863298, 1.00508909139073, 9.55297122675762, -2.01843356939834, 0.670059394260476, -0.257905981099553, 10.899541274751, -1.06805465250648, 0.225667733462114, -0.0749149177264327, 0.0288347652771179, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278317, 3.42857142857142, 0.989743318610801, 3.04933917230522, 4.98646126209433, -2.72741187029098, 2.16024689946928, 8.34624849531681, -3.63654916038797, 1.51635079315151, 12.0498962651137, 10.6270096138723, -2.24536559755125, 0.745394019896836, -0.286902292026516, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.16024689946929, 1.8142294704443, 2.96776330720949, 0.896421457000799, 5.41604758366941, -0.160356745147461, -9.52579344415678, 4.60043706228236, 5.34522483824849, -2.98319809926711, 0.0, 13.3887736279041, 9.90113162256757, -3.28687867566959, 1.26512019212765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835056, 0.766651877999943, 3.83609779052925, 8.63680425592141, 3.1689662255656, 3.65920700676628, 0.0, -8.74817765279707, 6.77630927178941, 0.521640530957299, 0.0, 0.0, 15.0623703313921, 8.33375849255573, -3.20766513935892, 0.0, -1.48137784516813e-14, 0.0, 0.0, 0.0, 0.0},
      {1.41421356237309, -6.73025456655335, 3.65714285714287, 0.0, 9.45502781700869, 5.66881911901251, 0.0, 1.28309015871647e-14, -6.99854212223765, 6.46497628513417, 0.0, 0.0, 0.0, 17.2141375215909, 4.96929346597889, 0.0, 0.0, 0.0, 0.0, 0.0, 1.01585406753202e-14},
      {5.71547606649407, 0.0, -4.61880215351702, -1.21498923528475e-14, 0.0, 12.7279220613579, 0.0, 1.13715737024626e-14, -2.43583362115028e-14, -3.26598632371091, 0.0, 0.0, 0.0, 0.0, 20.0831604418561, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 21; t++)
        {
          for (unsigned int u = 0; u < 21; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 21; s++)
        {
          for (unsigned int t = 0; t < 21; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 20:
      {
        
      // Array of basisvalues.
      double basisvalues[21] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.0;
      double tmp6 = 0.0;
      double tmp7 = 0.0;
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.0 + 2.0*r)/(1.0 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.0 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.5 + r + Y*(1.5 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.0 + 2.0*r + 2.0*s)*(3.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp6 = (1.0 + 4.0*r*r + 4.0*r)*(2.0 + 2.0*r + 2.0*s)/(2.0*(1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          tmp7 = (1.0 + s + 2.0*r)*(3.0 + 2.0*r + 2.0*s)*s/((1.0 + 2.0*r + 2.0*s)*(1.0 + s)*(2.0 + s + 2.0*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.5 + r)*(1.0 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[21] = \
      {0.280597929042281, 0.0, 0.248015873015873, -0.0603750614533913, 0.0, 0.13500274155551, 0.0, -0.0522863369736835, 0.0, -0.210448446781711, 0.0, 0.0, -0.148801932067876, 0.0, -0.142599100837319, 0.0, 0.0, 0.0, -0.135836957989878, 0.0, 0.108478811400768};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050515, 0.0, 0.0, 0.0, 0.0, 1.42730188533123e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.99999999999999, 0.0, 7.07106781186548, 0.0, 1.0172418463128e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212919, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660784, 0.0, -1.35448938231154e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004132, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690618, 0.0, 0.0, 8.40000000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 1.24344978758018e-14, 0.0, -3.83325938999964, 0.0, 17.7482393492988, 0.0, 0.553283335172475, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.7328638264797, 0.0, 3.34664010613632, 4.36435780471984, -1.35687344541151e-14, -5.07468037933238, 0.0, 17.0084012854152, 0.0, 1.52127765851135, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, -1.4210854715202e-14, 0.0, 9.14285714285712, 0.0, 0.0, 0.0, 14.8461497791618, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0},
      {3.09838667696594, 0.0, 7.66811580507235, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 1.06611606826009e-14, 9.29516003089783, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.41602560309062, 0.0, -4.37680963545756, 15.7321327225523, 0.0, 2.01017818278147, 0.0, -4.03686713879668, 0.0, -0.515811962199112, 21.7990825495019, 0.0, 0.451335466924227, 0.0, 0.057669530554236, 0.0, -1.00566098266321e-14, 0.0, -1.12643938743361e-14, 0.0, 0.0},
      {0.0, 6.85714285714284, 1.4210854715202e-14, 0.0, 9.97292252418865, 0.0, 4.32049379893856, 0.0, -7.27309832077594, 1.77635683940025e-14, 0.0, 21.2540192277445, 0.0, 1.49078803979367, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.32049379893857, 0.0, 5.93552661441899, 1.79284291400159, 0.0, -0.32071349029493, 0.0, 9.20087412456472, 0.0, -5.96639619853421, 0.0, 0.0, 19.8022632451351, 0.0, 2.5302403842553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.53330375599989, -1.06581410364015e-14, 0.0, 6.33793245113119, 0.0, 1.67653770533037e-14, 0.0, 13.5526185435788, 0.0, 0.0, 0.0, 0.0, 16.6675169851115, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.82842712474619, 0.0, 7.31428571428574, 0.0, 0.0, 11.337638238025, 0.0, 0.0, 0.0, 12.9299525702683, 0.0, 0.0, 0.0, 0.0, 9.93858693195778, 0.0, 0.0, 0.0, 0.0, 0.0, 1.14352971536391e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[21][21] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278317, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175272, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99999999999999, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063972, -1.05830052442583, 0.305505046330393, 1.041420495798e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823012, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454315, 3.91918358845309, 0.0, 9.69948452238571, 4.2, -1.1869079656298e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.00000000000001, 0.0, -2.82842712474618, 0.0, -1.19730614311919e-14, 12.1243556529821, 0.0, 0.0, 1.26921260252476e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505165, -1.89736659610102, 7.42307488958089, -1.91662969499982, 0.663940002206985, 8.87411967464942, -1.07142857142858, 0.276641667586235, -0.0958314847499854, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923786, 1.67332005306817, 2.18217890235992, 5.74704893215391, -2.53734018966619, 10.062305898749, 8.50420064270762, -2.19577516413422, 0.760638829255681, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.00000000000001, 1.2247448713916, 3.53553390593274, -7.37711113563318, 4.57142857142855, 1.64957219768464, 0.0, 11.4997781699989, 7.42307488958092, -2.57142857142858, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848298, 6.64078308635361, 3.83405790253616, 0.0, -6.19677335393189, 5.3665631459995, 0.0, -1.02942565495247e-14, 13.4164078649988, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.32934244475986e-14, 0.0},
      {-3.57770876399966, 0.0, 8.85437744847149, 0.0, 0.0, -3.09838667696592, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 1.35447209004269e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 2.02338146237935e-14},
      {2.70801280154531, 5.6856424977521, -2.18840481772877, 7.86606636127614, -2.61129805863298, 1.00508909139073, 9.55297122675762, -2.01843356939834, 0.670059394260476, -0.257905981099553, 10.899541274751, -1.06805465250648, 0.225667733462114, -0.0749149177264327, 0.0288347652771179, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278317, 3.42857142857142, 0.989743318610801, 3.04933917230522, 4.98646126209433, -2.72741187029098, 2.16024689946928, 8.34624849531681, -3.63654916038797, 1.51635079315151, 12.0498962651137, 10.6270096138723, -2.24536559755125, 0.745394019896836, -0.286902292026516, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.16024689946929, 1.8142294704443, 2.96776330720949, 0.896421457000799, 5.41604758366941, -0.160356745147461, -9.52579344415678, 4.60043706228236, 5.34522483824849, -2.98319809926711, 0.0, 13.3887736279041, 9.90113162256757, -3.28687867566959, 1.26512019212765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835056, 0.766651877999943, 3.83609779052925, 8.63680425592141, 3.1689662255656, 3.65920700676628, 0.0, -8.74817765279707, 6.77630927178941, 0.521640530957299, 0.0, 0.0, 15.0623703313921, 8.33375849255573, -3.20766513935892, 0.0, -1.48137784516813e-14, 0.0, 0.0, 0.0, 0.0},
      {1.41421356237309, -6.73025456655335, 3.65714285714287, 0.0, 9.45502781700869, 5.66881911901251, 0.0, 1.28309015871647e-14, -6.99854212223765, 6.46497628513417, 0.0, 0.0, 0.0, 17.2141375215909, 4.96929346597889, 0.0, 0.0, 0.0, 0.0, 0.0, 1.01585406753202e-14},
      {5.71547606649407, 0.0, -4.61880215351702, -1.21498923528475e-14, 0.0, 12.7279220613579, 0.0, 1.13715737024626e-14, -2.43583362115028e-14, -3.26598632371091, 0.0, 0.0, 0.0, 0.0, 20.0831604418561, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[21][21] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 21; t++)
        {
          for (unsigned int u = 0; u < 21; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 21; t++)
          {
            for (unsigned int u = 0; u < 21; u++)
            {
              for (unsigned int tu = 0; tu < 21; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 21; s++)
        {
          for (unsigned int t = 0; t < 21; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 21; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = 0.8*x[1][0] + 0.2*x[2][0];
      y[1] = 0.8*x[1][1] + 0.2*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.6*x[1][0] + 0.4*x[2][0];
      y[1] = 0.6*x[1][1] + 0.4*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.4*x[1][0] + 0.6*x[2][0];
      y[1] = 0.4*x[1][1] + 0.6*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 6:
      {
        y[0] = 0.2*x[1][0] + 0.8*x[2][0];
      y[1] = 0.2*x[1][1] + 0.8*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 7:
      {
        y[0] = 0.8*x[0][0] + 0.2*x[2][0];
      y[1] = 0.8*x[0][1] + 0.2*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 8:
      {
        y[0] = 0.6*x[0][0] + 0.4*x[2][0];
      y[1] = 0.6*x[0][1] + 0.4*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 9:
      {
        y[0] = 0.4*x[0][0] + 0.6*x[2][0];
      y[1] = 0.4*x[0][1] + 0.6*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 10:
      {
        y[0] = 0.2*x[0][0] + 0.8*x[2][0];
      y[1] = 0.2*x[0][1] + 0.8*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 11:
      {
        y[0] = 0.8*x[0][0] + 0.2*x[1][0];
      y[1] = 0.8*x[0][1] + 0.2*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 12:
      {
        y[0] = 0.6*x[0][0] + 0.4*x[1][0];
      y[1] = 0.6*x[0][1] + 0.4*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 13:
      {
        y[0] = 0.4*x[0][0] + 0.6*x[1][0];
      y[1] = 0.4*x[0][1] + 0.6*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 14:
      {
        y[0] = 0.2*x[0][0] + 0.8*x[1][0];
      y[1] = 0.2*x[0][1] + 0.8*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 15:
      {
        y[0] = 0.6*x[0][0] + 0.2*x[1][0] + 0.2*x[2][0];
      y[1] = 0.6*x[0][1] + 0.2*x[1][1] + 0.2*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 16:
      {
        y[0] = 0.4*x[0][0] + 0.4*x[1][0] + 0.2*x[2][0];
      y[1] = 0.4*x[0][1] + 0.4*x[1][1] + 0.2*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 17:
      {
        y[0] = 0.2*x[0][0] + 0.6*x[1][0] + 0.2*x[2][0];
      y[1] = 0.2*x[0][1] + 0.6*x[1][1] + 0.2*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 18:
      {
        y[0] = 0.4*x[0][0] + 0.2*x[1][0] + 0.4*x[2][0];
      y[1] = 0.4*x[0][1] + 0.2*x[1][1] + 0.4*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 19:
      {
        y[0] = 0.2*x[0][0] + 0.4*x[1][0] + 0.4*x[2][0];
      y[1] = 0.2*x[0][1] + 0.4*x[1][1] + 0.4*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 20:
      {
        y[0] = 0.2*x[0][0] + 0.2*x[1][0] + 0.6*x[2][0];
      y[1] = 0.2*x[0][1] + 0.2*x[1][1] + 0.6*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = 0.8*x[1][0] + 0.2*x[2][0];
    y[1] = 0.8*x[1][1] + 0.2*x[2][1];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.6*x[1][0] + 0.4*x[2][0];
    y[1] = 0.6*x[1][1] + 0.4*x[2][1];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.4*x[1][0] + 0.6*x[2][0];
    y[1] = 0.4*x[1][1] + 0.6*x[2][1];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
    y[0] = 0.2*x[1][0] + 0.8*x[2][0];
    y[1] = 0.2*x[1][1] + 0.8*x[2][1];
    f.evaluate(vals, y, c);
    values[6] = vals[0];
    y[0] = 0.8*x[0][0] + 0.2*x[2][0];
    y[1] = 0.8*x[0][1] + 0.2*x[2][1];
    f.evaluate(vals, y, c);
    values[7] = vals[0];
    y[0] = 0.6*x[0][0] + 0.4*x[2][0];
    y[1] = 0.6*x[0][1] + 0.4*x[2][1];
    f.evaluate(vals, y, c);
    values[8] = vals[0];
    y[0] = 0.4*x[0][0] + 0.6*x[2][0];
    y[1] = 0.4*x[0][1] + 0.6*x[2][1];
    f.evaluate(vals, y, c);
    values[9] = vals[0];
    y[0] = 0.2*x[0][0] + 0.8*x[2][0];
    y[1] = 0.2*x[0][1] + 0.8*x[2][1];
    f.evaluate(vals, y, c);
    values[10] = vals[0];
    y[0] = 0.8*x[0][0] + 0.2*x[1][0];
    y[1] = 0.8*x[0][1] + 0.2*x[1][1];
    f.evaluate(vals, y, c);
    values[11] = vals[0];
    y[0] = 0.6*x[0][0] + 0.4*x[1][0];
    y[1] = 0.6*x[0][1] + 0.4*x[1][1];
    f.evaluate(vals, y, c);
    values[12] = vals[0];
    y[0] = 0.4*x[0][0] + 0.6*x[1][0];
    y[1] = 0.4*x[0][1] + 0.6*x[1][1];
    f.evaluate(vals, y, c);
    values[13] = vals[0];
    y[0] = 0.2*x[0][0] + 0.8*x[1][0];
    y[1] = 0.2*x[0][1] + 0.8*x[1][1];
    f.evaluate(vals, y, c);
    values[14] = vals[0];
    y[0] = 0.6*x[0][0] + 0.2*x[1][0] + 0.2*x[2][0];
    y[1] = 0.6*x[0][1] + 0.2*x[1][1] + 0.2*x[2][1];
    f.evaluate(vals, y, c);
    values[15] = vals[0];
    y[0] = 0.4*x[0][0] + 0.4*x[1][0] + 0.2*x[2][0];
    y[1] = 0.4*x[0][1] + 0.4*x[1][1] + 0.2*x[2][1];
    f.evaluate(vals, y, c);
    values[16] = vals[0];
    y[0] = 0.2*x[0][0] + 0.6*x[1][0] + 0.2*x[2][0];
    y[1] = 0.2*x[0][1] + 0.6*x[1][1] + 0.2*x[2][1];
    f.evaluate(vals, y, c);
    values[17] = vals[0];
    y[0] = 0.4*x[0][0] + 0.2*x[1][0] + 0.4*x[2][0];
    y[1] = 0.4*x[0][1] + 0.2*x[1][1] + 0.4*x[2][1];
    f.evaluate(vals, y, c);
    values[18] = vals[0];
    y[0] = 0.2*x[0][0] + 0.4*x[1][0] + 0.4*x[2][0];
    y[1] = 0.2*x[0][1] + 0.4*x[1][1] + 0.4*x[2][1];
    f.evaluate(vals, y, c);
    values[19] = vals[0];
    y[0] = 0.2*x[0][0] + 0.2*x[1][0] + 0.6*x[2][0];
    y[1] = 0.2*x[0][1] + 0.2*x[1][1] + 0.6*x[2][1];
    f.evaluate(vals, y, c);
    values[20] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new poisson2d_5_finite_element_0();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class poisson2d_5_dofmap_0: public ufc::dofmap
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  poisson2d_5_dofmap_0() : ufc::dofmap()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~poisson2d_5_dofmap_0()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Lagrange', Cell('triangle', Space(2)), 5, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return true;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dofmap for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[0] + 4.0*m.num_entities[1] + 6.0*m.num_entities[2];
    return false;
  }

  /// Initialize dofmap for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dofmap for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the topological dimension of the associated cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 21;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 21;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 6;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 4;
        break;
      }
    case 2:
      {
        return 6;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    offset += m.num_entities[0];
    dofs[3] = offset + 4*c.entity_indices[1][0];
    dofs[4] = offset + 4*c.entity_indices[1][0] + 1;
    dofs[5] = offset + 4*c.entity_indices[1][0] + 2;
    dofs[6] = offset + 4*c.entity_indices[1][0] + 3;
    dofs[7] = offset + 4*c.entity_indices[1][1];
    dofs[8] = offset + 4*c.entity_indices[1][1] + 1;
    dofs[9] = offset + 4*c.entity_indices[1][1] + 2;
    dofs[10] = offset + 4*c.entity_indices[1][1] + 3;
    dofs[11] = offset + 4*c.entity_indices[1][2];
    dofs[12] = offset + 4*c.entity_indices[1][2] + 1;
    dofs[13] = offset + 4*c.entity_indices[1][2] + 2;
    dofs[14] = offset + 4*c.entity_indices[1][2] + 3;
    offset += 4*m.num_entities[1];
    dofs[15] = offset + 6*c.entity_indices[2][0];
    dofs[16] = offset + 6*c.entity_indices[2][0] + 1;
    dofs[17] = offset + 6*c.entity_indices[2][0] + 2;
    dofs[18] = offset + 6*c.entity_indices[2][0] + 3;
    dofs[19] = offset + 6*c.entity_indices[2][0] + 4;
    dofs[20] = offset + 6*c.entity_indices[2][0] + 5;
    offset += 6*m.num_entities[2];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 5;
      dofs[5] = 6;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 7;
      dofs[3] = 8;
      dofs[4] = 9;
      dofs[5] = 10;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 11;
      dofs[3] = 12;
      dofs[4] = 13;
      dofs[5] = 14;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 3;
        dofs[1] = 4;
        dofs[2] = 5;
        dofs[3] = 6;
          break;
        }
      case 1:
        {
          dofs[0] = 7;
        dofs[1] = 8;
        dofs[2] = 9;
        dofs[3] = 10;
          break;
        }
      case 2:
        {
          dofs[0] = 11;
        dofs[1] = 12;
        dofs[2] = 13;
        dofs[3] = 14;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 15;
      dofs[1] = 16;
      dofs[2] = 17;
      dofs[3] = 18;
      dofs[4] = 19;
      dofs[5] = 20;
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
    coordinates[3][0] = 0.8*x[1][0] + 0.2*x[2][0];
    coordinates[3][1] = 0.8*x[1][1] + 0.2*x[2][1];
    coordinates[4][0] = 0.6*x[1][0] + 0.4*x[2][0];
    coordinates[4][1] = 0.6*x[1][1] + 0.4*x[2][1];
    coordinates[5][0] = 0.4*x[1][0] + 0.6*x[2][0];
    coordinates[5][1] = 0.4*x[1][1] + 0.6*x[2][1];
    coordinates[6][0] = 0.2*x[1][0] + 0.8*x[2][0];
    coordinates[6][1] = 0.2*x[1][1] + 0.8*x[2][1];
    coordinates[7][0] = 0.8*x[0][0] + 0.2*x[2][0];
    coordinates[7][1] = 0.8*x[0][1] + 0.2*x[2][1];
    coordinates[8][0] = 0.6*x[0][0] + 0.4*x[2][0];
    coordinates[8][1] = 0.6*x[0][1] + 0.4*x[2][1];
    coordinates[9][0] = 0.4*x[0][0] + 0.6*x[2][0];
    coordinates[9][1] = 0.4*x[0][1] + 0.6*x[2][1];
    coordinates[10][0] = 0.2*x[0][0] + 0.8*x[2][0];
    coordinates[10][1] = 0.2*x[0][1] + 0.8*x[2][1];
    coordinates[11][0] = 0.8*x[0][0] + 0.2*x[1][0];
    coordinates[11][1] = 0.8*x[0][1] + 0.2*x[1][1];
    coordinates[12][0] = 0.6*x[0][0] + 0.4*x[1][0];
    coordinates[12][1] = 0.6*x[0][1] + 0.4*x[1][1];
    coordinates[13][0] = 0.4*x[0][0] + 0.6*x[1][0];
    coordinates[13][1] = 0.4*x[0][1] + 0.6*x[1][1];
    coordinates[14][0] = 0.2*x[0][0] + 0.8*x[1][0];
    coordinates[14][1] = 0.2*x[0][1] + 0.8*x[1][1];
    coordinates[15][0] = 0.6*x[0][0] + 0.2*x[1][0] + 0.2*x[2][0];
    coordinates[15][1] = 0.6*x[0][1] + 0.2*x[1][1] + 0.2*x[2][1];
    coordinates[16][0] = 0.4*x[0][0] + 0.4*x[1][0] + 0.2*x[2][0];
    coordinates[16][1] = 0.4*x[0][1] + 0.4*x[1][1] + 0.2*x[2][1];
    coordinates[17][0] = 0.2*x[0][0] + 0.6*x[1][0] + 0.2*x[2][0];
    coordinates[17][1] = 0.2*x[0][1] + 0.6*x[1][1] + 0.2*x[2][1];
    coordinates[18][0] = 0.4*x[0][0] + 0.2*x[1][0] + 0.4*x[2][0];
    coordinates[18][1] = 0.4*x[0][1] + 0.2*x[1][1] + 0.4*x[2][1];
    coordinates[19][0] = 0.2*x[0][0] + 0.4*x[1][0] + 0.4*x[2][0];
    coordinates[19][1] = 0.2*x[0][1] + 0.4*x[1][1] + 0.4*x[2][1];
    coordinates[20][0] = 0.2*x[0][0] + 0.2*x[1][0] + 0.6*x[2][0];
    coordinates[20][1] = 0.2*x[0][1] + 0.2*x[1][1] + 0.6*x[2][1];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual unsigned int num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new poisson2d_5_dofmap_0();
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class poisson2d_5_cell_integral_0_0: public ufc::cell_integral
{
public:

  /// Constructor
  poisson2d_5_cell_integral_0_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~poisson2d_5_cell_integral_0_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      11
    // Number of operations (multiply-add pairs) for geometry tensor:    8
    // Number of operations (multiply-add pairs) for tensor contraction: 1259
    // Total number of operations (multiply-add pairs):                  1278
    
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0_0 = det*(K_00*K_00 + K_01*K_01);
    const double G0_0_1 = det*(K_00*K_10 + K_01*K_11);
    const double G0_1_0 = det*(K_10*K_00 + K_11*K_01);
    const double G0_1_1 = det*(K_10*K_10 + K_11*K_11);
    
    // Compute element tensor
    A[0] = 0.342406580687829*G0_0_0 + 0.342406580687829*G0_0_1 + 0.342406580687829*G0_1_0 + 0.342406580687829*G0_1_1;
    A[1] = -0.0409984016754849*G0_0_0 - 0.040998401675485*G0_1_0;
    A[2] = -0.0409984016754849*G0_0_1 - 0.0409984016754849*G0_1_1;
    A[3] = -0.0408192791005282*G0_0_0 - 0.0408192791005289*G0_0_1 - 0.0408192791005285*G0_1_0 - 0.0408192791005293*G0_1_1;
    A[4] = -0.0379774305555556*G0_0_0 - 0.0379774305555541*G0_0_1 - 0.0379774305555555*G0_1_0 - 0.0379774305555539*G0_1_1;
    A[5] = -0.0379774305555545*G0_0_0 - 0.0379774305555556*G0_0_1 - 0.0379774305555549*G0_1_0 - 0.0379774305555561*G0_1_1;
    A[6] = -0.0408192791005288*G0_0_0 - 0.0408192791005283*G0_0_1 - 0.0408192791005287*G0_1_0 - 0.0408192791005282*G0_1_1;
    A[7] = 0.202287946428571*G0_0_0 - 0.64802758487654*G0_0_1 + 0.202287946428571*G0_1_0 - 0.648027584876541*G0_1_1;
    A[8] = -0.0158454585537925*G0_0_0 + 0.594204695767192*G0_0_1 - 0.0158454585537926*G0_1_0 + 0.594204695767194*G0_1_1;
    A[9] = -0.0696683476631384*G0_0_0 - 0.449959352954142*G0_0_1 - 0.0696683476631385*G0_1_0 - 0.449959352954143*G0_1_1;
    A[10] = 0.0408192791005288*G0_0_0 + 0.202374063051146*G0_0_1 + 0.0408192791005287*G0_1_0 + 0.202374063051146*G0_1_1;
    A[11] = -0.64802758487654*G0_0_0 + 0.202287946428571*G0_0_1 - 0.64802758487654*G0_1_0 + 0.202287946428571*G0_1_1;
    A[12] = 0.594204695767192*G0_0_0 - 0.0158454585537912*G0_0_1 + 0.594204695767193*G0_1_0 - 0.0158454585537909*G0_1_1;
    A[13] = -0.449959352954142*G0_0_0 - 0.0696683476631401*G0_0_1 - 0.449959352954142*G0_1_0 - 0.0696683476631402*G0_1_1;
    A[14] = 0.202374063051145*G0_0_0 + 0.0408192791005294*G0_0_1 + 0.202374063051146*G0_1_0 + 0.0408192791005298*G0_1_1;
    A[15] = -0.215291556437388*G0_0_0 - 0.21529155643739*G0_0_1 - 0.215291556437387*G0_1_0 - 0.21529155643739*G0_1_1;
    A[16] = -0.0538228891093493*G0_0_0 - 0.0538228891093448*G0_0_1 - 0.0538228891093495*G0_1_0 - 0.0538228891093454*G0_1_1;
    A[17] = 0.107645778218695*G0_0_0 + 0.107645778218693*G0_0_1 + 0.107645778218695*G0_1_0 + 0.107645778218693*G0_1_1;
    A[18] = -0.0538228891093453*G0_0_0 - 0.0538228891093464*G0_0_1 - 0.0538228891093455*G0_1_0 - 0.0538228891093461*G0_1_1;
    A[19] = 0.107645778218693*G0_0_0 + 0.107645778218693*G0_0_1 + 0.107645778218694*G0_1_0 + 0.107645778218694*G0_1_1;
    A[20] = 0.107645778218693*G0_0_0 + 0.107645778218693*G0_0_1 + 0.107645778218694*G0_1_0 + 0.107645778218693*G0_1_1;
    A[21] = -0.0409984016754849*G0_0_0 - 0.040998401675485*G0_0_1;
    A[22] = 0.342406580687829*G0_0_0;
    A[23] = 0.0409984016754844*G0_0_1;
    A[24] = 0.202287946428571*G0_0_0 + 0.85031553130511*G0_0_1;
    A[25] = -0.0158454585537941*G0_0_0 - 0.610050154320986*G0_0_1;
    A[26] = -0.0696683476631369*G0_0_0 + 0.380291005291004*G0_0_1;
    A[27] = 0.0408192791005278*G0_0_0 - 0.161554783950617*G0_0_1;
    A[28] = -0.0408192791005284*G0_0_0;
    A[29] = -0.0379774305555559*G0_0_0;
    A[30] = -0.037977430555554*G0_0_0;
    A[31] = -0.0408192791005278*G0_0_0;
    A[32] = 0.202374063051145*G0_0_0 + 0.161554783950616*G0_0_1;
    A[33] = -0.449959352954141*G0_0_0 - 0.380291005291001*G0_0_1;
    A[34] = 0.594204695767192*G0_0_0 + 0.610050154320982*G0_0_1;
    A[35] = -0.64802758487654*G0_0_0 - 0.85031553130511*G0_0_1;
    A[36] = 0.107645778218694*G0_0_0;
    A[37] = -0.0538228891093484*G0_0_0;
    A[38] = -0.215291556437388*G0_0_0;
    A[39] = 0.107645778218696*G0_0_0;
    A[40] = -0.0538228891093463*G0_0_0;
    A[41] = 0.107645778218691*G0_0_0;
    A[42] = -0.0409984016754849*G0_1_0 - 0.0409984016754849*G0_1_1;
    A[43] = 0.0409984016754844*G0_1_0;
    A[44] = 0.34240658068783*G0_1_1;
    A[45] = -0.161554783950616*G0_1_0 + 0.040819279100528*G0_1_1;
    A[46] = 0.380291005291005*G0_1_0 - 0.0696683476631366*G0_1_1;
    A[47] = -0.610050154320987*G0_1_0 - 0.0158454585537935*G0_1_1;
    A[48] = 0.850315531305114*G0_1_0 + 0.202287946428572*G0_1_1;
    A[49] = 0.161554783950617*G0_1_0 + 0.202374063051146*G0_1_1;
    A[50] = -0.380291005291005*G0_1_0 - 0.449959352954143*G0_1_1;
    A[51] = 0.610050154320987*G0_1_0 + 0.594204695767194*G0_1_1;
    A[52] = -0.850315531305114*G0_1_0 - 0.648027584876542*G0_1_1;
    A[53] = -0.0408192791005288*G0_1_1;
    A[54] = -0.0379774305555552*G0_1_1;
    A[55] = -0.0379774305555548*G0_1_1;
    A[56] = -0.0408192791005283*G0_1_1;
    A[57] = 0.107645778218694*G0_1_1;
    A[58] = 0.107645778218694*G0_1_1;
    A[59] = 0.107645778218692*G0_1_1;
    A[60] = -0.0538228891093463*G0_1_1;
    A[61] = -0.0538228891093455*G0_1_1;
    A[62] = -0.21529155643739*G0_1_1;
    A[63] = -0.0408192791005282*G0_0_0 - 0.0408192791005285*G0_0_1 - 0.0408192791005289*G0_1_0 - 0.0408192791005293*G0_1_1;
    A[64] = 0.202287946428571*G0_0_0 + 0.85031553130511*G0_1_0;
    A[65] = -0.161554783950616*G0_0_1 + 0.040819279100528*G0_1_1;
    A[66] = 1.98929398148147*G0_0_0 + 1.28098476080246*G0_0_1 + 1.28098476080246*G0_1_0 + 2.56196952160492*G0_1_1;
    A[67] = -0.906377452601408*G0_0_0 + 0.796578758818338*G0_0_1 - 0.529617228835982*G0_1_0 - 1.39508928571428*G0_1_1;
    A[68] = 0.818107914462076*G0_0_0 - 0.482253086419752*G0_0_1 + 0.232514880952384*G0_1_0 + 0.895612874779536*G0_1_1;
    A[69] = -0.340160659171073*G0_0_0 + 0.329396081349206*G0_0_1 - 0.0710462136243398*G0_1_0 - 0.340160659171073*G0_1_1;
    A[70] = 0.142092427248678*G0_0_0 + 0.0710462136243377*G0_0_1 + 0.0710462136243384*G0_1_0;
    A[71] = 0.131327849426806*G0_0_0 + 0.0301408179012346*G0_0_1 + 0.0301408179012316*G0_1_0;
    A[72] = 0.172233245149912*G0_0_0 + 0.0301408179012346*G0_0_1 + 0.0301408179012379*G0_1_0;
    A[73] = 0.340160659171073*G0_0_0 + 0.071046213624338*G0_0_1 + 0.0710462136243397*G0_1_0;
    A[74] = 0.198068231922396*G0_0_0 + 0.269114445546736*G0_0_1 + 0.269114445546735*G0_1_0 + 0.340160659171074*G0_1_1;
    A[75] = -0.359536899250437*G0_0_0 - 0.663097993827154*G0_0_1 - 0.663097993827156*G0_1_0 - 0.89561287477953*G0_1_1;
    A[76] = 0.286337770061724*G0_0_0 + 0.865472056878299*G0_0_1 + 0.865472056878299*G0_1_0 + 1.39508928571427*G0_1_1;
    A[77] = -0.286337770061726*G0_0_0 - 1.28098476080246*G0_0_1 - 1.28098476080246*G0_1_0 - 2.56196952160492*G0_1_1;
    A[78] = -0.667403824955902*G0_0_0 - 0.262655698853614*G0_0_1 - 0.26265569885361*G0_1_0;
    A[79] = 1.35633680555554*G0_0_0 + 0.57267554012345*G0_0_1 + 0.572675540123448*G0_1_0;
    A[80] = -2.82031938932979*G0_0_0 - 1.66205081569664*G0_0_1 - 1.66205081569664*G0_1_0;
    A[81] = -0.419818535052908*G0_0_0 - 0.0731991291887133*G0_0_1 - 0.0731991291887062*G0_1_0;
    A[82] = 1.19486813822751*G0_0_0 + 0.572675540123457*G0_0_1 + 0.572675540123457*G0_1_0;
    A[83] = -0.990341159611988*G0_0_0 - 0.262655698853616*G0_0_1 - 0.262655698853622*G0_1_0;
    A[84] = -0.0379774305555556*G0_0_0 - 0.0379774305555555*G0_0_1 - 0.0379774305555541*G0_1_0 - 0.037977430555554*G0_1_1;
    A[85] = -0.0158454585537941*G0_0_0 - 0.610050154320986*G0_1_0;
    A[86] = 0.380291005291005*G0_0_1 - 0.0696683476631366*G0_1_1;
    A[87] = -0.906377452601408*G0_0_0 - 0.529617228835982*G0_0_1 + 0.796578758818338*G0_1_0 - 1.39508928571428*G0_1_1;
    A[88] = 3.07436342592592*G0_0_0 + 1.17549189814815*G0_0_1 + 1.17549189814815*G0_1_0 + 3.6944031084656*G0_1_1;
    A[89] = -1.80414324294532*G0_0_0 + 0.699697558421508*G0_0_1 - 0.350925236992954*G0_1_0 - 1.80414324294532*G0_1_1;
    A[90] = 0.895612874779541*G0_0_0 - 0.482253086419749*G0_0_1 + 0.232514880952387*G0_1_0 + 0.818107914462079*G0_1_1;
    A[91] = 0.131327849426809*G0_0_0 + 0.101187031525575*G0_0_1 + 0.101187031525576*G0_1_0 + 0.0710462136243377*G0_1_1;
    A[92] = -0.297102347883599*G0_0_0 - 0.148551173941802*G0_0_1 - 0.148551173941799*G0_1_0 - 0.0172233245149923*G0_1_1;
    A[93] = -0.219597387566135*G0_0_0 - 0.0624345513668397*G0_0_1 - 0.0624345513668439*G0_1_0 - 0.0172233245149916*G0_1_1;
    A[94] = -0.895612874779541*G0_0_0 - 0.232514880952382*G0_0_1 - 0.232514880952387*G0_1_0 + 0.0710462136243367*G0_1_1;
    A[95] = 0.111951609347442*G0_0_0 + 0.142092427248675*G0_0_1 + 0.142092427248674*G0_1_0 + 0.172233245149912*G0_1_1;
    A[96] = -0.11195160934744*G0_0_0 - 0.157162836199292*G0_0_1 - 0.157162836199291*G0_1_0 - 0.219597387566138*G0_1_1;
    A[97] = 0.103339947089945*G0_0_0 + 0.133480764991182*G0_0_1 + 0.133480764991179*G0_1_0 + 0.266961529982366*G0_1_1;
    A[98] = -0.0495170579805984*G0_0_0 + 0.529617228835981*G0_0_1 + 0.529617228835978*G0_1_0 + 1.39508928571428*G0_1_1;
    A[99] = -0.344466490299822*G0_0_0 - 0.447806437389765*G0_0_1 - 0.447806437389769*G0_1_0 - 0.516699735449732*G0_1_1;
    A[100] = 0.387524801587299*G0_0_0 + 0.859013310185177*G0_0_1 + 0.859013310185181*G0_1_0 + 1.01187031525573*G0_1_1;
    A[101] = 0.731991291887125*G0_0_0 - 1.30897266313933*G0_0_1 - 1.30897266313932*G0_1_0 - 3.96136463844796*G0_1_1;
    A[102] = 1.03339947089947*G0_0_0 + 0.374607308201056*G0_0_1 + 0.374607308201051*G0_1_0 + 0.0430583112874712*G0_1_1;
    A[103] = -3.81066054894179*G0_0_0 - 1.4015480324074*G0_0_1 - 1.4015480324074*G0_1_0 + 1.01187031525573*G0_1_1;
    A[104] = 2.02374063051146*G0_0_0 + 0.413359788359785*G0_0_1 + 0.413359788359797*G0_1_0 - 0.516699735449728*G0_1_1;
    A[105] = -0.0379774305555545*G0_0_0 - 0.0379774305555549*G0_0_1 - 0.0379774305555557*G0_1_0 - 0.0379774305555561*G0_1_1;
    A[106] = -0.0696683476631369*G0_0_0 + 0.380291005291004*G0_1_0;
    A[107] = -0.610050154320987*G0_0_1 - 0.0158454585537935*G0_1_1;
    A[108] = 0.818107914462076*G0_0_0 + 0.232514880952384*G0_0_1 - 0.482253086419752*G0_1_0 + 0.895612874779536*G0_1_1;
    A[109] = -1.80414324294532*G0_0_0 - 0.350925236992954*G0_0_1 + 0.699697558421508*G0_1_0 - 1.80414324294532*G0_1_1;
    A[110] = 3.6944031084656*G0_0_0 + 1.17549189814815*G0_0_1 + 1.17549189814815*G0_1_0 + 3.07436342592591*G0_1_1;
    A[111] = -1.39508928571428*G0_0_0 + 0.796578758818336*G0_0_1 - 0.529617228835981*G0_1_0 - 0.906377452601409*G0_1_1;
    A[112] = 0.172233245149908*G0_0_0 + 0.142092427248673*G0_0_1 + 0.142092427248674*G0_1_0 + 0.111951609347442*G0_1_1;
    A[113] = -0.21959738756613*G0_0_0 - 0.157162836199288*G0_0_1 - 0.15716283619929*G0_1_0 - 0.111951609347441*G0_1_1;
    A[114] = 0.266961529982358*G0_0_0 + 0.133480764991177*G0_0_1 + 0.13348076499118*G0_1_0 + 0.103339947089946*G0_1_1;
    A[115] = 1.39508928571428*G0_0_0 + 0.52961722883598*G0_0_1 + 0.529617228835982*G0_1_0 - 0.0495170579805972*G0_1_1;
    A[116] = 0.0710462136243364*G0_0_0 + 0.101187031525572*G0_0_1 + 0.101187031525572*G0_1_0 + 0.131327849426805*G0_1_1;
    A[117] = -0.0172233245149903*G0_0_0 - 0.148551173941798*G0_0_1 - 0.148551173941798*G0_1_0 - 0.297102347883594*G0_1_1;
    A[118] = -0.0172233245149913*G0_0_0 - 0.062434551366846*G0_0_1 - 0.0624345513668431*G0_1_0 - 0.219597387566141*G0_1_1;
    A[119] = 0.0710462136243375*G0_0_0 - 0.232514880952384*G0_0_1 - 0.23251488095238*G0_1_0 - 0.895612874779538*G0_1_1;
    A[120] = -0.516699735449726*G0_0_0 - 0.447806437389764*G0_0_1 - 0.447806437389764*G0_1_0 - 0.344466490299815*G0_1_1;
    A[121] = 0.04305831128747*G0_0_0 + 0.374607308201054*G0_0_1 + 0.374607308201051*G0_1_0 + 1.03339947089946*G0_1_1;
    A[122] = -0.516699735449729*G0_0_0 + 0.413359788359799*G0_0_1 + 0.413359788359792*G0_1_0 + 2.02374063051146*G0_1_1;
    A[123] = 1.01187031525572*G0_0_0 + 0.859013310185174*G0_0_1 + 0.859013310185179*G0_1_0 + 0.387524801587296*G0_1_1;
    A[124] = 1.01187031525574*G0_0_0 - 1.4015480324074*G0_0_1 - 1.4015480324074*G0_1_0 - 3.81066054894178*G0_1_1;
    A[125] = -3.96136463844795*G0_0_0 - 1.30897266313932*G0_0_1 - 1.30897266313933*G0_1_0 + 0.731991291887122*G0_1_1;
    A[126] = -0.0408192791005288*G0_0_0 - 0.0408192791005287*G0_0_1 - 0.0408192791005283*G0_1_0 - 0.0408192791005282*G0_1_1;
    A[127] = 0.0408192791005278*G0_0_0 - 0.161554783950617*G0_1_0;
    A[128] = 0.850315531305114*G0_0_1 + 0.202287946428572*G0_1_1;
    A[129] = -0.340160659171073*G0_0_0 - 0.0710462136243398*G0_0_1 + 0.329396081349206*G0_1_0 - 0.340160659171073*G0_1_1;
    A[130] = 0.895612874779541*G0_0_0 + 0.232514880952387*G0_0_1 - 0.482253086419749*G0_1_0 + 0.818107914462079*G0_1_1;
    A[131] = -1.39508928571428*G0_0_0 - 0.529617228835981*G0_0_1 + 0.796578758818336*G0_1_0 - 0.906377452601409*G0_1_1;
    A[132] = 2.56196952160493*G0_0_0 + 1.28098476080247*G0_0_1 + 1.28098476080247*G0_1_0 + 1.98929398148148*G0_1_1;
    A[133] = 0.340160659171075*G0_0_0 + 0.269114445546735*G0_0_1 + 0.269114445546736*G0_1_0 + 0.198068231922395*G0_1_1;
    A[134] = -0.895612874779542*G0_0_0 - 0.663097993827158*G0_0_1 - 0.663097993827158*G0_1_0 - 0.359536899250437*G0_1_1;
    A[135] = 1.39508928571428*G0_0_0 + 0.865472056878305*G0_0_1 + 0.865472056878305*G0_1_0 + 0.286337770061725*G0_1_1;
    A[136] = -2.56196952160494*G0_0_0 - 1.28098476080247*G0_0_1 - 1.28098476080247*G0_1_0 - 0.286337770061728*G0_1_1;
    A[137] = 0.0710462136243395*G0_0_1 + 0.0710462136243365*G0_1_0 + 0.142092427248678*G0_1_1;
    A[138] = 0.0301408179012359*G0_0_1 + 0.0301408179012366*G0_1_0 + 0.131327849426808*G0_1_1;
    A[139] = 0.030140817901236*G0_0_1 + 0.0301408179012328*G0_1_0 + 0.172233245149912*G0_1_1;
    A[140] = 0.0710462136243399*G0_0_1 + 0.0710462136243388*G0_1_0 + 0.340160659171074*G0_1_1;
    A[141] = -0.262655698853618*G0_0_1 - 0.262655698853612*G0_1_0 - 0.667403824955909*G0_1_1;
    A[142] = -0.073199129188715*G0_0_1 - 0.0731991291887134*G0_1_0 - 0.419818535052912*G0_1_1;
    A[143] = -0.262655698853622*G0_0_1 - 0.262655698853615*G0_1_0 - 0.990341159611992*G0_1_1;
    A[144] = 0.572675540123459*G0_0_1 + 0.57267554012345*G0_1_0 + 1.35633680555555*G0_1_1;
    A[145] = 0.57267554012346*G0_0_1 + 0.572675540123455*G0_1_0 + 1.19486813822751*G0_1_1;
    A[146] = -1.66205081569665*G0_0_1 - 1.66205081569664*G0_1_0 - 2.8203193893298*G0_1_1;
    A[147] = 0.202287946428571*G0_0_0 + 0.202287946428571*G0_0_1 - 0.64802758487654*G0_1_0 - 0.648027584876541*G0_1_1;
    A[148] = -0.0408192791005284*G0_0_0;
    A[149] = 0.161554783950617*G0_0_1 + 0.202374063051146*G0_1_1;
    A[150] = 0.142092427248678*G0_0_0 + 0.0710462136243384*G0_0_1 + 0.0710462136243377*G0_1_0;
    A[151] = 0.131327849426809*G0_0_0 + 0.101187031525576*G0_0_1 + 0.101187031525575*G0_1_0 + 0.0710462136243377*G0_1_1;
    A[152] = 0.172233245149908*G0_0_0 + 0.142092427248675*G0_0_1 + 0.142092427248673*G0_1_0 + 0.111951609347442*G0_1_1;
    A[153] = 0.340160659171076*G0_0_0 + 0.269114445546736*G0_0_1 + 0.269114445546735*G0_1_0 + 0.198068231922395*G0_1_1;
    A[154] = 1.98929398148147*G0_0_0 + 0.708309220679009*G0_0_1 + 0.708309220679009*G0_1_0 + 1.98929398148147*G0_1_1;
    A[155] = -0.906377452601405*G0_0_0 - 1.70295621141975*G0_0_1 - 0.376760223765426*G0_1_0 - 2.56842826829805*G0_1_1;
    A[156] = 0.818107914462075*G0_0_0 + 1.30036100088183*G0_0_1 + 0.585593033509693*G0_1_0 + 1.96345899470898*G0_1_1;
    A[157] = -0.340160659171076*G0_0_0 - 0.66955674052028*G0_0_1 - 0.269114445546735*G0_1_0 - 0.938671186067015*G0_1_1;
    A[158] = -0.286337770061728*G0_0_0 + 0.994646990740737*G0_0_1 + 0.994646990740736*G0_1_0 - 0.286337770061727*G0_1_1;
    A[159] = 0.286337770061727*G0_0_0 - 0.579134286816576*G0_0_1 - 0.579134286816577*G0_1_0 - 0.0495170579806024*G0_1_1;
    A[160] = -0.359536899250438*G0_0_0 + 0.303561094576719*G0_0_1 + 0.303561094576719*G0_1_0 + 0.0710462136243422*G0_1_1;
    A[161] = 0.198068231922397*G0_0_0 - 0.0710462136243384*G0_0_1 - 0.0710462136243397*G0_1_0;
    A[162] = -2.82031938932979*G0_0_0 - 1.15826857363315*G0_0_1 - 1.15826857363315*G0_1_0 + 0.503782242063496*G0_1_1;
    A[163] = 1.35633680555554*G0_0_0 + 0.783661265432093*G0_0_1 + 0.783661265432097*G0_1_0 + 0.210985725308637*G0_1_1;
    A[164] = -0.667403824955903*G0_0_0 - 0.404748126102295*G0_0_1 - 0.404748126102292*G0_1_0 - 0.142092427248677*G0_1_1;
    A[165] = 1.1948681382275*G0_0_0 + 0.622192598104044*G0_0_1 + 0.622192598104045*G0_1_0 + 0.0495170579805889*G0_1_1;
    A[166] = -0.419818535052907*G0_0_0 - 0.34661940586419*G0_0_1 - 0.346619405864194*G0_1_0 - 0.27342027667548*G0_1_1;
    A[167] = -0.990341159611983*G0_0_0 - 0.72768546075837*G0_0_1 - 0.727685460758366*G0_1_0 - 0.465029761904751*G0_1_1;
    A[168] = -0.0158454585537925*G0_0_0 - 0.0158454585537926*G0_0_1 + 0.594204695767192*G0_1_0 + 0.594204695767194*G0_1_1;
    A[169] = -0.0379774305555559*G0_0_0;
    A[170] = -0.380291005291005*G0_0_1 - 0.449959352954143*G0_1_1;
    A[171] = 0.131327849426806*G0_0_0 + 0.0301408179012316*G0_0_1 + 0.0301408179012346*G0_1_0;
    A[172] = -0.297102347883599*G0_0_0 - 0.148551173941799*G0_0_1 - 0.148551173941802*G0_1_0 - 0.0172233245149923*G0_1_1;
    A[173] = -0.21959738756613*G0_0_0 - 0.15716283619929*G0_0_1 - 0.157162836199288*G0_1_0 - 0.111951609347441*G0_1_1;
    A[174] = -0.895612874779541*G0_0_0 - 0.663097993827158*G0_0_1 - 0.663097993827158*G0_1_0 - 0.359536899250437*G0_1_1;
    A[175] = -0.906377452601405*G0_0_0 - 0.376760223765426*G0_0_1 - 1.70295621141975*G0_1_0 - 2.56842826829805*G0_1_1;
    A[176] = 3.07436342592591*G0_0_0 + 1.89887152777776*G0_0_1 + 1.89887152777776*G0_1_0 + 4.41778273809522*G0_1_1;
    A[177] = -1.80414324294532*G0_0_0 - 2.50384080136683*G0_0_1 - 1.45321800595237*G0_1_0 - 3.9570588073192*G0_1_1;
    A[178] = 0.895612874779542*G0_0_0 + 1.37786596119929*G0_0_1 + 0.663097993827159*G0_1_0 + 1.96345899470899*G0_1_1;
    A[179] = -0.0495170579805956*G0_0_0 - 0.579134286816575*G0_0_1 - 0.579134286816574*G0_1_0 + 0.286337770061726*G0_1_1;
    A[180] = 0.103339947089942*G0_0_0 - 0.0301408179012337*G0_0_1 - 0.030140817901234*G0_1_0 + 0.103339947089951*G0_1_1;
    A[181] = -0.11195160934744*G0_0_0 + 0.0452112268518504*G0_0_1 + 0.0452112268518502*G0_1_0 - 0.0172233245149959*G0_1_1;
    A[182] = 0.111951609347442*G0_0_0 - 0.0301408179012329*G0_0_1 - 0.0301408179012331*G0_1_0;
    A[183] = 0.731991291887122*G0_0_0 + 2.04096395502645*G0_0_1 + 2.04096395502645*G0_1_0 - 0.611428020282192*G0_1_1;
    A[184] = 0.387524801587297*G0_0_0 - 0.47148850859788*G0_0_1 - 0.471488508597883*G0_1_0 - 0.318631503527331*G0_1_1;
    A[185] = -0.344466490299821*G0_0_0 + 0.103339947089949*G0_0_1 + 0.103339947089948*G0_1_0 + 0.0344466490299851*G0_1_1;
    A[186] = -3.81066054894178*G0_0_0 - 2.40911251653438*G0_0_1 - 2.40911251653437*G0_1_0 + 0.00430583112876007*G0_1_1;
    A[187] = 1.03339947089947*G0_0_0 + 0.658792162698404*G0_0_1 + 0.658792162698409*G0_1_0 + 0.327243165784825*G0_1_1;
    A[188] = 2.02374063051144*G0_0_0 + 1.61038084215167*G0_0_1 + 1.61038084215166*G0_1_0 + 0.680321318342139*G0_1_1;
    A[189] = -0.0696683476631384*G0_0_0 - 0.0696683476631385*G0_0_1 - 0.449959352954142*G0_1_0 - 0.449959352954143*G0_1_1;
    A[190] = -0.037977430555554*G0_0_0;
    A[191] = 0.610050154320987*G0_0_1 + 0.594204695767194*G0_1_1;
    A[192] = 0.172233245149912*G0_0_0 + 0.0301408179012379*G0_0_1 + 0.0301408179012346*G0_1_0;
    A[193] = -0.219597387566135*G0_0_0 - 0.0624345513668439*G0_0_1 - 0.0624345513668398*G0_1_0 - 0.0172233245149917*G0_1_1;
    A[194] = 0.266961529982358*G0_0_0 + 0.13348076499118*G0_0_1 + 0.133480764991177*G0_1_0 + 0.103339947089946*G0_1_1;
    A[195] = 1.39508928571428*G0_0_0 + 0.865472056878305*G0_0_1 + 0.865472056878305*G0_1_0 + 0.286337770061725*G0_1_1;
    A[196] = 0.818107914462075*G0_0_0 + 0.585593033509693*G0_0_1 + 1.30036100088183*G0_1_0 + 1.96345899470898*G0_1_1;
    A[197] = -1.80414324294532*G0_0_0 - 1.45321800595237*G0_0_1 - 2.50384080136683*G0_1_0 - 3.9570588073192*G0_1_1;
    A[198] = 3.69440310846559*G0_0_0 + 2.51891121031745*G0_0_1 + 2.51891121031744*G0_1_0 + 4.41778273809521*G0_1_1;
    A[199] = -1.39508928571429*G0_0_0 - 2.19166804453262*G0_0_1 - 0.865472056878306*G0_1_0 - 2.56842826829805*G0_1_1;
    A[200] = 0.071046213624336*G0_0_0 + 0.303561094576719*G0_0_1 + 0.303561094576716*G0_1_0 - 0.359536899250438*G0_1_1;
    A[201] = -0.0172233245149908*G0_0_0 + 0.045211226851852*G0_0_1 + 0.0452112268518524*G0_1_0 - 0.111951609347446*G0_1_1;
    A[202] = -0.0172233245149899*G0_0_0 + 0.131327849426808*G0_0_1 + 0.131327849426808*G0_1_0 - 0.0172233245149878*G0_1_1;
    A[203] = 0.0710462136243364*G0_0_0 - 0.0301408179012378*G0_0_1 - 0.0301408179012353*G0_1_0;
    A[204] = -0.516699735449728*G0_0_0 - 0.93005952380952*G0_0_1 - 0.93005952380952*G0_1_0 + 0.680321318342154*G0_1_1;
    A[205] = 0.0430583112874704*G0_0_0 - 0.331548996913587*G0_0_1 - 0.331548996913578*G0_1_0 + 0.327243165784827*G0_1_1;
    A[206] = -0.516699735449729*G0_0_0 - 0.0688932980599635*G0_0_1 - 0.068893298059965*G0_1_0 + 0.0344466490299823*G0_1_1;
    A[207] = 1.01187031525572*G0_0_0 + 2.41341834766313*G0_0_1 + 2.41341834766312*G0_1_0 + 0.00430583112873867*G0_1_1;
    A[208] = 1.01187031525573*G0_0_0 + 0.152857005070556*G0_0_1 + 0.152857005070547*G0_1_0 - 0.318631503527331*G0_1_1;
    A[209] = -3.96136463844795*G0_0_0 - 2.65239197530863*G0_0_1 - 2.65239197530862*G0_1_0 - 0.611428020282176*G0_1_1;
    A[210] = 0.0408192791005288*G0_0_0 + 0.0408192791005287*G0_0_1 + 0.202374063051146*G0_1_0 + 0.202374063051146*G0_1_1;
    A[211] = -0.0408192791005278*G0_0_0;
    A[212] = -0.850315531305114*G0_0_1 - 0.648027584876542*G0_1_1;
    A[213] = 0.340160659171073*G0_0_0 + 0.0710462136243398*G0_0_1 + 0.0710462136243379*G0_1_0;
    A[214] = -0.895612874779541*G0_0_0 - 0.232514880952387*G0_0_1 - 0.232514880952382*G0_1_0 + 0.0710462136243366*G0_1_1;
    A[215] = 1.39508928571428*G0_0_0 + 0.529617228835982*G0_0_1 + 0.52961722883598*G0_1_0 - 0.0495170579805972*G0_1_1;
    A[216] = -2.56196952160494*G0_0_0 - 1.28098476080247*G0_0_1 - 1.28098476080247*G0_1_0 - 0.286337770061728*G0_1_1;
    A[217] = -0.340160659171076*G0_0_0 - 0.269114445546735*G0_0_1 - 0.66955674052028*G0_1_0 - 0.938671186067015*G0_1_1;
    A[218] = 0.895612874779542*G0_0_0 + 0.663097993827159*G0_0_1 + 1.37786596119929*G0_1_0 + 1.96345899470899*G0_1_1;
    A[219] = -1.39508928571429*G0_0_0 - 0.865472056878306*G0_0_1 - 2.19166804453262*G0_1_0 - 2.56842826829805*G0_1_1;
    A[220] = 2.56196952160494*G0_0_0 + 1.28098476080247*G0_0_1 + 1.28098476080247*G0_1_0 + 1.98929398148148*G0_1_1;
    A[221] = -0.0710462136243395*G0_0_1 - 0.0710462136243369*G0_1_0 + 0.198068231922397*G0_1_1;
    A[222] = -0.0301408179012362*G0_0_1 - 0.0301408179012355*G0_1_0 + 0.111951609347443*G0_1_1;
    A[223] = -0.0301408179012358*G0_0_1 - 0.0301408179012342*G0_1_0 + 0.071046213624337*G0_1_1;
    A[224] = -0.0710462136243398*G0_0_1 - 0.0710462136243385*G0_1_0;
    A[225] = 0.262655698853618*G0_0_1 + 0.262655698853614*G0_1_0 - 0.465029761904762*G0_1_1;
    A[226] = 0.0731991291887159*G0_0_1 + 0.0731991291887137*G0_1_0 - 0.27342027667548*G0_1_1;
    A[227] = 0.262655698853622*G0_0_1 + 0.262655698853614*G0_1_0 - 0.142092427248675*G0_1_1;
    A[228] = -0.572675540123459*G0_0_1 - 0.572675540123449*G0_1_0 + 0.0495170579806039*G0_1_1;
    A[229] = -0.572675540123461*G0_0_1 - 0.572675540123456*G0_1_0 + 0.210985725308636*G0_1_1;
    A[230] = 1.66205081569665*G0_0_1 + 1.66205081569664*G0_1_0 + 0.503782242063488*G0_1_1;
    A[231] = -0.64802758487654*G0_0_0 - 0.64802758487654*G0_0_1 + 0.202287946428571*G0_1_0 + 0.202287946428571*G0_1_1;
    A[232] = 0.202374063051145*G0_0_0 + 0.161554783950616*G0_1_0;
    A[233] = -0.0408192791005288*G0_1_1;
    A[234] = 0.198068231922396*G0_0_0 + 0.269114445546735*G0_0_1 + 0.269114445546736*G0_1_0 + 0.340160659171074*G0_1_1;
    A[235] = 0.111951609347441*G0_0_0 + 0.142092427248674*G0_0_1 + 0.142092427248675*G0_1_0 + 0.172233245149912*G0_1_1;
    A[236] = 0.0710462136243364*G0_0_0 + 0.101187031525572*G0_0_1 + 0.101187031525572*G0_1_0 + 0.131327849426805*G0_1_1;
    A[237] = 0.0710462136243365*G0_0_1 + 0.0710462136243396*G0_1_0 + 0.142092427248678*G0_1_1;
    A[238] = -0.286337770061728*G0_0_0 + 0.994646990740736*G0_0_1 + 0.994646990740737*G0_1_0 - 0.286337770061727*G0_1_1;
    A[239] = -0.0495170579805956*G0_0_0 - 0.579134286816574*G0_0_1 - 0.579134286816575*G0_1_0 + 0.286337770061726*G0_1_1;
    A[240] = 0.071046213624336*G0_0_0 + 0.303561094576716*G0_0_1 + 0.303561094576719*G0_1_0 - 0.359536899250438*G0_1_1;
    A[241] = -0.0710462136243369*G0_0_1 - 0.0710462136243395*G0_1_0 + 0.198068231922397*G0_1_1;
    A[242] = 1.98929398148147*G0_0_0 + 0.708309220679006*G0_0_1 + 0.708309220679005*G0_1_0 + 1.98929398148147*G0_1_1;
    A[243] = -2.56842826829804*G0_0_0 - 0.37676022376543*G0_0_1 - 1.70295621141974*G0_1_0 - 0.906377452601404*G0_1_1;
    A[244] = 1.96345899470898*G0_0_0 + 0.585593033509696*G0_0_1 + 1.30036100088182*G0_1_0 + 0.818107914462072*G0_1_1;
    A[245] = -0.938671186067014*G0_0_0 - 0.269114445546736*G0_0_1 - 0.669556740520277*G0_1_0 - 0.340160659171072*G0_1_1;
    A[246] = 0.503782242063487*G0_0_0 - 1.15826857363315*G0_0_1 - 1.15826857363315*G0_1_0 - 2.82031938932979*G0_1_1;
    A[247] = 0.0495170579806023*G0_0_0 + 0.622192598104046*G0_0_1 + 0.622192598104048*G0_1_0 + 1.1948681382275*G0_1_1;
    A[248] = -0.465029761904758*G0_0_0 - 0.727685460758368*G0_0_1 - 0.72768546075837*G0_1_0 - 0.990341159611986*G0_1_1;
    A[249] = 0.210985725308635*G0_0_0 + 0.783661265432095*G0_0_1 + 0.783661265432093*G0_1_0 + 1.35633680555555*G0_1_1;
    A[250] = -0.27342027667548*G0_0_0 - 0.34661940586419*G0_0_1 - 0.346619405864192*G0_1_0 - 0.419818535052902*G0_1_1;
    A[251] = -0.142092427248673*G0_0_0 - 0.40474812610229*G0_0_1 - 0.404748126102292*G0_1_0 - 0.667403824955909*G0_1_1;
    A[252] = 0.594204695767192*G0_0_0 + 0.594204695767193*G0_0_1 - 0.0158454585537913*G0_1_0 - 0.0158454585537909*G0_1_1;
    A[253] = -0.449959352954141*G0_0_0 - 0.380291005291001*G0_1_0;
    A[254] = -0.0379774305555552*G0_1_1;
    A[255] = -0.359536899250437*G0_0_0 - 0.663097993827156*G0_0_1 - 0.663097993827154*G0_1_0 - 0.89561287477953*G0_1_1;
    A[256] = -0.11195160934744*G0_0_0 - 0.157162836199291*G0_0_1 - 0.157162836199292*G0_1_0 - 0.219597387566138*G0_1_1;
    A[257] = -0.0172233245149903*G0_0_0 - 0.148551173941798*G0_0_1 - 0.148551173941798*G0_1_0 - 0.297102347883594*G0_1_1;
    A[258] = 0.0301408179012367*G0_0_1 + 0.0301408179012359*G0_1_0 + 0.131327849426808*G0_1_1;
    A[259] = 0.286337770061727*G0_0_0 - 0.579134286816577*G0_0_1 - 0.579134286816576*G0_1_0 - 0.0495170579806024*G0_1_1;
    A[260] = 0.103339947089942*G0_0_0 - 0.0301408179012341*G0_0_1 - 0.0301408179012337*G0_1_0 + 0.103339947089951*G0_1_1;
    A[261] = -0.0172233245149908*G0_0_0 + 0.0452112268518524*G0_0_1 + 0.0452112268518519*G0_1_0 - 0.111951609347446*G0_1_1;
    A[262] = -0.0301408179012354*G0_0_1 - 0.0301408179012362*G0_1_0 + 0.111951609347443*G0_1_1;
    A[263] = -2.56842826829804*G0_0_0 - 1.70295621141974*G0_0_1 - 0.37676022376543*G0_1_0 - 0.906377452601404*G0_1_1;
    A[264] = 4.41778273809521*G0_0_0 + 1.89887152777776*G0_0_1 + 1.89887152777776*G0_1_0 + 3.0743634259259*G0_1_1;
    A[265] = -3.9570588073192*G0_0_0 - 1.45321800595237*G0_0_1 - 2.50384080136682*G0_1_0 - 1.80414324294531*G0_1_1;
    A[266] = 1.96345899470898*G0_0_0 + 0.663097993827156*G0_0_1 + 1.37786596119928*G0_1_0 + 0.89561287477953*G0_1_1;
    A[267] = -0.611428020282181*G0_0_0 + 2.04096395502644*G0_0_1 + 2.04096395502643*G0_1_0 + 0.731991291887114*G0_1_1;
    A[268] = 0.00430583112874738*G0_0_0 - 2.40911251653437*G0_0_1 - 2.40911251653436*G0_1_0 - 3.81066054894177*G0_1_1;
    A[269] = 0.680321318342146*G0_0_0 + 1.61038084215166*G0_0_1 + 1.61038084215166*G0_1_0 + 2.02374063051144*G0_1_1;
    A[270] = -0.318631503527329*G0_0_0 - 0.471488508597882*G0_0_1 - 0.471488508597881*G0_1_0 + 0.387524801587309*G0_1_1;
    A[271] = 0.327243165784825*G0_0_0 + 0.658792162698403*G0_0_1 + 0.658792162698405*G0_1_0 + 1.03339947089946*G0_1_1;
    A[272] = 0.0344466490299827*G0_0_0 + 0.103339947089948*G0_0_1 + 0.103339947089946*G0_1_0 - 0.344466490299827*G0_1_1;
    A[273] = -0.449959352954142*G0_0_0 - 0.449959352954142*G0_0_1 - 0.0696683476631401*G0_1_0 - 0.0696683476631402*G0_1_1;
    A[274] = 0.594204695767191*G0_0_0 + 0.610050154320982*G0_1_0;
    A[275] = -0.0379774305555548*G0_1_1;
    A[276] = 0.286337770061724*G0_0_0 + 0.865472056878299*G0_0_1 + 0.865472056878299*G0_1_0 + 1.39508928571427*G0_1_1;
    A[277] = 0.103339947089945*G0_0_0 + 0.133480764991179*G0_0_1 + 0.133480764991182*G0_1_0 + 0.266961529982366*G0_1_1;
    A[278] = -0.0172233245149913*G0_0_0 - 0.0624345513668433*G0_0_1 - 0.062434551366846*G0_1_0 - 0.219597387566141*G0_1_1;
    A[279] = 0.0301408179012328*G0_0_1 + 0.030140817901236*G0_1_0 + 0.172233245149912*G0_1_1;
    A[280] = -0.359536899250438*G0_0_0 + 0.303561094576719*G0_0_1 + 0.303561094576719*G0_1_0 + 0.0710462136243422*G0_1_1;
    A[281] = -0.11195160934744*G0_0_0 + 0.0452112268518503*G0_0_1 + 0.0452112268518504*G0_1_0 - 0.0172233245149959*G0_1_1;
    A[282] = -0.0172233245149899*G0_0_0 + 0.131327849426808*G0_0_1 + 0.131327849426808*G0_1_0 - 0.0172233245149878*G0_1_1;
    A[283] = -0.0301408179012342*G0_0_1 - 0.0301408179012358*G0_1_0 + 0.071046213624337*G0_1_1;
    A[284] = 1.96345899470898*G0_0_0 + 1.30036100088182*G0_0_1 + 0.585593033509696*G0_1_0 + 0.818107914462072*G0_1_1;
    A[285] = -3.9570588073192*G0_0_0 - 2.50384080136682*G0_0_1 - 1.45321800595237*G0_1_0 - 1.80414324294531*G0_1_1;
    A[286] = 4.41778273809521*G0_0_0 + 2.51891121031744*G0_0_1 + 2.51891121031744*G0_1_0 + 3.69440310846558*G0_1_1;
    A[287] = -2.56842826829804*G0_0_0 - 0.865472056878299*G0_0_1 - 2.19166804453261*G0_1_0 - 1.39508928571427*G0_1_1;
    A[288] = 0.68032131834215*G0_0_0 - 0.930059523809513*G0_0_1 - 0.930059523809512*G0_1_0 - 0.516699735449726*G0_1_1;
    A[289] = 0.00430583112873977*G0_0_0 + 2.41341834766311*G0_0_1 + 2.41341834766311*G0_1_0 + 1.01187031525571*G0_1_1;
    A[290] = -0.611428020282177*G0_0_0 - 2.65239197530862*G0_0_1 - 2.65239197530862*G0_1_0 - 3.96136463844794*G0_1_1;
    A[291] = 0.327243165784828*G0_0_0 - 0.331548996913579*G0_0_1 - 0.331548996913578*G0_1_0 + 0.0430583112874738*G0_1_1;
    A[292] = -0.318631503527331*G0_0_0 + 0.152857005070553*G0_0_1 + 0.152857005070546*G0_1_0 + 1.01187031525573*G0_1_1;
    A[293] = 0.0344466490299798*G0_0_0 - 0.0688932980599661*G0_0_1 - 0.0688932980599624*G0_1_0 - 0.516699735449735*G0_1_1;
    A[294] = 0.202374063051145*G0_0_0 + 0.202374063051146*G0_0_1 + 0.0408192791005294*G0_1_0 + 0.0408192791005298*G0_1_1;
    A[295] = -0.64802758487654*G0_0_0 - 0.85031553130511*G0_1_0;
    A[296] = -0.0408192791005283*G0_1_1;
    A[297] = -0.286337770061726*G0_0_0 - 1.28098476080246*G0_0_1 - 1.28098476080246*G0_1_0 - 2.56196952160492*G0_1_1;
    A[298] = -0.0495170579805983*G0_0_0 + 0.529617228835978*G0_0_1 + 0.529617228835981*G0_1_0 + 1.39508928571428*G0_1_1;
    A[299] = 0.0710462136243375*G0_0_0 - 0.23251488095238*G0_0_1 - 0.232514880952384*G0_1_0 - 0.895612874779538*G0_1_1;
    A[300] = 0.0710462136243389*G0_0_1 + 0.0710462136243399*G0_1_0 + 0.340160659171074*G0_1_1;
    A[301] = 0.198068231922397*G0_0_0 - 0.0710462136243396*G0_0_1 - 0.0710462136243384*G0_1_0;
    A[302] = 0.111951609347443*G0_0_0 - 0.0301408179012331*G0_0_1 - 0.0301408179012329*G0_1_0;
    A[303] = 0.0710462136243364*G0_0_0 - 0.0301408179012353*G0_0_1 - 0.0301408179012378*G0_1_0;
    A[304] = -0.0710462136243385*G0_0_1 - 0.0710462136243399*G0_1_0;
    A[305] = -0.938671186067014*G0_0_0 - 0.669556740520277*G0_0_1 - 0.269114445546736*G0_1_0 - 0.340160659171072*G0_1_1;
    A[306] = 1.96345899470898*G0_0_0 + 1.37786596119928*G0_0_1 + 0.663097993827156*G0_1_0 + 0.89561287477953*G0_1_1;
    A[307] = -2.56842826829804*G0_0_0 - 2.19166804453261*G0_0_1 - 0.8654720568783*G0_1_0 - 1.39508928571427*G0_1_1;
    A[308] = 1.98929398148147*G0_0_0 + 1.28098476080246*G0_0_1 + 1.28098476080246*G0_1_0 + 2.56196952160492*G0_1_1;
    A[309] = -0.46502976190476*G0_0_0 + 0.262655698853612*G0_0_1 + 0.26265569885361*G0_1_0;
    A[310] = 0.0495170579806038*G0_0_0 - 0.572675540123446*G0_0_1 - 0.572675540123449*G0_1_0;
    A[311] = 0.503782242063485*G0_0_0 + 1.66205081569664*G0_0_1 + 1.66205081569664*G0_1_0;
    A[312] = -0.273420276675487*G0_0_0 + 0.0731991291887091*G0_0_1 + 0.073199129188708*G0_1_0;
    A[313] = 0.210985725308641*G0_0_0 - 0.572675540123458*G0_0_1 - 0.572675540123457*G0_1_0;
    A[314] = -0.142092427248673*G0_0_0 + 0.262655698853619*G0_0_1 + 0.262655698853622*G0_1_0;
    A[315] = -0.215291556437388*G0_0_0 - 0.215291556437387*G0_0_1 - 0.21529155643739*G0_1_0 - 0.21529155643739*G0_1_1;
    A[316] = 0.107645778218694*G0_0_0;
    A[317] = 0.107645778218694*G0_1_1;
    A[318] = -0.667403824955902*G0_0_0 - 0.26265569885361*G0_0_1 - 0.262655698853614*G0_1_0;
    A[319] = -0.344466490299822*G0_0_0 - 0.447806437389769*G0_0_1 - 0.447806437389766*G0_1_0 - 0.516699735449732*G0_1_1;
    A[320] = -0.516699735449726*G0_0_0 - 0.447806437389764*G0_0_1 - 0.447806437389764*G0_1_0 - 0.344466490299815*G0_1_1;
    A[321] = -0.262655698853612*G0_0_1 - 0.262655698853618*G0_1_0 - 0.667403824955909*G0_1_1;
    A[322] = -2.82031938932979*G0_0_0 - 1.15826857363315*G0_0_1 - 1.15826857363315*G0_1_0 + 0.503782242063496*G0_1_1;
    A[323] = 0.731991291887122*G0_0_0 + 2.04096395502645*G0_0_1 + 2.04096395502645*G0_1_0 - 0.611428020282192*G0_1_1;
    A[324] = -0.516699735449728*G0_0_0 - 0.93005952380952*G0_0_1 - 0.93005952380952*G0_1_0 + 0.680321318342154*G0_1_1;
    A[325] = 0.262655698853614*G0_0_1 + 0.262655698853618*G0_1_0 - 0.465029761904762*G0_1_1;
    A[326] = 0.503782242063487*G0_0_0 - 1.15826857363315*G0_0_1 - 1.15826857363315*G0_1_0 - 2.82031938932979*G0_1_1;
    A[327] = -0.611428020282181*G0_0_0 + 2.04096395502643*G0_0_1 + 2.04096395502644*G0_1_0 + 0.731991291887114*G0_1_1;
    A[328] = 0.68032131834215*G0_0_0 - 0.930059523809512*G0_0_1 - 0.930059523809513*G0_1_0 - 0.516699735449726*G0_1_1;
    A[329] = -0.46502976190476*G0_0_0 + 0.26265569885361*G0_0_1 + 0.262655698853612*G0_1_0;
    A[330] = 7.06156305114633*G0_0_0 + 3.10019841269839*G0_0_1 + 3.10019841269839*G0_1_0 + 7.06156305114636*G0_1_1;
    A[331] = -6.3295717592592*G0_0_0 - 3.0571401014109*G0_0_1 - 3.05714010141091*G0_1_0 - 1.80844907407406*G0_1_1;
    A[332] = 2.75573192239856*G0_0_0 + 1.37786596119928*G0_0_1 + 1.37786596119928*G0_1_0 + 1.03339947089946*G0_1_1;
    A[333] = -1.80844907407406*G0_0_0 - 3.05714010141091*G0_0_1 - 3.05714010141092*G0_1_0 - 6.32957175925924*G0_1_1;
    A[334] = 1.42092427248676*G0_0_0 + 1.46398258377423*G0_0_1 + 1.46398258377424*G0_1_0 + 1.42092427248676*G0_1_1;
    A[335] = 1.03339947089945*G0_0_0 + 1.37786596119928*G0_0_1 + 1.37786596119928*G0_1_0 + 2.75573192239859*G0_1_1;
    A[336] = -0.0538228891093493*G0_0_0 - 0.0538228891093495*G0_0_1 - 0.0538228891093448*G0_1_0 - 0.0538228891093454*G0_1_1;
    A[337] = -0.0538228891093484*G0_0_0;
    A[338] = 0.107645778218694*G0_1_1;
    A[339] = 1.35633680555554*G0_0_0 + 0.572675540123448*G0_0_1 + 0.57267554012345*G0_1_0;
    A[340] = 0.387524801587299*G0_0_0 + 0.859013310185181*G0_0_1 + 0.859013310185177*G0_1_0 + 1.01187031525573*G0_1_1;
    A[341] = 0.04305831128747*G0_0_0 + 0.374607308201051*G0_0_1 + 0.374607308201054*G0_1_0 + 1.03339947089946*G0_1_1;
    A[342] = -0.0731991291887134*G0_0_1 - 0.073199129188715*G0_1_0 - 0.419818535052912*G0_1_1;
    A[343] = 1.35633680555554*G0_0_0 + 0.783661265432096*G0_0_1 + 0.783661265432092*G0_1_0 + 0.210985725308637*G0_1_1;
    A[344] = 0.387524801587297*G0_0_0 - 0.471488508597883*G0_0_1 - 0.47148850859788*G0_1_0 - 0.318631503527331*G0_1_1;
    A[345] = 0.0430583112874704*G0_0_0 - 0.331548996913578*G0_0_1 - 0.331548996913587*G0_1_0 + 0.327243165784827*G0_1_1;
    A[346] = 0.0731991291887137*G0_0_1 + 0.0731991291887159*G0_1_0 - 0.27342027667548*G0_1_1;
    A[347] = 0.0495170579806023*G0_0_0 + 0.622192598104048*G0_0_1 + 0.622192598104046*G0_1_0 + 1.1948681382275*G0_1_1;
    A[348] = 0.00430583112874727*G0_0_0 - 2.40911251653436*G0_0_1 - 2.40911251653437*G0_1_0 - 3.81066054894177*G0_1_1;
    A[349] = 0.00430583112873977*G0_0_0 + 2.41341834766311*G0_0_1 + 2.41341834766311*G0_1_0 + 1.01187031525571*G0_1_1;
    A[350] = 0.0495170579806038*G0_0_0 - 0.572675540123449*G0_0_1 - 0.572675540123446*G0_1_0;
    A[351] = -6.3295717592592*G0_0_0 - 3.05714010141091*G0_0_1 - 3.0571401014109*G0_1_0 - 1.80844907407406*G0_1_1;
    A[352] = 9.94646990740732*G0_0_0 + 4.97323495370365*G0_0_1 + 4.97323495370365*G0_1_0 + 8.654720568783*G0_1_1;
    A[353] = -6.32957175925921*G0_0_0 - 3.27243165784829*G0_0_1 - 3.27243165784829*G0_1_0 - 2.02374063051143*G0_1_1;
    A[354] = -0.387524801587302*G0_0_0 + 2.55120494378304*G0_0_1 + 2.55120494378304*G0_1_0 - 0.387524801587314*G0_1_1;
    A[355] = -0.387524801587291*G0_0_0 - 2.93872974537035*G0_0_1 - 2.93872974537034*G0_1_0 - 5.8774594907407*G0_1_1;
    A[356] = -0.086116622574941*G0_0_0 - 0.0430583112874668*G0_0_1 - 0.0430583112874692*G0_1_0 + 1.42092427248678*G0_1_1;
    A[357] = 0.107645778218695*G0_0_0 + 0.107645778218695*G0_0_1 + 0.107645778218693*G0_1_0 + 0.107645778218693*G0_1_1;
    A[358] = -0.215291556437388*G0_0_0;
    A[359] = 0.107645778218692*G0_1_1;
    A[360] = -2.82031938932979*G0_0_0 - 1.66205081569664*G0_0_1 - 1.66205081569664*G0_1_0;
    A[361] = 0.731991291887125*G0_0_0 - 1.30897266313932*G0_0_1 - 1.30897266313933*G0_1_0 - 3.96136463844796*G0_1_1;
    A[362] = -0.516699735449729*G0_0_0 + 0.413359788359792*G0_0_1 + 0.413359788359799*G0_1_0 + 2.02374063051146*G0_1_1;
    A[363] = -0.262655698853615*G0_0_1 - 0.262655698853622*G0_1_0 - 0.990341159611992*G0_1_1;
    A[364] = -0.667403824955903*G0_0_0 - 0.404748126102292*G0_0_1 - 0.404748126102295*G0_1_0 - 0.142092427248677*G0_1_1;
    A[365] = -0.344466490299821*G0_0_0 + 0.103339947089948*G0_0_1 + 0.103339947089949*G0_1_0 + 0.0344466490299851*G0_1_1;
    A[366] = -0.51669973544973*G0_0_0 - 0.068893298059965*G0_0_1 - 0.0688932980599635*G0_1_0 + 0.0344466490299823*G0_1_1;
    A[367] = 0.262655698853615*G0_0_1 + 0.262655698853622*G0_1_0 - 0.142092427248675*G0_1_1;
    A[368] = -0.465029761904758*G0_0_0 - 0.72768546075837*G0_0_1 - 0.727685460758369*G0_1_0 - 0.990341159611986*G0_1_1;
    A[369] = 0.680321318342146*G0_0_0 + 1.61038084215166*G0_0_1 + 1.61038084215166*G0_1_0 + 2.02374063051144*G0_1_1;
    A[370] = -0.611428020282177*G0_0_0 - 2.65239197530862*G0_0_1 - 2.65239197530862*G0_1_0 - 3.96136463844794*G0_1_1;
    A[371] = 0.503782242063485*G0_0_0 + 1.66205081569664*G0_0_1 + 1.66205081569664*G0_1_0;
    A[372] = 2.75573192239856*G0_0_0 + 1.37786596119928*G0_0_1 + 1.37786596119928*G0_1_0 + 1.03339947089946*G0_1_1;
    A[373] = -6.32957175925921*G0_0_0 - 3.27243165784829*G0_0_1 - 3.27243165784829*G0_1_0 - 2.02374063051143*G0_1_1;
    A[374] = 7.06156305114634*G0_0_0 + 3.96136463844794*G0_0_1 + 3.96136463844794*G0_1_0 + 7.92272927689591*G0_1_1;
    A[375] = 1.42092427248677*G0_0_0 - 0.0430583112874671*G0_0_1 - 0.0430583112874739*G0_1_0 - 0.0861166225749498*G0_1_1;
    A[376] = -1.80844907407408*G0_0_0 + 1.24869102733685*G0_0_1 + 1.24869102733686*G0_1_0 - 2.02374063051147*G0_1_1;
    A[377] = 1.03339947089946*G0_0_0 - 0.344466490299827*G0_0_1 - 0.344466490299834*G0_1_0 + 1.03339947089947*G0_1_1;
    A[378] = -0.0538228891093453*G0_0_0 - 0.0538228891093455*G0_0_1 - 0.0538228891093464*G0_1_0 - 0.0538228891093461*G0_1_1;
    A[379] = 0.107645778218696*G0_0_0;
    A[380] = -0.0538228891093463*G0_1_1;
    A[381] = -0.419818535052908*G0_0_0 - 0.0731991291887062*G0_0_1 - 0.0731991291887132*G0_1_0;
    A[382] = 1.03339947089947*G0_0_0 + 0.374607308201051*G0_0_1 + 0.374607308201056*G0_1_0 + 0.0430583112874713*G0_1_1;
    A[383] = 1.01187031525572*G0_0_0 + 0.859013310185179*G0_0_1 + 0.859013310185174*G0_1_0 + 0.387524801587296*G0_1_1;
    A[384] = 0.57267554012345*G0_0_1 + 0.572675540123459*G0_1_0 + 1.35633680555555*G0_1_1;
    A[385] = 1.1948681382275*G0_0_0 + 0.622192598104045*G0_0_1 + 0.622192598104044*G0_1_0 + 0.0495170579805889*G0_1_1;
    A[386] = -3.81066054894178*G0_0_0 - 2.40911251653437*G0_0_1 - 2.40911251653438*G0_1_0 + 0.00430583112876018*G0_1_1;
    A[387] = 1.01187031525572*G0_0_0 + 2.41341834766312*G0_0_1 + 2.41341834766313*G0_1_0 + 0.00430583112873856*G0_1_1;
    A[388] = -0.572675540123449*G0_0_1 - 0.572675540123459*G0_1_0 + 0.0495170579806039*G0_1_1;
    A[389] = 0.210985725308635*G0_0_0 + 0.783661265432093*G0_0_1 + 0.783661265432095*G0_1_0 + 1.35633680555555*G0_1_1;
    A[390] = -0.318631503527329*G0_0_0 - 0.471488508597881*G0_0_1 - 0.471488508597882*G0_1_0 + 0.387524801587309*G0_1_1;
    A[391] = 0.327243165784828*G0_0_0 - 0.331548996913578*G0_0_1 - 0.331548996913579*G0_1_0 + 0.0430583112874738*G0_1_1;
    A[392] = -0.273420276675487*G0_0_0 + 0.073199129188708*G0_0_1 + 0.0731991291887092*G0_1_0;
    A[393] = -1.80844907407406*G0_0_0 - 3.05714010141092*G0_0_1 - 3.05714010141091*G0_1_0 - 6.32957175925924*G0_1_1;
    A[394] = -0.387524801587303*G0_0_0 + 2.55120494378304*G0_0_1 + 2.55120494378304*G0_1_0 - 0.387524801587314*G0_1_1;
    A[395] = 1.42092427248677*G0_0_0 - 0.0430583112874739*G0_0_1 - 0.043058311287467*G0_1_0 - 0.0861166225749498*G0_1_1;
    A[396] = 8.65472056878301*G0_0_0 + 4.97323495370368*G0_0_1 + 4.97323495370368*G0_1_0 + 9.94646990740738*G0_1_1;
    A[397] = -5.8774594907407*G0_0_0 - 2.93872974537034*G0_0_1 - 2.93872974537035*G0_1_0 - 0.387524801587284*G0_1_1;
    A[398] = -2.02374063051143*G0_0_0 - 3.2724316578483*G0_0_1 - 3.2724316578483*G0_1_0 - 6.32957175925924*G0_1_1;
    A[399] = 0.107645778218693*G0_0_0 + 0.107645778218694*G0_0_1 + 0.107645778218693*G0_1_0 + 0.107645778218694*G0_1_1;
    A[400] = -0.0538228891093463*G0_0_0;
    A[401] = -0.0538228891093455*G0_1_1;
    A[402] = 1.19486813822751*G0_0_0 + 0.572675540123457*G0_0_1 + 0.572675540123457*G0_1_0;
    A[403] = -3.81066054894179*G0_0_0 - 1.4015480324074*G0_0_1 - 1.4015480324074*G0_1_0 + 1.01187031525573*G0_1_1;
    A[404] = 1.01187031525574*G0_0_0 - 1.4015480324074*G0_0_1 - 1.4015480324074*G0_1_0 - 3.81066054894178*G0_1_1;
    A[405] = 0.572675540123455*G0_0_1 + 0.57267554012346*G0_1_0 + 1.19486813822751*G0_1_1;
    A[406] = -0.419818535052907*G0_0_0 - 0.346619405864194*G0_0_1 - 0.34661940586419*G0_1_0 - 0.27342027667548*G0_1_1;
    A[407] = 1.03339947089947*G0_0_0 + 0.658792162698409*G0_0_1 + 0.658792162698404*G0_1_0 + 0.327243165784825*G0_1_1;
    A[408] = 1.01187031525573*G0_0_0 + 0.152857005070547*G0_0_1 + 0.152857005070556*G0_1_0 - 0.318631503527331*G0_1_1;
    A[409] = -0.572675540123456*G0_0_1 - 0.572675540123461*G0_1_0 + 0.210985725308636*G0_1_1;
    A[410] = -0.27342027667548*G0_0_0 - 0.346619405864193*G0_0_1 - 0.34661940586419*G0_1_0 - 0.419818535052902*G0_1_1;
    A[411] = 0.327243165784825*G0_0_0 + 0.658792162698405*G0_0_1 + 0.658792162698403*G0_1_0 + 1.03339947089946*G0_1_1;
    A[412] = -0.318631503527331*G0_0_0 + 0.152857005070546*G0_0_1 + 0.152857005070553*G0_1_0 + 1.01187031525573*G0_1_1;
    A[413] = 0.210985725308641*G0_0_0 - 0.572675540123457*G0_0_1 - 0.572675540123458*G0_1_0;
    A[414] = 1.42092427248676*G0_0_0 + 1.46398258377424*G0_0_1 + 1.46398258377423*G0_1_0 + 1.42092427248676*G0_1_1;
    A[415] = -0.387524801587291*G0_0_0 - 2.93872974537034*G0_0_1 - 2.93872974537035*G0_1_0 - 5.8774594907407*G0_1_1;
    A[416] = -1.80844907407408*G0_0_0 + 1.24869102733686*G0_0_1 + 1.24869102733685*G0_1_0 - 2.02374063051147*G0_1_1;
    A[417] = -5.8774594907407*G0_0_0 - 2.93872974537035*G0_0_1 - 2.93872974537034*G0_1_0 - 0.387524801587284*G0_1_1;
    A[418] = 8.65472056878302*G0_0_0 + 3.68148561507933*G0_0_1 + 3.68148561507933*G0_1_0 + 8.65472056878302*G0_1_1;
    A[419] = -2.02374063051147*G0_0_0 + 1.24869102733685*G0_0_1 + 1.24869102733685*G0_1_0 - 1.80844907407408*G0_1_1;
    A[420] = 0.107645778218693*G0_0_0 + 0.107645778218694*G0_0_1 + 0.107645778218693*G0_1_0 + 0.107645778218693*G0_1_1;
    A[421] = 0.107645778218691*G0_0_0;
    A[422] = -0.21529155643739*G0_1_1;
    A[423] = -0.990341159611988*G0_0_0 - 0.262655698853622*G0_0_1 - 0.262655698853616*G0_1_0;
    A[424] = 2.02374063051146*G0_0_0 + 0.413359788359797*G0_0_1 + 0.413359788359785*G0_1_0 - 0.516699735449729*G0_1_1;
    A[425] = -3.96136463844795*G0_0_0 - 1.30897266313933*G0_0_1 - 1.30897266313932*G0_1_0 + 0.731991291887122*G0_1_1;
    A[426] = -1.66205081569664*G0_0_1 - 1.66205081569665*G0_1_0 - 2.8203193893298*G0_1_1;
    A[427] = -0.990341159611983*G0_0_0 - 0.727685460758366*G0_0_1 - 0.72768546075837*G0_1_0 - 0.465029761904751*G0_1_1;
    A[428] = 2.02374063051144*G0_0_0 + 1.61038084215166*G0_0_1 + 1.61038084215167*G0_1_0 + 0.680321318342139*G0_1_1;
    A[429] = -3.96136463844795*G0_0_0 - 2.65239197530862*G0_0_1 - 2.65239197530863*G0_1_0 - 0.611428020282176*G0_1_1;
    A[430] = 1.66205081569664*G0_0_1 + 1.66205081569665*G0_1_0 + 0.503782242063488*G0_1_1;
    A[431] = -0.142092427248673*G0_0_0 - 0.404748126102292*G0_0_1 - 0.40474812610229*G0_1_0 - 0.667403824955909*G0_1_1;
    A[432] = 0.0344466490299827*G0_0_0 + 0.103339947089946*G0_0_1 + 0.103339947089948*G0_1_0 - 0.344466490299827*G0_1_1;
    A[433] = 0.0344466490299798*G0_0_0 - 0.0688932980599625*G0_0_1 - 0.0688932980599661*G0_1_0 - 0.516699735449734*G0_1_1;
    A[434] = -0.142092427248673*G0_0_0 + 0.262655698853622*G0_0_1 + 0.262655698853619*G0_1_0;
    A[435] = 1.03339947089945*G0_0_0 + 1.37786596119928*G0_0_1 + 1.37786596119928*G0_1_0 + 2.75573192239858*G0_1_1;
    A[436] = -0.086116622574941*G0_0_0 - 0.0430583112874693*G0_0_1 - 0.0430583112874668*G0_1_0 + 1.42092427248678*G0_1_1;
    A[437] = 1.03339947089946*G0_0_0 - 0.344466490299834*G0_0_1 - 0.344466490299827*G0_1_0 + 1.03339947089947*G0_1_1;
    A[438] = -2.02374063051143*G0_0_0 - 3.2724316578483*G0_0_1 - 3.2724316578483*G0_1_0 - 6.32957175925924*G0_1_1;
    A[439] = -2.02374063051147*G0_0_0 + 1.24869102733685*G0_0_1 + 1.24869102733685*G0_1_0 - 1.80844907407408*G0_1_1;
    A[440] = 7.9227292768959*G0_0_0 + 3.96136463844795*G0_0_1 + 3.96136463844795*G0_1_0 + 7.06156305114636*G0_1_1;
  }

  /// Tabulate the tensor for the contribution from a local cell
  /// using the specified reference cell quadrature points/weights
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int num_quadrature_points,
                               const double * const * quadrature_points,
                               const double* quadrature_weights) const
  {
    throw std::runtime_error("Quadrature version of tabulate_tensor not available when using the FFC tensor representation.");
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class poisson2d_5_cell_integral_1_0: public ufc::cell_integral
{
public:

  /// Constructor
  poisson2d_5_cell_integral_1_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~poisson2d_5_cell_integral_1_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      9
    // Number of operations (multiply-add pairs) for geometry tensor:    21
    // Number of operations (multiply-add pairs) for tensor contraction: 430
    // Total number of operations (multiply-add pairs):                  460
    
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0 = det*w[0][0]*(1.0);
    const double G0_1 = det*w[0][1]*(1.0);
    const double G0_2 = det*w[0][2]*(1.0);
    const double G0_3 = det*w[0][3]*(1.0);
    const double G0_4 = det*w[0][4]*(1.0);
    const double G0_5 = det*w[0][5]*(1.0);
    const double G0_6 = det*w[0][6]*(1.0);
    const double G0_7 = det*w[0][7]*(1.0);
    const double G0_8 = det*w[0][8]*(1.0);
    const double G0_9 = det*w[0][9]*(1.0);
    const double G0_10 = det*w[0][10]*(1.0);
    const double G0_11 = det*w[0][11]*(1.0);
    const double G0_12 = det*w[0][12]*(1.0);
    const double G0_13 = det*w[0][13]*(1.0);
    const double G0_14 = det*w[0][14]*(1.0);
    const double G0_15 = det*w[0][15]*(1.0);
    const double G0_16 = det*w[0][16]*(1.0);
    const double G0_17 = det*w[0][17]*(1.0);
    const double G0_18 = det*w[0][18]*(1.0);
    const double G0_19 = det*w[0][19]*(1.0);
    const double G0_20 = det*w[0][20]*(1.0);
    
    // Compute element tensor
    A[0] = 0.00138945256132761*G0_0 + 0.000123877456776766*G0_1 + 0.000123877456776765*G0_2 + 0.000363647010782439*G0_3 + 0.000207201813104596*G0_4 + 0.000207201813104596*G0_5 + 0.000363647010782438*G0_6 + 0.00118136348605102*G0_7 - 0.000958243145743176*G0_8 + 0.000462681126743636*G0_9 - 2.29644326866557e-05*G0_10 + 0.00118136348605102*G0_11 - 0.000958243145743179*G0_12 + 0.000462681126743639*G0_13 - 2.2964432686655e-05*G0_14 + 0.000892481361231369*G0_15 - 0.000974683591871131*G0_16 + 0.000879433388113959*G0_17 - 0.000974683591871125*G0_18 + 0.000649789061247417*G0_19 + 0.00087943338811396*G0_20;
    A[1] = 0.000123877456776766*G0_0 + 0.00138945256132761*G0_1 + 0.000123877456776766*G0_2 + 0.00118136348605102*G0_3 - 0.000958243145743181*G0_4 + 0.000462681126743642*G0_5 - 2.2964432686658e-05*G0_6 + 0.000363647010782439*G0_7 + 0.000207201813104596*G0_8 + 0.000207201813104597*G0_9 + 0.000363647010782439*G0_10 - 2.29644326866581e-05*G0_11 + 0.000462681126743644*G0_12 - 0.000958243145743186*G0_13 + 0.00118136348605103*G0_14 + 0.000879433388113962*G0_15 - 0.000974683591871128*G0_16 + 0.000892481361231384*G0_17 + 0.000649789061247414*G0_18 - 0.000974683591871125*G0_19 + 0.000879433388113966*G0_20;
    A[2] = 0.000123877456776765*G0_0 + 0.000123877456776766*G0_1 + 0.0013894525613276*G0_2 - 2.29644326866539e-05*G0_3 + 0.000462681126743638*G0_4 - 0.000958243145743175*G0_5 + 0.00118136348605102*G0_6 - 2.2964432686655e-05*G0_7 + 0.00046268112674364*G0_8 - 0.000958243145743177*G0_9 + 0.00118136348605102*G0_10 + 0.00036364701078244*G0_11 + 0.000207201813104599*G0_12 + 0.000207201813104598*G0_13 + 0.000363647010782441*G0_14 + 0.000879433388113972*G0_15 + 0.000649789061247418*G0_16 + 0.000879433388113971*G0_17 - 0.000974683591871127*G0_18 - 0.000974683591871127*G0_19 + 0.000892481361231385*G0_20;
    A[3] = 0.000363647010782439*G0_0 + 0.00118136348605102*G0_1 - 2.2964432686654e-05*G0_2 + 0.0147050657033301*G0_3 - 0.00958373625474352*G0_4 + 0.00770482812583533*G0_5 - 0.00396984582097443*G0_6 - 0.000411011153198681*G0_7 - 0.00144832501603339*G0_8 - 4.5667905910966e-05*G0_9 - 0.00248237688558877*G0_10 - 0.00248237688558879*G0_11 + 0.00576068013134008*G0_12 - 0.00735253285166507*G0_13 + 0.00735253285166507*G0_14 + 0.000782878387045085*G0_15 - 0.00381653213684478*G0_16 + 0.0102426588971732*G0_17 - 0.00137003717732889*G0_18 + 9.78597983806285e-05*G0_19 - 0.00280531422024485*G0_20;
    A[4] = 0.000207201813104596*G0_0 - 0.000958243145743181*G0_1 + 0.000462681126743638*G0_2 - 0.00958373625474352*G0_3 + 0.0220771705146713*G0_4 - 0.0134785562302928*G0_5 + 0.00770482812583533*G0_6 - 0.0014483250160334*G0_7 + 0.00281836219336228*G0_8 - 0.00135698920421147*G0_9 + 0.00576068013134005*G0_10 - 4.56679059109596e-05*G0_11 - 0.00135698920421148*G0_12 + 0.00294884192453649*G0_13 - 0.00735253285166506*G0_14 + 0.0031315135481803*G0_15 - 0.00548014870931555*G0_16 - 0.00143527704291601*G0_17 - 0.000587158790283815*G0_18 + 0.00528442911255429*G0_19 + 0.00508870951579301*G0_20;
    A[5] = 0.000207201813104596*G0_0 + 0.000462681126743643*G0_1 - 0.000958243145743175*G0_2 + 0.00770482812583533*G0_3 - 0.0134785562302928*G0_4 + 0.0220771705146713*G0_5 - 0.00958373625474353*G0_6 - 4.5667905910971e-05*G0_7 - 0.00135698920421146*G0_8 + 0.00294884192453646*G0_9 - 0.00735253285166505*G0_10 - 0.0014483250160334*G0_11 + 0.0028183621933623*G0_12 - 0.00135698920421148*G0_13 + 0.00576068013134006*G0_14 + 0.00313151354818034*G0_15 - 0.00058715879028382*G0_16 + 0.00508870951579304*G0_17 - 0.00548014870931557*G0_18 + 0.0052844291125543*G0_19 - 0.00143527704291597*G0_20;
    A[6] = 0.000363647010782438*G0_0 - 2.29644326866579e-05*G0_1 + 0.00118136348605102*G0_2 - 0.00396984582097443*G0_3 + 0.00770482812583533*G0_4 - 0.00958373625474353*G0_5 + 0.0147050657033301*G0_6 - 0.00248237688558878*G0_7 + 0.00576068013134004*G0_8 - 0.00735253285166504*G0_9 + 0.00735253285166504*G0_10 - 0.000411011153198664*G0_11 - 0.00144832501603341*G0_12 - 4.56679059109587e-05*G0_13 - 0.00248237688558878*G0_14 + 0.000782878387045063*G0_15 - 0.00137003717732888*G0_16 - 0.00280531422024489*G0_17 - 0.00381653213684476*G0_18 + 9.78597983806367e-05*G0_19 + 0.0102426588971731*G0_20;
    A[7] = 0.00118136348605102*G0_0 + 0.000363647010782439*G0_1 - 2.29644326866551e-05*G0_2 - 0.000411011153198681*G0_3 - 0.0014483250160334*G0_4 - 4.56679059109712e-05*G0_5 - 0.00248237688558878*G0_6 + 0.0147050657033301*G0_7 - 0.00958373625474351*G0_8 + 0.00770482812583532*G0_9 - 0.00396984582097443*G0_10 + 0.00735253285166504*G0_11 - 0.00735253285166506*G0_12 + 0.00576068013134006*G0_13 - 0.00248237688558879*G0_14 + 0.0102426588971731*G0_15 - 0.00381653213684478*G0_16 + 0.000782878387045076*G0_17 + 9.78597983806161e-05*G0_18 - 0.0013700371773289*G0_19 - 0.00280531422024487*G0_20;
    A[8] = -0.000958243145743176*G0_0 + 0.000207201813104596*G0_1 + 0.00046268112674364*G0_2 - 0.00144832501603339*G0_3 + 0.00281836219336228*G0_4 - 0.00135698920421146*G0_5 + 0.00576068013134004*G0_6 - 0.00958373625474351*G0_7 + 0.0220771705146713*G0_8 - 0.0134785562302928*G0_9 + 0.00770482812583534*G0_10 - 0.00735253285166505*G0_11 + 0.00294884192453647*G0_12 - 0.00135698920421147*G0_13 - 4.56679059109589e-05*G0_14 - 0.001435277042916*G0_15 - 0.00548014870931555*G0_16 + 0.00313151354818031*G0_17 + 0.00528442911255431*G0_18 - 0.00058715879028381*G0_19 + 0.005088709515793*G0_20;
    A[9] = 0.000462681126743636*G0_0 + 0.000207201813104597*G0_1 - 0.000958243145743177*G0_2 - 4.56679059109662e-05*G0_3 - 0.00135698920421147*G0_4 + 0.00294884192453646*G0_5 - 0.00735253285166504*G0_6 + 0.00770482812583532*G0_7 - 0.0134785562302928*G0_8 + 0.0220771705146713*G0_9 - 0.00958373625474354*G0_10 + 0.00576068013134004*G0_11 - 0.00135698920421147*G0_12 + 0.00281836219336229*G0_13 - 0.0014483250160334*G0_14 + 0.00508870951579304*G0_15 - 0.000587158790283813*G0_16 + 0.00313151354818033*G0_17 + 0.00528442911255427*G0_18 - 0.00548014870931556*G0_19 - 0.00143527704291596*G0_20;
    A[10] = -2.29644326866557e-05*G0_0 + 0.000363647010782439*G0_1 + 0.00118136348605102*G0_2 - 0.00248237688558877*G0_3 + 0.00576068013134005*G0_4 - 0.00735253285166505*G0_5 + 0.00735253285166504*G0_6 - 0.00396984582097443*G0_7 + 0.00770482812583534*G0_8 - 0.00958373625474353*G0_9 + 0.0147050657033301*G0_10 - 0.00248237688558878*G0_11 - 4.56679059109644e-05*G0_12 - 0.0014483250160334*G0_13 - 0.000411011153198664*G0_14 - 0.0028053142202449*G0_15 - 0.00137003717732888*G0_16 + 0.000782878387045066*G0_17 + 9.78597983806526e-05*G0_18 - 0.00381653213684477*G0_19 + 0.0102426588971731*G0_20;
    A[11] = 0.00118136348605102*G0_0 - 2.2964432686658e-05*G0_1 + 0.00036364701078244*G0_2 - 0.00248237688558879*G0_3 - 4.56679059109596e-05*G0_4 - 0.00144832501603341*G0_5 - 0.000411011153198664*G0_6 + 0.00735253285166504*G0_7 - 0.00735253285166505*G0_8 + 0.00576068013134004*G0_9 - 0.00248237688558878*G0_10 + 0.0147050657033301*G0_11 - 0.00958373625474355*G0_12 + 0.00770482812583535*G0_13 - 0.00396984582097444*G0_14 + 0.0102426588971731*G0_15 + 9.78597983806274e-05*G0_16 - 0.00280531422024488*G0_17 - 0.00381653213684478*G0_18 - 0.00137003717732888*G0_19 + 0.000782878387045077*G0_20;
    A[12] = -0.000958243145743179*G0_0 + 0.000462681126743644*G0_1 + 0.000207201813104599*G0_2 + 0.00576068013134008*G0_3 - 0.00135698920421148*G0_4 + 0.0028183621933623*G0_5 - 0.00144832501603341*G0_6 - 0.00735253285166506*G0_7 + 0.00294884192453647*G0_8 - 0.00135698920421147*G0_9 - 4.56679059109644e-05*G0_10 - 0.00958373625474355*G0_11 + 0.0220771705146713*G0_12 - 0.0134785562302928*G0_13 + 0.00770482812583537*G0_14 - 0.00143527704291596*G0_15 + 0.00528442911255429*G0_16 + 0.00508870951579308*G0_17 - 0.00548014870931557*G0_18 - 0.000587158790283811*G0_19 + 0.00313151354818034*G0_20;
    A[13] = 0.000462681126743639*G0_0 - 0.000958243145743186*G0_1 + 0.000207201813104598*G0_2 - 0.00735253285166507*G0_3 + 0.00294884192453649*G0_4 - 0.00135698920421148*G0_5 - 4.56679059109586e-05*G0_6 + 0.00576068013134006*G0_7 - 0.00135698920421147*G0_8 + 0.00281836219336229*G0_9 - 0.0014483250160334*G0_10 + 0.00770482812583535*G0_11 - 0.0134785562302928*G0_12 + 0.0220771705146713*G0_13 - 0.00958373625474357*G0_14 + 0.00508870951579303*G0_15 + 0.0052844291125543*G0_16 - 0.001435277042916*G0_17 - 0.000587158790283812*G0_18 - 0.00548014870931555*G0_19 + 0.00313151354818032*G0_20;
    A[14] = -2.29644326866551e-05*G0_0 + 0.00118136348605103*G0_1 + 0.000363647010782441*G0_2 + 0.00735253285166507*G0_3 - 0.00735253285166506*G0_4 + 0.00576068013134006*G0_5 - 0.00248237688558878*G0_6 - 0.00248237688558879*G0_7 - 4.56679059109588e-05*G0_8 - 0.0014483250160334*G0_9 - 0.000411011153198664*G0_10 - 0.00396984582097444*G0_11 + 0.00770482812583537*G0_12 - 0.00958373625474357*G0_13 + 0.0147050657033301*G0_14 - 0.00280531422024487*G0_15 + 9.78597983806215e-05*G0_16 + 0.0102426588971732*G0_17 - 0.00137003717732889*G0_18 - 0.00381653213684476*G0_19 + 0.00078287838704509*G0_20;
    A[15] = 0.000892481361231369*G0_0 + 0.000879433388113962*G0_1 + 0.000879433388113972*G0_2 + 0.000782878387045085*G0_3 + 0.0031315135481803*G0_4 + 0.00313151354818034*G0_5 + 0.000782878387045063*G0_6 + 0.0102426588971731*G0_7 - 0.001435277042916*G0_8 + 0.00508870951579303*G0_9 - 0.0028053142202449*G0_10 + 0.0102426588971731*G0_11 - 0.00143527704291596*G0_12 + 0.00508870951579303*G0_13 - 0.00280531422024487*G0_14 + 0.0704590548340573*G0_15 - 0.0156575677409016*G0_16 + 0.0117431758056762*G0_17 - 0.0156575677409016*G0_18 + 0.00391439193522542*G0_19 + 0.0117431758056762*G0_20;
    A[16] = -0.000974683591871131*G0_0 - 0.000974683591871128*G0_1 + 0.000649789061247418*G0_2 - 0.00381653213684478*G0_3 - 0.00548014870931555*G0_4 - 0.00058715879028382*G0_5 - 0.00137003717732888*G0_6 - 0.00381653213684478*G0_7 - 0.00548014870931555*G0_8 - 0.000587158790283813*G0_9 - 0.00137003717732888*G0_10 + 9.78597983806264e-05*G0_11 + 0.00528442911255429*G0_12 + 0.0052844291125543*G0_13 + 9.78597983806214e-05*G0_14 - 0.0156575677409016*G0_15 + 0.0763306427368954*G0_16 - 0.0156575677409016*G0_17 - 0.0117431758056762*G0_18 - 0.0117431758056762*G0_19 + 0.00391439193522543*G0_20;
    A[17] = 0.000879433388113959*G0_0 + 0.000892481361231384*G0_1 + 0.000879433388113971*G0_2 + 0.0102426588971732*G0_3 - 0.00143527704291601*G0_4 + 0.00508870951579304*G0_5 - 0.00280531422024489*G0_6 + 0.000782878387045076*G0_7 + 0.00313151354818031*G0_8 + 0.00313151354818033*G0_9 + 0.000782878387045066*G0_10 - 0.00280531422024488*G0_11 + 0.00508870951579308*G0_12 - 0.001435277042916*G0_13 + 0.0102426588971732*G0_14 + 0.0117431758056762*G0_15 - 0.0156575677409016*G0_16 + 0.0704590548340573*G0_17 + 0.00391439193522538*G0_18 - 0.0156575677409016*G0_19 + 0.0117431758056763*G0_20;
    A[18] = -0.000974683591871125*G0_0 + 0.000649789061247414*G0_1 - 0.000974683591871127*G0_2 - 0.00137003717732889*G0_3 - 0.000587158790283815*G0_4 - 0.00548014870931557*G0_5 - 0.00381653213684476*G0_6 + 9.78597983806153e-05*G0_7 + 0.00528442911255431*G0_8 + 0.00528442911255427*G0_9 + 9.78597983806532e-05*G0_10 - 0.00381653213684478*G0_11 - 0.00548014870931557*G0_12 - 0.000587158790283812*G0_13 - 0.00137003717732889*G0_14 - 0.0156575677409016*G0_15 - 0.0117431758056762*G0_16 + 0.00391439193522538*G0_17 + 0.0763306427368953*G0_18 - 0.0117431758056762*G0_19 - 0.0156575677409016*G0_20;
    A[19] = 0.000649789061247417*G0_0 - 0.000974683591871125*G0_1 - 0.000974683591871127*G0_2 + 9.78597983806285e-05*G0_3 + 0.00528442911255429*G0_4 + 0.0052844291125543*G0_5 + 9.78597983806365e-05*G0_6 - 0.0013700371773289*G0_7 - 0.000587158790283809*G0_8 - 0.00548014870931556*G0_9 - 0.00381653213684477*G0_10 - 0.00137003717732888*G0_11 - 0.000587158790283812*G0_12 - 0.00548014870931555*G0_13 - 0.00381653213684476*G0_14 + 0.00391439193522542*G0_15 - 0.0117431758056762*G0_16 - 0.0156575677409016*G0_17 - 0.0117431758056762*G0_18 + 0.0763306427368953*G0_19 - 0.0156575677409016*G0_20;
    A[20] = 0.00087943338811396*G0_0 + 0.000879433388113966*G0_1 + 0.000892481361231385*G0_2 - 0.00280531422024485*G0_3 + 0.00508870951579301*G0_4 - 0.00143527704291597*G0_5 + 0.0102426588971731*G0_6 - 0.00280531422024487*G0_7 + 0.005088709515793*G0_8 - 0.00143527704291596*G0_9 + 0.0102426588971731*G0_10 + 0.000782878387045077*G0_11 + 0.00313151354818034*G0_12 + 0.00313151354818032*G0_13 + 0.00078287838704509*G0_14 + 0.0117431758056762*G0_15 + 0.00391439193522543*G0_16 + 0.0117431758056763*G0_17 - 0.0156575677409016*G0_18 - 0.0156575677409016*G0_19 + 0.0704590548340573*G0_20;
  }

  /// Tabulate the tensor for the contribution from a local cell
  /// using the specified reference cell quadrature points/weights
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int num_quadrature_points,
                               const double * const * quadrature_points,
                               const double* quadrature_weights) const
  {
    throw std::runtime_error("Quadrature version of tabulate_tensor not available when using the FFC tensor representation.");
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class poisson2d_5_form_0: public ufc::form
{
public:

  /// Constructor
  poisson2d_5_form_0() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~poisson2d_5_form_0()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(IndexSum(Product(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', Space(2)), 5, None), 0), MultiIndex((Index(0),), {Index(0): 2})), SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', Space(2)), 5, None), 1), MultiIndex((Index(0),), {Index(0): 2}))), MultiIndex((Index(0),), {Index(0): 2})), Measure('cell', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 2;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 0;
  }

  /// Return the number of cell domains
  virtual unsigned int num_cell_domains() const
  {
    return 1;
  }

  /// Return the number of exterior facet domains
  virtual unsigned int num_exterior_facet_domains() const
  {
    return 0;
  }

  /// Return the number of interior facet domains
  virtual unsigned int num_interior_facet_domains() const
  {
    return 0;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new poisson2d_5_finite_element_0();
        break;
      }
    case 1:
      {
        return new poisson2d_5_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dofmap for argument function i
  virtual ufc::dofmap* create_dofmap(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new poisson2d_5_dofmap_0();
        break;
      }
    case 1:
      {
        return new poisson2d_5_dofmap_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new poisson2d_5_cell_integral_0_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    return 0;
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class poisson2d_5_form_1: public ufc::form
{
public:

  /// Constructor
  poisson2d_5_form_1() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~poisson2d_5_form_1()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(Product(Argument(FiniteElement('Lagrange', Cell('triangle', Space(2)), 5, None), 0), Coefficient(FiniteElement('Lagrange', Cell('triangle', Space(2)), 5, None), 0)), Measure('cell', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 1;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 1;
  }

  /// Return the number of cell domains
  virtual unsigned int num_cell_domains() const
  {
    return 1;
  }

  /// Return the number of exterior facet domains
  virtual unsigned int num_exterior_facet_domains() const
  {
    return 0;
  }

  /// Return the number of interior facet domains
  virtual unsigned int num_interior_facet_domains() const
  {
    return 0;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new poisson2d_5_finite_element_0();
        break;
      }
    case 1:
      {
        return new poisson2d_5_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dofmap for argument function i
  virtual ufc::dofmap* create_dofmap(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new poisson2d_5_dofmap_0();
        break;
      }
    case 1:
      {
        return new poisson2d_5_dofmap_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new poisson2d_5_cell_integral_1_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    return 0;
  }

};

// DOLFIN wrappers

// Standard library includes
#include <string>

// DOLFIN includes
#include <dolfin/common/NoDeleter.h>
#include <dolfin/fem/FiniteElement.h>
#include <dolfin/fem/DofMap.h>
#include <dolfin/fem/Form.h>
#include <dolfin/function/FunctionSpace.h>
#include <dolfin/function/GenericFunction.h>
#include <dolfin/function/CoefficientAssigner.h>
#include <dolfin/adaptivity/ErrorControl.h>
#include <dolfin/adaptivity/GoalFunctional.h>

namespace Poisson2D_5
{

class CoefficientSpace_f: public dolfin::FunctionSpace
{
public:

  CoefficientSpace_f(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson2d_5_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson2d_5_dofmap_0()), mesh)))
  {
    // Do nothing
  }

  CoefficientSpace_f(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson2d_5_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson2d_5_dofmap_0()), mesh)))
  {
    // Do nothing
  }

  CoefficientSpace_f(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson2d_5_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson2d_5_dofmap_0()), *mesh)))
  {
      // Do nothing
  }

  CoefficientSpace_f(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson2d_5_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson2d_5_dofmap_0()), *mesh)))
  {
      // Do nothing
  }

  ~CoefficientSpace_f()
  {
  }

};

class Form_0_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  Form_0_FunctionSpace_0(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson2d_5_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson2d_5_dofmap_0()), mesh)))
  {
    // Do nothing
  }

  Form_0_FunctionSpace_0(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson2d_5_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson2d_5_dofmap_0()), mesh)))
  {
    // Do nothing
  }

  Form_0_FunctionSpace_0(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson2d_5_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson2d_5_dofmap_0()), *mesh)))
  {
      // Do nothing
  }

  Form_0_FunctionSpace_0(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson2d_5_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson2d_5_dofmap_0()), *mesh)))
  {
      // Do nothing
  }

  ~Form_0_FunctionSpace_0()
  {
  }

};

class Form_0_FunctionSpace_1: public dolfin::FunctionSpace
{
public:

  Form_0_FunctionSpace_1(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson2d_5_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson2d_5_dofmap_0()), mesh)))
  {
    // Do nothing
  }

  Form_0_FunctionSpace_1(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson2d_5_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson2d_5_dofmap_0()), mesh)))
  {
    // Do nothing
  }

  Form_0_FunctionSpace_1(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson2d_5_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson2d_5_dofmap_0()), *mesh)))
  {
      // Do nothing
  }

  Form_0_FunctionSpace_1(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson2d_5_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson2d_5_dofmap_0()), *mesh)))
  {
      // Do nothing
  }

  ~Form_0_FunctionSpace_1()
  {
  }

};

class Form_0: public dolfin::Form
{
public:

  // Constructor
  Form_0(const dolfin::FunctionSpace& V1, const dolfin::FunctionSpace& V0):
    dolfin::Form(2, 0)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);
    _function_spaces[1] = reference_to_no_delete_pointer(V1);

    _ufc_form = boost::shared_ptr<const ufc::form>(new poisson2d_5_form_0());
  }

  // Constructor
  Form_0(boost::shared_ptr<const dolfin::FunctionSpace> V1, boost::shared_ptr<const dolfin::FunctionSpace> V0):
    dolfin::Form(2, 0)
  {
    _function_spaces[0] = V0;
    _function_spaces[1] = V1;

    _ufc_form = boost::shared_ptr<const ufc::form>(new poisson2d_5_form_0());
  }

  // Destructor
  ~Form_0()
  {}

  /// Return the number of the coefficient with this name
  virtual dolfin::uint coefficient_number(const std::string& name) const
  {

    dolfin::error("No coefficients.");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(dolfin::uint i) const
  {

    dolfin::error("No coefficients.");
    return "unnamed";
  }

  // Typedefs
  typedef Form_0_FunctionSpace_0 TestSpace;
  typedef Form_0_FunctionSpace_1 TrialSpace;

  // Coefficients
};

class Form_1_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  Form_1_FunctionSpace_0(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson2d_5_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson2d_5_dofmap_0()), mesh)))
  {
    // Do nothing
  }

  Form_1_FunctionSpace_0(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson2d_5_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson2d_5_dofmap_0()), mesh)))
  {
    // Do nothing
  }

  Form_1_FunctionSpace_0(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson2d_5_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson2d_5_dofmap_0()), *mesh)))
  {
      // Do nothing
  }

  Form_1_FunctionSpace_0(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new poisson2d_5_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new poisson2d_5_dofmap_0()), *mesh)))
  {
      // Do nothing
  }

  ~Form_1_FunctionSpace_0()
  {
  }

};

typedef CoefficientSpace_f Form_1_FunctionSpace_1;

class Form_1: public dolfin::Form
{
public:

  // Constructor
  Form_1(const dolfin::FunctionSpace& V0):
    dolfin::Form(1, 1), f(*this, 0)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);

    _ufc_form = boost::shared_ptr<const ufc::form>(new poisson2d_5_form_1());
  }

  // Constructor
  Form_1(const dolfin::FunctionSpace& V0, const dolfin::GenericFunction& f):
    dolfin::Form(1, 1), f(*this, 0)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);

    this->f = f;

    _ufc_form = boost::shared_ptr<const ufc::form>(new poisson2d_5_form_1());
  }

  // Constructor
  Form_1(const dolfin::FunctionSpace& V0, boost::shared_ptr<const dolfin::GenericFunction> f):
    dolfin::Form(1, 1), f(*this, 0)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);

    this->f = *f;

    _ufc_form = boost::shared_ptr<const ufc::form>(new poisson2d_5_form_1());
  }

  // Constructor
  Form_1(boost::shared_ptr<const dolfin::FunctionSpace> V0):
    dolfin::Form(1, 1), f(*this, 0)
  {
    _function_spaces[0] = V0;

    _ufc_form = boost::shared_ptr<const ufc::form>(new poisson2d_5_form_1());
  }

  // Constructor
  Form_1(boost::shared_ptr<const dolfin::FunctionSpace> V0, const dolfin::GenericFunction& f):
    dolfin::Form(1, 1), f(*this, 0)
  {
    _function_spaces[0] = V0;

    this->f = f;

    _ufc_form = boost::shared_ptr<const ufc::form>(new poisson2d_5_form_1());
  }

  // Constructor
  Form_1(boost::shared_ptr<const dolfin::FunctionSpace> V0, boost::shared_ptr<const dolfin::GenericFunction> f):
    dolfin::Form(1, 1), f(*this, 0)
  {
    _function_spaces[0] = V0;

    this->f = *f;

    _ufc_form = boost::shared_ptr<const ufc::form>(new poisson2d_5_form_1());
  }

  // Destructor
  ~Form_1()
  {}

  /// Return the number of the coefficient with this name
  virtual dolfin::uint coefficient_number(const std::string& name) const
  {
    if (name == "f")
      return 0;

    dolfin::error("Invalid coefficient.");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(dolfin::uint i) const
  {
    switch (i)
    {
    case 0:
      return "f";
    }

    dolfin::error("Invalid coefficient.");
    return "unnamed";
  }

  // Typedefs
  typedef Form_1_FunctionSpace_0 TestSpace;
  typedef Form_1_FunctionSpace_1 CoefficientSpace_f;

  // Coefficients
  dolfin::CoefficientAssigner f;
};

// Class typedefs
typedef Form_0 BilinearForm;
typedef Form_0 JacobianForm;
typedef Form_1 LinearForm;
typedef Form_1 ResidualForm;
typedef Form_0::TestSpace FunctionSpace;

}

#endif
