<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:decimal-format name="czech" decimal-separator="," grouping-separator=" "/>

<xsl:template match="/root">
    <html>
    <meta http-equiv="content-type" content="text/html; charset=UTF-8"/>
    <head>
        <title>DiskSearch print</title>
    <style>
        /* the following definitions must keep their position, they are accessed by its index from javascript */
        .outer{
            width: 121mm;
            height: 121mm;
            overflow: hidden;
            padding: 0pt;
            border:thin dotted black;
        }
        .size{
            color: brown;
        }
        .even{
            background-color: #DDDDDD;
        }
        .folder {
            color: blue;
            background-color: yellow;
        }
        .file{
            color: black;
        }
    /* end */
        .spacing{
            padding: 10pt;
        }
        .type, .name{
            margin-top: 0pt;
            padding-top: 0pt;
            margin-bottom: 0pt;
            padding-bottom: 0pt;
        }
        .type{
            float: right;
        }
        .comment{
            font-style: italic;
        }
        .heading{
            margin-bottom: 1ex;
        }
        .note{
            margin-top: 0pt;
            padding-top: 0pt;
            margin-bottom: 3pt;
            font-size: x-small;
        }
        .list{
            margin-left: 1em;
        }
        .editbox{
            position:absolute;
            right:0px;
            top:0px;
             z-index: 1;
            border: medium solid black;
            margin-left: 1cm;
            margin-bottom: 1cm;
            padding: 10pt;
            /* display: none;  */
            display: block;
            background-color: #FAFAD2;
        }

        .withborder{
            border: thin solid black;
            padding: 5pt;
            margin: 5pt;
            background-color: 	#B0C4DE;
        }

        .heading {
            font-weight: bold;
        }

	select {
            width: 10em;
	}

	button {
           padding: 5pt;
           margin: 2pt;
        }

	.apply{
            font-weight: bold;
	}

    </style>
    <script language="javascript" type='text/javascript' id="functions">
        function showhidediv(id) { //function to hide or show contents of directory
            var mydiv = document.getElementById(id);
            sid = "mark_" + id;
            switchdiv = document.getElementById(sid);
            if (mydiv.style.display == 'none'){ //was hidden
                mydiv.style.display = 'block';
                switchdiv.innerHTML = '-';
            }
            else
            {
                mydiv.style.display = 'none';
                switchdiv.innerHTML = '+';
            }
        }

        function getRules(){ //auxiliary function for display editor
            if (!document.styleSheets) return;
            var theRules = new Array();
            if (document.styleSheets[0].cssRules) // Mozilla
                theRules = document.styleSheets[0].cssRules;
            else if (document.styleSheets[0].rules) // IE
                theRules = document.styleSheets[0].rules;
            return theRules;
        }

        function changeOuterStyle(val){ //change overflow behaviour of the outer div
            var theRules = getRules();
            theRules[0].style.overflow = val;
        }

        function changeOuterSize(){ //change size of the outer div
            var theRules = getRules();
            theRules[0].style.width = document.getElementById('edit_width').value + 'mm';
            theRules[0].style.height = document.getElementById('edit_height').value + 'mm';
        }

        function changeColours(){ //change colours of various elements
            var theRules = getRules();
            if (document.getElementById('edit_filesize').value){
                theRules[1].style.color = document.getElementById('edit_filesize').value;
            }
            if (document.getElementById('edit_evenline').value){
                theRules[2].style.backgroundColor = document.getElementById('edit_evenline').value;
            }
            if (document.getElementById('edit_foldername').value){
                theRules[3].style.color = document.getElementById('edit_foldername').value;
            }
            if (document.getElementById('edit_foldernameback').value){
                theRules[3].style.backgroundColor = document.getElementById('edit_foldernameback').value;
            }
            if (document.getElementById('edit_filename').value){
                theRules[4].style.color = document.getElementById('edit_filename').value;
            }
        }

        function changeLabels(){ //change labels
            if (document.getElementById('edit_label').value){
                document.getElementById('name').innerHTML = document.getElementById('edit_label').value;
            }
            if (document.getElementById('edit_type').value){
                document.getElementById('type').innerHTML = document.getElementById('edit_type').value;
            }
            if (document.getElementById('edit_comment').value){
                document.getElementById('comment').innerHTML = document.getElementById('edit_comment').value;
            }
        }

        function fillDefaults(){ // fill sizes of common used boxes
          what = document.getElementById('edit_selectsize').value;
            if (what == 'cd'){
                document.getElementById('edit_width').value = 121;
                document.getElementById('edit_height').value = 121;
            }
            if (what == 'dvd'){
                document.getElementById('edit_width').value = 130;
                document.getElementById('edit_height').value = 184;
            }
            if (what == 'dvda'){
                document.getElementById('edit_width').value = 273;
                document.getElementById('edit_height').value = 184;
            }
        }

        function swap(){ // swap width and height
            oldwidth = document.getElementById('edit_width').value;
            document.getElementById('edit_width').value = document.getElementById('edit_height').value;
            document.getElementById('edit_height').value = oldwidth;
        }

        //Internationalization
        function getText(name){
        if (this[this.lang][name])
            return this[this.lang][name];
        else if (this['english'][name])
            return this['english'][name];
        else return '???';
        }

        function MessagesObject () {
            this.lang = 'english';
            this.local = getText;
        }
        //Note: the lists messages._lang_ must _not_ contain comma (",") after 
	//the last item. It causes problems in Opera and IE.
        messages = new MessagesObject();

        messages.english = {
        'display_printed_by': 'Printed by DiskSearch.',
        'edit_show_editor': 'Show layout editor',
        'edit_hide_editor': 'Hide layout editor',

        'edit_main_header': 'Edit display properties:',

        'edit_language_header': 'Select a language to use',
        'edit_language_select': 'Select',

        'edit_overflow_header': 'What to do if the content is larger than the size of the frame',
        'edit_overflow_desc': 'The buttons change CSS property of the outer (dotted) frame',

        'edit_overflow_visible': 'Visible',
        'edit_overflow_hidden': 'Hidden',
        'edit_overflow_scroll': 'Scroll',
        'edit_overflow_auto': 'Auto',

        'edit_size_header': 'Change size of the frame',
        'edit_size_desc': 'Enter values in milimeters or use predefined values: ',
        'edit_size_cd': 'CD',
        'edit_size_dvd': 'DVD',
        'edit_size_dvdfront': 'DVD (front)',
        'edit_size_select': 'Select',
        'edit_size_width': 'width:',
        'edit_size_height': 'height:',
        'edit_size_swap': 'swap &lt; - &gt;',
        'edit_size_mm': 'mm',
        'edit_size_apply': 'Apply',

        'edit_colours_header': 'Colours',
        'edit_colours_desc': 'Enter valid CSS color',
        'edit_colours_element': 'Element',
        'edit_colours_colour': 'Colour',
        'edit_colours_filename': 'file name: ',
        'edit_colours_filesize': 'file size: ',
        'edit_colours_evenback': 'even line background: ',
        'edit_colours_foldername': 'folder name: ',
        'edit_colours_folderback': 'folder name background: ',
        'edit_colours_apply': 'Apply',

        'edit_labels_header': 'Labels',
        'edit_labels_desc': '', //not used yet
        'edit_labels_element': 'Element',
        'edit_labels_collabel': 'Label',
        'edit_labels_label': 'disc label: ',
        'edit_labels_type': 'disc type: ',
        'edit_labels_comment': 'disc comment: ',
        'edit_labels_apply': 'Apply'
        };

        messages.french = {
        'display_printed_by': 'Imprimé par DiskSearch.',
        'edit_show_editor': 'Montrer l\'\éditeur de mise en page',
        'edit_hide_editor': 'Cacher l\'\éditeur de mise en page',

        'edit_main_header': 'Édition des propriétés d\'\affichage : ',

        'edit_language_header': 'Sélectionner la langue à utiliser',
        'edit_language_select': 'Sélectionner',

        'edit_overflow_header': 'Ce qui doit être fait si le contenu dépasse les dimensions de la pochette',
        'edit_overflow_desc': 'Les boutons changent les propriétés CSS de la bordure externe (en pointillé)',

        'edit_overflow_visible': 'Visible',
        'edit_overflow_hidden': 'Cachée',
        'edit_overflow_scroll': 'Défilement',
        'edit_overflow_auto': 'Automatique',

        'edit_size_header': 'Choix des dimensions de la pochette du boîtier',
        'edit_size_desc': 'Entrez les valeurs en millimètres ou utilisez les valeurs prédéfinies :',
        'edit_size_cd': 'CD',
        'edit_size_dvd': 'DVD',
        'edit_size_dvdfront': 'DVD (face)',
        'edit_size_select': 'Sélectionner',
        'edit_size_width': 'Largeur:',
        'edit_size_height': 'Hauteur:',
        'edit_size_swap': 'Échanger &lt; - &gt;',
        'edit_size_mm': 'mm',
        'edit_size_apply': 'Appliquer',

        'edit_colours_header': 'Choix des couleurs',
        'edit_colours_desc': 'Entrez une couleur CSS valide',
        'edit_colours_element': 'Élément',
        'edit_colours_colour': 'Couleur',
        'edit_colours_filename': 'Noms des fichiers : ',
        'edit_colours_filesize': 'Taille des fichiers : ',
        'edit_colours_evenback': 'Arrière-plan des lignes paires : ',
        'edit_colours_foldername': 'Noms de dossiers : ',
        'edit_colours_folderback': 'Arrière-plan des noms de dossiers : ',
        'edit_colours_apply': 'Appliquer',

        'edit_labels_header': 'Entête',
        'edit_labels_desc': '', //not used yet
        'edit_labels_element': 'Élément',
        'edit_labels_collabel': 'Texte',
        'edit_labels_label': 'Titre du disque : ',
        'edit_labels_type': 'Type de disque : ',
        'edit_labels_comment': 'Commentaire : ',
        'edit_labels_apply': 'Appliquer'
        };

        function changeLanguage(){
            messages.lang = document.getElementById('edit_select_language').value;
            for (var item in messages['english']) {
                todo = document.getElementById(item);
                if (! todo ) {continue;} //the item is not used in the page
                todo.innerHTML = messages.local(item);
            }
        }
    </script>
    </head>
    <body onload="javascript:changeLanguage();">
            <button id="edit_show_editor" type="button" onclick="document.getElementById('editbox').style.display = 'block';"></button>
            <button id="edit_hide_editor" type="button" onclick="document.getElementById('editbox').style.display = 'none';"></button>
            <br/><br/>
            <div class="editbox" id="editbox">
                <h3 id="edit_main_header"></h3>
                <div class="withborder">
                        <p id="edit_language_header" class="heading"></p>
                        <form>
                            <select id="edit_select_language" onchange="changeLanguage()" value="">
                                <option value="english" selected="selected">English</option>
                                <option value="french">Français</option>
                            </select>
                            <button id="edit_language_select" type="button" onclick="changeLanguage()"></button>
                        </form>
                </div>
                <div class="withborder">
                        <p id="edit_overflow_header" class="heading"></p>
                        <p id="edit_overflow_desc"></p>
                        <p>
                            <form>
                                <button id="edit_overflow_visible" type="button" onclick="changeOuterStyle('visible')"></button>
                                <button type="button" onclick="changeOuterStyle('hidden')"><b id="edit_overflow_hidden"></b></button>
                                <button id="edit_overflow_scroll" type="button" onclick="changeOuterStyle('scroll')"></button>
                                <button id="edit_overflow_auto" type="button" onclick="changeOuterStyle('auto')"></button>
                            </form>
                        </p>
                </div>
                <div class="withborder">
                    <p id="edit_size_header" class="heading"></p>
                    <p id="edit_size_desc"></p>
                        <form>
                            <select id="edit_selectsize" onchange="fillDefaults()" value="">
                                <option id ="edit_size_cd" value="cd"></option>
                                <option id="edit_size_dvdfront" value="dvd"></option>
                                <option id="edit_size_dvd" value="dvda"></option>
                            </select>
                            <button id="edit_size_select" type="button" onclick="fillDefaults()"></button>
                        </form>
                    <p>
                        <form>
                            <span id="edit_size_width"></span> <input type="text" id="edit_width" size="10"/>
                            <button id="edit_size_swap" type="button" onclick="swap()"></button>
                            <span id="edit_size_height"></span> <input type="text" id="edit_height" size="10"/> (<span id="edit_size_mm"></span>)
                            <p>
                                <button id="edit_size_apply" class="apply" type="button" onclick="changeOuterSize()"></button>
                            </p>
                        </form>
                    </p>
                </div>
                <div class="withborder">
                    <p id="edit_colours_header" class="heading"></p>
                        <p id="edit_colours_desc"></p>
                        <form>
                            <table>
                            <tr><th id="edit_colours_element"></th><th id="edit_colours_colour"></th></tr>
                            <tr><td id="edit_colours_filename"></td><td><input type="text" id="edit_filename" size="10"/></td></tr>
                            <tr><td id="edit_colours_filesize"></td><td><input type="text" id="edit_filesize" size="10"/></td></tr>
                            <tr><td id="edit_colours_evenback"></td><td><input type="text" id="edit_evenline" size="10"/></td></tr>
                            <tr><td id="edit_colours_foldername"></td><td><input type="text" id="edit_foldername" size="10"/></td></tr>
                            <tr><td id="edit_colours_folderback"></td><td><input type="text" id="edit_foldernameback" size="10"/></td></tr>
                            </table>
                        </form>
                        <button id="edit_colours_apply" class="apply" type="button" onclick="changeColours()"><b></b></button>
                </div>
                <div class="withborder">
                    <p id="edit_labels_header" class="heading"></p>
                        <form>
                            <table>
                            <tr><th id="edit_labels_element"></th><th id="edit_labels_collabel"></th></tr>
                            <tr><td id="edit_labels_label"></td><td><input type="text" id="edit_label" size="10"/></td></tr>
                            <tr><td id="edit_labels_type"></td><td><input type="text" id="edit_type" size="10"/></td></tr>
                            <tr><td id="edit_labels_comment"></td><td><input type="text" id="edit_comment" size="10"/></td></tr>
                            </table>
                        </form>
                        <button id="edit_labels_apply" class="apply" type="button" onclick="changeLabels()"></button>
                </div>
            </div>
        <div class="outer">
	  <div class="spacing">
            <div id="display_printed_by" class="note"></div>
            <div class="heading">
                <h1 class="type" id="type"><xsl:value-of select="@type"/></h1>
                <h2 class="name" id="name"><xsl:value-of select="@name"/></h2>
                <br style="clear: both;"/>
                <div class="comment" id="comment"><xsl:value-of select="@comment"/></div>
            </div>
            <div>
                <xsl:call-template name="process"/>
            </div>
          </div>
        </div>
    </body>
    </html>
</xsl:template>

<xsl:template name="process">
    <xsl:apply-templates select="folder">
        <xsl:sort select="path"/>
    </xsl:apply-templates>
    <xsl:for-each select="file">
        <div>
            <xsl:if test="position() mod 2 = 0">
                <xsl:attribute name="class">even</xsl:attribute>
            </xsl:if>
            <xsl:call-template name="file"/>
        </div>
    </xsl:for-each>
</xsl:template>


<!-- process the individual files
  in the space-separated file list -->
<xsl:template name="file">
    <div>
	<div style="float: right">
            <xsl:if test="number(@size) =number(@size)">
		<!-- the value is number, not general string -->
        	<span class="size"><xsl:value-of select="format-number(@size, '# ### ### ###','czech')"/></span>
	    </xsl:if>
	</div>
        <span class="file"><xsl:value-of select="@path"/></span>
    </div>
</xsl:template>

<xsl:template match="folder">
    <div>
        <a class="folder" title="Click to show/hide">
                <xsl:attribute name="id">switcher_<xsl:value-of select="@id"/></xsl:attribute>
                <xsl:attribute name="href">javascript:showhidediv('<xsl:value-of select="@id"/>');</xsl:attribute>
                [<span>
                <xsl:attribute name="id">mark_<xsl:value-of select="@id"/></xsl:attribute>
                -</span>]
            <xsl:value-of select="@path"/>
        </a>
	<xsl:if test="@note">(<xsl:value-of select="@note"/>)</xsl:if>
        <div>
            <xsl:attribute name="class">list</xsl:attribute>
            <xsl:attribute name="id"><xsl:value-of select="@id"/></xsl:attribute>
            <xsl:call-template name="process"/>
        </div>
    </div>
</xsl:template>

</xsl:stylesheet>
