\name{dieharder}
\alias{dieharder}
\alias{dieharder.default}
\alias{print.dieharder}
\alias{plot.dieharder}
\alias{summary.dieharder}
\title{Random numebr generator test suite}
\description{
  The \code{random} package provides an interface to the dieharder suite
  of random number generators.
}
\usage{
   \method{dieharder}{default}(rng="mt19937", test="runs", psamples=100, seed=0, verbose=FALSE) 
   \method{print}{dieharder}(x, ...)
   \method{summary}{dieharder}(object, ...)
   \method{plot}{dieharder}(x, ...)
}
\arguments{
  \item{rng}{Either a single character vector, or an integer index,
    selecting a random-number generator to be tested.}
  \item{test}{Either a single character vector, or an integer index,
    selecting a dieharder test to be used.}
  \item{psamples}{An integer for the number of probability values samples
    underlying the main Kolomogorov-Smirnov test.}
  \item{seed}{An integer seed that is to be used for the dieharder rng;
    if 0, a new random seed is generated.}
  \item{verbose}{A switch selecting verbose or silent operation.}
  \item{x}{A dieharder object.}
  \item{object}{A dieharder object.}
  \item{...}{Other arguments passed on.}
}
\value{
  An object of class \code{dieharder}, which inherits from the class
  \code{htest} commonly used for test statistics is returned. It
  contains the members
  \item{p.value}{for the (Kuiper variant) of the Kolmogorov-Smirnov test
    of the null of a uniform distribution of test values generated by
    \code{psamples} tests of \code{test} using draws from \code{rng}}
  \item{data}{the vector of test statistics used for the
    Kolmogorov-Smirnov test}
  \item{method}{the test method as returned by the \code{dieharder}
    library}
  \item{data.name}{a character vector describing the data}
  \item{generator}{a text desciption of the generator as returned by the
    \code{dieharder} library}
} \details{
  The current list of generators comprises
  \code{borosh13},
  \code{cmrg},
  \code{coveyou},
  \code{fishman18},
  \code{fishman20},
  \code{fishman2x},
  \code{gfsr4},
  \code{knuthran},
  \code{knuthran2},
  \code{knuthran2002},
  \code{lecuyer21},
  \code{minstd},
  \code{mrg},
  \code{mt19937},
  \code{mt19937_1999},
  \code{mt19937_1998},
  \code{r250},
  \code{ran0},
  \code{ran1},
  \code{ran2},
  \code{ran3},
  \code{rand},
  \code{rand48},
  \code{random128-bsd},
  \code{random128-glibc2},
  \code{random128-libc5},
  \code{random256-bsd},
  \code{random256-glibc2},
  \code{random256-libc5},
  \code{random32-bsd},
  \code{random32-glibc2},
  \code{random32-libc5},
  \code{random64-bsd},
  \code{random64-glibc2},
  \code{random64-libc5},
  \code{random8-bsd},
  \code{random8-glibc2},
  \code{random8-libc5},
  \code{random-bsd},
  \code{random-glibc2},
  \code{random-libc5},
  \code{randu},
  \code{ranf},
  \code{ranlux},
  \code{ranlux389},
  \code{ranlxd1},
  \code{ranlxd2},
  \code{ranlxs0},
  \code{ranlxs1},
  \code{ranlxs2},
  \code{ranmar},
  \code{slatec},
  \code{taus},
  \code{taus2},
  \code{taus113},
  \code{transputer},
  \code{tt800},
  \code{uni},
  \code{uni32},
  \code{vax},
  \code{waterman14},
  \code{zuf},
  \code{dev/random},
  \code{dev/urandom},
  \code{empty},
  \code{file_input},
  \code{file_input_raw},
  \code{ca},
  \code{R_wichmann_hill},
  \code{R_marsaglia_multic.},
  \code{R_super_duper},
  \code{R_mersenne_twister},
  \code{R_knuth_taocp},
  \code{R_knuth_taocp2} .

  The current list of tests comprises
  \code{birthdays},
  \code{operm5},
  \code{rank_32x32},
  \code{rank_6x8},
  \code{bitstream},
  \code{opso},
  \code{oqso},
  \code{dna},
  \code{count_1s_stream},
  \code{count_1s_byte},
  \code{parking_lot},
  \code{2dsphere},
  \code{3dsphere},
  \code{squeeze},
  \code{sums},
  \code{runs},
  \code{craps},
  \code{marsaglia_tsang_gcd},
  \code{marsaglia_tsang_gorilla},
  \code{rgb_timing},
  \code{rgb_persist},
  \code{rgb_bitdist},
  \code{rgb_lmn},
  \code{sts_monobit},
  \code{sts_runs},
  \code{sts_block}
}
\references{
  The \code{dieharder} website at \url{http://www.phy.duke.edu/~rgb/General/dieharder.php}.
}
\author{Dirk Eddelbuettel \email{edd@debian.org} for the
  \R interface and the port of the R RNGs to DieHarder; Robert G. Brown
  for everything else in \code{dieharder}. 
}
\examples{
  dh <- dieharder("randu", "runs", seed=12345)
  dh
  summary(dh)
  plot(dh)
}
\keyword{misc}
