#!/usr/bin/env python
#
# Copyright 2009-2011 Canonical Ltd.
#
# This file is part of desktopcouch.
#
#  desktopcouch is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License version 3
# as published by the Free Software Foundation.
#
# desktopcouch is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with desktopcouch.  If not, see <http://www.gnu.org/licenses/>.
"""setup.py"""

from setuptools import find_packages
from DistUtilsExtra.command import build_extra, build_i18n
from DistUtilsExtra.auto import setup

setup(
    name='desktopcouch',
    version='1.0.8',
    description='A Desktop CouchDB instance.',
    url='https://launchpad.net/desktopcouch',
    license='LGPL-3',
    author='Stuart Langridge',
    author_email='stuart.langridge@canonical.com',
    packages=find_packages(),
    scripts=['bin/desktopcouch-pair'],
    data_files=[('lib/desktopcouch/', ['bin/desktopcouch-service',
                                              'bin/desktopcouch-pair',
                                              'bin/desktopcouch-get-port',
                                              'bin/desktopcouch-stop']),
                  # Be sure all additions are reflected in MANIFEST.in !
                  ('share/doc/python-desktopcouch-records/api/',
                      ['desktopcouch/records/doc/records.txt',
                      'desktopcouch/records/doc/an_example_application.txt',
                      'desktopcouch/records/doc/field_registry.txt',
                      'desktopcouch/recordtypes/contacts/schema.txt']),
                  ('/etc/xdg/desktop-couch/',
                      ['config/desktop-couch/compulsory-auth.ini',
                      'config/desktop-couch/default.ini']),
                  ('share/desktopcouch/', ['data/couchdb.tmpl']),
                  ('share/apport/package-hooks/', [
                    'data/source_desktopcouch.py']),
                  ('share/dbus-1/services/', [
                    'org.desktopcouch.CouchDB.service']),
                  ('share/man/man1/', ['docs/man/desktopcouch-pair.1'])],
    cmdclass={"build": build_extra.build_extra,
              "build_i18n": build_i18n.build_i18n})
