# Copyright 2010 Canonical Ltd.
#
# This file is part of desktopcouch-bookmarks.
#
#  desktopcouch is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License version 3
# as published by the Free Software Foundation.
#
# desktopcouch is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with desktopcouch.  If not, see <http://www.gnu.org/licenses/>.
#
# Authors: Zachery Bir <zachery.bir@canonical.com>
#          Joshua Blount <joshua.blount@canonical.com>

"""Tests for the Bookmarks record classes"""

import testtools

from desktopcouch.bookmarks.record import \
    Bookmark, BOOKMARK_RECORD_TYPE, \
    Folder, FOLDER_RECORD_TYPE, \
    Separator, SEPARATOR_RECORD_TYPE, \
    Feed, FEED_RECORD_TYPE

class TestBookmarkRecord(testtools.TestCase):
    """Test the Bookmark Record object."""

    def test_bookmark_record(self):
        """Test that we get the correct record type."""
        bookmark = Bookmark()
        self.assertEqual(BOOKMARK_RECORD_TYPE, bookmark.record_type)

class TestFolderRecord(testtools.TestCase):
    """Test the Folder Record object."""

    def test_folder_record(self):
        """Test that we get the correct record type."""
        folder = Folder()
        self.assertEqual(FOLDER_RECORD_TYPE, folder.record_type)

class TestSeparatorRecord(testtools.TestCase):
    """Test the Separator Record object."""

    def test_separator_record(self):
        """Test that we get the correct record type."""
        separator = Separator()
        self.assertEqual(SEPARATOR_RECORD_TYPE, separator.record_type)

class TestFeedRecord(testtools.TestCase):
    """Test the Feed Record object."""

    def test_feed_record(self):
        """Test that we get the correct record type."""
        feed = Feed()
        self.assertEqual(FEED_RECORD_TYPE, feed.record_type)
