#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "dependency_list.h"

#include <sstream>

dependency_list &dependency_list::operator=(std::string const &str)
{
	clear();
	std::string::size_type last_comma = 0;
	std::string::size_type comma;
	do
	{
		comma = str.find(',', last_comma);
		push_back(dependency(std::string(str, last_comma, (comma == std::string::npos)?comma:comma-last_comma)));
		last_comma = str.find_first_not_of(", ", comma);
	}
	while(last_comma != std::string::npos);
	return *this;
}

dependency_list::operator std::string(void) const
{
	std::ostringstream str;
	const_iterator i = begin();
	while(i != end())
	{
		str << *i;
		++i;
		if(i != end())
			str << ", ";
	}
	return str.str();
}

dependency_list &dependency_list::operator+=(dependency_list const &rhs)
{
	insert(end(), rhs.begin(), rhs.end());
	return *this;
}
