#    This file is part of EAP.
#
#    EAP is free software: you can redistribute it and/or modify
#    it under the terms of the GNU Lesser General Public License as
#    published by the Free Software Foundation, either version 3 of
#    the License, or (at your option) any later version.
#
#    EAP is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#    GNU Lesser General Public License for more details.
#
#    You should have received a copy of the GNU Lesser General Public
#    License along with EAP. If not, see <http://www.gnu.org/licenses/>.

"""
EAP stands for Evolutionary Algorithm in Python, it is dedicated to people who
wish to learn how to use evolutionary algorithms and to those who wish to
rediscover evolutionary algorithms. The concepts of EAP may be extremely well
resumed by some statements of the :pep:`20`, *the Zen of Python* by Tim Peters.

- Beautiful is better than ugly.
- Explicit is better than implicit.
- Simple is better than complex.
- Complex is better than complicated.
- Readability counts.
- Special cases aren't special enough to break the rules.
- Although practicality beats purity.
- In the face of ambiguity, refuse the temptation to guess.
- There should be one-- and preferably only one --obvious way to do it.
- Although that way may not be obvious at first unless you're *Canadian*.
- If the implementation is hard to explain, it's a bad idea.
- If the implementation is easy to explain, it may be a good idea.

EAP is the proof that evolutionary algorithms do **not** need to be neither
complex or complicated.
"""

__author__ = "Francois-Michel De Rainville and Felix-Antoine Fortin"
__version__ = "0.6"
__revision__ = "0.6.0"
