/* Copyright (C) 2004 - 2007 db4objects Inc. http://www.db4o.com */
using System;
using System.IO;
using System.IO.IsolatedStorage;
using Db4objects.Db4o;
using Db4objects.Db4o.Ext;

namespace Db4objects.Db4odoc.IsolatedStorage
{

    public class Db4oIsolatedStorageFile
    {
        private IsolatedStorageFileStream _stream;

        [System.Runtime.InteropServices.DllImport("kernel32.dll", SetLastError = true)]
        static extern int FlushFileBuffers(IntPtr fileHandle);

        public Db4oIsolatedStorageFile(String file, String fileMode)
        {
            try
            {
                IsolatedStorageFile isf = IsolatedStorageFile.GetUserStoreForAssembly();
                _stream = new IsolatedStorageFileStream(file, FileMode.OpenOrCreate,
                    fileMode.Equals("rw") ? FileAccess.ReadWrite : FileAccess.Read, isf);
            }
            catch (IOException x)
            {
                throw new DatabaseFileLockedException(file, x);
            }
        }
        // end Db4oIsolatedStorageFile

        public FileStream Stream
        {
            get { return _stream; }
        }
        // end Stream

        public void Close()
        {
            _stream.Close();
        }
        // end Close

        public long Length()
        {
            return _stream.Length;
        }
        // end Length

        public int Read(byte[] bytes, int offset, int length)
        {
            return _stream.Read(bytes, offset, length);
        }
        // end Read

        public void Read(byte[] bytes)
        {
            _stream.Read(bytes, 0, bytes.Length);
        }
        // end Read

        public void Seek(long pos)
        {
            _stream.Seek(pos, SeekOrigin.Begin);
        }
        // end Seek

        public void Sync()
        {
            _stream.Flush();

            FlushFileBuffers(_stream.SafeFileHandle.DangerousGetHandle());

        }
        // end Sync

        public Db4oIsolatedStorageFile GetFD()
        {
            return this;
        }
        // end GetFD

        public void Write(byte[] bytes)
        {
            this.Write(bytes, 0, bytes.Length);
        }
        // end Write

        public void Write(byte[] bytes, int offset, int length)
        {
            _stream.Write(bytes, offset, length);
        }
        // end Write
    }
}

