/* This file is part of the db4o object database http://www.db4o.com

Copyright (C) 2004 - 2009  Versant Corporation http://www.versant.com

db4o is free software; you can redistribute it and/or modify it under
the terms of version 3 of the GNU General Public License as published
by the Free Software Foundation.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program.  If not, see http://www.gnu.org/licenses/. */
using Db4objects.Db4o.Foundation;
using Db4objects.Db4o.Tests.Common.Migration;

namespace Db4objects.Db4o.Tests.Common.Migration
{
	public class Db4oLibraryEnvironmentProvider
	{
		private readonly Hashtable4 _environments = new Hashtable4();

		private readonly Sharpen.IO.File _classPath;

		public Db4oLibraryEnvironmentProvider(Sharpen.IO.File classPath)
		{
			_classPath = classPath;
		}

		/// <exception cref="System.IO.IOException"></exception>
		public virtual Db4oLibraryEnvironment EnvironmentFor(string path)
		{
			Db4oLibraryEnvironment existing = ExistingEnvironment(path);
			if (existing != null)
			{
				return existing;
			}
			return NewEnvironment(path);
		}

		private Db4oLibraryEnvironment ExistingEnvironment(string path)
		{
			return (Db4oLibraryEnvironment)_environments.Get(path);
		}

		/// <exception cref="System.IO.IOException"></exception>
		private Db4oLibraryEnvironment NewEnvironment(string path)
		{
			Db4oLibraryEnvironment env = new Db4oLibraryEnvironment(new Sharpen.IO.File(path)
				, _classPath);
			_environments.Put(path, env);
			return env;
		}
	}
}
