/* Copyright (C) 2004 - 2007  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o
{
	/// <exclude></exclude>
	public abstract class Debug : Db4objects.Db4o.Foundation.Debug4
	{
		public const bool indexAllFields = false;

		public const bool queries = false;

		public const bool atHome = false;

		public const bool longTimeOuts = false;

		public const bool freespace = Db4objects.Db4o.Deploy.debug;

		public const bool xbytes = freespace;

		public const bool freespaceChecker = false;

		public const bool checkSychronization = false;

		public const bool configureAllClasses = indexAllFields;

		public const bool configureAllFields = indexAllFields;

		public const bool weakReferences = true;

		public const bool fakeServer = false;

		public const bool messages = false;

		public const bool nio = true;

		public const bool lockFile = true;

		public static void Expect(bool cond)
		{
			if (!cond)
			{
				throw new System.Exception("Should never happen");
			}
		}

		public static void EnsureLock(object obj)
		{
		}

		public static bool ExceedsMaximumBlockSize(int a_length)
		{
			if (a_length > Db4objects.Db4o.Internal.Const4.MAXIMUM_BLOCK_SIZE)
			{
				return true;
			}
			return false;
		}

		public static bool ExceedsMaximumArrayEntries(int a_entries, bool a_primitive)
		{
			if (a_entries > (a_primitive ? Db4objects.Db4o.Internal.Const4.MAXIMUM_ARRAY_ENTRIES_PRIMITIVE
				 : Db4objects.Db4o.Internal.Const4.MAXIMUM_ARRAY_ENTRIES))
			{
				return true;
			}
			return false;
		}
	}
}
