/*
###
### This file is part of
###
###                        TurboLinux  ZWinPro
###
###                 Copyright (C) 1999-2000 TurboLinux, Inc.
###                        All Rights Reserved
### Distributed under the terms of the GNU General Public License (GPL)
###
###
### Authors:     TurboLinux Chinese Development Team:
###              Justin Yu   <justiny@turbolinux.com.cn>
###              Sean Chen   <seanc@turbolinux.com.cn>
###              Daniel Fang <danf@turbolinux.com.cn>
###
*/
/* Handwriting recognition engine implemented by Justin Yu
*/

#include "all.h"

#define  XINC (x0 += KEY_WIDTH)
#define  YINC (y0 += KEY_HEIGHT)
#define  F_STRING	0
#define  F_CONTROL	1

extern int ForwardEvent();
static int in_hwkeys(int x0, int y0);
static void set_hwkey(int n, char c, int f, char *label, char *blabel,
	int x, int y, int w, int h);



void HZinitServerHandwritingPad(int x, int y, int w, int h)
{
        int x0, y0;
	Cursor pencil_cursor = XCreateFontCursor(display, XC_pencil);

	XDefineCursor(display, window5, pencil_cursor);
	XDefineCursor(display, window6, pencil_cursor);

        //server part
        HZServer.hzHWwin.x = x;
        HZServer.hzHWwin.y = y;
        HZServer.hzHWwin.w = w;
        HZServer.hzHWwin.h = h;

        //for handwriting
	flag_checked = True;			//need not check
	flag_side    = HZSERVER_HW_LEFT;
	flag_sent    = True;

	//set default timeout
	hw_timeout = HZSERVER_HW_TIMEOUT;

	//no choice list
	hw_activekeys = 0;

        //char keys
        x0 = HZSERVER_HW_XOFF;
        y0 = HZSERVER_HW_YOFF  - 36;
        set_hwkey(0, '\b', F_STRING, "ɾ", "R", x0, y0, KEY_WIDTH, KEY_HEIGHT);XINC;
        set_hwkey(1, ' ',  F_STRING, "", "", x0, y0, KEY_WIDTH, KEY_HEIGHT);XINC;
        set_hwkey(2, '\n', F_STRING, "", "^", x0, y0, KEY_WIDTH, KEY_HEIGHT);XINC;
        set_hwkey(3, '\0', F_STRING, "", "A", x0, y0, KEY_WIDTH, KEY_HEIGHT);XINC;
        set_hwkey(4, '\0', F_STRING, "", "C", x0, y0, KEY_WIDTH, KEY_HEIGHT);XINC;
        set_hwkey(5, '\0', F_STRING, "", "B", x0, y0, KEY_WIDTH, KEY_HEIGHT);
	XINC; XINC;
	//control keys
	set_hwkey(6, '\0', F_CONTROL,"", "C", x0, y0, KEY_WIDTH, KEY_HEIGHT);XINC;
	set_hwkey(7, '\0', F_CONTROL,"", "", x0, y0, KEY_WIDTH, KEY_HEIGHT);XINC;
	//choice keys
	x0 = (HZSERVER_HW_XOFF + HZSERVER_HW_CHILD_WIDTH) * 2;
	y0 = HZSERVER_HW_YOFF  + 30;
	set_hwkey(8, '\0', F_STRING, "", "@", x0, y0, KEY_WIDTH, KEY_HEIGHT);YINC;
	set_hwkey(9, '\0', F_STRING, "", "@", x0, y0, KEY_WIDTH, KEY_HEIGHT);YINC;
	set_hwkey(10,'\0', F_STRING, "", "@", x0, y0, KEY_WIDTH, KEY_HEIGHT);YINC;
	set_hwkey(11,'\0', F_STRING, "", "@", x0, y0, KEY_WIDTH, KEY_HEIGHT);YINC;
	set_hwkey(12,'\0', F_STRING, "", "@", x0, y0, KEY_WIDTH, KEY_HEIGHT);YINC;
}

void HZhwDrawWindow(void)
{
	int i;
        Display *dpy = HZServer.display;
        Window  win  = HZServer.window4;
        GC   dimgc = HZServer.dimGC;
        GC   lightgc = HZServer.lightGC;
        GC   bargc = HZServer.barGC;

	//faked title bar
	XFillRectangle(dpy, win, bargc, HZSERVER_HW_XOFF, 5, 
		HZSERVER_HW_WIDTH - HZSERVER_HW_XOFF * 2, 24);
	if(HZServer.encoding == HZSERVER_ENCODING_GB ||
	   HZServer.encoding == HZSERVER_ENCODING_GBK ||
	   HZServer.encoding == HZSERVER_ENCODING_GB18030)
		MyXmbDrawString(dpy, win, fontset_gb, lightgc, 180, 20, 
			"дʶ", strlen("дʶ"));
	else
		MyXmbDrawString(dpy, win, fontset_big5, lightgc, 180, 20, 
			"gѧOO", strlen("gѧOO"));

	//draw buttons
	for(i=0; i<N_HWKEYS - 5 + hw_activekeys; i++){
		draw_button(dpy, win, dimgc, lightgc,
			hwkeys[i].x, hwkeys[i].y, 
                        hwkeys[i].x + hwkeys[i].w - 1, 
                        hwkeys[i].y + hwkeys[i].h - 1, True);
		if(HZServer.encoding == HZSERVER_ENCODING_GB ||
		   HZServer.encoding == HZSERVER_ENCODING_GBK ||
		   HZServer.encoding == HZSERVER_ENCODING_GB18030)
			MyDrawString(win, HZServer.normalGC, hwkeys[i].x + 6, 
				hwkeys[i].y + 20, hwkeys[i].label, 2);
		else
			MyDrawString(win, HZServer.normalGC, hwkeys[i].x + 6, 
				hwkeys[i].y + 20, hwkeys[i].blabel, 2);
	}

}

void HZhwClearPadLeft(void)
{
        Display *dpy = HZServer.display;
        Window  win  = HZServer.window5;
        GC   dimgc = HZServer.dimGC;

	//set background of drawing area
	XFillRectangle(dpy, win, dimgc, 0, 0, 
		HZSERVER_HW_CHILD_WIDTH, HZSERVER_HW_CHILD_HEIGHT);
}

void HZhwClearPadRight(void)
{
        Display *dpy = HZServer.display;
        Window  win  = HZServer.window6;
        GC   dimgc = HZServer.dimGC;

	//set background of drawing area
	XFillRectangle(dpy, win, dimgc, 0, 0, 
		HZSERVER_HW_CHILD_WIDTH, HZSERVER_HW_CHILD_HEIGHT);
}


void HZprocHWWindow(int x0, int y0)
{
	int rtn;
        Display *dpy = HZServer.display;
        Window  win  = HZServer.window4;
	GC      dimgc= HZServer.dimGC;
	GC      lightgc= HZServer.lightGC;

	rtn = in_hwkeys(x0, y0);
	if(rtn != -1){
		//send string 
                draw_button(dpy, win, dimgc, lightgc,
                        hwkeys[rtn].x, hwkeys[rtn].y, 
                        hwkeys[rtn].x + hwkeys[rtn].w - 1, 
			hwkeys[rtn].y + hwkeys[rtn].h - 1, False);
                wait_button_release();
                //check the pointer ?
                draw_button(dpy, win, dimgc, lightgc,
                        hwkeys[rtn].x, hwkeys[rtn].y, 
                        hwkeys[rtn].x + hwkeys[rtn].w - 1, 
			hwkeys[rtn].y + hwkeys[rtn].h - 1, True);
		if(hwkeys[rtn].f == F_CONTROL) {
			if(rtn == 6){
				if(hw_timeout<5000)hw_timeout += 100;
			}else if(rtn == 7){
				if(hw_timeout>500)hw_timeout -= 100;
			}
		} else if(rtn == 0){	//delete char
			ForwardEvent(XK_BackSpace, 0, 0, 0);
		} else if(hwkeys[rtn].c){
				char buf[2];
				buf[0] = hwkeys[rtn].c;
				buf[1] = '\0';
				ForwardString(buf, 1);
		} else {
			HZhwClearPadLeft();
			HZhwClearPadRight();
			if(HZServer.encoding == HZSERVER_ENCODING_BIG5)
				ForwardString(hwkeys[rtn].blabel, 2);
			else
				ForwardString(hwkeys[rtn].label, 2);
			if(rtn >= 8) flag_sent = True;
		}

	} else {
		HZprocMoveWindow();
	}
}

void HZprocHWChildWindow(Window win, int x0, int y0)
{
        Display *dpy = HZServer.display;
	GC      lightgc= HZServer.lightGC;
	XEvent  event;

	//see if drawing window changed
	if((win == window5 && flag_side == HZSERVER_HW_RIGHT) ||
	   (win == window6 && flag_side == HZSERVER_HW_LEFT)){
		//lookup the other side's recognition
		if(!flag_checked){
			HZhwToEngineNewLine();
			HZhwRecognize();
			HZhwDrawPanel();
			HZhwDrawWindow();
			flag_checked = True;
		}

		//if side changed, submit string even if
		//not timeout.
		if(!flag_sent && hw_activekeys > 0){
			if(HZServer.encoding == HZSERVER_ENCODING_BIG5)
				ForwardString(hwkeys[8].blabel, 2);
			else    
				ForwardString(hwkeys[8].label, 2);
			flag_sent = True;
			hw_activekeys = 0;
		}
		if(win == window6) {
			HZhwClearPadLeft();
			flag_side = HZSERVER_HW_RIGHT;
		} else if(win == window5) {
			HZhwClearPadRight();
			flag_side = HZSERVER_HW_LEFT;
		}
	} else {	//the same side
		//if timeout but string not sent,
		//send the first hanzi as default.
		if(flag_checked > 0 && !flag_sent) {
			if(HZServer.encoding == HZSERVER_ENCODING_BIG5)
				ForwardString(hwkeys[8].blabel, 2);
			else
				ForwardString(hwkeys[8].label, 2);
			flag_sent = True;
			hw_activekeys = 0;
			HZhwDrawPanel();
			HZhwDrawWindow();
			HZhwClearPadLeft();
			HZhwClearPadRight();
		}
	}
	//XFlush(display);

	//Here I confine the pointer to the handwriting pad window
	//Note: use this function only will cause hang of some XIM clients
	XGrabPointer(dpy, win, True, 
		ButtonMotionMask | ButtonReleaseMask, 
		GrabModeAsync, GrabModeAsync,
		win, None, CurrentTime);
	//so I grab the server at the same time......strange!!!
	XGrabServer(dpy);

	//enter loop
	while(1){
		int x, y;

		//send current position
		HZhwToEnginePoint(x0, y0);
		XNextEvent(dpy, &event);
		switch(event.type){
			case ButtonRelease:
				//release server
				XUngrabServer(dpy);
				XUngrabPointer(dpy, CurrentTime);	

				//send current position
				HZhwToEnginePoint(event.xbutton.x, 
					event.xbutton.y);

				//send newline to end the stroke
				HZhwToEngineNewLine();

				//record the time for timeout checking
				record_time();
				//init
				flag_sent = False;
				flag_checked = False;
				return ;

			case MotionNotify:
				x = event.xbutton.x;
				y = event.xbutton.y;
				XDrawLine(dpy, win, lightgc, x0, y0, x, y);
				HZhwToEnginePoint(x, y);
				x0 = x;
				y0 = y;
				break;
			default:
				break;
		}
	}
}


static int in_hwkeys(int x0, int y0)
{
        int i;
        //get 
        for(i=0; i<N_HWKEYS - 5 + hw_activekeys; i++){
                if(in_box(x0, y0, hwkeys[i].x, hwkeys[i].y,
                        hwkeys[i].x + hwkeys[i].w, hwkeys[i].y + hwkeys[i].h)){
                        return i;
		}
        }
        return -1;
}

static void set_hwkey(int n, char c, int f, char *label,  char *blabel,
	int x, int y, int w, int h)
{
	hwkeys[n].c = c;
	hwkeys[n].f = f;
	strncpy(hwkeys[n].label, label, 3);
	strncpy(hwkeys[n].blabel, blabel, 3);
	hwkeys[n].x = x;
	hwkeys[n].y = y;
	hwkeys[n].w = w;
	hwkeys[n].h = h;
}

void HZhwDrawPanel(void)
{
        Display *dpy = HZServer.display;
        Window  win  = HZServer.window4;
        GC  dimgc = HZServer.dimGC;
        GC  lightgc = HZServer.lightGC;
        GC  panelgc = HZServer.panelGC;
        int width = HZServer.hzHWwin.w;
        int height = HZServer.hzHWwin.h;

        XFillRectangle(dpy, win, panelgc, 0, 0, width, height);

        /* draw 3D border */
        XDrawLine(dpy, win, lightgc, 0, 0, width-1, 0);
        XDrawLine(dpy, win, lightgc, 0, 1, width-1, 1);
        XDrawLine(dpy, win, lightgc, 0, 0, 0, height-1);
        XDrawLine(dpy, win, lightgc, 1, 0, 1, height-1);
        XDrawLine(dpy, win, dimgc, 0, height-1, width-1, height-1);
        XDrawLine(dpy, win, dimgc, 0, height-2, width-1, height-2);
        XDrawLine(dpy, win, dimgc, width-1, 0, width-1, height-1);
        XDrawLine(dpy, win, dimgc, width-2, 0, width-2, height-1);
}


void HZhwFlush()
{
	HZhwDrawPanel();
	HZhwDrawWindow();
	HZhwClearPadLeft();
	HZhwClearPadRight();
}

void HZprocHW()
{
	if(hwmode == True){
		XUnmapWindow(display, window6);
		XUnmapWindow(display, window5);
		XUnmapWindow(display, window4);
		hwmode = False;
	} else {
		XUnmapWindow(display, window1);
		XUnmapWindow(display, window2);
		XUnmapWindow(display, window3);
		hwmode = True;
		XMapRaised(display, window4);
		XMapRaised(display, window5);
		XMapRaised(display, window6);
		HZhwFlush();
	}
}
