#ifndef H_CDW_CDLL
#define H_CDW_CDLL

#include <stdlib.h> /* size_t */
#include <stdbool.h>

#include "main.h"
#include "cdw_cdll.h"

/** \brief Type of variables that are elements of list
 *
 * Should not be used outside of filelist.c and filelist_tests.c */
typedef struct _cdw_cdll_t cdw_cdll_t;
struct _cdw_cdll_t {
	cdw_cdll_t *prev;
	cdw_cdll_t *next;
	void *data;
};



/* public */

cdw_rv_t cdw_cdll_init(cdw_cdll_t **head);
cdw_rv_t cdw_cdll_destroy(cdw_cdll_t *head);

cdw_rv_t cdw_cdll_append(cdw_cdll_t *head, void *data);
cdw_rv_t cdw_cdll_remove(cdw_cdll_t **head, size_t i);
// void *cdw_cdll_get_ith(cdw_cdll_t *head, size_t i);
void *cdw_cdll_ith_data(cdw_cdll_t *head, size_t i);


size_t cdw_cdll_length(cdw_cdll_t *head);

bool cdw_cdll_is_empty(cdw_cdll_t *head);



/* unit tests */
void cdw_cdll_run_tests(void);

#endif /* H_CDW_CDLL */
