# Copyright (C) 2010 Canonical Ltd
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

from bzrlib.lazy_import import lazy_import
lazy_import(globals(), '''

import os

from bzrlib import (
    builtins,
    bzrdir,
    commands,
    errors,
    osutils,
    registry,
    trace,
    transport,
    )
from bzrlib.trace import note, mutter
from bzrlib.plugins.explorer.lib.helpers import plural
''')

import workspace_dialogs
import checkout_dialog
import switch_dialog

class CustomDialogRegistry(registry.Registry):
    """Registry for custom dialogs.
    
    The registered object should be a SubProcessDialog subclass.
    """
    pass

custom_dialog_registry = CustomDialogRegistry()

custom_dialog_registry.register('init',
        workspace_dialogs.QInitWorkspaceDialog)
custom_dialog_registry.register('branch',
        workspace_dialogs.QBranchExplorerStyleDialog)
custom_dialog_registry.register('checkout',
        checkout_dialog.QCheckoutExplorerStyleDialog)
custom_dialog_registry.register('switch',
        switch_dialog.QSwitchExplorerStyleDialog)
