
/*
 *  Diverse Bristol audio routines.
 *  Copyright (c) by Nick Copeland <nickycopeland@hotmail.com> 1996,2009
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef BRIGHTONMINI_H
#define BRIGHTONMINI_H

#include "brighton.h"
#include "brightoninternals.h"
#include "bristol.h"

extern int configureGlobals();
extern int initConnection();

extern void cleanupBristol();
extern void cleanupBristolQuietly();

extern int bristolMidiSendControlMsg();
extern int bristolMidiSendNRP();
extern int bristolMidiSendRP();
extern int bristolMidiSendMsg();
extern int destroySynth(brightonWindow *);

typedef int (*synthRoutine)(void *, int, int, int, int, int);

typedef struct miniDispatch {
	int controller;
	int operator;
	int other1;
	int other2;
	synthRoutine routine;
} dispatcher;

typedef struct Memory {
	char algo[32];
	char name[32];
	short count;
	short vers;
	short active;
	short pad;
	float *param;
} memory;

#define BRISTOL_NOCALLS		0x01
#define BRISTOL_STAT		0x02
#define BRISTOL_FORCE		0x04
#define BRISTOL_SID2		0x08
#define BRISTOL_SEQLOAD		0x10
#define BRISTOL_SEQFORCE	0x20

#define OPERATIONAL	0x01
#define BANK_SELECT	0x02
#define MEM_LOADING	0x04
#define SUPPRESS	0x08
#define NO_KEYTRACK	0x10
#define REQ_MIDI_DEBUG	0x20
#define MIDI_NRP	0x40
#define REQ_MIDI_DEBUG2	0x80

typedef struct GuiSynth {
	struct GuiSynth *next, *last;
	unsigned int flags;
	char name[32];
	int sid;
	int sid2; /* for GUIs with dual manual connections. */
	int midichannel;
	int velocity;
	int synthtype;
	int voices;
	brightonWindow *win;
	int mbi;
	int bank;
	int location;
	int panel;
	int transpose;
	memory mem;
	memory seq1;
	memory seq2;
	brightonApp *resources;
	dispatcher *dispatch;
	struct guiSynth *second; /* Dual manual keyboards */
	struct guimain *manual; /* Dual manual keyboards */
	int gain;
	int detune;
	int pwd;
	int keypanel;
	int keypanel2;
	int glide;
	int lwf;
	int notepref;
	int notetrig;
	int legatovelocity;
} guiSynth;

#define BRIGHTON_NOENGINE 0x80000000
#define BRIGHTON_NRP	 0x40000000
typedef struct guiMain {
	unsigned int flags;
	char *home;
	int controlfd;
	int enginePID;
	int libtest;
	int voices;
	guiSynth *synths;
	char *host;
	int port;
} guimain;

extern guiSynth *findSynth(guiSynth *, brightonWindow *);
extern int loadMemory(guiSynth *, char *, char *,  int, int, int, int);
extern int loadSequence(memory *, char *, int, int);
extern int chordInsert(arpeggiatorMemory *, int, int);
extern int seqInsert(arpeggiatorMemory *, int, int);
extern int fillSequencer(guiSynth *, arpeggiatorMemory *, int);
extern int saveSequence(guiSynth *, char *, int, int);
extern int saveMemory(guiSynth *, char *, char *, int, int);
extern int displayText(guiSynth *, char *, int, int);
extern void displayPanel(guiSynth *, char *, int, int, int);
extern int displayPanelText(guiSynth *, char *, int, int, int);

extern void brightonReadConfiguration(brightonWindow *, brightonApp *, int, char *);
extern int doAlarm();

#endif /* BRIGHTONMINI_H */

