/***************************************************************************
                          opera.h  -  Opera Browser Class
                             -------------------
    begin                : Tue Feb 18 2003
    copyright            : (C) 2003 by Ken Schenke
    email                : kschenke at users dot sourceforge dot net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software           *
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA         *
 *   02110-1301, USA                                                       *
 *                                                                         *
 ***************************************************************************/

#ifndef OPERA_H
#define OPERA_H

#include "browserbk.h"

#include <QDir>
#include <QTextStream>

class Opera : public BrowserBk
{
public:
	Opera() { m_Root = NULL; }
	virtual ~Opera() { delete m_Root; }

	virtual bool    AreBookmarksValid(const QString &bookmarks);
	virtual bool    BrowseForBookmarks(
		const BridgeCfg &cfg, QString &bookmarks, QWidget *parent=0);
	virtual bool	DetectBrowser(const BridgeCfg &cfg, QStringList &paths);
	virtual void	readBookmarks(const QString &path, BRWSNUM browserOrd)
						throw(BkException);
	static	void	saveBookmarks(const QString &path, BkFolder &root, BRWSNUM browserOrd)
						throw(BkException);
	static BrowserBk *classFactory(void);

protected:
	virtual BkFolder & root(void) { return *m_Root; }

	bool	findBookmarkFile(const QString &path, QString &bookmarkFile);

	void	readAttributes(QTextStream &stream, BkNode &node, QString &line,
						BRWSNUM browserOrd) throw(BkException);
	void	readFolder(QTextStream &stream, BkFolder &folder, BRWSNUM browserOrd)
						throw(BkException);

private:

	BkFolder	*m_Root;
};

#endif  // end of OPERA_H
