// ServerConnection.H  -*- C++ -*-
// Copyright (c) 1997, 1998 Etienne BERNARD

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef SERVERCONNECTION_H
#define SERVERCONNECTION_H

#include <time.h>

#include "Server.H"
#include "ServerQueue.H"
#include "Connection.H"

class Bot;
class Parser;
class Channel;
class Commands;
class UserCommands;
#ifdef USESCRIPTS
class Interp;
class BotInterp;
class ScriptCommands;
#endif

class ServerConnection : public Connection {
  Server * server;
  Bot * bot;  
  ServerQueue * queue;
  time_t pingTime;
  int lag;
  time_t serverLastSpoken;
  bool debug;
  
public:
  ServerConnection(Bot *, Server *, String);
  ~ServerConnection();

  bool connect();
  bool handleInput();

  friend class Bot;
  friend class Person;
  friend class Parser;
  friend class Channel;
  friend class Commands;
  friend class UserCommands;
#ifdef USESCRIPTS
  friend class Interp;
  friend class BotInterp;
  friend class ScriptCommands;
#endif
};

#endif
