/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "IPv4SubnetParser.h"
#include <boost/test/auto_unit_test.hpp>
#include <string>

BOOST_AUTO_UNIT_TEST(test)
{
	IPv4SubnetParser p;
	
	BOOST_CHECK(p.parse("10"));
	BOOST_CHECK(p.getNetAddr() == 0x0A000000);
	BOOST_CHECK(p.getNetBits() == 8);
	
	BOOST_CHECK(p.parse("10.1"));
	BOOST_CHECK(p.getNetAddr() == 0x0A010000);
	BOOST_CHECK(p.getNetBits() == 16);
	
	BOOST_CHECK(p.parse("10.1.2"));
	BOOST_CHECK(p.getNetAddr() == 0x0A010200);
	BOOST_CHECK(p.getNetBits() == 24);
	
	BOOST_CHECK(p.parse("10.1.2.3"));
	BOOST_CHECK(p.getNetAddr() == 0x0A010203);
	BOOST_CHECK(p.getNetBits() == 32);
	
	BOOST_CHECK(p.parse("128/16"));
	BOOST_CHECK(p.getNetAddr() == 0x80000000);
	BOOST_CHECK(p.getNetBits() == 16);
	
	BOOST_CHECK(!p.parse(""));
	BOOST_CHECK(!p.parse("10."));
	BOOST_CHECK(!p.parse("10 "));
	BOOST_CHECK(!p.parse("10/16 "));
}
