/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "HexDecoder.h"
#include <boost/test/auto_unit_test.hpp>

BOOST_AUTO_UNIT_TEST(test)
{
	static unsigned char const deadbeef[] = { 0xde, 0xad, 0xbe, 0xef };
	HexDecoder decoder;
	BOOST_REQUIRE(decoder.feed("dea"));
	BOOST_REQUIRE(decoder.feed("dbeef"));
	BOOST_REQUIRE(decoder.finalize());
	BOOST_REQUIRE(decoder.buffer().size() == sizeof(deadbeef));
	BOOST_CHECK(!memcmp(&decoder.buffer()[0], deadbeef, sizeof(deadbeef)));
}
