#include <windows.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <exdll.h>

static char* trim(char* str)
{
	char* begin = str;
	char* end = str + strlen(str);
	for (; begin != end; ++begin) {
		if (!isspace(*begin)) {
			break;
		}
	}
	for (; end != begin; --end) {
		if (!isspace(end[-1])) {
			break;
		}
	}
	*end = '\0';
	return begin;
}

static int validateProxySettings(const char* host, const char* port)
{
	char* endptr;
	long port_num = strtol(port, &endptr, 10);
	if (*endptr || port_num <= 0) {
		return 0;
	}
	if (host[0] == '\0') {
		return 0;
	}
	if (!strcmp(host, "localhost") || !strcmp(host, "127.0.0.1")) {
		if (port_num == 8080) {
			// Most likely it points to the previous installation of bfilter.
			// To avoind proxying to itself, we treat it as invalid setting.
			return 0;
		}
	}
	return 1;
}

void __declspec(dllexport) process(HWND hwndParent, int string_size, char *variables, stack_t **stacktop)
{
	char* proxy_enable_str;
	char* proxy_string;
	char proxy_host[1024] = "";
	char proxy_port[1024] = "";
	int proxy_enabled;
	char* http_pos;
	char* http_end;
	char* colon_pos;
	
	proxy_enable_str = GlobalAlloc(GPTR, string_size);
	proxy_string = GlobalAlloc(GPTR, string_size);
	
	EXDLL_INIT();
	popstring(proxy_enable_str);
	popstring(proxy_string);
	
	proxy_enabled = (strcmp(proxy_enable_str, "1") == 0);
	
	if ((http_pos = strstr(proxy_string, "http=")) &&
	    (http_pos == proxy_string || http_pos[-1] == ';')) {
		http_end = strchr(http_pos, ';');
		if (!http_end) {
			http_end = http_pos + strlen(http_pos);
		}
		colon_pos = (char*)memchr(http_pos, ':', http_end - http_pos);
		if (colon_pos) {
			*colon_pos = '\0';
			lstrcpyn(proxy_host, trim(http_pos + 5), sizeof(proxy_host));
			lstrcpyn(proxy_port, trim(colon_pos + 1), sizeof(proxy_port));
		}
	} else if (!strchr(proxy_string, ';')) {
		// one proxy for all protocols
		colon_pos = strchr(proxy_string, ':');
		if (colon_pos) {
			*colon_pos = '\0';
			lstrcpyn(proxy_host, trim(proxy_string), sizeof(proxy_port));
			lstrcpyn(proxy_port, trim(colon_pos + 1), sizeof(proxy_port));
		}
	}
	
	if (!validateProxySettings(proxy_host, proxy_port)) {
		proxy_enabled = 0;
	}
	
	pushstring(proxy_port);
	pushstring(proxy_host);
	pushstring(proxy_enabled ? "1" : "0");
	
	GlobalFree(proxy_string);
	GlobalFree(proxy_enable_str);
}

BOOL APIENTRY DllMain(HANDLE hInst, ULONG ul_reason_for_call, LPVOID lpReserved)
{
	return TRUE;
}
