/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef TRAYICON_H_
#define TRAYICON_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "AnimatedTrayIcon.h"
#include <wx/timer.h>
#include <sigc++/sigc++.h>

namespace wxGUI
{

class TrayIcon : public AnimatedTrayIcon, public sigc::trackable
{
public:
	TrayIcon();
	
	virtual ~TrayIcon();
	
	void displayNetworkActivity();
	
	using wxTaskBarIcon::PopupMenu;
private:
	void loadIcons();
	
	void initFrame(Frame& frame, char const* name, int delay);
	
	void loadIcon(wxIcon& icon, char const* name);
	
	void setNormalIcon();
	
	void setInoperativeIcon();
	
	void setWarningIcon();
	
	void setNormalAnimation();
	
	void setWarningAnimation();
	
	void onMouseUp(wxTaskBarIconEvent& evt);
	
	void onTimer(wxTimerEvent& evt);
	
	void onAcceptingConnections(bool accepting);
	
	void onUnseenWarnings(bool warnings);
	
	void onStateChange();
	
	wxTimer m_timer;
	Frame m_normalFrames[7];
	Frame m_warningFrames[7];
	wxIcon m_inoperativeIcon;
	
	DECLARE_EVENT_TABLE()
};

} // namespace wxGUI

#endif
