/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef TEXTSTYLE_H_
#define TEXTSTYLE_H_

#include "AtomicCounter.h"
#include <ace/config-lite.h>
#include <wx/textctrl.h>

namespace wxGUI
{

class TextStyle : public wxTextAttr
{
public:
	TextStyle() {}

	TextStyle(wxTextAttr const& attr) : wxTextAttr(attr) {}
	
	void ref() const { ++m_refCounter; }
	
	void unref() const { if (--m_refCounter == 0) delete this; } 
private:
	mutable AtomicCounter<ACE_NULL_SYNCH> m_refCounter;
};

} // namespace wxGUI

#endif
