/*
    BFilter - a web proxy which removes banner ads
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef XMLLEXER_H_
#define XMLLEXER_H_

#include "XmlLexerCore.h"

class XmlLexer : public XmlLexerCore
{
	friend struct XmlLexerCore::Actions;
public:
	XmlLexer() : XmlLexerCore(this) {}
	
	virtual ~XmlLexer() {}
private: /* to be called from XmlLexerCore */
	/**
	 * \brief Handle a string like "<?name ... ?>", including "<?xml ... ?>".
	 */
	virtual void processProcInstNode(
		Iterator const& begin, Iterator const& end) = 0;
	
	/**
	 * \brief Handle a string like "<!DOCTYPE ... >".
	 */
	virtual void processDocTypeNode(
		Iterator const& begin, Iterator const& end) = 0;
	
	virtual void processTextNode(
		Iterator const& begin, Iterator const& end) = 0;
	
	/**
	 * \brief Handle a string like "<![CDATA[ ... ]]>".
	 */
	virtual void processCDataNode(
		Iterator const& begin, Iterator const& end) = 0;
	
	/**
	 * \brief Handle a string like "<!-- ... -->".
	 */
	virtual void processCommentNode(
		Iterator const& begin, Iterator const& end) = 0;
	
	/**
	 * \brief Handle the name of an opening tag.
	 */
	virtual void processOpeningTagName(
		Iterator const& begin, Iterator const& end) = 0;
	
	virtual void processAttrName(
		Iterator const& begin, Iterator const& end) = 0;
	
	/**
	 * \brief Handle an attribute value <b>with quotes</b>, like "on" or 'on'.
	 */
	virtual void processAttrValueWithQuotes(
		Iterator const& begin, Iterator const& end) = 0;
	
	/**
	 * \brief Handle the completion of an opening tag.
	 */
	virtual void processOpeningTag(bool empty_tag) = 0;
	
	/**
	 * \brief Handle the name (and completion) of a closing tag.
	 */
	virtual void processClosingTag(
		Iterator const& begin, Iterator const& end) = 0;
	
	virtual void processParseError(Position const& pos) = 0;
};

#endif
