/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef URLPATTERNS_H_
#define URLPATTERNS_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "IntrusivePtr.h"
#include <vector>
#include <utility>

class BString;
class TextPattern;

class UrlPatterns
{
public:
	enum Substitution {
		NO_SUBSTITUTION = 0, FORBID_HTML, EMPTY_HTML,
		EMPTY_IMAGE, EMPTY_FLASH, EMPTY_JS, AUTO_SUBST
	};
	typedef IntrusivePtr<TextPattern const> PatternPtr;
	
	UrlPatterns();
	
	UrlPatterns(UrlPatterns const& other);
	
	~UrlPatterns();
	
	UrlPatterns& operator=(UrlPatterns const& other);
	
	void swap(UrlPatterns& other);
	
	void clear();
	
	void addAllowPattern(PatternPtr const& pattern);
	
	void addNoFilterPattern(PatternPtr const& pattern);
	
	void addSubstitutionPattern(PatternPtr const& pattern, Substitution subst);
	
	void addHintPattern(PatternPtr const& pattern, int hint);
	
	bool isExplicitlyAllowed(BString const& subj) const;
	
	bool isFilteringDisabled(BString const& subj) const;
	
	Substitution getSubstitutionFor(BString const& subj) const;
	
	int getHintFor(BString const& subj) const;
private:
	typedef std::vector<PatternPtr> AllowPatterns;
	typedef std::vector<PatternPtr> NoFilterPatterns;
	typedef std::vector<std::pair<PatternPtr, Substitution> > SubstPatterns;
	typedef std::vector<std::pair<PatternPtr, int> > HintPatterns;
	
	template<typename Iter>
	static bool findMatch(Iter begin, Iter end, BString const& subj);
	
	AllowPatterns m_allowPatterns;
	NoFilterPatterns m_noFilterPatterns;
	SubstPatterns m_substPatterns;
	HintPatterns m_hintPatterns;
};


inline void swap(UrlPatterns& o1, UrlPatterns& o2)
{
	o1.swap(o2);
}

#endif
