/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef HTTPCACHE_FILEINSTANCE_H_
#define HTTPCACHE_FILEINSTANCE_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "NonCopyable.h"
#include "AbstractFileStorage.h"
#include "AbstractFileIO.h"
#include "IntrusivePtr.h"
#include <memory>

namespace HttpCache
{

class FileId;

/**
 * \brief Represents one of many handles referencing the same file.
 *
 * The idea behind this class is as follows:\n
 * A single file is opened several times.  When the last instance is gone,
 * the file is deleted.  It's also possible to mix in non-instances, that is
 * non-opened files.  Whether or not the file will be deleted when all
 * instances and non-instances are gone, is configurable.
 */
class FileInstance
{
	DECLARE_NON_COPYABLE(FileInstance)
public:
	FileInstance(
		IntrusivePtr<AbstractFileStorage> const& storage,
		FileId const& file_id, std::auto_ptr<AbstractFileIO> file_io,
		bool unlink_on_no_refs);
	
	FileInstance(
		FileInstance const& other_instance,
		std::auto_ptr<AbstractFileIO> file_io);
	
	~FileInstance();
	
	/**
	 * \brief Sets whether to delete a file when the last instance closes.
	 *
	 * This function affects all instances and is thread-safe.
	 */
	void unlinkOnNoRefs(bool val);
	
	std::auto_ptr<AbstractFileIO>& fileIO() { return m_ptrFileIO; }
private:
	class Rep;
	
	IntrusivePtr<Rep> m_ptrRep;
	std::auto_ptr<AbstractFileIO> m_ptrFileIO; // must be destroyed before m_ptrRep
};

} // namespace HttpCache

#endif
