/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef JPEGIMAGEINSPECTOR_H_
#define JPEGIMAGEINSPECTOR_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "AbstractImageInspector.h"
#include "SplittableBuffer.h"
#include <stddef.h>

class SplittableBuffer;

class JpegImageInspector : public AbstractImageInspector
{
public:
	JpegImageInspector();
	
	virtual ~JpegImageInspector();
	
	virtual void consumeDataChunk(SplittableBuffer& data, bool eof);
	
	virtual void reset();
	
	virtual SplittableBuffer& accumulatedData() { return m_data; }
	
	virtual Status getStatus() const { return m_status; }
	
	virtual unsigned int getWidth() const { return m_width; }
	
	virtual unsigned int getHeight() const { return m_height; }
	
	virtual bool isAnimated() const { return false; }
private:
	enum State {
		ST_SIGNATURE,
		ST_MARKER_OR_PADDING,
		ST_SKIP_VAR,
		ST_SKIP_VAR_DATA,
		ST_SOF,
		ST_SOF_DATA
	};
	
	void advance() { ++m_curPos; ++m_curOffset; }
	
	void advance(size_t s) { m_curPos += s; m_curOffset += s; }
	
	void processNewData();
	
	bool checkSignature();
	
	State m_state;
	Status m_status;
	SplittableBuffer m_data;
	size_t m_dataSize;
	SplittableBuffer::ByteIterator m_curPos;
	size_t m_curOffset;
	size_t m_curBlockSize;
	int m_width;
	int m_height;
};

#endif
