/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef IMMEDIATERESPONSE_H_
#define IMMEDIATERESPONSE_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "RequestPtr.h"

class AbstractResponseHandler;
class RequestStatus;
class RequestTag;

/**
 * \brief Abstract base class for locally generated responses.
 */
class ImmediateResponse
{
public:
	virtual ~ImmediateResponse() {}
	
	/**
	 * \brief Feed the response to handler.
	 *
	 * Implementations must adjust the response to comply with the request.
	 * Specifically, responses to HEAD requests must not contain bodies.\n
	 * RequestTag is provided because some implementations may want to
	 * change its flags.
	 * \note This method must not be called multiple times.
	 */
	virtual void output(
		AbstractResponseHandler& handler,
		ConstRequestPtr const& request,
		RequestStatus& request_status,
		RequestTag const& request_tag) = 0;
};

#endif
