/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "IframeHeuristicScore.h"
#include "URI.h"

using namespace std;

int
IframeHeuristicScore::getNumericScore() const
{
	return m_score;
}

int
IframeHeuristicScore::getNumericSizeScore() const
{
	return m_sizeScore;
}

void
IframeHeuristicScore::processSize(int width, int height)
{
	if (m_sizeScore) {
		m_score -= m_sizeScore;
		m_sizeScore = 0;
	}
	m_sizeScore = getSizeScore(width, height);
	m_score += m_sizeScore;
}

void
IframeHeuristicScore::processUrl(URI const& abs, URI const& rel, URI const& base)
{
	m_score += getHintModifier(abs);
	UrlRelationship rship = getUrlRelationship(rel, base);
	if (rship == URLS_UNRELATED) {
		m_score += 100;
	} else if (rship == URLS_SAME_HOST) {
		m_score -= 40;
	}
	UrlFlags const flags = getUrlStatus(abs, EXPECT_HTML);
	if ((flags & LOOKS_LIKE_SCRIPT) && !(flags & UNEXPECTED_EXTENSION)) {
		m_score += 20;
	} else if (flags & HTML_EXTENSION) {
		m_score -= 20;
	}
}

void
IframeHeuristicScore::processNoscript(bool val)
{
	if (val) {
		m_score += 30;
	}
}

void
IframeHeuristicScore::processScriptLevel(int level, bool external)
{
	if (level > 1) {
		m_score += 70;
		if (external) {
			m_score += 30;
		}
	} else if (level > 0) {
		m_score += 30;
		if (external) {
			m_score += 20;
		}
	}
	
}

void
IframeHeuristicScore::processScriptRedirect(bool val)
{
	if (val) {
		m_score += 40;
	}
}

void
IframeHeuristicScore::processScriptPersistentCookies(bool val)
{
	if (val) {
		m_score += 40;
	}
}
