/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef HTTPSTATERESPONSEHEADERS_H_
#define HTTPSTATERESPONSEHEADERS_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "HttpStateHeaders.h"
#include "RequestPtr.h"
#include <memory>

class HttpResponseParser;
class HttpResponseMetadata;
class HttpStatusLine;
class HttpHeadersCollection;
class BString;

class HttpStateResponseHeaders : public HttpStateHeaders
{
public:
	HttpStateResponseHeaders(HttpResponseParser& parser);
	
	virtual ~HttpStateResponseHeaders();
	
	void activate(ConstRequestPtr const& req, HttpStatusLine const& status_line);
	
	virtual void cleanup();
private:
	virtual void addHeader(BString const& name, BString const& value);
	
	virtual HttpState* headersReceived(bool& body_eof);
	
	bool isHeadResponse() const;
	
	bool isConnectResponse() const;
	
	bool handleWrongGzipEncoding(HttpHeadersCollection& headers);
	
	HttpState* handleLengthPlusEncodingProblem(
		HttpHeadersCollection& headers, BString const& cenc, bool is_persistent);
	
	HttpResponseParser& m_rParser;
	ConstRequestPtr m_ptrRequest;
	std::auto_ptr<HttpResponseMetadata> m_ptrMetadata;
};

#endif
