/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef HTTPRESPONSEMETADATA_H_
#define HTTPRESPONSEMETADATA_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "HttpMessageMetadata.h"
#include "HttpStatusLine.h"
#include "HttpHeadersCollection.h"

class HttpResponseMetadata : public HttpMessageMetadata
{
public:
	HttpResponseMetadata(HttpStatusLine const& status_line, const HttpHeadersCollection& headers)
	: m_statusLine(status_line), m_headers(headers) {}
	
	HttpResponseMetadata(HttpStatusLine const& status_line)
	: m_statusLine(status_line) {}
	
	HttpStatusLine& statusLine() { return m_statusLine; }
	
	HttpStatusLine const& statusLine() const { return m_statusLine; }
	
	HttpHeadersCollection& headers() { return m_headers; }
	
	HttpHeadersCollection const& headers() const { return m_headers; }
private:
	HttpStatusLine m_statusLine;
	HttpHeadersCollection m_headers;
};

#endif
