/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef HTTPREQUESTLINE_H_
#define HTTPREQUESTLINE_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "HttpVersion.h"
#include "BString.h"
#include "URI.h"
#include <iosfwd>

class HttpRequestLine
{
public:
	enum Style { DEFAULT, RELATIVE_URL };
	
	HttpRequestLine(BString const& method, URI const& uri, HttpVersion const& http_version);
	
	BString const& getMethod() const { return m_method; }
	
	void setMethod(BString const& method) { m_method = method; }
	
	URI const& getURI() const { return m_uri; }
	
	void setURI(URI const& uri) { m_uri = uri; }
	
	HttpVersion const& getHttpVersion() const { return m_httpVersion; }
	
	void setHttpVersion(HttpVersion const& version) { m_httpVersion = version; }
	
	void toStream(std::ostream& strm, Style style = DEFAULT) const;
private:
	BString m_method;
	URI m_uri;
	HttpVersion m_httpVersion;
};

#endif
