/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef HTMLCONTENTVALIDATOR_H_
#define HTMLCONTENTVALIDATOR_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "ResponseFilterBase.h"
#include "NonCopyable.h"
#include <memory>
#include <string>

class HttpResponseMetadata;
class ResponseFilterChain;
class HtmlDetector;
class RequestStatus;

class HtmlContentValidator : public ResponseFilterBase
{
	DECLARE_NON_COPYABLE(HtmlContentValidator)
public:
	HtmlContentValidator(ResponseFilterChain& filter_chain, bool xhtml);
	
	virtual ~HtmlContentValidator();
	
	virtual void processMetadata(
		RequestStatus& status,
		std::auto_ptr<HttpResponseMetadata> metadata);
	
	virtual void processBodyData(
		RequestStatus& status,
		SplittableBuffer& data, bool eof);
private:
	enum { MAX_BUFFERED_SIZE = 1024 };
	
	void setFlags();
	
	void onResult(RequestStatus& status, bool detected, bool eof);
	
	std::auto_ptr<HttpResponseMetadata> m_ptrMetadata;
	std::auto_ptr<HtmlDetector> m_ptrHtmlDetector;
	bool const m_isXhtml;
};

#endif
