/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef GIFIMAGEINSPECTOR_H_
#define GIFIMAGEINSPECTOR_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "AbstractImageInspector.h"
#include "SplittableBuffer.h"
#include <stddef.h>

class GifImageInspector : public AbstractImageInspector
{
public:
	GifImageInspector();
	
	virtual ~GifImageInspector();
	
	virtual void consumeDataChunk(SplittableBuffer& data, bool eof);
	
	virtual void reset();
	
	virtual SplittableBuffer& accumulatedData() { return m_data; }
	
	virtual Status getStatus() const { return m_status; }
	
	virtual unsigned int getWidth() const { return m_width; }
	
	virtual unsigned int getHeight() const { return m_height; }
	
	virtual bool isAnimated() const { return m_isAnimated; }
private:
	enum State {
		ST_SIGNATURE,
		ST_HEADER,
		ST_GLOBAL_COLOR_TABLE,
		ST_BLOCK_BEGIN,
		ST_IMAGE_DESCRIPTOR,
		ST_LOCAL_COLOR_TABLE,
		ST_IMAGE_DATA,
		ST_IMAGE_DATA_SUBBLOCK_OR_TERMINATOR,
		ST_IMAGE_DATA_SUBBLOCK,
		ST_EXTENSION_BLOCK_BEGIN,
		ST_GRAPHIC_CONTROL_EXTENSION_SUBBLOCK_OR_TERMINATOR,
		ST_GRAPHIC_CONTROL_EXTENSION_SUBBLOCK,
		ST_APPLICATION_EXTENSION_SUBBLOCK_OR_TERMINATOR,
		ST_APPLICATION_EXTENSION_SUBBLOCK,
		ST_NETSCAPE_EXTENSION_SUBBLOCK2_OR_TERMINATOR,
		ST_NETSCAPE_EXTENSION_SUBBLOCK2,
		ST_OTHER_EXTENSION_SUBBLOCK_OR_TERMINATOR,
		ST_OTHER_EXTENSION_SUBBLOCK
	};
	enum DelayState {
		DST_DELAY_NOT_ENCOUNTERED,
		DST_WAITING_FOR_GRAPHIC_BLOCK,
		DST_WAITING_FOR_ANOTHER_GRAPHIC_BLOCK
	};
	
	void advance() { ++m_curPos; ++m_curOffset; }
	
	void advance(size_t s) { m_curPos += s; m_curOffset += s; }
	
	void processNewData();
	
	bool checkSignature();
	
	State m_state;
	DelayState m_delayState;
	Status m_status;
	SplittableBuffer m_data;
	size_t m_dataSize;
	SplittableBuffer::ByteIterator m_curPos;
	size_t m_curOffset;
	size_t m_curBlockSize;
	unsigned int m_width;
	unsigned int m_height;
	bool m_isAnimated;
};

#endif
