/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "FilterJsLogger.h"
#include "AbstractFilterJsLogHandler.h"
#include "FilterTag.h"
#include "FilterGroupTag.h"
#include "InterthreadCommandQueue.h"
#include "AbstractCommand.h"
#include <string>

using namespace std;

class FilterJsLogger::MessageCommand : public AbstractCommand
{
public:
	MessageCommand(
		FilterTag const& filter_tag,
		FilterGroupTag const& group_tag, char const* msg);
	
	virtual ~MessageCommand();
	
	virtual void operator()();
private:
	FilterTag m_filterTag;
	FilterGroupTag m_groupTag;
	std::string m_msg;
};


class FilterJsLogger::ErrorCommand : public AbstractCommand
{
public:
	ErrorCommand(
		FilterTag const& filter_tag,
		FilterGroupTag const& group_tag, char const* msg,
		int lineno, char const* linebuf, int linepos);
	
	virtual ~ErrorCommand();
	
	virtual void operator()();
private:
	FilterTag m_filterTag;
	FilterGroupTag m_groupTag;
	std::string m_msg;
	std::string m_line;
	int m_lineNo;
	int m_linePos;
};


AbstractFilterJsLogHandler* FilterJsLogger::m_spHandler = 0;

void
FilterJsLogger::logMessage(
	FilterTag const& filter_tag,
	FilterGroupTag const& group_tag, char const* msg)
{
	if (!m_spHandler) {
		return;
	}
	
	m_spHandler->getCommandQueue().push(
		IntrusivePtr<AbstractCommand>(
			new MessageCommand(filter_tag, group_tag, msg)
		)
	);
}

void
FilterJsLogger::logError(
	FilterTag const& filter_tag,
	FilterGroupTag const& group_tag, char const* msg,
	int lineno, char const* linebuf, int linepos)
{
	if (!m_spHandler) {
		return;
	}
	
	m_spHandler->getCommandQueue().push(
		IntrusivePtr<AbstractCommand>(
			new ErrorCommand(
				filter_tag, group_tag,
				msg, lineno, linebuf, linepos
			)
		)
	);
}


/*================== FilterJsLogger::MessageCommand ====================*/

FilterJsLogger::MessageCommand::MessageCommand(
	FilterTag const& filter_tag,
	FilterGroupTag const& group_tag, char const* msg)
:	m_filterTag(filter_tag),
	m_groupTag(group_tag),
	m_msg(msg)
{
}

FilterJsLogger::MessageCommand::~MessageCommand()
{
}

void
FilterJsLogger::MessageCommand::operator()()
{
	m_spHandler->logMessage(m_filterTag, m_groupTag, m_msg);
}


/*=================== FilterJsLogger::ErrorCommand =====================*/

FilterJsLogger::ErrorCommand::ErrorCommand(
	FilterTag const& filter_tag,
	FilterGroupTag const& group_tag, char const* msg,
	int lineno, char const* linebuf, int linepos)
:	m_filterTag(filter_tag),
	m_groupTag(group_tag),
	m_msg(msg),
	m_lineNo(lineno),
	m_linePos(linepos)
{
	if (linebuf) {
		m_line = linebuf;
	}
}

FilterJsLogger::ErrorCommand::~ErrorCommand()
{
}

void
FilterJsLogger::ErrorCommand::operator()()
{
	m_spHandler->logError(
		m_filterTag, m_groupTag, m_msg, m_lineNo, m_line, m_linePos
	);
}
