/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef ERRORCODES_H_
#define ERRORCODES_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

namespace ErrorCodes
{
	enum Code {
		UNKNOWN_ERROR,
		ERROR_PARSING_REQUEST,
		ERROR_PARSING_RESPONSE,
		UNSUPPORTED_METHOD,
		UNSUPPORTED_PROTOCOL,
		EXPECTATION_FAILED,
		SERVER_TIMEOUT,
		CONNECT_TIMEOUT,
		CONNECT_FAILED,
		DNS_ERROR,
		REQUEST_BODY_TOO_BIG, // when using chunked requests (we have to buffer them)
		ERROR_COMPRESSING_RESPONSE,
		ERROR_DECOMPRESSING_RESPONSE,
		ERROR_READING_CACHED_RESPONSE,
		TOO_MANY_REDIRECTS,    //
		RESPONSE_BODY_TOO_BIG, //
		WRONG_RESPONSE_STATUS, // } when fetching external scripts
		SCRIPT_FETCH_NOFILTER, //
		REQUEST_CANCEL_TO_SAVE_TRAFFIC, // used by response analyzers
		REMOTE_PROXY_CONFIG_PROBLEM,
		ERROR_FORWARDING_THROUGH_PROXY,
		TUNNEL_PORT_NOT_ALLOWED,
		URL_FORBIDDEN
	};
}

#endif
