/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef ETAG_H_
#define ETAG_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>
#include <stddef.h>

class BString;
class HttpHeader;

class ETag
{
public:
	// Member-wise copying is OK.
	
	ETag();
	
	ETag(HttpHeader const& header);
	
	ETag(BString const& etag);
	
	ETag(std::string const& etag);
	
	ETag(char const* str, size_t len);
	
	~ETag();
	
	bool isNull() const { return m_flags & ETAG_NULL; }
	
	bool isValid() const { return m_flags & ETAG_VALID; }
	
	bool isWeak() const { return m_flags & ETAG_WEAK; }
	
	void swap(ETag& other);
	
	BString toBString() const;
	
	bool strongIdentity(ETag const& other) const;
	
	bool weakIdentity(ETag const& other) const;
private:
	enum { ETAG_NULL = 1, ETAG_VALID = 2, ETAG_WEAK = 4 };
	
	void parse(char const* begin, char const* end);
	
	std::string m_value; // contains a quoted value with quotes included
	unsigned char m_flags;
};

inline void swap(ETag& o1, ETag& o2)
{
	o1.swap(o2);
}

#endif
