/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef CACHINGSERVER_H_
#define CACHINGSERVER_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "AbstractServer.h"
#include "NonCopyable.h"
#include "IntrusivePtr.h"
#include "RequestPtr.h"
#include <memory>

class ImmediateResponse;

class CachingServer : public AbstractServer
{
	DECLARE_NON_COPYABLE(CachingServer)
public:
	/**
	 * \brief Construct a caching server.
	 *
	 * \param delegate The server which responses we will be caching.
	 * \param dont_create If true, no new cache entries will be created.
	 *        Reading and updating existing ones is still allowed.
	 */
	CachingServer(AbstractServer& delegate, bool dont_create = false);
	
	virtual ~CachingServer();
	
	virtual IntrusivePtr<AbstractRequestHandler> submitRequest(
		ConstRequestPtr const& request_metadata,
		RequestTag const& request_tag,
		IntrusivePtr<AbstractResponseHandler> const& handler);
	
	/**
	 * \brief Submit a request with response attached.
	 * \note This method just forwards this request to the delegate.
	 */
	virtual IntrusivePtr<AbstractRequestHandler> submitRequest(
		ConstRequestPtr const& request_metadata,
		RequestTag const& request_tag,
		IntrusivePtr<AbstractResponseHandler> const& handler,
		std::auto_ptr<ImmediateResponse> response);
	
	virtual bool isIdle() const;
	
	virtual bool isOverloaded() const;
private:
	enum { READ_BUF_SIZE = 16*1024 };
	
	class CachedResponse;
	class CachingFilter;
	
	AbstractServer& m_rDelegate;
	bool m_dontCreate;
};

#endif
