/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef NFACLOSURE_H_
#define NFACLOSURE_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Nfa.h"
#include "NfaState.h"
#include <vector>

class NfaClosure : public Nfa
{
public:
	NfaClosure(Nfa const& object);
	
	virtual ~NfaClosure();
	
	virtual int length() const;
	
	virtual NfaState const* statesBegin() const;
	
	virtual NfaState const* statesEnd() const;
	
	virtual int getStartPos() const;
	
	virtual int getFinishPos() const;
private:
	std::vector<NfaState> m_states;
	int m_startPos;
	int m_finishPos;
};

#endif
