/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef SBOUTSTREAMBUF_H_
#define SBOUTSTREAMBUF_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "SplittableBuffer.h"
#include "IntrusivePtr.h"
#include <stddef.h>
#include <iosfwd>
#include <streambuf>

class DataChunk;
class BString;

class SBOutStreamBuf : public std::streambuf
{
public:
	SBOutStreamBuf(size_t chunk_size);
	
	virtual ~SBOutStreamBuf();
	
	size_t readChunk(std::istream& strm);
	
	SplittableBuffer& data() { return m_buf; }
	
	SplittableBuffer const& data() const { return m_buf; }
	
	void swapData(SplittableBuffer& with);
	
	void clearData() { m_buf.clear(); }
	
	void clear(); // clears both data and the internal buffer
protected:
	virtual int_type overflow(int_type c);
	
	virtual std::streamsize xsputn(char_type const* s, std::streamsize n);
private:
	void nextChunk();
	
	size_t m_chunkSize;
	SplittableBuffer m_buf;
	IntrusivePtr<DataChunk const> m_ptrChunk;
	char_type* m_pCur;
	char_type* m_pEnd;
};

#endif
