/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "FileHandle.h"
#include <ace/config-lite.h>
#include <ace/OS_NS_unistd.h> // for ACE_OS::close()
#include <algorithm>

FileHandle::~FileHandle()
{
	if (m_handle != ACE_INVALID_HANDLE) {
		ACE_OS::close(m_handle);
	}
}

FileHandle&
FileHandle::operator=(FileHandle& other)
{
	FileHandle(other).swap(*this);
	return *this;
}

FileHandle&
FileHandle::operator=(CopyHelper helper)
{
	FileHandle(helper).swap(*this);
	return *this;
}

void
FileHandle::swap(FileHandle& other)
{
	std::swap(m_handle, other.m_handle);
}

void
FileHandle::reset(ACE_HANDLE h)
{
	FileHandle(h).swap(*this);
}

ACE_HANDLE
FileHandle::release()
{
	ACE_HANDLE const handle = m_handle;
	m_handle = ACE_INVALID_HANDLE;
	return handle;
}
