

#ifndef STRING_HH
#include "../tools/string.hh"
#endif
#ifndef MESSAGE_DISPLAY_HH
#include "../tools/message_display.hh"
#endif

#ifndef AVD_AVIDA_DRIVER_HH
#include "avd_avida_driver.hh"
#endif

#ifndef AVD_MISSION_CONTROL_HH
#include "avd_mission_control.hh"
#endif
#ifndef AVD_GUI_MSG_EVENT_HH
#include "avd_gui_msg_event.hh"
#endif

#ifndef CONFIG_HH
#include "../main/config.hh"
#endif
#ifndef POPULATION_HH
#include "../main/population.hh"
#endif

#ifndef QAPPLICATION_H
#include <qapplication.h>
#endif
#ifndef QDATETIME_H
#include <qdatetime.h>
#endif
#ifndef QEVENT_H
#include <qevent.h>
#endif
#ifndef QSTRINGLIST_H
#include <qstringlist.h>
#endif
#ifndef QTIMER_H
#include <qtimer.h>
#endif


using namespace std;


const QString
  avd_AvidaDriver::update_avida_message("UpdateAvida"),
  avd_AvidaDriver::step_organism_message("StepOrganism"),
  avd_AvidaDriver::exit_avida_message("ExitAvida"),
  
  avd_AvidaDriver::avida_updated_message("AvidaUpdated"),
  avd_AvidaDriver::organism_stepped_message("OrganismStepped"),
  avd_AvidaDriver::avida_breakpoint_message("AvidaBreakpoint"),
  avd_AvidaDriver::avida_exited_message("AvidaExited"),
                                                                                    
  avd_AvidaDriver::hello_query_message("Hello?"),                                   
  avd_AvidaDriver::hello_response_message("Hello..."),
  
  avd_AvidaDriver::malformed_message_to_avida("AvidaMessageMalformed"),
  avd_AvidaDriver::null_message("(null)"),
  
  avd_AvidaDriver::avida_threadstat_breakpoint("Breakpoint"),
  avd_AvidaDriver::avida_threadstat_stepping("Stepping"),
  avd_AvidaDriver::avida_threadstat_waiting("Waiting");



avd_AvidaDriver::avd_AvidaDriver(avd_MissionControl *mission_control, cEnvironment &environment)
: m_mission_control(mission_control),
  cAvidaDriver_Population(environment)
{
  m_avida_thread_q = new avd_MessageQueue<QString>(
    null_message,
    m_mission_control->getMutex()
  );
  m_gui_thread_q = new avd_MessageQueue<QString>(
    null_message,
    m_mission_control->getMutex()
  );
 
  m_mission_control->setPopulation(population);
  m_mission_control->setEventList(event_list);

  // signals to avida from gui.
  connect(
    m_mission_control, SIGNAL(startAvidaSig()),
    this, SLOT(startAvidaSlot())
  );
  connect(
    m_mission_control, SIGNAL(updateAvidaSig()),
    this, SLOT(updateAvidaSlot())
  );
  connect(
    m_mission_control, SIGNAL(stepAvidaSig(int)),
    this, SLOT(stepOrganismSlot(int))
  );
  connect(
    m_mission_control, SIGNAL(stopAvidaSig()),
    this, SLOT(stopAvidaSlot())
  );
  connect(
    m_mission_control, SIGNAL(exitAvidaSig()),
    this, SLOT(exitAvidaSlot())
  );
  connect(
    m_mission_control, SIGNAL(isAvidaRunningSig()),
    this, SLOT(isAvidaRunningSlot())
  );
}

/* FIXME: complete. */
avd_AvidaDriver::~avd_AvidaDriver(void){
  m_mission_control->setPopulation(0);
  m_mission_control->setEventList(0);
}

void
avd_AvidaDriver::run(void){
  GenDebug << "entered.";
  avidaMainMessageCatcher();
  GenDebug << "done.";
}

void
avd_AvidaDriver::Run(void){
  GenDebug << "entered.";
  m_expected_avida_state = STOPPED;
  m_gui_step_organism = -1; // no step organism yet.

  // variables to support running average of max number of organisms to
  // process at a time before checking for messages from gui, in order
  // to keep the processing thread responsive.  see description in
  // header file.
  m_desired_update_chunk_time_interval_in_milliseconds = 20;
  m_update_chunking_timer = new QTime();
  m_required_chunk_size_in_organisms = 1;

  // this is fantastically stupid:  in X11, Qt does not check for
  // nonspontaneous events (i.e. not generated by the windowing system)
  // except in passing when a spontaneous event occurs.  the
  // 50-millisecond timer below doesn't connect to anything in this
  // class, but its timer events are considered spontaneous and make Qt
  // pay attention to nonspontaneous events -- in particular,
  // notification from the processing thread of a message for the gui
  // thread.
  //
  // OSX doesn't require this; probably neither does Windows.  We'll
  // see.
  startTimer(50);

  // inherited start() causes avd_AvidaDriver::run(void) to run in its
  // own thread.             note the lowercase^^^!
  // run() is defined right before Run(), just a few lines above this
  // one.
  start();
}


void
avd_AvidaDriver::isAvidaRunningSlot(void){
  GenDebug << "called.n";
  m_mission_control->emitAvidaStatusSig(avidaIsRunning());
  GenDebug << "done.n";
}


void
avd_AvidaDriver::scheduleUpdateSlot(void){
  GenDebug << "called.n";

  switch(m_expected_avida_state){
  case STEPPING:
    GenDebug << " --- trying to resume stepping mode.";

    stepOrganismSlot(m_gui_step_organism);
    break;
  case RUNNING:
    m_gui_step_organism = -1;
    /*
    FIXME:  scheduleUpdateSlot() and updateAvidaSlot() can be joined if
    I decide to do away with the delay timer.
    */
    GenDebug << " --- trying to enter running mode.";
    updateAvidaSlot();
    break;
  case STOPPED:
    GenDebug << " --- m_expected_avida_state == STOPPED.\n"
      " --- (not updating.)\n"
      " --- sending avidaStoppedSig()." ;
    m_mission_control->emitAvidaStoppedSig();
    break;
  default:
    GenDebug <<
      " --- m_expected_avida_state == INSANE.\n"
      " --- (m_expected_avida_state shouldn't have this value.)\n"
      " --- dying gracelessly."
    ;
    GenFatal("m_expected_avida_state has insane value.");
    break;  // never reached.
  }
  GenDebug << "done.";
}

void
avd_AvidaDriver::updateAvidaSlot(void){
  GenDebug << "called." ;
  m_gui_step_organism = -1;
  m_avida_thread_q->send(update_avida_message);
  GenDebug << "sent \""
  << update_avida_message << "\"." ;
  GenDebug << "done.";
}

void
avd_AvidaDriver::stepOrganismSlot(int cell_id){
  GenDebug << "called.";

  /* FIXME:  verify that cell_id is in the grid.  -- K.
  */
  m_expected_avida_state = STEPPING;
  m_gui_step_organism = cell_id;
  m_avida_thread_q->send( (step_organism_message + ",%1").arg(cell_id));

  GenDebug << "sent \""
    << (step_organism_message + ",%1").arg(cell_id) << "\"." ;
  GenDebug << "done.";
}

void
avd_AvidaDriver::startAvidaSlot(void){
  GenDebug << "called.";
  m_expected_avida_state = RUNNING;
  scheduleUpdateSlot();
  GenDebug << "done.";
}

void
avd_AvidaDriver::stopAvidaSlot(void){
  GenDebug << "called.";
  m_expected_avida_state = STOPPED;
  GenDebug << "done.";
}

void
avd_AvidaDriver::exitAvidaSlot(void){
  GenDebug << "called.";
  m_avida_thread_q->urgent(exit_avida_message);
  GenDebug << "sent \""
    << exit_avida_message << "\".  waiting...";
  wait();
  m_expected_avida_state = STOPPED;
  m_mission_control->emitAvidaExitedSig();
  GenDebug << "done.";
}

void
avd_AvidaDriver::helloAvidaSlot(void){
  GenDebug << "called.";
  m_avida_thread_q->urgent(hello_query_message);
  GenDebug << "sent \""
    << hello_query_message << "\".";
  GenDebug << "done.";
}

void
avd_AvidaDriver::malformedMessageToAvidaSlot(void){
  GenDebug << "called.";
  m_avida_thread_q->send("fooey");
  GenDebug << " --- sent \"fooey\".";
  GenDebug << "done.";
}


// GUI thread management

void
avd_AvidaDriver::customEvent(QCustomEvent *custom_event){
  GenDebug << "entered.";
  if (custom_event->type() == avd_GuiMsgEvent::EventType){
    GenDebug << "avd_GuiMsgEvent::EventType.";
    guiMessageCatcher();
  }
  GenDebug << "done.";
}

void
avd_AvidaDriver::guiMessageCatcher(void){
  QString message = m_gui_thread_q->receive(0);
  if (message != null_message){
    GenDebug
    << " --- got message \"" << message << "\".";

    QStringList components = QStringList::split(",", message);
    if(components[0] == avida_updated_message){
      if(!avidaUpdated(components)) avidaSentBunkMessage(components);
    } else
    if(components[0] == organism_stepped_message){
      if(!organismStepped(components)) avidaSentBunkMessage(components);
    } else
    if(components[0] == avida_breakpoint_message){
      if(!avidaBreakpoint(components)) avidaSentBunkMessage(components);
    } else
    if(components[0] == avida_exited_message){
      if(!avidaExited(components)) avidaSentBunkMessage(components);
    } else
    if(components[0] == hello_response_message){
      if(!avidaSaysHi(components)) avidaSentBunkMessage(components);
    } else
    if(components[0] == malformed_message_to_avida){
      avidaGotBunkMessage(components);
    } else {
      avidaSentBunkMessage(components);
    }
  }
}

bool
avd_AvidaDriver::avidaUpdated(const QStringList &components){
  GenDebug << "called.";

  if (components.size() != 1){
    return false;
  }
  m_mission_control->emitAvidaUpdatedSig();

  scheduleUpdateSlot();

  GenDebug << "called scheduleUpdateSlot().";
  GenDebug << "done.";

  return true;
}

bool
avd_AvidaDriver::organismStepped(const QStringList &components){
  GenDebug << "called.";

  if (components.size() != 2){
    return false;
  }

  bool ok;
  int cell_id = components[1].toInt(&ok);
  if(!ok
    /*
    use of m_gui_step_organism as a sanity check may be a bad idea;
    things may run fine under a mismatch.

    FIXME:  if this turns out to hold, ditch m_gui_step_organism.
    */
    /*
    ||
    cell_id != m_gui_step_organism
    */
  ){
    GenDebug << "early exit.";
    return false;
  }

  m_expected_avida_state = STOPPED;
  m_mission_control->emitAvidaSteppedSig(cell_id);
  GenDebug << "done.";
  return true;
}

bool
avd_AvidaDriver::avidaBreakpoint(const QStringList &components){
  GenDebug << "called.";

  if (components.size() != 2){
    GenDebug << "early exit.";
    return false;
  }

  bool ok;
  int cell_id = components[1].toInt(&ok);
  if(!ok
    /*
    use of m_gui_step_organism as a sanity check may be a bad idea;
    things may run fine under a mismatch.

    FIXME:  if this turns out to hold, ditch m_gui_step_organism.
    */
    /*
    ||
    cell_id != m_gui_step_organism
    */
  ){
    GenDebug << "early exit.";
    return false;
  }

  m_expected_avida_state = STOPPED;
  m_mission_control->emitAvidaBreakpointSig(cell_id);
  GenDebug << "done.";
  return true;
}


/* FIXME: complete. */
bool
avd_AvidaDriver::avidaExited(const QStringList &components){
  GenDebug << "called.\n";

  if (components.size() != 1){
    GenDebug << "early exit.";
    return false;
  }
  m_expected_avida_state = STOPPED;
  m_mission_control->emitAvidaExitedSig();
  GenDebug << "done.";
  return true;
}

/* FIXME: complete. */
bool
avd_AvidaDriver::avidaSaysHi(const QStringList &components){
  GenDebug << "called.\n";

  if (components.size() != 2){
    return false;
  }
  GenDebug
  << " --- message: \"" << components.join(",") << "\".\n"
  << " --- NOT FULLY IMPLEMENTED.";
  return true;
}

void
avd_AvidaDriver::avidaGotBunkMessage(const QStringList &components){
  GenDebug
  << " --- bunk message: \""
  << components.join(",") << "\".";
  GenFatal("<avd_AvidaDriver::avidaGotBunkMessage>");
}

void
avd_AvidaDriver::avidaSentBunkMessage(const QStringList &components){
  GenDebug
  << " --- bunk message: \""
  << components.join(",") << "\".";
  GenFatal("<avd_AvidaDriver::avidaSentBunkMessage>");
}

// Avida thread management
void
avd_AvidaDriver::avidaMainMessageCatcher(void){

  m_avida_thread_status = avida_threadstat_waiting;

  GenDebug <<
    " --- entered; ready to begin."
  ;

  QString message;
  QStringList components;

  for (;;) {

    int timeout = 1000;
    message = m_avida_thread_q->receive(timeout);

GenDebug << message;

    components = QStringList::split(",", message);

    if(components[0] == update_avida_message){
      if(!parseUpdateAvidaArgs(components)){
        malformedMessageToAvida(message);
      } else {
        m_avida_step_organism = -1;
        // we're nailed into updating mode.
        m_mission_control->lock();
        if(ProcessUpdate()){
          m_mission_control->unlock();
          m_gui_thread_q->urgent(avida_exited_message);
          avd_GuiMsgEvent *me = new avd_GuiMsgEvent();
          QApplication::postEvent(this, me);

          GenDebug <<
            " --- avida thread finishing.\n"
            " --- sent \""
          << avida_exited_message << "\".";

          exit();
        }
        m_mission_control->unlock();
      }
    } else
    if(components[0] == step_organism_message){
      if(!parseStepAvidaArgs(components, m_avida_step_organism)){
        malformedMessageToAvida(message);
      } else {
        // we've just switched to stepping mode.
        GenDebug <<
          " --- trying to enter step mode.  m_avida_step_organism: "
        << m_avida_step_organism << ".";

        m_mission_control->lock();
        if(ProcessUpdate()){
          m_mission_control->unlock();
          m_gui_thread_q->urgent(avida_exited_message);
          avd_GuiMsgEvent *me = new avd_GuiMsgEvent();
          QApplication::postEvent(this, me);

          GenDebug <<
            " --- avida thread finishing.\n"
            " --- sent \""
          << avida_exited_message << "\".";

          exit();
        }
        m_mission_control->unlock();
      }
    } else
    if(components[0] == exit_avida_message){
      if(!parseExitAvidaArgs(components)){
        malformedMessageToAvida(message);
      } else {
        //m_gui_thread_q->urgent(avida_exited_message);
        //avd_GuiMsgEvent *me = new avd_GuiMsgEvent();
        //QApplication::postEvent(this, me);

        //GenDebug <<
        //  "<avd_AvidaDriver::avidaMainMessageCatcher>\n"
        //  " --- avida thread finishing.\n"
        //  " --- sent \""
        //<< avida_exited_message << "\".\n";
        GenDebug << "done.";
        exit();
      }
    } else
    if(components[0] == hello_query_message){
      if(!parseHelloAvidaArgs(components)) malformedMessageToAvida(message);
    } else
    if(components[0] == null_message){
      ;
    } else {
      malformedMessageToAvida(message);
    }
  }
}

void
avd_AvidaDriver::avidaSubupdateMessageCatcher(void){

  QString message = m_avida_thread_q->receive(0);
  QStringList components = QStringList::split(",", message);

  if(components[0] == update_avida_message){
    if(!parseUpdateAvidaArgs(components)){
      malformedMessageToAvida(message);
    } else {
      m_avida_step_organism = -1;
      return;
    }
  } else
  if(components[0] == step_organism_message){
    if(!parseStepAvidaArgs(components, m_avida_step_organism)){
      malformedMessageToAvida(message);
    } else {
      return;
    }
  } else
  //if(components[0] == reset_avida_message){
  //  if(!parseResetAvidaArgs(components)) malformedMessageToAvida(message);
  //} else
  if(components[0] == exit_avida_message){
    if(!parseExitAvidaArgs(components)){
      malformedMessageToAvida(message);
    } else {
      //m_gui_thread_q->urgent(avida_exited_message);
      //avd_GuiMsgEvent *me = new avd_GuiMsgEvent();
      //QApplication::postEvent(this, me);

      //GenDebug <<
      //  "<avd_AvidaDriver::avidaSubupdateMessageCatcher>\n"
      //  " --- avida thread finishing.\n"
      //  " --- sent \""
      //  << avida_exited_message
      //  << "\".\n";
      GenDebug << "exiting.";

      exit();
    }
  } else
  if(components[0] == hello_query_message){
    if(!parseHelloAvidaArgs(components)) malformedMessageToAvida(message);
  } else
  if(components[0] == null_message){
    return;
  } else {
    malformedMessageToAvida(message);
  }
}

void
avd_AvidaDriver::avidaSteppingMessageCatcher(void){

  m_avida_thread_status = avida_threadstat_stepping;

  GenDebug << " --- entered; ready to begin.";

  QString message;
  QStringList components;

  for (;;) {

    GenDebug << " --- waiting for message...";

    message = m_avida_thread_q->receive();

    GenDebug << " --- got message \"" << message << "\".";

    components = QStringList::split(",", message);

    if(components[0] == update_avida_message){
      if(!parseUpdateAvidaArgs(components)){
        malformedMessageToAvida(message);
      } else {
        m_avida_step_organism = -1;
        // we've just switched out of stepping mode, into updating mode.
        return;
      }
    } else
    if(components[0] == step_organism_message){
      if(!parseStepAvidaArgs(components, m_avida_step_organism)){
        malformedMessageToAvida(message);
      } else {
        // we've still in stepping mode, maybe with a different stepping
        // organism.
        return;
      }
    } else
    if(components[0] == exit_avida_message){
      if(!parseExitAvidaArgs(components)){
        malformedMessageToAvida(message);
      } else {
        //m_gui_thread_q->urgent(avida_exited_message);
        //avd_GuiMsgEvent *me = new avd_GuiMsgEvent();
        //QApplication::postEvent(this, me);

        //GenDebug <<
        //  "<avd_AvidaDriver::avidaSteppingMessageCatcher>\n"
        //  " --- avida thread finishing.\n"
        //  " --- sent \""
        //  << avida_exited_message
        //  << "\".\n";
        GenDebug << "exiting.";

        exit();
      }
    } else
    if(components[0] == hello_query_message){
      if(!parseHelloAvidaArgs(components)) malformedMessageToAvida(message);
    } else
    if(components[0] == null_message){
      ; // do nothing
    } else {
      malformedMessageToAvida(message);
    }
  }
}

void
avd_AvidaDriver::avidaBreakpointMessageCatcher(void){

  m_avida_thread_status = avida_threadstat_breakpoint;

  GenDebug << " --- entered; ready to begin."
  ;

  QString message;
  QStringList components;

  for (;;) {

    GenDebug << " --- waiting for message...";

    message = m_avida_thread_q->receive();

    GenDebug << " --- got message \"" << message << "\".";

    components = QStringList::split(",", message);

    if(components[0] == update_avida_message){
      if(!parseUpdateAvidaArgs(components)){
        malformedMessageToAvida(message);
      } else {
        m_avida_step_organism = -1;
        // we've just switched out of stepping mode, into updating mode.
        return;
      }
    } else
    if(components[0] == step_organism_message){
      if(!parseStepAvidaArgs(components, m_avida_step_organism)){
        malformedMessageToAvida(message);
      } else {
        // We're in stepping mode now even if we weren't before
        // breakpoint.  If we were, maybe we've switched to a different
        // stepping organism.
        return;
      }
    } else
    if(components[0] == exit_avida_message){
      if(!parseExitAvidaArgs(components)){
        malformedMessageToAvida(message);
      } else {
        //m_gui_thread_q->urgent(avida_exited_message);
        //avd_GuiMsgEvent *me = new avd_GuiMsgEvent();
        //QApplication::postEvent(this, me);

        //GenDebug <<
        //  "<avd_AvidaDriver::avidaBreakpointMessageCatcher>\n"
        //  " --- avida thread finishing.\n"
        //  " --- sent \""
        //  << avida_exited_message
        //  << "\".\n"; GenDebug << "<avd_AvidaDriver::avidaBreakpointMessageCatcher> exiting.\n"; exit();
      } } else
    if(components[0] == hello_query_message){
      if(!parseHelloAvidaArgs(components)) malformedMessageToAvida(message);
    } else
    if(components[0] == null_message){
      ; // do nothing
    } else {
      malformedMessageToAvida(message);
    }
  }
}

bool
avd_AvidaDriver::parseUpdateAvidaArgs(const QStringList &components){
  GenDebug << "entered.";

  if (components.size() != 1){
    GenDebug << "returning false.";
    return false;
  } else {
    GenDebug << "returning true.";
    return true;
  }
}

bool
avd_AvidaDriver::parseStepAvidaArgs(const QStringList &components, int &cell_id_return){
  GenDebug << "entered.";

  if (components.size() != 2){
    return false;
  }
  bool ok;
  int cell_id = components[1].toInt(&ok);
  if (!ok){
    return false;
  }

  /* FIXME:  sanity check cell_id:  is it in the avida world?
     if it isn't, puke.
  */

  cell_id_return = cell_id;

  return true;
}

bool
avd_AvidaDriver::parseExitAvidaArgs(const QStringList &components){
  GenDebug << "entered.";

  if (components.size() != 1){
    return false;
  } else {
    return true;
  }
}

bool
avd_AvidaDriver::parseHelloAvidaArgs(const QStringList &components){
  GenDebug << "called.\n";

  if (components.size() != 1){
    return false;
  }
  m_gui_thread_q->send(hello_response_message + "," + m_avida_thread_status);
  avd_GuiMsgEvent *me = new avd_GuiMsgEvent();
  QApplication::postEvent(this, me);

  GenDebug << " sent \""
    << (hello_response_message + "," + m_avida_thread_status)
    << "\".";

  return true;
}

void
avd_AvidaDriver::malformedMessageToAvida(const QStringList &components){
  GenDebug << "entered.";

  m_gui_thread_q->urgent(malformed_message_to_avida + "," + components.join(","));
  avd_GuiMsgEvent *me = new avd_GuiMsgEvent();
  QApplication::postEvent(this, me);

  GenDebug << " sent \""
    << (malformed_message_to_avida + "," + components.join(","))
    << "\".";

  exit();
}



void
avd_AvidaDriver::ProcessOrganisms(void){
  GenDebug << "called.\n";

  // Process the update.

  const int UD_size =
    cConfig::GetAveTimeslice()*population->GetNumOrganisms();
  m_mission_control->unlock();
  const double step_size = 1.0 / (double) UD_size;

  m_update_chunking_timer_isvalid = true;
  m_update_chunking_timer->start();

  int i = 0;
  while (i < UD_size) {
    m_mission_control->lock();

    // process sufficiently small qty of organisms, determined by
    // m_required_chunk_size_in_organisms, that processing thread can
    // respond to gui messages fairly quickly..
    int j = 0;
    while (j < m_required_chunk_size_in_organisms && i < UD_size){
      m_current_organism_id = population->ScheduleOrganism();
      population->ProcessStep(step_size, m_current_organism_id);

      // Keep the viewer informed about the organism we are stepping
      // through, if we're stepping through an organism...
      // m_avida_step_organism == -1 if we're not, in which case
      // NotifyStep() will never be called.
      if (m_current_organism_id == m_avida_step_organism){
        m_update_chunking_timer_isvalid = false;
        m_mission_control->unlock();
        NotifyStep(m_current_organism_id);
        m_mission_control->lock();
      }
      j++; i++;
    }
    m_required_chunk_size_in_organisms = j;

    if ( (m_last_chunk_interval_in_milliseconds = m_update_chunking_timer->restart()) < 1){
      // prevent divide by zero when computing running average.
      m_last_chunk_interval_in_milliseconds = 1;
    }
    if(m_update_chunking_timer_isvalid){
      m_required_chunk_size_in_organisms +=
        ( m_required_chunk_size_in_organisms
          * m_desired_update_chunk_time_interval_in_milliseconds)
        / m_last_chunk_interval_in_milliseconds;
      if ( (m_required_chunk_size_in_organisms /= 2) < 1){
        // must always process at least one arganism!
        m_required_chunk_size_in_organisms = 1;
      }
    }
    m_update_chunking_timer_isvalid = true;

    m_mission_control->unlock();
    avidaSubupdateMessageCatcher();
  }

  // end-of-update stats...
  m_mission_control->lock();
  population->CalcUpdateStats();

  // Setup the viewer for the new update.
  cStats & stats = population->GetStats();
  Message
    << "UD: "
    << stats.GetUpdate()
    << "\tGen: "
    << stats.SumGeneration().Average()
    << "\tFit: "
    << stats.GetAveFitness();
  m_mission_control->unlock();

  NotifyUpdate();

  m_mission_control->lock();
}


//
bool
avd_AvidaDriver::avidaIsRunning(){
  GenDebug << "entered";
  if(m_expected_avida_state == STOPPED){
    GenDebug << " -- false; done.";
    return false;
  } else {
    GenDebug << " -- true; done.";
    return true;
  }
}


/* FIXME: complete. */
void
avd_AvidaDriver::NotifyUpdate(void){
  m_gui_thread_q->send(avida_updated_message);
  avd_GuiMsgEvent *me = new avd_GuiMsgEvent();
  QApplication::postEvent(this, me);

  GenDebug << " sent \"" << avida_updated_message << "\".";
}

/* FIXME: complete. */
void
avd_AvidaDriver::NotifyStep(int cell_id){
  m_gui_thread_q->send(
    (organism_stepped_message + ",%1")
    .arg(cell_id)
  );
  avd_GuiMsgEvent *me = new avd_GuiMsgEvent();
  QApplication::postEvent(this, me);

  GenDebug << " sent \""
    << (organism_stepped_message + ",%1").arg(cell_id) << "\".";

  avidaSteppingMessageCatcher();
}

/* FIXME: complete. */
void
avd_AvidaDriver::SignalBreakpoint(void){
  GenDebug << "called.";

  // Process the update.
  const int UD_size =
    cConfig::GetAveTimeslice()*population->GetNumOrganisms();
  m_mission_control->unlock();
  const double step_size = 1.0 / (double) UD_size;

  // Keep the viewer informed about the organism we are stepping
  // through, if we're stepping through an organism...
  // m_avida_step_organism == -1 if we're not, in which case
  // NotifyStep() will never be called.

  for (int i = 0; i < UD_size; i++) {
    m_mission_control->lock();
    m_current_organism_id = population->ScheduleOrganism();
    population->ProcessStep(step_size, m_current_organism_id);
    m_mission_control->unlock();
    if (m_current_organism_id == m_avida_step_organism){
      NotifyStep(m_current_organism_id);
    }
  }

  // end-of-update stats...
  m_mission_control->lock();
  population->CalcUpdateStats();

  // Setup the viewer for the new update.
  cStats & stats = population->GetStats();
  Message
    << "UD: "
    << stats.GetUpdate()
    << "\tGen: "
    << stats.SumGeneration().Average()
    << "\tFit: "
    << stats.GetAveFitness();
  m_mission_control->unlock();

  NotifyUpdate();

  m_mission_control->lock();
}


