// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __scan_buffer_h__
#define __scan_buffer_h__

#include <iostream>
using namespace std;

namespace Puma {

class ScanBuffer {
public:
  typedef enum { STATE_NEW, STATE_END, STATE_ERROR, STATE_OK } State;

private:
  int _token;      // start position of current token
  int _pos;        // current position (in token; _pos >= _token && pos < filled)
  char *_buffer;   // token to the buffer that contains all input characters
  int  _buff_size; // size of the input buffer
  State _state;

public:  
  ScanBuffer () : _state (STATE_NEW) {}

  // init buffer to directly scan from a string
  void init (const char *str, int l = 0);
  
  char next () { return _buffer[_pos++]; }
  char lookahead () { return _buffer[_pos]; }
  char *token () const { return _buffer + _token; }
  int len () const { return _pos - _token; }
  void reset () { _token = _pos = 0; }
  void retry () { _pos = _token; } 
  void accept (int len) {
    _token += len;
    _pos = _token;
  }
  void more (int len) { _pos = _token + len; }
  State state () {
    if (_state == STATE_OK && _pos >= _buff_size)
      return STATE_END;
    return _state;
  }
};


} // namespace Puma

#endif /* __scan_buffer_h__ */
