/*
    This file is part of Advanced Strategic Command; http://www.asc-hq.de
    Copyright (C) 1994-1999  Martin Bickel  and  Marc Schellenberger

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; see the file COPYING. If not, write to the 
    Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
    Boston, MA  02111-1307  USA
*/

#ifndef researchExecutionH
#define researchExecutionH

class Vehicle;
class Player;

class Vehicletype;
class BuildingType;

class TechnologyPresenter {
   public:
      class Gadgets {
         public:
            std::list<const Vehicletype*> units;
            std::list<const BuildingType*> buildings;
      };
      
      virtual void showTechnology( const Technology* tech, const Gadgets& newGadgetsAvailable )  = 0;
      virtual ~TechnologyPresenter() {};
};
  
//! registers the class that will present newly researched technologies to the user
extern void setResearchPresenter( TechnologyPresenter* presenter ); 

class SuppressTechPresentation {
      TechnologyPresenter* presenter;
   public: 
      SuppressTechPresentation();
      ~SuppressTechPresentation();
};


//! dissects a vehicle; if you haven't researched this vehicle type you will get some research points for it.
extern void dissectvehicle ( Vehicle* eht );

/** progresses in the current research, automatically chosing technologies towards the research goal.

    This function does not generate any research points, it only consumes them.
    Research points are generated by #doresearch()

    No user interaction takes place. 

    \param player the player who is researching
    \param nweTechs If non-Null, add all technologies that have been made available during this call
    \param newTechAdapter If non-Null, add all TechAdapter that have been activated during this call

*/
extern void runResearch( Player& player, vector<const Technology*>* newTechs, vector<ASCString>* newTechAdapter );

//! Let's the user select new technology for research if the current research projects are finished
extern void checkForNewResearch( Player& player );


#endif
