/*
 * Argus Software.  Common include files - Parser
 * Copyright (C) 2000-2006 QoSient, LLC.
 * All Rights Reserved
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* 
 * $Id: $
 * $DateTime: $
 * $Change: $
 */


#if !defined(Argus_parser_h)
#define Argus_parser_h

#include <argus_def.h>
#include <argus_out.h>

#define ARGUS_PRINTSRC	0x0001
#define ARGUS_PRINTDST	0x0002
#define ARGUS_ACTTIME	0x0004
#define ARGUS_IDLETIME	0x0008
#define ARGUS_DIST	0x0010

#define ARGUS_PRINTGMT	0x0020
#define ARGUS_PRINTNET	0x0022

 
#define ARGUS_ENCODE_ASCII       0
#define ARGUS_ENCODE_64          1
#define ARGUS_ENCODE_32          2

#define ARGUS_MAX_S_OPTIONS      34 
#define HASHNAMESIZE		256

#include <netinet/in.h>
 
struct h6namemem {
   struct in6_addr addr; 
   char *name; 
   struct h6namemem *nxt; 
}; 
 
struct hnamemem { 
   u_int addr; 
   char *name; 
   struct hnamemem *nxt; 
}; 

struct enamemem {
   u_short e_addr0; 
   u_short e_addr1; 
   u_short e_addr2; 
   char *e_name; 
   u_char *e_nsap;         /* used only for nsaptable[] */ 
   struct enamemem *e_nxt; 
}; 
 
 
struct protoidmem { 
   u_int p_oui; 
   u_short p_proto; 
   char *p_name; 
   struct protoidmem *p_nxt;
};

 
struct ArgusCIDRAddr {
   u_char type, len, masklen, pad; 
   u_int addr[4];
};

struct ArgusParserStruct {
   int status;
   char fflag, nflag, tflag, uflag, Wflag;
   char Iflag, Tflag, rflag, Rflag, Sflag, xflag;
   char Xflag, XMLflag, zflag, Zflag;

   int RaCumulativeMerge, RaFlowMajorModified;
   int RaAllocHashTableHealers, RaAllocArgusRecord;
   int RaThisActiveIndex, RaThisFlowNum;
   int RaThisModelNum, RaParseError;

   char *RaFlowModelFile, *ArgusFlowModelFile, *ArgusRemoteFilter;
   struct RaFlowModelStruct *RaFlowModel;

   struct ArgusCIDRAddr ArgusCIDRBuffer, *ArgusCIDRPtr;

   struct ArgusModeStruct *ArgusModeList;
   struct ArgusInput *ArgusCurrentInput;

   int ArgusFilterFiledes[2];
   int ArgusControlFiledes[2];
 
   unsigned int f_localnet, f_netmask;
   struct protoidmem protoidtable[HASHNAMESIZE];
   struct enamemem enametable[HASHNAMESIZE]; 
   struct enamemem nsaptable[HASHNAMESIZE]; 

 #define ARGUS_MAXEPROTODB   0x10000
   struct ArgusEtherTypeStruct *argus_eproto_db[ARGUS_MAXEPROTODB];
  
   struct h6namemem h6nametable[HASHNAMESIZE];
   struct hnamemem  hnametable[HASHNAMESIZE];
   struct hnamemem  tporttable[HASHNAMESIZE];
   struct hnamemem  uporttable[HASHNAMESIZE];
   struct hnamemem  eprototable[HASHNAMESIZE];
   struct hnamemem  nnametable[HASHNAMESIZE];
   struct hnamemem  llcsaptable[HASHNAMESIZE];
};

#if defined(ArgusParser)
struct ArgusParserStruct *ArgusNewParser(char *);
#else
extern struct ArgusParserStruct *ArgusNewParser(char *);
#endif

#endif
