%{
/*
 * Argus Software.  Common utilities - compiler scanner
 * Copyright (C) 2000-2006 QoSient, LLC.
 * All Rights Reserved
 *
 * QOSIENT, LLC DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL QOSIENT, LLC BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 *
 */

/*
 * Copyright (c) 1988, 1989, 1990, 1991, 1992, 1993, 1994
 *   The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: (1) source code distributions
 * retain the above copyright notice and this paragraph in its entirety, (2)
 * distributions including binary code include the above copyright notice and
 * this paragraph in its entirety in the documentation or other materials
 * provided with the distribution, and (3) all advertising materials mentioning
 * features or use of this software display the following acknowledgement:
 * ``This product includes software developed by the University of California,
 * Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
 * the University nor the names of its contributors may be used to endorse
 * or promote products derived from this software without specific prior
 * written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */



#include <unistd.h>
#include <sys/types.h>

#include <ctype.h>
#include <string.h>
#include <compat.h>

#include <argus_namedb.h>

#include <sys/time.h>


#include <argus_def.h>
#include <argus_out.h>
#include <argus_parser.h>
#include <argus_filter.h>
#include <tokdefs.h>
#include <syslog.h>

extern void ArgusLog (int, char *, ...);

#if !defined(__GNUC__)
#define inline
#endif

int argus_lex(void);
int stoi(char *);
static inline int xdtoi(int);

#if defined(FLEX_SCANNER)
#define YY_NO_UNPUT
static YY_BUFFER_STATE in_buffer;
#else
static char *in_buffer;
 
#undef getc
#define getc(fp)  (*in_buffer == 0 ? EOF : *in_buffer++)
#endif
 
#define yylval argus_lval
extern YYSTYPE yylval;
%}

N      ([0-9]+|(0X|0x)[0-9A-Fa-f]+)
B      ([0-9A-Fa-f][0-9A-Fa-f]?)
V6     ([0-9A-Fa-f:.]+) 
                         

%a 3000

%%
start      return START;
stop      return STOP;
status      return STATUS;
shut      return SHUTDOWN;
error      return ERROR;

dst      return DST;
src      return SRC;

link|ether|ppp|slip  return LINK;
fddi     return LINK;
arp      return ARP;
rarp     return RARP;
ip       return IP;
ipv4     return IPV4;
ipv6     return IPV6;
tcp      return TCP;
udp      return UDP;
rtp      return RTP;
rtcp     return RTCP;
man      return MAN;
icmp     return ICMP;
igmp     return IGMP;
mpls     return MPLS;
vlan     return VLAN;
vid      return VID;
vpri     return VPRI;
mid      return MPLSID;
anon     return ANON;

test     return TEST;
host     return HOST;
srcid    return SRCID;
net      return NET;
mask     return ARGUSMASK;
port     return PORT;
proto    return PROTO;

ttl      return TTL;
tos      return TOS;

gateway  return GATEWAY;

eq       return EQUAL;
equal    return EQUAL;
lt       return LESS;
less     return LESS;
gt       return GREATER;
greater  return GREATER;
byte     return BYTE;
broadcast return TK_BROADCAST;
multicast return TK_MULTICAST;

and|"&&"  return AND;
or|"||"   return OR;
not       return '!';

len|length   return LEN;
inbound      return INBOUND;
outbound     return OUTBOUND;

syn          return SYN;
synack       return SYNACK;
data         return DATA;
fin          return FIN;
finack       return FINACK;
urg          return URGENT;
ack          return ACK;
push         return PUSH;

rtr          return RTR;
mbr          return MBR;
lvg          return LVG;

reset        return RESET;
normal       return NORMAL;
wait         return WAIT;
timeout      return TIMEDOUT;
est          return ESTABLISHED;
con          return CONNECTED;
cor          return CORRELATED;
corolated    return CORRELATED;

ecn          return ECN;
drop         return RETRANS;
retrans      return RETRANS;
outoforder   return OUTOFORDER;
ooo          return OUTOFORDER;
multipath    return MULTIPATH;
mpath        return MULTIPATH;
winshut      return WINSHUT;
frag         return FRAG;
fragonly     return FRAG_ONLY;

icmpmap      return ICMPMAP;
echo         return ICMPECHO;
unreach      return UNREACH;
redirect     return REDIRECT;
timexed      return TIMEXED;

[ \n\t]         ;
[+\-*/:\[\]!<>()&|=]   return yytext[0];
">="         return GEQ;
"<="         return LEQ;
"!="         return NEQ;
"=="         return '=';
"<<"         return LSH;
">>"         return RSH;
{N}         { yylval.i = stoi((char *)yytext); return NUM; }
({N}\.{N})|({N}\.{N}\.{N})|({N}\.{N}\.{N}\.{N})   {
         yylval.s = Argussdup((char *)yytext); return HID; }
{B}:{B}:{B}:{B}:{B}:{B} { yylval.e = argus_ether_aton((char *)yytext);
           return EID; }
{V6}	{
         yylval.s = Argussdup((char *)yytext); return HIDV6; }
[A-Za-z0-9][-_.A-Za-z0-9]*[.A-Za-z0-9] {
         yylval.s = Argussdup((char *)yytext); return ID; }
"\\"[^ !()\n\t]+   { yylval.s = Argussdup((char *)yytext + 1); return ID; }
[^ \[\]\t\n\-_.A-Za-z0-9!<>()&|=]+i {
         ArgusLog(LOG_ERR, "illegal token: %s\n", yytext); }
.         { ArgusLog (LOG_ERR, "illegal char '%c'", *yytext); }

%%
void
argus_lex_init(char *buf)
{
#if defined(FLEX_SCANNER)
   in_buffer = yy_scan_string(buf);
#else 
   in_buffer = buf;
#endif 
}

/*
 * Also define a yywrap.  Note that if we're using flex, it will
 * define a macro to map this identifier to pcap_wrap.
 */
int
yywrap()
{
   return 1;
}

/* Hex digit to integer. */
static inline int
xdtoi(c)
int c;
{
   if (isdigit(c))
      return c - '0';
   else if (islower(c))
      return c - 'a' + 10;
   else
      return c - 'A' + 10;
}

/*
 * Convert string to integer.  Just like atoi(), but checks for
 * preceding 0x or 0 and uses hex or octal instead of decimal.
 */
int
stoi(s)
char *s;
{
   int base = 10;
   int n = 0;

   if (*s == '0') {
      if (s[1] == 'x' || s[1] == 'X') {
         s += 2;
         base = 16;
      }
      else {
         base = 8;
         s += 1;
      }
   }
   while (*s)
      n = n * base + xdtoi(*s++);

   return n;
}

