%{
/*
 * Argus Software
 * Copyright (c) 2000-2006 QoSient, LLC
 * All rights reserved.
 *
 * QOSIENT, LLC DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL QOSIENT, LLC BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 *
 */

/*
 * Copyright (c) 1988, 1989, 1990, 1991, 1992, 1993, 1994
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: (1) source code distributions
 * retain the above copyright notice and this paragraph in its entirety, (2)
 * distributions including binary code include the above copyright notice and
 * this paragraph in its entirety in the documentation or other materials
 * provided with the distribution, and (3) all advertising materials mentioning
 * features or use of this software display the following acknowledgement:
 * ``This product includes software developed by the University of California,
 * Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
 * the University nor the names of its contributors may be used to endorse
 * or promote products derived from this software without specific prior
 * written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 */


#include <compat.h>
#include <sys/types.h>

#if defined(HAVE_SOLARIS) || defined(__FreeBSD__) || defined(__NetBSD__) || defined(__OpenBSD__)
#include <sys/socket.h>
#endif

#include <stdlib.h>
#include <sys/time.h>
#include <net/if.h>

#include <argus_def.h>
#include <argus_out.h>
#include <argus_parser.h>
#include <argus_client.h>
#include <argus_filter.h>

#include <argus_ethertype.h>
#include <syslog.h>

extern void ArgusLog (int, char *, ...);

#define YYDEBUG		2

#define QSET(q, p, d, a) (q).proto = (p),\
			 (q).dir = (d),\
			 (q).addr = (a)

int argus_n_errors = 0;

static struct qual qerr = { Q_UNDEF, Q_UNDEF, Q_UNDEF};

static void
yyerror(char *msg)
{
   ++argus_n_errors;
   exit(1);
	/* NOTREACHED */
}

/*
#ifndef YYBISON
argus_parse()
{
	return (yyparse());
}
#endif
*/

%}

%union {
	int i;
	u_long h;
	u_char *e;
	char *s;
	struct stmt *stmt;
	struct arth *a;
	struct {
		struct qual q;
		struct ablock *b;
	} blk;
	struct ablock *rblk;
}

%type	<blk>	expr id nid pid term rterm qid tid
%type	<blk>	head thead
%type	<i>	pqual dqual aqual iqual ndaqual
%type	<a>	arth narth
%type	<i>	pname sname tname pnum relop irelop
%type	<blk>	and or paren not null prog
%type	<rblk>	other

%token  START STOP STATUS SHUTDOWN ERROR
%token  DST SRC HOST GATEWAY TEST IPID TTL TOS SRCID TCPBASE
%token  NET ARGUSMASK PORT EQUAL LESS GREATER PROTO BYTE PKT
%token  ARP RARP IP IPV4 IPV6 TCP UDP ICMP IGMP MAN
%token  MPLS VLAN ANON VID VPRI MPLSID QRY
%token  RTP RTCP ESP DECNET LAT MOPRC MOPDL
%token  TK_BROADCAST TK_MULTICAST FRAG FRAG_ONLY
%token  NUM INBOUND OUTBOUND
%token  LINK
%token	GEQ LEQ NEQ
%token	ID EID HID HIDV6
%token	LSH RSH
%token  LEN

%token  OUTOFORDER RETRANS NORMAL WAIT MULTIPATH RESET TIMEDOUT WINSHUT
%token  SYN SYNACK ACK PUSH URGENT DATA FIN FINACK ICMPECHO ICMPMAP
%token  UNREACH REDIRECT ECN TIMEXED ESTABLISHED CONNECTED CORRELATED
%token  RTR MBR LVG

%type	<s> ID
%type	<e> EID
%type	<s> HID
%type	<s> HIDV6
%type	<i> NUM

%left OR AND
%nonassoc  '!'
%left '|'
%left '&'
%left LSH RSH
%left '+' '-'
%left '*' '/'
%nonassoc UMINUS
%%
prog:	  null expr
{
	Argusfinish_parse($2.b);
}
	| null
	;
null:	  /* null */		{ $$.q = qerr; }
	;
expr:	  term
	| expr and term		{ Argusgen_and($1.b, $3.b); $$ = $3; }
	| expr and id		{ Argusgen_and($1.b, $3.b); $$ = $3; }
	| expr or term		{ Argusgen_or($1.b, $3.b); $$ = $3; }
	| expr or id		{ Argusgen_or($1.b, $3.b); $$ = $3; }
	;
and:	  AND			{ $$ = $<blk>0; }
	;
or:	  OR			{ $$ = $<blk>0; }
	;
id:	  nid
	| pnum			{ $$.b = Argusgen_ncode(NULL, (arg_uint32)$1, $$.q = $<blk>0.q, Q_EQUAL); }
	| LESS pnum		{ $$.b = Argusgen_ncode(NULL, (arg_uint32)$2, $$.q = $<blk>0.q, Q_LESS); }
	| GREATER pnum		{ $$.b = Argusgen_ncode(NULL, (arg_uint32)$2, $$.q = $<blk>0.q, Q_GREATER); }
	| EQUAL pnum		{ $$.b = Argusgen_ncode(NULL, (arg_uint32)$2, $$.q = $<blk>0.q, Q_EQUAL); }
	| paren pid ')'		{ $$ = $2; }
	;
tid:	  tname			{ $$.b = Argusgen_tcode($1, $$.q = $<blk>0.q); }
	;
nid:	  ID			{ $$.b = Argusgen_scode($1, $$.q = $<blk>0.q); }
	| HID '/' NUM		{ $$.q = $<blk>0.q; $$.q.proto = Q_IP;
                                  $$.b = Argusgen_mcode($1, NULL, $3, $$.q); }
	| HID ARGUSMASK HID	{ $$.q = $<blk>0.q; $$.q.proto = Q_IP;
                                  $$.b = Argusgen_mcode($1, $3, 0, $$.q); }
	| HID			{ $$.q = $<blk>0.q; $$.q.proto = Q_IP;
                                  $$.b = Argusgen_ncode($1, 0, $$.q, Q_EQUAL); }
	| HIDV6 '/' NUM		{ $$.q = $<blk>0.q; $$.q.proto = Q_IPV6;
                                  $$.b = Argusgen_mcode($1, NULL, $3, $$.q); }
	| HIDV6			{ $$.q = $<blk>0.q; $$.q.proto = Q_IPV6;
                                  $$.b = Argusgen_ncode($1, 0, $$.q, Q_EQUAL); }
	| EID			{ $$.b = Argusgen_ecode($1, $$.q = $<blk>0.q); }
	| not id		{ Argusgen_not($2.b); $$ = $2; }
	;
not:	  '!'			{ $$ = $<blk>0; }
	;
paren:	  '('			{ $$ = $<blk>0; }
	;
pid:	  nid
	| qid and id		{ Argusgen_and($1.b, $3.b); $$ = $3; }
	| qid or id		{ Argusgen_or($1.b, $3.b); $$ = $3; }
	;
qid:	  pnum			{ $$.b = Argusgen_ncode(NULL, (arg_uint32)$1, $$.q = $<blk>0.q, Q_EQUAL); }
	| pid
	;
term:	  rterm
	| not term		{ Argusgen_not($2.b); $$ = $2; }
	;
head:	  pqual dqual aqual	{ QSET($$.q, $1, $2, $3); }
	| pqual dqual		{ QSET($$.q, $1, $2, Q_DEFAULT); }
	| pqual aqual		{ QSET($$.q, $1, Q_DEFAULT, $2); }
	| pqual iqual 		{ QSET($$.q, $1, Q_DEFAULT, $2); }
	| pqual dqual iqual 	{ QSET($$.q, $1, $2, $3); }
	| pqual PROTO		{ QSET($$.q, $1, Q_DEFAULT, Q_PROTO); }
	| pqual ndaqual		{ QSET($$.q, $1, Q_DEFAULT, $2); }
	;

thead:	  pqual dqual		{ QSET($$.q, $1, $2, Q_DEFAULT); }
	;

rterm:	  head id		{ $$ = $2; }
	| thead tid		{ $$ = $2; }
	| paren expr ')'	{ $$.b = $2.b; $$.q = $1.q; }
	| pname			{ $$.b = Argusgen_proto_abbrev($1); $$.q = qerr; }
	| sname			{ $$.b = Argusgen_proto_abbrev($1); $$.q = qerr; }
	| DATA			{ $$.b = Argusgen_appbytes(Q_DATA, Q_DEFAULT, Q_DEFAULT); $$.q = qerr; }
	| pqual dqual DATA	{ $$.b = Argusgen_appbytes(Q_DATA, $1, $2); $$.q = qerr; }
	| tid			{ $$ = $1; }
	| arth relop arth	{ $$.b = Argusgen_relation($2, $1, $3, 0);
				  $$.q = qerr; }
	| arth irelop arth	{ $$.b = Argusgen_relation($2, $1, $3, 1);
				  $$.q = qerr; }
	| other			{ $$.b = $1; $$.q = qerr; }
	;
/* protocol level qualifiers */
pqual:	  pname
	|			{ $$ = Q_DEFAULT; }
	;
/* 'direction' qualifiers */
dqual:	  SRC			{ $$ = Q_SRC; }
	| DST			{ $$ = Q_DST; }
	| SRC OR DST		{ $$ = Q_OR; }
	| DST OR SRC		{ $$ = Q_OR; }
	| SRC AND DST		{ $$ = Q_AND; }
	| DST AND SRC		{ $$ = Q_AND; }
	;
/* address type qualifiers */
aqual:	  HOST			{ $$ = Q_HOST; }
	| SRCID			{ $$ = Q_SRCID; }
	| NET			{ $$ = Q_NET; }
	;
/* identifier types */
iqual:    PORT			{ $$ = Q_PORT; }
	| IPID			{ $$ = Q_IPID; }
	| TTL			{ $$ = Q_TTL; }
	| TOS			{ $$ = Q_TOS; }
	| VID			{ $$ = Q_VID; }
	| VPRI			{ $$ = Q_VPRI; }
	| MPLSID		{ $$ = Q_MPLSID; }
	| BYTE			{ $$ = Q_BYTE; }
	| PKT			{ $$ = Q_PKT; }
	| TCPBASE		{ $$ = Q_TCPBASE; }
	;
/* non-directional address type qualifiers */
ndaqual:  GATEWAY		{ $$ = Q_GATEWAY; }
	;

sname:	  START			{ $$ = Q_START; }
	| STOP			{ $$ = Q_STOP; }
	| STATUS		{ $$ = Q_STATUS; }
	| SHUTDOWN		{ $$ = Q_SHUTDOWN; }
	| ERROR			{ $$ = Q_ERROR; }
	| MAN			{ $$ = Q_MAN; }
        | NORMAL		{ $$ = Q_NORMAL; }
        | WAIT			{ $$ = Q_WAIT; }
	| MULTIPATH		{ $$ = Q_MULTIPATH; }
	| ESTABLISHED		{ $$ = Q_ESTABLISHED; }
	| CONNECTED		{ $$ = Q_CONNECTED; }
	| CORRELATED		{ $$ = Q_CORRELATED; }
	| TIMEDOUT		{ $$ = Q_TIMEDOUT; }
	| SYN			{ $$ = Q_SYN; }
	| SYNACK		{ $$ = Q_SYNACK; }
	| FIN			{ $$ = Q_FIN; }
	| FINACK		{ $$ = Q_FINACK; }
	| ICMPMAP		{ $$ = Q_ICMPMAP; }
	| ICMPECHO		{ $$ = Q_ECHO; }
	| UNREACH		{ $$ = Q_UNREACH; }
	| REDIRECT		{ $$ = Q_REDIRECT; }
	| TIMEXED 		{ $$ = Q_TIMEXED; }
	| RTR			{ $$ = Q_RTR; }
	| MBR			{ $$ = Q_MBR; }
	| LVG			{ $$ = Q_LVG; }
	;

pname:	  LINK			{ $$ = Q_LINK; }
	| IP			{ $$ = Q_IP; }
	| IPV4			{ $$ = Q_IPV4; }
	| IPV6			{ $$ = Q_IPV6; }
	| ARP			{ $$ = Q_ARP; }
	| RARP			{ $$ = Q_RARP; }
	| ESP			{ $$ = Q_ESP; }
	| RTP			{ $$ = Q_RTP; }
	| RTCP			{ $$ = Q_RTCP; }
	| TCP			{ $$ = Q_TCP; }
	| UDP			{ $$ = Q_UDP; }
	| ICMP			{ $$ = Q_ICMP; }
	| IGMP			{ $$ = Q_IGMP; }
	| MPLS			{ $$ = Q_MPLS; }
	| VLAN			{ $$ = Q_VLAN; }
	| ANON			{ $$ = Q_ANON; }
	| DECNET		{ $$ = Q_DECNET; }
	| LAT			{ $$ = Q_LAT; }
	| MOPDL			{ $$ = Q_MOPDL; }
	| MOPRC			{ $$ = Q_MOPRC; }
	;

tname:	  OUTOFORDER		{ $$ = Q_OUTOFORDER; }
	| RETRANS		{ $$ = Q_RETRANS; }
	| WINSHUT		{ $$ = Q_WINSHUT; }
	| RESET			{ $$ = Q_RESET; }
	| ACK			{ $$ = Q_ACK; }
	| PUSH			{ $$ = Q_PUSH; }
	| URGENT		{ $$ = Q_URGENT; }
	| FRAG			{ $$ = Q_FRAG; }
	| FRAG_ONLY		{ $$ = Q_FRAG_ONLY; }
	| ECN			{ $$ = Q_ECN; }
	;

other:	  pqual TK_BROADCAST	{ $$ = Argusgen_broadcast($1); }
	| pqual TK_MULTICAST	{ $$ = Argusgen_multicast($1); }
	| INBOUND		{ $$ = Argusgen_inbound(0); }
	| OUTBOUND		{ $$ = Argusgen_inbound(1); }
	;
relop:	  '>'			{ $$ = NFF_JGT; }
	| GEQ			{ $$ = NFF_JGE; }
	| '='			{ $$ = NFF_JEQ; }
	| EQUAL			{ $$ = NFF_JEQ; }
	;
irelop:	  LEQ			{ $$ = NFF_JGT; }
	| '<'			{ $$ = NFF_JGE; }
	| NEQ			{ $$ = NFF_JEQ; }
	;
arth:	  pnum			{ $$ = Argusgen_loadi($1); }
	| narth
	;
narth:	  pname '[' arth ']'		{ $$ = Argusgen_load($1, $3, 1); }
	| pname '[' arth ':' NUM ']'	{ $$ = Argusgen_load($1, $3, $5); }
	| arth '+' arth			{ $$ = Argusgen_arth(NFF_ADD, $1, $3); }
	| arth '-' arth			{ $$ = Argusgen_arth(NFF_SUB, $1, $3); }
	| arth '*' arth			{ $$ = Argusgen_arth(NFF_MUL, $1, $3); }
	| arth '/' arth			{ $$ = Argusgen_arth(NFF_DIV, $1, $3); }
	| arth '&' arth			{ $$ = Argusgen_arth(NFF_AND, $1, $3); }
	| arth '|' arth			{ $$ = Argusgen_arth(NFF_OR, $1, $3); }
	| arth LSH arth			{ $$ = Argusgen_arth(NFF_LSH, $1, $3); }
	| arth RSH arth			{ $$ = Argusgen_arth(NFF_RSH, $1, $3); }
	| '-' arth %prec UMINUS		{ $$ = Argusgen_neg($2); }
	| paren narth ')'		{ $$ = $2; }
	| LEN				{ $$ = Argusgen_loadlen(); }
	;
pnum:	  NUM
	| paren pnum ')'	{ $$ = $2; }
	;
%%
