/*
 * Argus Software.  Argus files - Output include file
 * Copyright (c) 2000-2006 QoSient, LLC
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* 
 * $Id: $
 * $DateTime: $
 * $Change: $
 */


#ifndef ArgusOutput_h
#define ArgusOutput_h

#define ARGUS_MONITORPORT	561
#define ARGUS_MAXLISTEN		16

#include <unistd.h>
#include <stdlib.h>
#include <limits.h>

#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <strings.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>

#if defined(__NetBSD__)
#include <sys/sched.h>
#else
#include <sched.h>
#endif

#include <fcntl.h>
#include <signal.h>

#include <pcap.h>
#include <argus_filter.h>

#ifdef ARGUS_SASL
#include <sasl.h>
#endif


struct ArgusClientData {
   int fd, ArgusClientStart, ArgusFilterInitialized;
   struct ArgusSocketStruct *sock;
   struct bpf_program ArgusBPFcode;
   char *filename, *filter;


#ifdef ARGUS_SASL
   sasl_conn_t *sasl_conn;
#endif
};

struct ArgusOutputStruct {
   int status;

#if defined(ARGUS_THREADS)
   pthread_t thread;
   pthread_mutex_t lock;
#endif

   struct ArgusSourceStruct *ArgusSrc;
   struct ArgusModelerStruct *ArgusModel;
   struct ArgusListStruct *ArgusWfileList;
   struct ArgusListStruct *ArgusOutputList;
   struct ArgusClientData clients[ARGUS_MAXLISTEN];
   struct ArgusRecord *ArgusInitMar;

   long long ArgusTotalRecords, ArgusLastRecords;
   int clientnum, clientindex;
   int ArgusWriteStdOut;
   int ArgusOutputSequence;
   int ArgusPortNum;
   int ArgusLfd;
   int nflag;
 
   char *ArgusBindAddr;

   struct timeval ArgusGlobalTime;
   struct timeval ArgusStartTime;
   struct timeval ArgusReportTime;
   struct timeval ArgusLastMarUpdateTime;
   struct timeval ArgusMarReportInterval;
};

struct ArgusWfileStruct {
   struct ArgusListObjectStruct *nxt;
   char *filename;
   char *filter;
};


#if defined(ArgusOutput)

struct ArgusOutputStruct *ArgusOutputTask = NULL;

struct ArgusOutputStruct * ArgusNewOutput (struct ArgusSourceStruct *, struct ArgusModelerStruct *);
void ArgusCloseOutput (struct ArgusOutputStruct *);
 
void ArgusInitOutput (struct ArgusOutputStruct *);
void ArgusInitOutputProcess(void);

void *ArgusOutputProcess(void *);

int ArgusEstablishListen (struct ArgusOutputStruct *, char *);
int  ArgusTcpWrapper (int, struct sockaddr *);

void ArgusUsr1Sig (int);
void ArgusUsr2Sig (int);
void ArgusChildExit (int);

void ArgusClientError(void);
void ArgusInitClientProcess(struct ArgusClientData *, struct ArgusWfileStruct *);

extern int ArgusFilterCompile(struct bpf_program *, char *, int);
extern unsigned int argus_filter (struct bpf_insn *, unsigned char *);
extern int getArgusPortNum(void);

#else

#if defined(Argus)
int getArgusPortNum(struct ArgusOutputStruct *);
void setArgusPortNum(struct ArgusOutputStruct *, int);
 
void setArgusBindAddr (struct ArgusOutputStruct *, char *);
char *getArgusBindAddr (struct ArgusOutputStruct *);
#endif

extern struct timeval ArgusReportTime;
extern int ArgusPortNum;
extern char *ArgusBindAddr;
extern int ArgusLfd;
extern int ArgusOutfd;

extern struct ArgusOutputStruct *ArgusOutputTask;
extern struct ArgusOutputStruct * ArgusNewOutput (struct ArgusSourceStruct *, struct ArgusModelerStruct *);
extern void ArgusCloseOutput (struct ArgusOutputStruct *);

extern void ArgusInitOutput (struct ArgusOutputStruct *);
extern void ArgusInitOutputProcess(void);

extern void ArgusSendOutputData(int, struct ArgusRecord *);
extern int ArgusHandleData(struct ArgusSocketStruct *, unsigned char *, int, void *);
extern int ArgusHandleClientData(struct ArgusSocketStruct *, unsigned char *, int, void *);

extern void ArgusOutputProcess(void *);
extern void *ArgusClientProcess(struct ArgusClientData *, struct ArgusWfileStruct *);

extern int getArgusLfd(void);
extern void setArgusLfd(int);

extern char *getArgusWfile(void);
extern void setArgusWfile(char *, char *);

extern struct timeval *getArgusMarReportInterval(struct ArgusOutputStruct *);
extern void setArgusMarReportInterval(struct ArgusOutputStruct *, char *);

extern void ArgusCheckClientStatus (void);

extern int ArgusEstablishListen (struct ArgusOutputStruct *, char *);
extern int  ArgusTcpWrapper (int, struct sockaddr *);

extern void ArgusCloseSocket (int);
extern void ArgusCloseClients (void);

extern void ArgusUsr1Sig (int);
extern void ArgusUsr2Sig (int);

extern void ArgusClientError(void);
extern void ArgusInitClientProcess(struct ArgusClientData *, struct ArgusWfileStruct *);

#endif
#endif /* #ifndef ArgusOutput_h */

