/*
 * Argus Software.  Argus files - ESP layer processing
 * Copyright (c) 2000-2006 QoSient, LLC
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* 
 * $Id: $
 * $DateTime: $
 * $Change: $
 */

#if !defined(ArgusEsp)
#define ArgusEsp
#endif


#include <stdio.h>
#include <ArgusModeler.h>

#include <errno.h>
#include <string.h>


struct esphdr {
   unsigned int spi, seq;
};


struct ArgusSystemFlow *
ArgusCreateESPv6Flow (struct ArgusModelerStruct *model, struct ip6_hdr *ip)
{
   struct ArgusSystemFlow *retn = NULL;
/*
   struct esphdr *esp = (struct esphdr *) model->ArgusThisUpHdr;

struct ArgusESPv6Flow {
   unsigned int ip_src[4], ip_dst[4];
#if defined(_LITTLE_ENDIAN)
   unsigned int flow:20;
   unsigned int resv:4;
   unsigned int ip_p:8;
#else
   unsigned int ip_p:8;
   unsigned int resv:4;
   unsigned int flow:20;
#endif 
   unsigned int spi;
};
*/

#ifdef ARGUSDEBUG
   ArgusDebug (4, "ArgusCreateESPv6Flow(0x%x) returning %d\n", ip, retn);
#endif 

   return (retn);
}

struct ArgusSystemFlow *
ArgusCreateESPFlow (struct ArgusModelerStruct *model, struct ip *ip)
{
   struct ArgusSystemFlow *retn = NULL;
   struct esphdr *esp = (struct esphdr *) model->ArgusThisUpHdr;

   if (STRUCTCAPTURED(model, *esp)) {
      struct ArgusESPFlow *espFlow = &model->ArgusThisFlow->esp_flow;
 
      retn = model->ArgusThisFlow;
      model->state &= ~ARGUS_DIRECTION;
 
      retn->hdr.type             = ARGUS_FLOW_DSR;
      retn->hdr.subtype          = ARGUS_FLOW_CLASSIC5TUPLE;
      retn->hdr.argus_dsrvl8.qual = ARGUS_TYPE_IPV4;
      retn->hdr.argus_dsrvl8.len  = 5;

      espFlow->ip_src = ip->ip_src.s_addr;
      espFlow->ip_dst = ip->ip_dst.s_addr;
      espFlow->ip_p   = ip->ip_p;
      espFlow->pad    = 0;
      espFlow->spi    = ntohl(esp->spi);
   }

#ifdef ARGUSDEBUG
  ArgusDebug (4, "ArgusCreateESPFlow(0x%x) returning 0x%x\n", ip, retn);
#endif 

   return (retn);
}

void ArgusUpdateESPState (struct ArgusModelerStruct *, struct ArgusFlowStruct *, unsigned char *);

void
ArgusUpdateESPState (struct ArgusModelerStruct *model, struct ArgusFlowStruct *flowstr, unsigned char *state)
{
   struct ArgusNetworkStruct *net = (struct ArgusNetworkStruct *) &flowstr->canon.net;
   struct esphdr *esp = (struct esphdr *) model->ArgusThisUpHdr;
   struct ArgusESPObject *espObj = &net->net_union.esp;

   if (STRUCTCAPTURED(model, *esp)) {
#ifdef _LITTLE_ENDIAN
      esp->spi = ntohl(esp->spi);
      esp->seq = ntohl(esp->seq);
#endif 
      if (*state == ARGUS_START) {
         net->hdr.type             = ARGUS_NETWORK_DSR;
         net->hdr.subtype          = ARGUS_ESP_DSR;
         net->hdr.argus_dsrvl8.qual = 0;
         net->hdr.argus_dsrvl8.len  = ((sizeof(struct ArgusESPObject)+3))/4 + 1;

         flowstr->dsrs[ARGUS_NETWORK_INDEX] = (void *) net;

         bzero ((char *)espObj, sizeof(*espObj));
         flowstr->timeout = ARGUS_IPTIMEOUT;

         espObj->spi     = esp->spi;
         espObj->lastseq = esp->seq;
         
      } else {

#define ARGUS_ESP_SEQ_IPID	0x01

         if (espObj->status & ARGUS_ESP_SEQ_IPID) {
            if (espObj->lastseq && ((((struct ip *)model->ArgusThisIpHdr)->ip_id != (espObj->lastseq + 1)))) {
               espObj->lostseq++;
               espObj->status |= ARGUS_SRC_PKTS_DROP;
            }

            espObj->lastseq = ((struct ip *)model->ArgusThisIpHdr)->ip_id;
            
         } else {
            if (espObj->lastseq && (esp->seq != (espObj->lastseq + 1))) {
               if (espObj->lastseq == esp->seq) {
                  espObj->status |= ARGUS_ESP_SEQ_IPID;
                  espObj->lastseq = ((struct ip *)model->ArgusThisIpHdr)->ip_id;
                  
               } else {
                  espObj->lostseq++;
                  espObj->status |= ARGUS_SRC_PKTS_DROP;
                  espObj->lastseq = esp->seq;
               }

            } else
               espObj->lastseq = esp->seq;
         }
      }
   }
   
#ifdef ARGUSDEBUG
   ArgusDebug (8, "ArgusUpdateESPState(0x%x, %d) returning\n", flowstr, *state);
#endif 
}


#include <argus_out.h>

void ArgusESPFlowRecord (struct ArgusNetworkStruct *net, unsigned char state);

void
ArgusESPFlowRecord (struct ArgusNetworkStruct *net, unsigned char state)
{
#ifdef ARGUSDEBUG
   ArgusDebug (4, "ArgusESPFlowRecord(0x%x, %d) returning\n", net, state);
#endif 
}
