dnl
dnl Copyright (C) 2000-2006 QoSient, LLC.
dnl
dnl Copyright (c) 1995, 1996, 1997, 1998
dnl   The Regents of the University of California.  All rights reserved.
dnl
dnl Redistribution and use in source and binary forms, with or without
dnl modification, are permitted provided that: (1) source code distributions
dnl retain the above copyright notice and this paragraph in its entirety, (2)
dnl distributions including binary code include the above copyright notice and
dnl this paragraph in its entirety in the documentation or other materials
dnl provided with the distribution, and (3) all advertising materials mentioning
dnl features or use of this software display the following acknowledgement:
dnl ``This product includes software developed by the University of California,
dnl Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
dnl the University nor the names of its contributors may be used to endorse
dnl or promote products derived from this software without specific prior
dnl written permission.
dnl THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
dnl WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
dnl MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
dnl
dnl QOSIENT and LBL autoconf macros
dnl
dnl
dnl Check for flex require flex 2.4 or higher
dnl Check for bison define the yy prefix string
dnl
dnl usage:
dnl
dnl   AC_QOSIENT_LEX_AND_YACC(lex, yacc, yyprefix)
dnl
dnl results:
dnl
dnl   $1 (lex set)
dnl   $2 (yacc appended)
dnl   $3 (optional flex and bison -P prefix)
dnl
AC_DEFUN(AC_QOSIENT_LEX_AND_YACC,
   [AC_CHECK_PROGS($1, flex, lex)
   if test "$$1" = flex ; then
      AC_MSG_CHECKING(for flex 2.4 or higher)
      AC_CACHE_VAL(ac_cv_lbl_flex_v24,
         if flex -V >/dev/null 2>&1; then
            ac_cv_lbl_flex_v24=yes
         else
            ac_cv_lbl_flex_v24=no
         fi)
      AC_MSG_RESULT($ac_cv_lbl_flex_v24)
      if test $ac_cv_lbl_flex_v24 = no ; then
         s="2.4 or higher required"
         AC_MSG_WARN(ignoring obsolete flex executable ($s))
         $1=lex
      fi
   else
      AC_MSG_ERROR(flex not found. see the INSTALL for more info)
   fi

   AC_CHECK_PROGS($2, bison, yacc)

   if test "$$2" = bison ; then
      $2="$$2 -y"
   else
      AC_MSG_ERROR(bison not found. see the INSTALL for more info)
   fi

   if test "$$1" = flex -a -n "$3" ; then
      $1="$$1 -P$3"
      $2="$$2 -p $3"
   fi])

dnl
dnl Determine which compiler we're using (cc or gcc)
dnl If using gcc, determine the version number
dnl If using cc, require that it support ansi prototypes
dnl If using gcc, use -O3 (otherwise use -O)
dnl If using cc, explicitly specify /usr/local/include
dnl
dnl usage:
dnl
dnl   AC_LBL_C_INIT(copt, incls)
dnl
dnl results:
dnl
dnl   $1 (copt set)
dnl   $2 (incls set)
dnl   CC
dnl   LDFLAGS
dnl   ac_cv_lbl_gcc_vers
dnl   LBL_CFLAGS
dnl
AC_DEFUN(AC_LBL_C_INIT,
    [AC_PREREQ(2.12)
    AC_BEFORE([$0], [AC_PROG_CC])
    AC_BEFORE([$0], [AC_LBL_FIXINCLUDES])
    AC_BEFORE([$0], [AC_LBL_DEVEL])
    AC_BEFORE([$0], [AC_QOSIENT_DEBUG])
    AC_ARG_WITH(gcc, [  --without-gcc           don't use gcc])
    $1="-O"
    $2=""
    if test "${srcdir}" != "." ; then
       $2="-I\$(srcdir)"
    fi
    if test "${CFLAGS+set}" = set; then
       LBL_CFLAGS="$CFLAGS"
    fi
    if test -z "$CC" ; then
       case "$target_os" in

       bsdi*)
          AC_CHECK_PROG(SHLICC2, shlicc2, yes, no)
          if test $SHLICC2 = yes ; then
             CC=shlicc2
             export CC
          fi
          ;;
       esac
    fi
    if test -z "$CC" -a "$with_gcc" = no ; then
       CC=cc
       export CC
    fi
    AC_PROG_CC
    if test "$GCC" = yes ; then
       if test "$SHLICC2" = yes ; then
          ac_cv_lbl_gcc_vers=2
          $1="-O3"
       else
          AC_MSG_CHECKING(gcc version)
          AC_CACHE_VAL(ac_cv_lbl_gcc_vers,
         ac_cv_lbl_gcc_vers=`$CC -v 2>&1 | \
             sed -e '/^gcc version /!d' \
            -e 's/^gcc version //' \
            -e 's/ .*//' -e 's/^[[[^0-9]]]*//' \
            -e 's/\..*//'`)
          AC_MSG_RESULT($ac_cv_lbl_gcc_vers)
          if test $ac_cv_lbl_gcc_vers -gt 1 ; then
             $1="-O3"
          fi
       fi
    else
       AC_MSG_CHECKING(that $CC handles ansi prototypes)
       AC_CACHE_VAL(ac_cv_lbl_cc_ansi_prototypes,
      AC_TRY_COMPILE(
          [#include <sys/types.h>],
          [int frob(int, char *)],
          ac_cv_lbl_cc_ansi_prototypes=yes,
          ac_cv_lbl_cc_ansi_prototypes=no))
       AC_MSG_RESULT($ac_cv_lbl_cc_ansi_prototypes)
       if test $ac_cv_lbl_cc_ansi_prototypes = no ; then
          case "$target_os" in

          hpux*)
             AC_MSG_CHECKING(for HP-UX ansi compiler ($CC -Aa -D_HPUX_SOURCE))
             savedcflags="$CFLAGS"
             CFLAGS="-Aa -D_HPUX_SOURCE $CFLAGS"
             AC_CACHE_VAL(ac_cv_lbl_cc_hpux_cc_aa,
            AC_TRY_COMPILE(
                [#include <sys/types.h>],
                [int frob(int, char *)],
                ac_cv_lbl_cc_hpux_cc_aa=yes,
                ac_cv_lbl_cc_hpux_cc_aa=no))
             AC_MSG_RESULT($ac_cv_lbl_cc_hpux_cc_aa)
             if test $ac_cv_lbl_cc_hpux_cc_aa = no ; then
                AC_MSG_ERROR(see the INSTALL doc for more info)
             fi
             CFLAGS="$savedcflags"
             V_CCOPT="-Aa $V_CCOPT"
             AC_DEFINE(_HPUX_SOURCE,1,[needed on HP-UX])
             ;;

          *)
             AC_MSG_ERROR(see the INSTALL doc for more info)
             ;;
          esac
       fi
       $2="$$2 -I/usr/local/include"
       LDFLAGS="$LDFLAGS -L/usr/local/lib"

       case "$target_os" in

       irix*)
          V_CCOPT="$V_CCOPT -xansi -signed -g3"
          ;;

       osf*)
          V_CCOPT="$V_CCOPT -std1 -g3"
          ;;

       ultrix*)
          AC_MSG_CHECKING(that Ultrix $CC hacks const in prototypes)
          AC_CACHE_VAL(ac_cv_lbl_cc_const_proto,
         AC_TRY_COMPILE(
             [#include <sys/types.h>],
             [struct a { int b; };
             void c(const struct a *)],
             ac_cv_lbl_cc_const_proto=yes,
             ac_cv_lbl_cc_const_proto=no))
          AC_MSG_RESULT($ac_cv_lbl_cc_const_proto)
          if test $ac_cv_lbl_cc_const_proto = no ; then
             AC_DEFINE(const,)
          fi
          ;;
       esac
    fi
])


dnl
dnl Check whether a given format can be used to print 64-bit integers
dnl
AC_DEFUN(AC_LBL_CHECK_64BIT_FORMAT,
  [
    AC_MSG_CHECKING([whether %$1x can be used to format 64-bit integers])
    AC_RUN_IFELSE(
      [
	AC_LANG_SOURCE(
	  [[
#	    ifdef HAVE_INTTYPES_H
	    #include <inttypes.h>
#	    endif
#	    ifdef HAVE_SYS_BITYPES_H
            #include <sys/bitypes.h>
#	    endif
	    #include <stdio.h>
	    #include <sys/types.h>

	    main()
	    {
	      u_int64_t t = 1;
	      char strbuf[16+1];
	      sprintf(strbuf, "%016$1x", t << 32);
	      if (strcmp(strbuf, "0000000100000000") == 0)
		exit(0);
	      else
		exit(1);
	    }
	  ]])
      ],
      [
	AC_DEFINE(PRId64, "$1d")
	AC_DEFINE(PRIo64, "$1o")
	AC_DEFINE(PRIx64, "$1x")
	AC_DEFINE(PRIu64, "$1u")
	AC_MSG_RESULT(yes)
      ],
      [
	AC_MSG_RESULT(no)
	$2
      ])
  ])


dnl
dnl Checks to see if unaligned memory accesses fail
dnl
dnl usage:
dnl
dnl   AC_LBL_UNALIGNED_ACCESS
dnl
dnl results:
dnl
dnl   LBL_ALIGN (DEFINED)
dnl
AC_DEFUN(AC_LBL_UNALIGNED_ACCESS,
    [AC_MSG_CHECKING(if unaligned accesses fail)
    AC_CACHE_VAL(ac_cv_lbl_unaligned_fail,
   [case "$target_cpu" in

   # XXX: should also check that they don't do weird things (like on arm)
   alpha*|arm*|hp*|mips|sparc)
      ac_cv_lbl_unaligned_fail=yes
      ;;

   *)
      cat >conftest.c <<EOF
#      include <sys/types.h>
#      include <sys/wait.h>
#      include <stdio.h>
      unsigned char a[[5]] = { 1, 2, 3, 4, 5 };
      main() {
      unsigned int i;
      pid_t pid;
      int status;
      /* avoid "core dumped" message */
      pid = fork();
      if (pid <  0)
         exit(2);
      if (pid > 0) {
         /* parent */
         pid = waitpid(pid, &status, 0);
         if (pid < 0)
            exit(3);
         exit(!WIFEXITED(status));
      }
      /* child */
      i = *(unsigned int *)&a[[1]];
      printf("%d\n", i);
      exit(0);
      }
EOF
      ${CC-cc} -o conftest $CFLAGS $CPPFLAGS $LDFLAGS \
          conftest.c $LIBS >/dev/null 2>&1
      if test ! -x conftest ; then
         dnl failed to compile for some reason
         ac_cv_lbl_unaligned_fail=yes
      else
         ./conftest >conftest.out
         if test ! -s conftest.out ; then
            ac_cv_lbl_unaligned_fail=yes
         else
            ac_cv_lbl_unaligned_fail=no
         fi
      fi
      rm -f conftest* core core.conftest
      ;;
   esac])
    AC_MSG_RESULT($ac_cv_lbl_unaligned_fail)
    if test $ac_cv_lbl_unaligned_fail = yes ; then
       AC_DEFINE(LBL_ALIGN)
    fi])


dnl
dnl If using gcc and the file .devel exists:
dnl   Compile with -g (if supported) and -Wall
dnl   If using gcc 2, do extra prototype checking
dnl   If an os prototype include exists, symlink os-proto.h to it
dnl
dnl usage:
dnl
dnl   AC_LBL_DEVEL(copt)
dnl
dnl results:
dnl
dnl   $1 (copt appended)
dnl

AC_DEFUN(AC_LBL_DEVEL,
    [rm -f os-proto.h
    if test "${LBL_CFLAGS+set}" = set; then
       $1="$$1 ${LBL_CFLAGS}"
    fi
    if test -f .devel ; then
       if test "$GCC" = yes ; then
          $1=`echo $$1 | sed -e 's/-O3//'`
          if test "${LBL_CFLAGS+set}" != set; then
             if test "$ac_cv_prog_cc_g" = yes ; then
                $1="-g $$1"
             fi
             $1="$$1 -Wall"
             if test $ac_cv_lbl_gcc_vers -gt 1 ; then
                $1="$$1 -Wmissing-prototypes -Wstrict-prototypes"
             fi
          fi
       else
          case "$target_os" in

          irix6*)
             V_CCOPT="$V_CCOPT -n32"
             ;;

          *)
             ;;
          esac
       fi
    fi])

dnl
dnl If the file .debug exists:
dnl   Add ARGUS_DEBUG to the condefs.h file.
dnl
dnl usage:
dnl
dnl   AC_QOSIENT_DEBUG(copt)
dnl
dnl results:
dnl
dnl   $1 (copt appended)
dnl


AC_DEFUN(AC_QOSIENT_DEBUG,
    [
    if test -f .debug ; then
        cat >> confdefs.h <<\EOF
#define ARGUSDEBUG 1
EOF
    fi])

dnl 
dnl If the file .threads exists:
dnl   Add ARGUS_THREADS to the condefs.h file.
dnl
dnl usage:
dnl
dnl   AC_QOSIENT_THREADS(copt)
dnl
dnl results:
dnl
dnl   $1 (copt appended)
dnl
 
 
AC_DEFUN(AC_QOSIENT_THREADS,
    [
    if test -f .threads ; then
        cat >> confdefs.h <<\EOF
#define ARGUS_THREADS 1
EOF

    if test "$GCC" = yes ; then
        $1="-pthread $$1"
    fi

    fi])


dnl
dnl If the file .memory exists:
dnl   Add ARGUSMEMDEBUG to the condefs.h file.
dnl
dnl usage:
dnl
dnl   AC_QOSIENT_MEMORY(copt)
dnl
dnl results:
dnl
dnl   $1 (copt appended)
dnl


AC_DEFUN(AC_QOSIENT_MEMORY,
    [
    if test -f .memory ; then
        cat >> confdefs.h <<\EOF
#define ARGUSMEMDEBUG 1
EOF
    fi])


dnl sasl.m4--sasl libraries and includes
dnl Derrick Brashear
dnl from KTH sasl and Arla

AC_DEFUN(AC_CMU_SASL_INC_WHERE1, [
   AC_REQUIRE([AC_PROG_CC_GNU])
   saved_CPPFLAGS=$CPPFLAGS
   CPPFLAGS="$saved_CPPFLAGS -I$1"
   CMU_CHECK_HEADER_NOCACHE(sasl.h, ac_cv_found_sasl_inc=yes, ac_cv_found_sasl_inc=no)
   CPPFLAGS=$saved_CPPFLAGS
])

AC_DEFUN(AC_CMU_SASL_INC_WHERE, [
   for i in $1; do
      AC_CMU_SASL_INC_WHERE1($i)
      CMU_TEST_INCPATH($i, sasl)
      if test "$ac_cv_found_sasl_inc" = "yes"; then
        ac_cv_sasl_where_inc=$i
        break
      fi
    done
])

AC_DEFUN(AC_CMU_SASL_LIB_WHERE1, [
   AC_REQUIRE([AC_PROG_CC_GNU])
   saved_LIBS=$LIBS
   LIBS="$saved_LIBS -L$1 -lsasl"
   AC_TRY_LINK(,
      [sasl_getprop();],
      [ac_cv_found_sasl_lib=yes],
      ac_cv_found_sasl_lib=no)
   LIBS=$saved_LIBS
])

AC_DEFUN(AC_CMU_SASL_LIB_WHERE, [
   for i in $1; do
      AC_CMU_SASL_LIB_WHERE1($i)
      dnl deal with false positives from implicit link paths
      CMU_TEST_LIBPATH($i, sasl)
      if test "$ac_cv_found_sasl_lib" = "yes" ; then
        ac_cv_sasl_where_lib=$i
        break
      fi
    done
])

AC_DEFUN(AC_CMU_SASL, [
   AC_ARG_WITH(sasl,
      [  --with-sasl=DIR|yes     use libsasl in <DIR> no],
      with_sasl="$withval", with_sasl=no)

   SASLFLAGS=""
   LIB_SASL=""

   if test "$with_sasl" != no ; then
      cmu_saved_CPPFLAGS=$CPPFLAGS
      cmu_saved_LDFLAGS=$LDFLAGS
      cmu_saved_LIBS=$LIBS
   
      if test -d ${with_sasl}; then
          ac_cv_sasl_where_lib=${with_sasl}/lib
          ac_cv_sasl_where_inc=${with_sasl}/include
   
          SASLFLAGS="-I$ac_cv_sasl_where_inc"
          LIB_SASL="-L$ac_cv_sasl_where_lib"
          CPPFLAGS="${cmu_saved_CPPFLAGS} -I${ac_cv_sasl_where_inc}"
          LDFLAGS="${cmu_saved_LDFLAGS} -L${ac_cv_sasl_where_lib}"
      fi
   
      AC_CHECK_HEADER(sasl.h,
           AC_CHECK_LIB(sasl, sasl_getprop, 
                  ac_cv_found_sasl=yes, ac_cv_found_sasl=no), 
                  ac_cv_found_sasl=no)
   
      LIBS="$cmu_saved_LIBS"
      LDFLAGS="$cmu_saved_LDFLAGS"
      CPPFLAGS="$cmu_saved_CPPFLAGS"
   
      if test "$ac_cv_found_sasl" = yes; then
         LIB_SASL="$LIB_SASL -lsasl"

         if test "$with_sasl" != no; then
            AC_DEFINE(ARGUS_SASL, 1)
            AC_SUBST(LIB_SASL)
            AC_SUBST(SASLFLAGS)
         fi
      else
         LIB_SASL=""
         SASLFLAGS=""
      fi
   fi
])


dnl
dnl Use pfopen.c if available and pfopen() not in standard libraries
dnl Require libpcap
dnl Look for libpcap in ..
dnl Use the installed libpcap if there is no local version
dnl
dnl usage:
dnl
dnl   AC_LBL_LIBPCAP(pcapdep, incls)
dnl
dnl results:
dnl
dnl   $1 (pcapdep set)
dnl   $2 (incls appended)
dnl   LIBS
dnl   LBL_LIBS
dnl
AC_DEFUN(AC_LBL_LIBPCAP,
    [AC_REQUIRE([AC_LBL_LIBRARY_NET])
    dnl
    dnl save a copy before locating libpcap.a
    dnl
    LBL_LIBS="$LIBS"
    pfopen=/usr/examples/packetfilter/pfopen.c
    if test -f $pfopen ; then
       AC_CHECK_FUNCS(pfopen)
       if test $ac_cv_func_pfopen = "no" ; then
          AC_MSG_RESULT(Using $pfopen)
          LIBS="$LIBS $pfopen"
       fi
    fi
    AC_MSG_CHECKING(for local pcap library)
    libpcap=FAIL
    pcapdir=FAIL
    lastdir=FAIL

    places=`ls .. | sed -e 's,/$,,' -e 's,^,../,' | \
        egrep '/libpcap-[[0-9]]*.[[0-9]]*(.[[0-9]]*)?([[ab]][[0-9]]*)?$'`

    for dir in $places ../libpcap libpcap ; do
       basedir=`echo $dir | sed -e 's/[[ab]][[0-9]]*$//'`
       if test $lastdir = $basedir ; then
          dnl skip alphas when an actual release is present
          continue;
       fi
       lastdir=$dir
       if test -r $dir/libpcap.a ; then
          libpcap=$dir/libpcap.a
          d=$dir
          if test -f $dir/pcap.h ; then
             pcapdir=$dir
          else
             pcapdir=FAIL
          fi
          dnl continue and select the last one that exists
       fi
    done

    if test $libpcap = FAIL ; then
       if test -f /usr/local/lib/libpcap.a ; then
          libpcap=/usr/local/lib/libpcap.a
          if test -f /usr/local/include/pcap.h ; then
             pcapdir=/usr/local/include
          else
             libpcap=FAIL
          fi
       fi
    fi

    if test $libpcap = FAIL ; then
       AC_MSG_RESULT(no)
       AC_CHECK_LIB(pcap, main, libpcap="-lpcap")
    fi

    if test $libpcap = FAIL ; then
       AC_MSG_CHECKING(for local wpcap library)
       dir=../wpdpack/Lib
       if test -r $dir/libwpcap.a ; then
          libpcap=$dir/libwpcap.a
          pcapdir=../wpdpack/Include
       fi

       if test $libpcap = FAIL ; then
          AC_MSG_RESULT(no)
          AC_CHECK_LIB(wpcap, main, libpcap="-lwpcap")
       fi
    fi


    if ! test $libpcap = FAIL ; then
       $1=$libpcap

       AC_MSG_CHECKING(for pcap.h)
       if test $pcapdir = FAIL; then
          if test $libpcap = "-lpcap" ; then
             for dir in /usr/local/include/pcap /usr/include /usr/include/pcap; do
                if test -f $dir/pcap.h ; then
                   pcapdir=$dir
                fi
             done
          else
             places=`ls $srcdir/.. | sed -e 's,/$,,' -e "s,^,$srcdir/../," | \
                 egrep '/libpcap-[[0-9]]*.[[0-9]]*(.[[0-9]]*)?([[ab]][[0-9]]*)?$'`
 
             for dir in $places ../wpdpack/Include ; do
               if test -f $dir/pcap.h ; then
                  pcapdir=$dir
               fi
             done
          fi
 
          if test $pcapdir = FAIL; then
             AC_MSG_RESULT(no)
             AC_MSG_ERROR(cannot find pcap.h, see INSTALL)
          fi
       fi

       if ! test $pcapdir = FAIL; then
          AC_MSG_RESULT(yes $pcapdir)
          tdir=`echo $pcapdir | sed -e 's/^\.\./..\/../'`
          $2="-I$tdir $$2"
       fi

    else
       AC_MSG_ERROR(cannot find packet capture library, see INSTALL)
    fi

    case "$host_os" in

    aix*)
       pseexe="/lib/pse.exp"
       AC_MSG_CHECKING(for $pseexe)
       if test -f $pseexe ; then
          AC_MSG_RESULT(yes)
          LIBS="$LIBS -I:$pseexe"
       fi
       ;;
    esac])


dnl
dnl Find libwrappers
dnl Look for libwrappers in ..
dnl Use the installed libwrappers if there is no local version
dnl
dnl usage:
dnl
dnl   AC_QOSIENT_TCPWRAP(wrapdep, incls)
dnl
dnl results:
dnl
dnl   $1 (wrapdep set)
dnl   $2 (incls appended)
dnl   LIBS
dnl   LBL_LIBS
dnl
AC_DEFUN(AC_QOSIENT_TCPWRAP,
   [AC_MSG_CHECKING(for local tcp_wrappers library)
   libwrap=FAIL
   lastdir=FAIL
   pwdir=`pwd`
   places=`ls .. | sed -e 's,/$,,' -e 's,^,../,' | egrep 'tcp_wrappers'`
   for dir in $places; do
      if test $lastdir = $dir ; then
         dnl skip alphas when an actual release is present
         continue;
      fi
      lastdir=$dir
      if test -r $dir/libwrap.a ; then
         libwrap=$dir/libwrap.a
         d=$dir
         dnl continue and select the last one that exists
      fi
   done

   if test $libwrap = FAIL ; then
      AC_MSG_RESULT(not found)
      AC_MSG_CHECKING(for system tcp_wrappers library)
      AC_CACHE_VAL(ac_cv_qosient_wrapper,
        [ac_save_LIBS="$LIBS"
         LIBS="-lwrap $LIBS"
         AC_TRY_COMPILE(
            [#include <tcpd.h>;
             int deny_severity = 0, allow_severity = 0;],
            [struct request_info request;
             fromhost(&request);],
            ac_cv_qosient_wrapper=yes,
            ac_cv_qosient_wrapper=no)
         LIBS="$ac_save_LIBS"])
      AC_MSG_RESULT($ac_cv_qosient_wrapper)
      if test $ac_cv_qosient_wrapper = no ; then
         AC_MSG_WARN(tcp_wrapper not found)
      else
         libwrap="-lwrap"
         $1=$libwrap
         if test -r /usr/local/include/tcpd.h; then
            $2="-I/usr/local/include $$2"
         fi
      fi
   else
      $1=$libwrap
      if test -r $d/tcpd.h; then
         $2="-I../$d $$2"
      elif test -r $srcdir/../libwrap/tcpd.h; then
         $2="-I$srcdir/../libwrap $$2"
      elif test -r /usr/local/include/tcpd.h; then
         $2="-I/usr/local/include $$2"
      elif test -r /usr/include/tcpd.h; then
         $2="-I$d -I$srcdir/../libwrap $$2"
      else
         AC_MSG_WARN(cannot find tcpd.h)
         libwrap=FAIL
      fi
      AC_MSG_RESULT($libwrap)
   fi])

dnl
dnl Improved version of AC_CHECK_LIB
dnl
dnl Thanks to John Hawkinson (jhawk@mit.edu)
dnl
dnl usage:
dnl
dnl   AC_LBL_CHECK_LIB(LIBRARY, FUNCTION [, ACTION-IF-FOUND [,
dnl       ACTION-IF-NOT-FOUND [, OTHER-LIBRARIES]]])
dnl
dnl results:
dnl
dnl   LIBS
dnl

define(AC_LBL_CHECK_LIB,
[AC_MSG_CHECKING([for $2 in -l$1])
dnl Use a cache variable name containing both the library and function name,
dnl because the test really is for library $1 defining function $2, not
dnl just for library $1.  Separate tests with the same $1 and different $2's
dnl may have different results.
ac_lib_var=`echo $1['_']$2['_']$5 | sed 'y%./+- %__p__%'`
AC_CACHE_VAL(ac_cv_lbl_lib_$ac_lib_var,
[ac_save_LIBS="$LIBS"
LIBS="-l$1 $5 $LIBS"
AC_TRY_LINK(dnl
ifelse([$2], [main], , dnl Avoid conflicting decl of main.
[/* Override any gcc2 internal prototype to avoid an error.  */
]ifelse(AC_LANG, CPLUSPLUS, [#ifdef __cplusplus
extern "C"
#endif
])dnl
[/* We use char because int might match the return type of a gcc2
    builtin and then its argument prototype would still apply.  */
char $2();
]),
       [$2()],
       eval "ac_cv_lbl_lib_$ac_lib_var=yes",
       eval "ac_cv_lbl_lib_$ac_lib_var=no")
LIBS="$ac_save_LIBS"
])dnl
if eval "test \"`echo '$ac_cv_lbl_lib_'$ac_lib_var`\" = yes"; then
  AC_MSG_RESULT(yes)
  ifelse([$3], ,
[changequote(, )dnl
  ac_tr_lib=HAVE_LIB`echo $1 | sed -e 's/[^a-zA-Z0-9_]/_/g' \
    -e 'y/abcdefghijklmnopqrstuvwxyz/ABCDEFGHIJKLMNOPQRSTUVWXYZ/'`
changequote([, ])dnl
  AC_DEFINE_UNQUOTED($ac_tr_lib)
  LIBS="-l$1 $LIBS"
], [$3])
else
  AC_MSG_RESULT(no)
ifelse([$4], , , [$4
])dnl
fi
])


dnl
dnl AC_LBL_LIBRARY_NET
dnl
dnl This test is for network applications that need socket() and
dnl gethostbyname() -ish functions.  Under Solaris, those applications
dnl need to link with "-lsocket -lnsl".  Under IRIX, they need to link
dnl with "-lnsl" but should *not* link with "-lsocket" because
dnl libsocket.a breaks a number of things (for instance:
dnl gethostbyname() under IRIX 5.2, and snoop sockets under most
dnl versions of IRIX).
dnl
dnl Unfortunately, many application developers are not aware of this,
dnl and mistakenly write tests that cause -lsocket to be used under
dnl IRIX.  It is also easy to write tests that cause -lnsl to be used
dnl under operating systems where neither are necessary (or useful),
dnl such as SunOS 4.1.4, which uses -lnsl for TLI.
dnl
dnl This test exists so that every application developer does not test
dnl this in a different, and subtly broken fashion.

dnl It has been argued that this test should be broken up into two
dnl seperate tests, one for the resolver libraries, and one for the
dnl libraries necessary for using Sockets API. Unfortunately, the two
dnl are carefully intertwined and allowing the autoconf user to use
dnl them independantly potentially results in unfortunate ordering
dnl dependancies -- as such, such component macros would have to
dnl carefully use indirection and be aware if the other components were
dnl executed. Since other autoconf macros do not go to this trouble,
dnl and almost no applications use sockets without the resolver, this
dnl complexity has not been implemented.
dnl
dnl The check for libresolv is in case you are attempting to link
dnl statically and happen to have a libresolv.a lying around (and no
dnl libnsl.a).
dnl
AC_DEFUN(AC_LBL_LIBRARY_NET, [
    # Most operating systems have gethostbyname() in the default searched
    # libraries (i.e. libc):
    # Some OSes (eg. Solaris) place it in libnsl
    # Some strange OSes (SINIX) have it in libsocket:
    AC_SEARCH_LIBS(gethostbyname, nsl socket resolv)
    # Unfortunately libsocket sometimes depends on libnsl and
    # AC_SEARCH_LIBS isn't up to the task of handling dependencies like this.
    if test "$ac_cv_search_gethostbyname" = "no"
    then
   AC_CHECK_LIB(socket, gethostbyname,
                     LIBS="-lsocket -lnsl $LIBS", , -lnsl)
    fi
    AC_SEARCH_LIBS(socket, socket, ,
   AC_CHECK_LIB(socket, socket, LIBS="-lsocket -lnsl $LIBS", , -lnsl))
    # DLPI needs putmsg under HPUX so test for -lstr while we're at it
    AC_SEARCH_LIBS(putmsg, str)
    ])


dnl
dnl If using gcc, make sure we have ANSI ioctl definitions
dnl
dnl usage:
dnl
dnl     AC_LBL_FIXINCLUDES
dnl
AC_DEFUN(AC_LBL_FIXINCLUDES,
    [if test "$GCC" = yes ; then
            AC_MSG_CHECKING(for ANSI ioctl definitions)
            AC_CACHE_VAL(ac_cv_lbl_gcc_fixincludes,
                AC_TRY_COMPILE(
                    [/*
                     * This generates a "duplicate case value" when fixincludes
                     * has not be run.
                     */
#               include <sys/types.h>
#               include <sys/time.h>
#               include <sys/ioctl.h>
#               ifdef HAVE_SYS_IOCCOM_H
#               include <sys/ioccom.h>
#               endif],
                    [switch (0) {
                    case _IO('A', 1):;
                    case _IO('B', 1):;
                    }],
                    ac_cv_lbl_gcc_fixincludes=yes,
                    ac_cv_lbl_gcc_fixincludes=no))
            AC_MSG_RESULT($ac_cv_lbl_gcc_fixincludes)
            if test $ac_cv_lbl_gcc_fixincludes = no ; then
                    # Don't cache failure
                    unset ac_cv_lbl_gcc_fixincludes
                    AC_MSG_ERROR(see the INSTALL for more info)
            fi
    fi])
